/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.ui.text;

import java.util.Arrays;
import org.eclipse.dltk.ruby.internal.ui.RubyUI;
import org.eclipse.dltk.ruby.internal.ui.text.RubyHeuristicScanner;
import org.eclipse.dltk.ruby.internal.ui.text.RubyPreferenceInterpreter;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.text.util.AutoEditUtils;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;

public class RubyAutoEditStrategy
extends DefaultIndentLineAutoEditStrategy {
    private static final int[] INDENT_TO_BLOCK_TOKENS = new int[]{1012, 1023, 1008, 1029, 1030, 1013, 2};
    private static final int[] CONTINUATION_TOKENS = new int[]{16, 9, 17, 18, 19, 20};
    private static final int[] REMOVE_IDENTATION_TOKENS = new int[]{1033, 1034};
    private boolean fIsSmartMode;
    private boolean fCloseBlocks = true;
    private RubyPreferenceInterpreter fPreferences;

    static {
        Arrays.sort(INDENT_TO_BLOCK_TOKENS);
        Arrays.sort(CONTINUATION_TOKENS);
        Arrays.sort(REMOVE_IDENTATION_TOKENS);
    }

    public RubyAutoEditStrategy(String partitioning) {
        this(partitioning, RubyUI.getDefault().getPreferenceStore());
    }

    public RubyAutoEditStrategy(String partitioning, IPreferenceStore store) {
        this.fPreferences = new RubyPreferenceInterpreter(store);
    }

    private void clearCachedValues() {
        this.fCloseBlocks = this.fPreferences.closeBlocks();
        this.fIsSmartMode = this.fPreferences.isSmartMode();
    }

    private void closeBlock(IDocument d, DocumentCommand c, String indent, String afterCursor, RubyHeuristicScanner scanner) throws BadLocationException {
        c.caretOffset = c.offset + c.text.length();
        c.length = afterCursor.length();
        c.shiftsCaret = false;
        String delimiter = TextUtilities.getDefaultLineDelimiter((IDocument)d);
        c.text = String.valueOf(c.text) + afterCursor.trim() + delimiter + indent + this.getApropriateBlockEnding(d, scanner, c.offset);
    }

    private String getApropriateBlockEnding(IDocument d, RubyHeuristicScanner scanner, int offset) throws BadLocationException {
        int beginning = scanner.findBlockBeginningOffset(offset);
        if (beginning == -1) {
            throw new BadLocationException();
        }
        IRegion line = d.getLineInformationOfOffset(beginning);
        int ending = Math.min(line.getOffset() + line.getLength(), offset);
        int token = scanner.previousToken(ending, beginning);
        if (token == 1) {
            return "}";
        }
        return "end";
    }

    private boolean isSmartMode() {
        return this.fIsSmartMode;
    }

    public void customizeDocumentCommand(IDocument d, DocumentCommand c) {
        if (!c.doit) {
            return;
        }
        this.clearCachedValues();
        if (!this.isSmartMode()) {
            super.customizeDocumentCommand(d, c);
            return;
        }
        try {
            if (c.length == 0 && c.text != null && this.isLineDelimiter(d, c.text)) {
                this.smartIndentAfterNewLine(d, c);
            } else if (c.text.length() == 1 && c.text.charAt(0) == '\t') {
                this.smartTab(d, c);
            } else if (c.text.length() == 1) {
                this.smartIndentOnKeypress(d, c);
            } else if (c.text.length() > 1 && this.fPreferences.isSmartPaste()) {
                this.smartPaste(d, c);
            } else {
                super.customizeDocumentCommand(d, c);
            }
        }
        catch (BadLocationException e) {
            DLTKUIPlugin.log((Throwable)e);
        }
    }

    private boolean isLineDelimiter(IDocument document, String text) {
        String[] delimiters = document.getLegalLineDelimiters();
        if (delimiters != null) {
            return TextUtilities.equals((String[])delimiters, (String)text) > -1;
        }
        return false;
    }

    private void smartTab(IDocument d, DocumentCommand c) throws BadLocationException {
        IRegion info = d.getLineInformationOfOffset(c.offset);
        int endOffset = info.getOffset() + info.getLength();
        String line = d.get(info.getOffset(), info.getLength());
        String linePrefix = line.substring(0, c.offset - info.getOffset());
        String linePostfix = line.substring(c.offset - info.getOffset(), endOffset - info.getOffset());
        String postfixIndent = AutoEditUtils.getLineIndent((String)linePostfix);
        RubyHeuristicScanner scanner = new RubyHeuristicScanner(d);
        String rightIndent = this.nextIsIdentToBlockToken(scanner, c.offset, endOffset) ? this.getBlockIndent(d, c.offset, scanner) : this.getLineIndent(d, c.offset, scanner);
        if (linePrefix.trim().length() != 0 || linePostfix.trim().length() != 0 && postfixIndent.length() == 0 && this.computeVisualLength(linePrefix) >= this.computeVisualLength(rightIndent)) {
            c.text = this.fPreferences.getIndent();
            return;
        }
        c.text = String.valueOf(rightIndent) + linePostfix.trim();
        c.offset = info.getOffset();
        c.length = info.getLength();
        c.caretOffset = info.getOffset() + rightIndent.length();
        c.shiftsCaret = false;
    }

    private void smartIndentOnKeypress(IDocument d, DocumentCommand c) throws BadLocationException {
        RubyHeuristicScanner scanner = new RubyHeuristicScanner(d);
        IRegion info = d.getLineInformationOfOffset(c.offset);
        int token = scanner.previousTokenAfterInput(c.offset, c.text);
        if (Arrays.binarySearch(INDENT_TO_BLOCK_TOKENS, token) >= 0) {
            String indent = "";
            indent = this.getBlockIndent(d, info.getOffset(), scanner);
            int pos = scanner.findNonWhitespaceForwardInAnyPartition(info.getOffset(), c.offset);
            String line = "";
            if (pos != -1) {
                line = d.get(pos, c.offset - pos);
            }
            c.text = String.valueOf(indent) + line + c.text;
            c.length = c.offset - info.getOffset();
            c.offset = info.getOffset();
        } else if (Arrays.binarySearch(REMOVE_IDENTATION_TOKENS, token) >= 0) {
            int start = scanner.findNonWhitespaceForward(info.getOffset(), c.offset);
            c.text = String.valueOf(d.get(start, c.offset - start)) + c.text;
            c.length = c.offset - info.getOffset();
            c.offset = info.getOffset();
        } else {
            int wsPos = scanner.findNonIdentifierBackward(c.offset, info.getOffset());
            int previosToken = scanner.previousToken(c.offset, wsPos);
            if (Arrays.binarySearch(INDENT_TO_BLOCK_TOKENS, previosToken) >= 0 && Character.isJavaIdentifierPart(c.text.charAt(0))) {
                String indent = this.getPreviousLineIndent(d, info.getOffset() - 1, scanner);
                int pos = scanner.findNonWhitespaceForwardInAnyPartition(info.getOffset(), c.offset);
                String line = "";
                if (pos != -1) {
                    line = d.get(pos, c.offset - pos);
                }
                c.text = String.valueOf(indent) + line + c.text;
                c.length = c.offset - info.getOffset();
                c.offset = info.getOffset();
            }
        }
    }

    private String getLineIndent(IDocument d, int offset, RubyHeuristicScanner scanner) {
        int blockOffset = scanner.findBlockBeginningOffset(offset);
        if (blockOffset != -1) {
            try {
                return String.valueOf(AutoEditUtils.getLineIndent((IDocument)d, (int)d.getLineOfOffset(blockOffset))) + this.fPreferences.getIndent();
            }
            catch (BadLocationException e) {
                DLTKUIPlugin.log((Throwable)e);
            }
        }
        return "";
    }

    private String getBlockIndent(IDocument d, int offset, RubyHeuristicScanner scanner) {
        int blockOffset = scanner.findBlockBeginningOffset(offset);
        if (blockOffset != -1) {
            try {
                return AutoEditUtils.getLineIndent((IDocument)d, (int)d.getLineOfOffset(blockOffset));
            }
            catch (BadLocationException e) {
                DLTKUIPlugin.log((Throwable)e);
            }
        }
        return "";
    }

    private void smartIndentAfterNewLine(IDocument d, DocumentCommand c) throws BadLocationException {
        RubyHeuristicScanner scanner = new RubyHeuristicScanner(d);
        IRegion line = d.getLineInformationOfOffset(c.offset);
        int lineEnd = line.getOffset() + line.getLength();
        int nonWsPos = scanner.findNonWhitespaceForwardInAnyPartition(c.offset, lineEnd);
        if (nonWsPos != -1) {
            c.length = nonWsPos - c.offset;
        }
        if (this.nextIsIdentToBlockToken(scanner, c.offset, lineEnd)) {
            c.text = String.valueOf(c.text) + this.getBlockIndent(d, c.offset, scanner);
            return;
        }
        String indent = this.getPreviousLineIndent(d, c.offset, scanner);
        c.text = String.valueOf(c.text) + indent;
        if (this.previousIsBlockBeginning(d, scanner, c.offset)) {
            c.text = String.valueOf(c.text) + this.fPreferences.getIndent();
            if (this.fCloseBlocks && scanner.isBlockBeginning(line.getOffset(), lineEnd) && !this.isBlockClosed(d, c.offset)) {
                this.closeBlock(d, c, indent, d.get(c.offset, lineEnd - c.offset), scanner);
            }
        } else if (this.previousIsFirstContinuation(d, scanner, c.offset, line.getOffset())) {
            c.text = String.valueOf(c.text) + this.fPreferences.getIndent();
        } else if (this.hasUnclosedParen(scanner, c.offset, line.getOffset())) {
            c.text = String.valueOf(c.text) + this.fPreferences.getIndent();
        }
    }

    private boolean hasUnclosedParen(RubyHeuristicScanner scanner, int offset, int bound) {
        int pos = scanner.findOpeningPeer(offset, bound, '(', ')');
        return pos != -1;
    }

    private boolean previousIsFirstContinuation(IDocument d, RubyHeuristicScanner scanner, int offset, int bound) throws BadLocationException {
        IRegion previousLine = null;
        int line = d.getLineOfOffset(offset);
        if (line > 0) {
            previousLine = d.getLineInformation(line - 1);
        }
        return this.previousIsContinuation(scanner, offset, bound) && (previousLine == null || !this.previousIsContinuation(scanner, previousLine.getOffset() + previousLine.getLength(), previousLine.getOffset()));
    }

    private boolean previousIsContinuation(RubyHeuristicScanner scanner, int offset, int bound) {
        int token = scanner.previousToken(offset, bound);
        return Arrays.binarySearch(CONTINUATION_TOKENS, token) >= 0;
    }

    private boolean previousIsBlockBeginning(IDocument d, RubyHeuristicScanner scanner, int offset) throws BadLocationException {
        int previousLineOffset = scanner.findPrecedingNotEmptyLine(offset);
        IRegion previousLine = d.getLineInformationOfOffset(previousLineOffset);
        int previousLineEnd = Math.min(previousLine.getOffset() + previousLine.getLength(), offset);
        boolean previousIsBlockBeginning = scanner.isBlockBeginning(previousLine.getOffset(), previousLineEnd) || scanner.isBlockMiddle(previousLine.getOffset(), previousLineEnd);
        return previousIsBlockBeginning;
    }

    private boolean nextIsIdentToBlockToken(RubyHeuristicScanner scanner, int offset, int bound) {
        int token = scanner.nextToken(offset, bound);
        return Arrays.binarySearch(INDENT_TO_BLOCK_TOKENS, token) >= 0;
    }

    private void smartPaste(IDocument d, DocumentCommand c) throws BadLocationException {
        IRegion info = d.getLineInformationOfOffset(c.offset);
        String line = d.get(info.getOffset(), c.offset - info.getOffset());
        int startFixFrom = 1;
        if (line.trim().length() == 0) {
            c.length += line.length();
            c.offset -= line.length();
            startFixFrom = 0;
        }
        RubyHeuristicScanner scanner = new RubyHeuristicScanner(d);
        String indent = this.getLineIndent(d, c.offset, scanner);
        String delimiter = TextUtilities.getDefaultLineDelimiter((IDocument)d);
        boolean addLastDelimiter = c.text.endsWith(delimiter);
        String[] lines = c.text.split(delimiter);
        if (lines.length > startFixFrom) {
            String currentIndent = "";
            int i = startFixFrom;
            while (i < lines.length) {
                if (lines[i].trim().length() != 0) {
                    currentIndent = AutoEditUtils.getLineIndent((String)lines[i]);
                    break;
                }
                ++i;
            }
            int shift = this.computeVisualLength(indent) - this.computeVisualLength(currentIndent);
            StringBuffer result = new StringBuffer();
            int i2 = 0;
            while (i2 < startFixFrom) {
                result.append(lines[i2]).append(delimiter);
                ++i2;
            }
            i2 = startFixFrom;
            while (i2 < lines.length - 1) {
                result.append(this.shiftIdentation(lines[i2], shift)).append(delimiter);
                ++i2;
            }
            result.append(this.shiftIdentation(lines[lines.length - 1], shift));
            if (addLastDelimiter) {
                result.append(delimiter);
            }
            c.text = result.toString();
        }
    }

    private String shiftIdentation(String line, int shift) {
        if (shift > 0) {
            return String.valueOf(this.fPreferences.getIndentByVirtualSize(shift)) + line;
        }
        int pos = 0;
        while (shift < 0 && pos < line.length() && Character.isWhitespace(line.charAt(pos))) {
            shift += this.computeVisualLength(line.substring(pos, pos + 1));
            ++pos;
        }
        return line.substring(pos);
    }

    private int computeVisualLength(CharSequence indent) {
        int tabSize = this.fPreferences.getTabSize();
        int length = 0;
        int i = 0;
        while (i < indent.length()) {
            char ch = indent.charAt(i);
            switch (ch) {
                case '\t': {
                    if (tabSize <= 0) break;
                    int reminder = length % tabSize;
                    length += tabSize - reminder;
                    break;
                }
                case ' ': {
                    ++length;
                }
            }
            ++i;
        }
        return length;
    }

    private String getPreviousLineIndent(IDocument d, int offset, RubyHeuristicScanner scanner) throws BadLocationException {
        IRegion info;
        StringBuffer result = new StringBuffer();
        if (offset < 0 || d.getLength() == 0) {
            return result.toString();
        }
        int start = scanner.findPrecedingNotEmptyLine(offset);
        int end = scanner.findNonWhitespaceForwardInAnyPartition(start, start + (info = d.getLineInformationOfOffset(start)).getLength());
        if (end > start) {
            result.append(d.get(start, end - start));
        }
        return result.toString();
    }

    private boolean isBlockClosed(IDocument document, int offset) throws BadLocationException {
        return RubyAutoEditStrategy.getBlockBalance(document, offset) <= 0;
    }

    private static int getBlockBalance(IDocument document, int offset) {
        if (offset < 1) {
            return -1;
        }
        if (offset >= document.getLength()) {
            return 1;
        }
        int begin = offset;
        int end = offset - 1;
        RubyHeuristicScanner scanner = new RubyHeuristicScanner(document);
        do {
            begin = scanner.findBlockBeginningOffset(begin);
            end = scanner.findBlockEndingOffset(end);
            if (begin == -1 && end == -1) {
                return 0;
            }
            if (begin != -1) continue;
            return -1;
        } while (end != -1);
        return 1;
    }
}

