/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.tclchecker.ui.preferences;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.tcl.internal.tclchecker.TclCheckerHelper;
import org.eclipse.dltk.tcl.internal.tclchecker.TclCheckerPlugin;
import org.eclipse.dltk.tcl.internal.tclchecker.TclCheckerProblemDescription;
import org.eclipse.dltk.tcl.internal.tclchecker.ui.preferences.PreferencesMessages;
import org.eclipse.dltk.ui.environment.EnvironmentPathBlock;
import org.eclipse.dltk.ui.environment.IEnvironmentUI;
import org.eclipse.dltk.validators.ui.ValidatorConfigurationPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;

public class TclCheckerConfigurationPage
extends ValidatorConfigurationPage
implements ISelectionChangedListener {
    EnvironmentPathBlock environmentPathBlock;
    private Map pcxPaths;
    private Button errorsMode;
    private Button errorsAndUsageWarningsMode;
    private Button allMode;
    private Table problemsTable;
    private String message = "";
    private int messageType = 0;
    private ListViewer lview;
    private Button noPCX;
    private SelectionAdapter noPCXSelectionListener;
    private Map noPCXValues;
    private Group pcxGroup;
    private Button pcxAdd;
    private Button pcxRemove;
    static /* synthetic */ Class class$0;

    public void createControl(Composite parent, int columns) {
        Composite c = new Composite(parent, 0);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = columns;
        c.setLayoutData((Object)gd);
        c.setLayout((Layout)new FillLayout());
        this.createContents(c);
        this.initializeValues();
        this.validateTclCheckerPath();
    }

    public IStatus getStatus() {
        return new Status(this.messageType, "org.eclipse.dltk.tcl.tclchecker", this.message);
    }

    protected void setModeSelection(int mode) {
        this.errorsMode.setSelection(mode == 0);
        this.errorsAndUsageWarningsMode.setSelection(mode == 1);
        this.allMode.setSelection(mode == 2);
    }

    protected int getModeSelection() {
        if (this.errorsMode.getSelection()) {
            return 0;
        }
        if (this.errorsAndUsageWarningsMode.getSelection()) {
            return 1;
        }
        if (this.allMode.getSelection()) {
            return 2;
        }
        return -1;
    }

    public void validateTclCheckerPath() {
    }

    private void setMessage(Object object) {
        this.message = "";
        this.messageType = 0;
    }

    private void setMessage(String message, int type) {
        this.message = message;
        this.messageType = type;
    }

    protected void createModeGroup(Composite parent, Object data) {
        Group radioGroup = new Group(parent, 0);
        radioGroup.setText(PreferencesMessages.TclChecker_mode);
        radioGroup.setLayoutData(data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        radioGroup.setLayout((Layout)layout);
        this.errorsMode = new Button((Composite)radioGroup, 16);
        this.errorsMode.setText(PreferencesMessages.TclChecker_mode_errors);
        this.errorsAndUsageWarningsMode = new Button((Composite)radioGroup, 16);
        this.errorsAndUsageWarningsMode.setText(PreferencesMessages.TclChecker_mode_errorsAndUsageWarnings);
        this.allMode = new Button((Composite)radioGroup, 16);
        this.allMode.setText(PreferencesMessages.TclChecker_mode_all);
    }

    protected void createPathGroup(Composite parent, Object data) {
        Group group = new Group(parent, 0);
        group.setText(PreferencesMessages.TclChecker_path);
        group.setLayoutData(data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        group.setLayout((Layout)layout);
        GridData dt = new GridData(4, 4, true, true);
        dt.horizontalSpan = 1;
        group.setLayoutData((Object)dt);
        this.environmentPathBlock = new EnvironmentPathBlock();
        this.environmentPathBlock.createControl((Composite)group);
    }

    protected void editPDX() {
    }

    protected void createPCXPathGroup(Composite parent, Object data) {
        this.pcxGroup = new Group(parent, 0);
        this.pcxGroup.setText(PreferencesMessages.TclChecker_pcxPath);
        this.pcxGroup.setLayoutData(data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.pcxGroup.setLayout((Layout)layout);
        this.noPCX = new Button((Composite)this.pcxGroup, 32);
        this.noPCX.setText("Disable Using of PCX files");
        GridData noPCXDG = new GridData(4, -1, true, false);
        noPCXDG.horizontalSpan = 2;
        this.noPCX.setLayoutData((Object)noPCXDG);
        org.eclipse.swt.widgets.List list = new org.eclipse.swt.widgets.List((Composite)this.pcxGroup, 2048);
        this.lview = new ListViewer(list);
        list.setLayoutData((Object)new GridData(4, 4, true, true));
        this.lview.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                IEnvironment environment = TclCheckerConfigurationPage.this.getEnvironment();
                if (inputElement instanceof Map && environment != null) {
                    return ((List)TclCheckerConfigurationPage.this.pcxPaths.get(environment)).toArray();
                }
                return new Object[0];
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.lview.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        Composite buttons = new Composite((Composite)this.pcxGroup, 0);
        RowLayout row = new RowLayout(512);
        row.fill = true;
        buttons.setLayout((Layout)row);
        this.pcxAdd = new Button(buttons, 8);
        this.pcxAdd.setText("Add");
        this.pcxAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IEnvironmentUI ui;
                String path;
                IEnvironment environment = TclCheckerConfigurationPage.this.getEnvironment();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.dltk.ui.environment.IEnvironmentUI");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((path = (ui = (IEnvironmentUI)environment.getAdapter((Class)clazz)).selectFolder(TclCheckerConfigurationPage.this.pcxAdd.getShell())) != null) {
                    ((List)TclCheckerConfigurationPage.this.pcxPaths.get(environment)).add(path);
                }
                TclCheckerConfigurationPage.this.updatePCX();
            }
        });
        this.pcxRemove = new Button(buttons, 8);
        this.pcxRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ISelection selection = TclCheckerConfigurationPage.this.lview.getSelection();
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection ssel = (IStructuredSelection)selection;
                    Iterator i = ssel.iterator();
                    while (i.hasNext()) {
                        String s = (String)i.next();
                        IEnvironment environment = TclCheckerConfigurationPage.this.getEnvironment();
                        ((List)TclCheckerConfigurationPage.this.pcxPaths.get(environment)).remove(s);
                    }
                }
                TclCheckerConfigurationPage.this.updatePCX();
            }
        });
        this.pcxRemove.setText("Remove");
        this.lview.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = TclCheckerConfigurationPage.this.lview.getSelection();
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection ssel = (IStructuredSelection)selection;
                    boolean empty = ssel.isEmpty();
                    TclCheckerConfigurationPage.this.pcxRemove.setEnabled(!empty);
                }
            }
        });
        this.noPCXSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selection = TclCheckerConfigurationPage.this.noPCX.getSelection();
                TclCheckerConfigurationPage.this.noPCXValues.put(TclCheckerConfigurationPage.this.getEnvironment(), new Boolean(selection).toString());
                IStructuredSelection pathSelection = TclCheckerConfigurationPage.this.environmentPathBlock.getSelection();
                boolean enabled = !pathSelection.isEmpty();
                TclCheckerConfigurationPage.this.pcxRemove.setEnabled(!selection && enabled);
                TclCheckerConfigurationPage.this.updatePCX();
            }
        };
        this.noPCX.addSelectionListener((SelectionListener)this.noPCXSelectionListener);
    }

    protected IEnvironment getEnvironment() {
        IStructuredSelection selection = this.environmentPathBlock.getSelection();
        if (selection.isEmpty()) {
            return EnvironmentManager.getEnvironmentById((String)"org.eclipse.dltk.core.environment.localEnvironment");
        }
        return (IEnvironment)selection.getFirstElement();
    }

    protected void setSelection(boolean value) {
        TableItem[] items = this.problemsTable.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].setChecked(value);
            ++i;
        }
    }

    protected void invertSelection() {
        TableItem[] items = this.problemsTable.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].setChecked(!items[i].getChecked());
            ++i;
        }
    }

    protected void createSuppressProblemsGroup(Composite parent, Object data) {
        Group group = new Group(parent, 0);
        group.setText(PreferencesMessages.TclChecker_suppressProblems);
        group.setLayoutData(data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        this.problemsTable = new Table((Composite)group, 33312);
        this.problemsTable.setBounds(0, 0, 150, 200);
        this.problemsTable.setHeaderVisible(false);
        GridData tableData = new GridData(4, 4, true, true, 0, 0);
        tableData.heightHint = 100;
        this.problemsTable.setLayoutData((Object)tableData);
        TableColumn problemsColumn = new TableColumn(this.problemsTable, 16384);
        problemsColumn.setWidth(200);
        TableColumn typesColumn = new TableColumn(this.problemsTable, 16384);
        typesColumn.setWidth(100);
        List problems = TclCheckerProblemDescription.getProblemIdentifiers();
        Collections.sort(problems);
        Iterator it = problems.iterator();
        while (it.hasNext()) {
            TableItem item = new TableItem(this.problemsTable, 0);
            String problemId = (String)it.next();
            item.setData((Object)problemId);
            String type = TclCheckerProblemDescription.getProblemType(problemId);
            int category = TclCheckerProblemDescription.matchProblemCategory(type);
            String typeString = "";
            if (TclCheckerProblemDescription.isError(category)) {
                typeString = PreferencesMessages.TclChecker_error;
            } else if (TclCheckerProblemDescription.isWarning(category)) {
                typeString = PreferencesMessages.TclChecker_warning;
            }
            item.setText(new String[]{problemId, typeString});
        }
        Composite buttonsComposite = new Composite((Composite)group, 0);
        RowLayout buttonsLayout = new RowLayout();
        buttonsLayout.type = 512;
        buttonsLayout.fill = true;
        buttonsComposite.setLayout((Layout)buttonsLayout);
        GridData buttonsData = new GridData();
        buttonsData.verticalAlignment = 128;
        buttonsComposite.setLayoutData((Object)buttonsData);
        Button selectAll = new Button(buttonsComposite, 8);
        selectAll.setText(PreferencesMessages.TclChecker_selectAll);
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TclCheckerConfigurationPage.this.setSelection(true);
            }
        });
        Button clearSelection = new Button(buttonsComposite, 8);
        clearSelection.setText(PreferencesMessages.TclChecker_clearSelection);
        clearSelection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TclCheckerConfigurationPage.this.setSelection(false);
            }
        });
        Button invertSelection = new Button(buttonsComposite, 8);
        invertSelection.setText(PreferencesMessages.TclChecker_invertSelection);
        invertSelection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items = TclCheckerConfigurationPage.this.problemsTable.getItems();
                int i = 0;
                while (i < items.length) {
                    items[i].setChecked(!items[i].getChecked());
                    ++i;
                }
            }
        });
    }

    public Control createContents(Composite parent) {
        Composite top = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        top.setLayout((Layout)layout);
        this.createPathGroup(top, new GridData(4, 0, true, false));
        Composite ctrl = new Composite(top, 0);
        ctrl.setLayoutData((Object)new GridData(4, 0, true, false));
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        gl.marginLeft = -5;
        gl.marginTop = -5;
        gl.marginRight = -5;
        ctrl.setLayout((Layout)gl);
        this.createModeGroup(ctrl, new GridData(-1, 4, false, false));
        this.createPCXPathGroup(ctrl, new GridData(4, 4, true, true));
        this.createSuppressProblemsGroup(top, new GridData(4, 4, true, true));
        this.initializeValues();
        this.validateTclCheckerPath();
        return top;
    }

    public void init(IWorkbench workbench) {
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return TclCheckerPlugin.getDefault().getPreferenceStore();
    }

    public void initializeValues() {
        IPreferenceStore store = this.doGetPreferenceStore();
        this.environmentPathBlock.setPaths(TclCheckerHelper.getPaths(store));
        this.pcxPaths = TclCheckerHelper.getPcxPaths(store);
        this.noPCXValues = TclCheckerHelper.getNoPCX(store);
        this.lview.setInput((Object)this.pcxPaths);
        String value = (String)this.noPCXValues.get(this.getEnvironment());
        if ("true".equals(value)) {
            this.noPCX.setSelection(true);
        } else {
            this.noPCX.setSelection(false);
        }
        this.updatePCX();
        this.setModeSelection(store.getInt("tclchecker.mode"));
        TableItem[] items = this.problemsTable.getItems();
        int i = 0;
        while (i < items.length) {
            TableItem item = items[i];
            item.setChecked(store.getBoolean((String)item.getData()));
            ++i;
        }
    }

    protected void performDefaults() {
        this.setModeSelection(2);
        this.setSelection(false);
    }

    public void applyChanges() {
        IPreferenceStore store = this.doGetPreferenceStore();
        TclCheckerHelper.setPaths(store, this.environmentPathBlock.getPaths());
        TclCheckerHelper.setPcxPaths(store, this.pcxPaths);
        TclCheckerHelper.setNoPCX(store, this.noPCXValues);
        store.setValue("tclchecker.mode", this.getModeSelection());
        TableItem[] items = this.problemsTable.getItems();
        int i = 0;
        while (i < items.length) {
            TableItem item = items[i];
            store.setValue((String)item.getData(), item.getChecked());
            ++i;
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.environmentPathBlock.getSelection();
        this.updatePCX();
    }

    private void updatePCX() {
        String value = (String)this.noPCXValues.get(this.getEnvironment());
        if ("true".equals(value)) {
            this.lview.getControl().setEnabled(false);
        } else {
            this.lview.getControl().setEnabled(true);
        }
        this.lview.refresh();
    }
}

