/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.formatting;

import com.xored.org.mozilla.javascript.CompilerEnvirons;
import com.xored.org.mozilla.javascript.Decompiler;
import com.xored.org.mozilla.javascript.ErrorReporter;
import com.xored.org.mozilla.javascript.EvaluatorException;
import com.xored.org.mozilla.javascript.Parser;
import com.xored.org.mozilla.javascript.UintMap;
import java.util.Map;
import org.eclipse.dltk.javascript.internal.ui.JavaScriptUI;
import org.eclipse.dltk.javascript.internal.ui.formatting.CodeFormatter;
import org.eclipse.dltk.javascript.internal.ui.text.JsPreferenceInterpreter;
import org.eclipse.dltk.ui.text.util.TabStyle;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class OldCodeFormatter
extends CodeFormatter {
    Map options;

    public OldCodeFormatter(Map options) {
        this.options = options;
    }

    public TextEdit format(int kind, String source, int offset, int length, StringBuffer computeIndentation, String lineSeparator) {
        String newText = this.formatString(source.substring(offset, offset + length), computeIndentation);
        return new ReplaceEdit(offset, length, newText);
    }

    public String formatString(String substring, StringBuffer computeIndentation) {
        Parser ps = new Parser(new CompilerEnvirons(), new ErrorReporter(){

            public void error(String message, String sourceName, int line, String lineSource, int offset) {
            }

            public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
                return null;
            }

            public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
            }
        });
        ps.parse(substring, "", 0);
        String encodedSource = ps.getEncodedSource();
        Decompiler de = new Decompiler();
        de.setIndent(computeIndentation);
        UintMap uintMap = new UintMap();
        JsPreferenceInterpreter pi = new JsPreferenceInterpreter(JavaScriptUI.getDefault().getPreferenceStore());
        uintMap.put(2, pi.getIndentSize());
        TabStyle tabStyle = pi.getTabStyle();
        if (tabStyle == TabStyle.TAB) {
            uintMap.put(5, 1);
        } else {
            uintMap.put(5, 0);
        }
        String retValue = computeIndentation == null || computeIndentation.length() == 0 ? de.decompile(encodedSource, 0, uintMap).trim() : de.decompile(encodedSource, 0, uintMap);
        retValue = OldCodeFormatter.replaceAll(OldCodeFormatter.replaceAll(retValue, "/*/**", "/**"), "\n*", "\n *").toString();
        return retValue;
    }

    public static CharSequence replaceAll(CharSequence s, CharSequence searchFor, CharSequence replaceWith) {
        int searchForLength;
        String searchString;
        int matchIndex;
        if (s == null) {
            return null;
        }
        if (searchFor == null || "".equals(searchFor)) {
            return s;
        }
        if (replaceWith == null) {
            replaceWith = "";
        }
        if ((matchIndex = OldCodeFormatter.search(s, searchString = searchFor.toString(), 0)) == -1) {
            return s;
        }
        int size = s.length();
        int replaceWithLength = replaceWith.length();
        if (replaceWithLength > (searchForLength = searchFor.length())) {
            size += replaceWithLength - searchForLength;
        }
        StringBuffer buffer = new StringBuffer(size + 16);
        int pos = 0;
        do {
            buffer.append((Object)s.subSequence(pos, matchIndex));
            buffer.append((Object)replaceWith);
        } while ((matchIndex = OldCodeFormatter.search(s, searchString, pos = matchIndex + searchForLength)) != -1);
        buffer.append((Object)s.subSequence(pos, s.length()));
        return buffer;
    }

    private static int search(CharSequence s, String searchString, int pos) {
        int matchIndex = -1;
        matchIndex = s instanceof String ? ((String)s).indexOf(searchString, pos) : (s instanceof StringBuffer ? ((StringBuffer)s).indexOf(searchString, pos) : s.toString().indexOf(searchString, pos));
        return matchIndex;
    }
}

