/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.launching;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IExecutionEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.launching.IInterpreterInstallType;
import org.eclipse.dltk.launching.Messages;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterpreterSearcher {
    private Set<IFileHandle> searchedDirs = new HashSet<IFileHandle>();
    private List<IFileHandle> found = new ArrayList<IFileHandle>();
    private List<IInterpreterInstallType> types = new ArrayList<IInterpreterInstallType>();
    private String natureId;
    private IInterpreterInstallType[] installTypes;
    private Set<IFileHandle> ignore;

    protected void searchFast(IProgressMonitor monitor, IEnvironment environment, int depth) {
        if (monitor.isCanceled()) {
            return;
        }
        IExecutionEnvironment exeEnv = (IExecutionEnvironment)environment.getAdapter(IExecutionEnvironment.class);
        if (exeEnv == null) {
            return;
        }
        monitor.subTask(Messages.InterpreterSearcher_0);
        Map env = exeEnv.getEnvironmentVariables(true);
        if (env == null) {
            return;
        }
        String path = null;
        for (String name : env.keySet()) {
            if (!name.equalsIgnoreCase("path")) continue;
            path = (String)env.get(name);
            break;
        }
        if (path == null) {
            return;
        }
        String separator = environment.getPathsSeparator();
        ArrayList<IPath> folders = new ArrayList<IPath>();
        String[] res = path.split(separator);
        int i = 0;
        while (i < res.length) {
            folders.add(Path.fromOSString((String)res[i]));
            ++i;
        }
        monitor.beginTask(Messages.InterpreterSearcher_1, folders.size());
        for (IPath folder : folders) {
            IFileHandle f = environment.getFile(folder);
            if (f.isDirectory()) {
                this.search(f, monitor, depth);
            }
            monitor.worked(1);
        }
        monitor.done();
    }

    protected void search(IFileHandle directory, IProgressMonitor monitor, int depth) {
        if (depth == 0) {
            return;
        }
        if (monitor.isCanceled()) {
            return;
        }
        if (!this.searchedDirs.add(directory)) {
            return;
        }
        IFileHandle[] files = directory.getChildren();
        if (files == null) {
            return;
        }
        ArrayList<IFileHandle> subDirs = new ArrayList<IFileHandle>();
        int i = 0;
        while (i < files.length) {
            if (monitor.isCanceled()) {
                return;
            }
            IFileHandle file = files[i];
            monitor.subTask(NLS.bind((String)Messages.InterpreterSearcher_foundSearching, (Object)this.found.size(), (Object)file.getCanonicalPath()));
            if (!(file.isDirectory() && file.isSymlink() || this.ignore.contains(file))) {
                boolean validLocation = false;
                int j = 0;
                while (j < this.installTypes.length) {
                    if (monitor.isCanceled()) {
                        return;
                    }
                    IInterpreterInstallType installType = this.installTypes[j];
                    IStatus status = installType.validatePossiblyName(file);
                    if (status.isOK()) {
                        this.found.add(file);
                        this.types.add(installType);
                        validLocation = true;
                        break;
                    }
                    ++j;
                }
                if (file.isDirectory() && !validLocation) {
                    subDirs.add(file);
                }
            }
            ++i;
        }
        if (!subDirs.isEmpty()) {
            for (IFileHandle subDir : subDirs) {
                this.search(subDir, monitor, depth - 1);
            }
        }
    }

    public void search(IEnvironment environment, String natureId, Set<IFileHandle> ignore, int depth, IProgressMonitor monitor) {
        if (natureId == null) {
            throw new IllegalArgumentException();
        }
        this.found.clear();
        this.types.clear();
        this.searchedDirs.clear();
        this.natureId = natureId;
        this.installTypes = ScriptRuntime.getInterpreterInstallTypes(natureId);
        this.ignore = ignore == null ? Collections.emptySet() : ignore;
        this.searchFast((IProgressMonitor)(monitor == null ? new NullProgressMonitor() : monitor), environment, depth);
    }

    public boolean hasResults() {
        return !this.found.isEmpty();
    }

    public IFileHandle[] getFoundFiles() {
        return this.found.toArray(new IFileHandle[this.found.size()]);
    }

    public IInterpreterInstallType[] getFoundInstallTypes() {
        return this.types.toArray(new IInterpreterInstallType[this.types.size()]);
    }
}

