/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.search;

import org.eclipse.dltk.core.ILocalVariable;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.matching2.AbstractMatchingPredicate;
import org.eclipse.dltk.core.search.matching2.MatchLevel;
import org.eclipse.dltk.internal.core.search.matching.LocalVariablePattern;
import org.eclipse.dltk.javascript.ast.Argument;
import org.eclipse.dltk.javascript.ast.Identifier;
import org.eclipse.dltk.javascript.internal.search.ArgumentDeclarationNode;
import org.eclipse.dltk.javascript.internal.search.LocalVariableDeclarationNode;
import org.eclipse.dltk.javascript.internal.search.LocalVariableReferenceNode;
import org.eclipse.dltk.javascript.internal.search.MatchingNode;
import org.eclipse.dltk.javascript.typeinference.ReferenceLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalVariablePredicate
extends AbstractMatchingPredicate<MatchingNode> {
    private final boolean declarations;
    private final boolean references;
    private final ISourceModule module;
    private final int nameStart;
    private final int nameEnd;

    public LocalVariablePredicate(LocalVariablePattern pattern) {
        super((SearchPattern)pattern, pattern.name);
        ILocalVariable variable = pattern.getLocalVariable();
        this.module = (ISourceModule)variable.getAncestor(5);
        ISourceRange name = variable.getNameRange();
        this.nameStart = name.getOffset();
        this.nameEnd = name.getOffset() + name.getLength();
        this.declarations = pattern.findDeclarations;
        this.references = pattern.findReferences;
    }

    public MatchLevel match(MatchingNode node) {
        if (node instanceof LocalVariableDeclarationNode) {
            if (!this.declarations) {
                return null;
            }
            LocalVariableDeclarationNode varNode = (LocalVariableDeclarationNode)node;
            if (((Identifier)varNode.node).sourceStart() == this.nameStart && ((Identifier)varNode.node).sourceEnd() == this.nameEnd && this.isSame(varNode.module)) {
                return this.matchName(((Identifier)varNode.node).getName());
            }
        } else if (node instanceof ArgumentDeclarationNode) {
            if (!this.declarations) {
                return null;
            }
            ArgumentDeclarationNode varNode = (ArgumentDeclarationNode)node;
            if (((Argument)varNode.node).sourceStart() == this.nameStart && ((Argument)varNode.node).sourceEnd() == this.nameEnd && this.isSame(varNode.module)) {
                return this.matchName(((Argument)varNode.node).getArgumentName());
            }
        } else if (node instanceof LocalVariableReferenceNode) {
            if (!this.references) {
                return null;
            }
            LocalVariableReferenceNode varNode = (LocalVariableReferenceNode)node;
            ReferenceLocation location = varNode.declarationLoc;
            if (location.getNameStart() == this.nameStart && location.getNameEnd() == this.nameEnd && this.isSame(location.getSourceModule())) {
                return this.matchName(((Identifier)varNode.node).getName());
            }
        }
        return null;
    }

    private boolean isSame(ISourceModule module) {
        return module != null && module.equals(this.module);
    }
}

