/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementMemento;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.dltk.internal.core.util.MementoTokenizer;

public class MementoModelElementUtil {
    public static IModelElement getHandleFromMemento(MementoTokenizer memento, IParent parent, WorkingCopyOwner owner) {
        String token = null;
        String name = "";
        while (memento.hasMoreTokens()) {
            token = memento.nextToken();
            char firstChar = token.charAt(0);
            if ("=/<^~{[&!@]%}".indexOf(firstChar) != -1 || firstChar == '!') break;
            name = String.valueOf(name) + token;
        }
        try {
            IModelElement[] children = parent.getChildren();
            int i = 0;
            while (i < children.length) {
                if (name.equals(children[i].getElementName()) && children[i] instanceof IModelElementMemento) {
                    IModelElementMemento childMemento = (IModelElementMemento)((Object)children[i]);
                    if (token == null) {
                        return childMemento.getHandleFromMemento(memento, owner);
                    }
                    return childMemento.getHandleFromMemento(token, memento, owner);
                }
                ++i;
            }
        }
        catch (ModelException e) {
            DLTKCore.error("Incorrect handle resolving", (Throwable)((Object)e));
        }
        return null;
    }
}

