/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.caching;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementVisitor;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SimpleClassDLTKExtensionManager;
import org.eclipse.dltk.core.caching.AbstractContentCache;
import org.eclipse.dltk.core.caching.IContentCacheProvider;
import org.eclipse.dltk.core.caching.MetadataContentCache;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.internal.core.caching.ModelCacheListener;

public class DLTKCoreCache
extends AbstractContentCache {
    private MetadataContentCache metadataCache;
    private SimpleClassDLTKExtensionManager extensions = new SimpleClassDLTKExtensionManager("org.eclipse.dltk.core.contentCacheProvider");
    private ModelCacheListener listener = new ModelCacheListener(){

        protected void remove(IProject element) {
            IFileHandle handle = EnvironmentPathUtils.getFile((IResource)element);
            if (handle != null) {
                DLTKCoreCache.this.metadataCache.clearCacheEntryAttributes(handle);
            }
        }

        protected void remove(IScriptProject element) {
            this.removeElement(element);
        }

        private void removeElement(IModelElement element) {
            IFileHandle handle = EnvironmentPathUtils.getFile(element, false);
            if (handle != null) {
                DLTKCoreCache.this.metadataCache.clearCacheEntryAttributes(handle);
            }
        }

        protected void remove(IScriptFolder element) {
            this.removeElement(element);
        }

        protected void remove(ISourceModule element) {
            this.removeElement(element);
        }

        protected void remove(IProjectFragment element) {
            block2: {
                IProjectFragment fragment = element;
                try {
                    fragment.accept(new IModelElementVisitor(){

                        public boolean visit(IModelElement element) {
                            if (element.getElementType() == 5) {
                                this.remove((ISourceModule)element);
                                return false;
                            }
                            return true;
                        }
                    });
                }
                catch (ModelException e) {
                    if (!DLTKCore.DEBUG) break block2;
                    e.printStackTrace();
                }
            }
        }
    };

    public DLTKCoreCache() {
        this.metadataCache = new MetadataContentCache(DLTKCore.getDefault().getStateLocation().append("cache"));
        DLTKCore.addElementChangedListener(this.listener);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.listener);
        this.initialize();
    }

    private void initialize() {
        Object[] objects = this.extensions.getObjects();
        int i = 0;
        while (i < objects.length) {
            IContentCacheProvider provider = (IContentCacheProvider)objects[i];
            provider.setCache(this.metadataCache);
            ++i;
        }
    }

    public void stop() {
        this.metadataCache.save(false);
        DLTKCore.removeElementChangedListener(this.listener);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.listener);
    }

    public void clearCacheEntryAttributes(IFileHandle handle) {
        this.metadataCache.clearCacheEntryAttributes(handle);
    }

    public InputStream getCacheEntryAttribute(IFileHandle handle, String attribute) {
        return this.getCacheEntryAttribute(handle, attribute, false);
    }

    public InputStream getCacheEntryAttribute(IFileHandle handle, String attribute, boolean localonly) {
        if (handle == null) {
            return null;
        }
        InputStream result = this.metadataCache.getCacheEntryAttribute(handle, attribute);
        if (result == null) {
            if (localonly) {
                return null;
            }
            Object[] objects = this.extensions.getObjects();
            int i = 0;
            while (i < objects.length) {
                IContentCacheProvider provider = (IContentCacheProvider)objects[i];
                InputStream stream = provider.getAttributeAndUpdateCache(handle, attribute);
                if (stream != null) {
                    return stream;
                }
                ++i;
            }
        }
        return result;
    }

    public OutputStream getCacheEntryAttributeOutputStream(IFileHandle handle, String attribute) {
        return this.metadataCache.getCacheEntryAttributeOutputStream(handle, attribute);
    }

    public void removeCacheEntryAttributes(IFileHandle handle, String attribute) {
        this.metadataCache.removeCacheEntryAttributes(handle, attribute);
    }

    public void clear() {
        this.metadataCache.clear();
    }

    public File getEntryAsFile(IFileHandle handle, String attribute) {
        return this.metadataCache.getEntryAsFile(handle, attribute);
    }

    public void updateFolderTimestamps(IFileHandle parent) {
        this.metadataCache.updateFolderTimestamps(parent);
    }
}

