/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.utils;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.utils.TextUtils;
import org.osgi.service.prefs.BackingStoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DLTKLogging {
    private static DLTKDebugOptions debugOptions = null;

    private static synchronized DLTKDebugOptions getDebugOptions() {
        if (debugOptions == null) {
            debugOptions = new DLTKDebugOptions();
            String loggingOptions = new InstanceScope().getNode("org.eclipse.dltk.core").get("org.eclipse.dltk.core.logging.options", null);
            if (loggingOptions != null) {
                String[] stringArray = TextUtils.split(loggingOptions, ';');
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String option = stringArray[n2];
                    debugOptions.add(option);
                    ++n2;
                }
            }
        }
        return debugOptions;
    }

    private static synchronized void setDebugOptions(DLTKDebugOptions debugOptions) {
        DLTKLogging.debugOptions = new DLTKDebugOptions(debugOptions);
    }

    private static DLTKDebugOptions copy(DLTKDebugOptions source) {
        return new DLTKDebugOptions(source);
    }

    public static boolean isEnabled(String option) {
        DLTKDebugOptions debugOptions = DLTKLogging.getDebugOptions();
        return debugOptions.contains(option);
    }

    public static void setEnabled(String option, boolean value) {
        DLTKDebugOptions debugOptions = DLTKLogging.copy(DLTKLogging.getDebugOptions());
        if (value) {
            debugOptions.add(option);
        } else {
            debugOptions.remove(option);
        }
        DLTKLogging.setDebugOptions(debugOptions);
    }

    public static Map<String, Boolean> getState(Collection<String> options) {
        DLTKDebugOptions debugOptions = DLTKLogging.getDebugOptions();
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        for (String option : options) {
            boolean value = debugOptions.contains(option);
            result.put(option, value);
        }
        return result;
    }

    public static void setState(Map<String, Boolean> state) {
        DLTKDebugOptions debugOptions = DLTKLogging.copy(DLTKLogging.getDebugOptions());
        for (Map.Entry<String, Boolean> entry : state.entrySet()) {
            if (entry.getValue().booleanValue()) {
                debugOptions.add(entry.getKey());
                continue;
            }
            debugOptions.remove(entry.getKey());
        }
        IEclipsePreferences node = new InstanceScope().getNode("org.eclipse.dltk.core");
        if (!debugOptions.isEmpty()) {
            node.put("org.eclipse.dltk.core.logging.options", TextUtils.join(debugOptions, ';'));
        } else {
            node.remove("org.eclipse.dltk.core.logging.options");
        }
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            DLTKCore.error("Error Saving Logging Options", e);
        }
        DLTKLogging.setDebugOptions(debugOptions);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DLTKDebugOptions
    extends HashSet<String> {
        public DLTKDebugOptions() {
        }

        public DLTKDebugOptions(DLTKDebugOptions source) {
            super(source);
        }
    }
}

