/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.testing.model;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.internal.testing.Messages;
import org.eclipse.dltk.internal.testing.model.ITestRunSessionListener;
import org.eclipse.dltk.internal.testing.model.ModelMessages;
import org.eclipse.dltk.internal.testing.model.RemoteTestRunnerClient;
import org.eclipse.dltk.internal.testing.model.SocketTestRunnerClient;
import org.eclipse.dltk.internal.testing.model.TestRunHandler;
import org.eclipse.dltk.internal.testing.model.TestRunSession;
import org.eclipse.dltk.internal.testing.model.TestRunSessionSerializer;
import org.eclipse.dltk.internal.testing.ui.TestRunnerViewPart;
import org.eclipse.dltk.testing.DLTKTestingConstants;
import org.eclipse.dltk.testing.DLTKTestingPlugin;
import org.eclipse.dltk.testing.ITestSession;
import org.eclipse.dltk.testing.model.ITestRunSession;
import org.eclipse.dltk.testing.model.ITestingModel;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class DLTKTestingModel
implements ITestingModel {
    private final ListenerList fTestRunSessionListeners = new ListenerList();
    private final LinkedList fTestRunSessions = new LinkedList();
    private final DLTKTestingLaunchListener fLaunchListener = new DLTKTestingLaunchListener();
    private boolean started = false;

    public static IScriptProject getScriptProject(ILaunchConfiguration configuration) {
        try {
            String projectName = configuration.getAttribute("project", null);
            if (projectName != null && projectName.length() > 0) {
                return DLTKCore.create((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(projectName));
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    public synchronized void start() {
        if (this.started) {
            return;
        }
        this.started = true;
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        launchManager.addLaunchListener((ILaunchListener)this.fLaunchListener);
        this.fLaunchListener.initialize(launchManager);
    }

    public void stop() {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        launchManager.removeLaunchListener((ILaunchListener)this.fLaunchListener);
        File historyDirectory = DLTKTestingPlugin.getHistoryDirectory();
        File[] swapFiles = historyDirectory.listFiles();
        if (swapFiles != null) {
            int i = 0;
            while (i < swapFiles.length) {
                swapFiles[i].delete();
                ++i;
            }
        }
        this.started = false;
    }

    public void addTestRunSessionListener(ITestRunSessionListener listener) {
        this.fTestRunSessionListeners.add((Object)listener);
    }

    public void removeTestRunSessionListener(ITestRunSessionListener listener) {
        this.fTestRunSessionListeners.remove((Object)listener);
    }

    public List getTestRunSessions() {
        return new ArrayList(this.fTestRunSessions);
    }

    public ITestRunSession getTestRunSession(ILaunch launch) {
        String inputLaunchKey = launch.getAttribute("org.eclipse.dltk.testing.LAUNCH_KEY");
        if (inputLaunchKey != null) {
            for (TestRunSession session : this.fTestRunSessions) {
                ILaunch sessionLaunch = session.getLaunch();
                if (sessionLaunch == null || !inputLaunchKey.equals(sessionLaunch.getAttribute("org.eclipse.dltk.testing.LAUNCH_KEY"))) continue;
                return session;
            }
        }
        return null;
    }

    public void addTestRunSession(TestRunSession testRunSession) {
        Assert.isNotNull((Object)testRunSession);
        Assert.isLegal((!this.fTestRunSessions.contains(testRunSession) ? 1 : 0) != 0);
        this.fTestRunSessions.addFirst(testRunSession);
        this.notifyTestRunSessionAdded(testRunSession);
    }

    public static ITestSession importTestRunSession(File file) throws CoreException {
        try {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            SAXParser parser = parserFactory.newSAXParser();
            TestRunHandler handler = new TestRunHandler();
            parser.parse(file, (DefaultHandler)handler);
            TestRunSession session = handler.getTestRunSession();
            DLTKTestingPlugin.getModel().addTestRunSession(session);
            return session;
        }
        catch (ParserConfigurationException e) {
            DLTKTestingModel.throwImportError(file, e);
        }
        catch (SAXException e) {
            DLTKTestingModel.throwImportError(file, e);
        }
        catch (IOException e) {
            DLTKTestingModel.throwImportError(file, e);
        }
        return null;
    }

    public static void importIntoTestRunSession(File swapFile, TestRunSession testRunSession) throws CoreException {
        try {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            SAXParser parser = parserFactory.newSAXParser();
            TestRunHandler handler = new TestRunHandler(testRunSession);
            parser.parse(swapFile, (DefaultHandler)handler);
        }
        catch (ParserConfigurationException e) {
            DLTKTestingModel.throwImportError(swapFile, e);
        }
        catch (SAXException e) {
            DLTKTestingModel.throwImportError(swapFile, e);
        }
        catch (IOException e) {
            DLTKTestingModel.throwImportError(swapFile, e);
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void exportTestRunSession(TestRunSession testRunSession, File file) throws CoreException {
        FileOutputStream out = null;
        try {
            try {
                out = new FileOutputStream(file);
                DLTKTestingModel.exportTestRunSession(testRunSession, out);
                return;
            }
            catch (IOException e) {
                DLTKTestingModel.throwExportError(file, e);
                if (out == null) return;
                try {
                    out.close();
                    return;
                }
                catch (IOException e2) {
                    DLTKTestingPlugin.log(e2);
                }
                return;
            }
            catch (TransformerConfigurationException e) {
                DLTKTestingModel.throwExportError(file, e);
                if (out == null) return;
                try {
                    out.close();
                    return;
                }
                catch (IOException e2) {
                    DLTKTestingPlugin.log(e2);
                }
                return;
            }
            catch (TransformerException e) {
                DLTKTestingModel.throwExportError(file, e);
                if (out == null) return;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    out.close();
                    return;
                }
                catch (IOException e2) {
                    DLTKTestingPlugin.log(e2);
                }
                return;
            }
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e2) {
                    DLTKTestingPlugin.log(e2);
                }
            }
        }
    }

    public static void exportTestRunSession(TestRunSession testRunSession, OutputStream out) throws TransformerFactoryConfigurationError, TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        InputSource inputSource = new InputSource();
        SAXSource source = new SAXSource(new TestRunSessionSerializer(testRunSession), inputSource);
        StreamResult result = new StreamResult(out);
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", "yes");
        try {
            transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "2");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        transformer.transform(source, result);
    }

    private static void throwExportError(File file, Exception e) throws CoreException {
        throw new CoreException((IStatus)new Status(4, DLTKTestingPlugin.getPluginId(), Messages.format(ModelMessages.JUnitModel_could_not_write, file.getAbsolutePath()), (Throwable)e));
    }

    private static void throwImportError(File file, Exception e) throws CoreException {
        throw new CoreException((IStatus)new Status(4, DLTKTestingPlugin.getPluginId(), Messages.format(ModelMessages.JUnitModel_could_not_read, file.getAbsolutePath()), (Throwable)e));
    }

    public void removeTestRunSession(TestRunSession testRunSession) {
        boolean existed = this.fTestRunSessions.remove(testRunSession);
        if (existed) {
            this.notifyTestRunSessionRemoved(testRunSession);
        }
        testRunSession.removeSwapFile();
    }

    private void notifyTestRunSessionRemoved(TestRunSession testRunSession) {
        testRunSession.stopTestRun();
        ILaunch launch = testRunSession.getLaunch();
        if (launch != null) {
            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
            launchManager.removeLaunch(launch);
        }
        Object[] listeners = this.fTestRunSessionListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ITestRunSessionListener)listeners[i]).sessionRemoved(testRunSession);
            ++i;
        }
    }

    private void notifyTestRunSessionAdded(TestRunSession testRunSession) {
        Object[] listeners = this.fTestRunSessionListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ITestRunSessionListener)listeners[i]).sessionAdded(testRunSession);
            ++i;
        }
    }

    private final class DLTKTestingLaunchListener
    implements ILaunchListener {
        private final HashSet fTrackedLaunches = new HashSet(20);

        private DLTKTestingLaunchListener() {
        }

        protected void initialize(ILaunchManager launchManager) {
            this.fTrackedLaunches.clear();
            ILaunch[] launchs = launchManager.getLaunches();
            int i = 0;
            int size = launchs.length;
            while (i < size) {
                this.fTrackedLaunches.add(launchs[i]);
                ++i;
            }
        }

        public void launchAdded(ILaunch launch) {
            this.fTrackedLaunches.add(launch);
        }

        public void launchRemoved(ILaunch launch) {
            this.fTrackedLaunches.remove(launch);
        }

        public void launchChanged(final ILaunch launch) {
            if (!this.fTrackedLaunches.contains(launch)) {
                return;
            }
            ILaunchConfiguration config = launch.getLaunchConfiguration();
            if (config == null) {
                return;
            }
            final IScriptProject javaProject = DLTKTestingConstants.getScriptProject(config);
            if (javaProject == null) {
                return;
            }
            String portStr = launch.getAttribute("org.eclipse.dltk.testing.PORT");
            if (portStr != null) {
                try {
                    final int port = Integer.parseInt(portStr);
                    this.fTrackedLaunches.remove(launch);
                    this.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            DLTKTestingLaunchListener.this.connectTestRunner(launch, javaProject, port);
                        }
                    });
                }
                catch (NumberFormatException numberFormatException) {
                    return;
                }
            } else {
                String atr = launch.getAttribute("org.eclipse.dltk.testing.LAUNCH_KEY");
                if (atr != null) {
                    this.fTrackedLaunches.remove(launch);
                    this.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            DLTKTestingLaunchListener.this.connectTestRunner(launch, javaProject);
                        }
                    });
                }
            }
        }

        private void connectTestRunner(ILaunch launch, IScriptProject javaProject) {
            this.showTestRunnerViewPartInActivePage(this.findTestRunnerViewPartInActivePage());
            this.limitSessionHistory();
            DLTKTestingModel.this.addTestRunSession(new TestRunSession(launch, javaProject, new RemoteTestRunnerClient()));
        }

        private void connectTestRunner(ILaunch launch, IScriptProject javaProject, int port) {
            this.showTestRunnerViewPartInActivePage(this.findTestRunnerViewPartInActivePage());
            this.limitSessionHistory();
            DLTKTestingModel.this.addTestRunSession(new TestRunSession(launch, javaProject, new SocketTestRunnerClient(port)));
        }

        private void limitSessionHistory() {
            int maxCount = DLTKTestingPlugin.getDefault().getPreferenceStore().getInt("org.eclipse.dltk.testing.max_test_runs");
            int toDelete = DLTKTestingModel.this.fTestRunSessions.size() - maxCount;
            while (toDelete > 0) {
                --toDelete;
                TestRunSession session = (TestRunSession)DLTKTestingModel.this.fTestRunSessions.removeLast();
                DLTKTestingModel.this.notifyTestRunSessionRemoved(session);
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private TestRunnerViewPart showTestRunnerViewPartInActivePage(TestRunnerViewPart testRunner) {
            block12: {
                block11: {
                    block9: {
                        block10: {
                            activePart = null;
                            page = null;
                            try {
                                if (testRunner != null && testRunner.isCreated()) {
                                    var6_4 = testRunner;
                                    if (page == null || activePart == null) break block9;
                                    break block10;
                                }
                                ** GOTO lbl-1000
                            }
                            catch (PartInitException pie) {
                                DLTKTestingPlugin.log(pie);
                            }
                            finally {
                                if (page == null || activePart == null) break block11;
                            }
                        }
                        page.activate(activePart);
                    }
                    return var6_4;
lbl-1000:
                    // 1 sources

                    {
                        page = DLTKTestingPlugin.getActivePage();
                        if (page == null) {
                        }
                        ** GOTO lbl-1000
                    }
                    page.activate(activePart);
                }
                return null;
lbl-1000:
                // 1 sources

                {
                    activePart = page.getActivePart();
                    var6_5 = (TestRunnerViewPart)page.showView("org.eclipse.dltk.testing.ResultView");
                    if (page == null || activePart == null) break block12;
                }
                page.activate(activePart);
            }
            return var6_5;
        }

        private TestRunnerViewPart findTestRunnerViewPartInActivePage() {
            IWorkbenchPage page = DLTKTestingPlugin.getActivePage();
            if (page == null) {
                return null;
            }
            return (TestRunnerViewPart)page.findView("org.eclipse.dltk.testing.ResultView");
        }

        private Display getDisplay() {
            Display display = Display.getCurrent();
            if (display == null) {
                display = Display.getDefault();
            }
            return display;
        }
    }
}

