/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.templates;

import java.io.IOException;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.templates.TemplateMessages;
import org.eclipse.dltk.ui.text.templates.ITemplateAccess;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.editors.text.templates.ContributionContextTypeRegistry;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;

public abstract class ScriptTemplateAccess
implements ITemplateAccess {
    private ContextTypeRegistry fRegistry;
    private TemplateStore fStore;

    public TemplateStore getTemplateStore() {
        if (this.fStore == null) {
            this.fStore = new ContributionTemplateStore(this.getContextTypeRegistry(), this.getPreferenceStore(), this.getCustomTemplatesKey());
            this.loadTemplates();
        }
        return this.fStore;
    }

    public ContextTypeRegistry getContextTypeRegistry() {
        if (this.fRegistry == null) {
            this.fRegistry = this.createContextTypeRegistry();
        }
        return this.fRegistry;
    }

    protected ContextTypeRegistry createContextTypeRegistry() {
        ContributionContextTypeRegistry registry = new ContributionContextTypeRegistry();
        registry.addContextType(this.getContextTypeId());
        return registry;
    }

    protected abstract String getContextTypeId();

    protected abstract String getCustomTemplatesKey();

    protected abstract IPreferenceStore getPreferenceStore();

    public IPreferenceStore getTemplatePreferenceStore() {
        return this.getPreferenceStore();
    }

    private void loadTemplates() {
        try {
            this.fStore.load();
        }
        catch (IOException e) {
            String msg = NLS.bind((String)TemplateMessages.ScriptTemplateAccess_unableToLoadTemplateStore, (Object)e);
            DLTKUIPlugin.logErrorMessage(msg, e);
        }
    }
}

