/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.terminal.view.ui.view;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.tm.internal.terminal.control.ITerminalViewControl;
import org.eclipse.tm.terminal.view.ui.interfaces.ILauncherDelegate;
import org.eclipse.tm.terminal.view.ui.interfaces.IMementoHandler;
import org.eclipse.tm.terminal.view.ui.launcher.LauncherDelegateManager;
import org.eclipse.tm.terminal.view.ui.view.TerminalsView;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;

public class TerminalsViewMementoHandler {
    private final List<CTabItem> saveables = new ArrayList<CTabItem>();

    public void setSaveables(List<CTabItem> saveables) {
        Assert.isNotNull(saveables);
        this.saveables.clear();
        this.saveables.addAll(saveables);
    }

    public void saveState(TerminalsView view, IMemento memento) {
        Assert.isNotNull((Object)view);
        Assert.isNotNull((Object)memento);
        memento = memento.createChild("terminalConnections");
        Assert.isNotNull((Object)memento);
        memento.putString("id", view.getViewSite().getId());
        memento.putString("secondaryId", view.getViewSite().getSecondaryId());
        for (CTabItem item : this.saveables) {
            ITerminalViewControl terminal;
            String encoding;
            IMementoHandler mementoHandler;
            Map properties;
            if (item.isDisposed() || (properties = (Map)item.getData("properties")) == null) continue;
            String delegateId = (String)properties.get("delegateId");
            ILauncherDelegate delegate = delegateId != null ? LauncherDelegateManager.getInstance().getLauncherDelegate(delegateId, false) : null;
            IMementoHandler iMementoHandler = mementoHandler = delegate != null ? (IMementoHandler)delegate.getAdapter(IMementoHandler.class) : null;
            if (mementoHandler == null) continue;
            IMemento connectionMemento = memento.createChild("connection");
            Assert.isNotNull((Object)connectionMemento);
            connectionMemento.putString("delegateId", delegateId);
            String terminalConnectorId = (String)properties.get("tm.terminal.connector.id");
            if (terminalConnectorId != null) {
                connectionMemento.putString("tm.terminal.connector.id", terminalConnectorId);
            }
            if (properties.get("terminal.forceNew") instanceof Boolean) {
                connectionMemento.putBoolean("terminal.forceNew", ((Boolean)properties.get("terminal.forceNew")).booleanValue());
            }
            String string = encoding = (terminal = (ITerminalViewControl)item.getData()) != null ? terminal.getEncoding() : null;
            if (encoding == null || "".equals(encoding)) {
                encoding = (String)properties.get("encoding");
            }
            if (encoding != null && !"".equals(encoding)) {
                connectionMemento.putString("encoding", encoding);
            }
            if (terminal != null) {
                encoding = terminal.getEncoding();
                Optional workingDirectory = terminal.getTerminalConnector().getWorkingDirectory();
                String cwd = workingDirectory.orElse((String)properties.get("process.working_dir"));
                if (cwd != null) {
                    connectionMemento.putString("process.working_dir", cwd);
                }
            }
            mementoHandler.saveState(connectionMemento, properties);
        }
    }

    protected void restoreState(TerminalsView view, IMemento memento) {
        Assert.isNotNull((Object)view);
        Assert.isNotNull((Object)memento);
        memento = memento.getChild("terminalConnections");
        if (memento != null) {
            IMemento[] connections;
            String id = memento.getString("id");
            String secondaryId = memento.getString("secondaryId");
            if ("null".equals(secondaryId)) {
                secondaryId = null;
            }
            IMemento[] iMementoArray = connections = memento.getChildren("connection");
            int n = connections.length;
            int n2 = 0;
            while (n2 < n) {
                IMementoHandler mementoHandler;
                String delegateId;
                IMemento connection = iMementoArray[n2];
                HashMap<String, Object> properties = new HashMap<String, Object>();
                properties.put("id", id);
                properties.put("secondaryId", secondaryId);
                properties.put("delegateId", connection.getString("delegateId"));
                properties.put("tm.terminal.connector.id", connection.getString("tm.terminal.connector.id"));
                if (connection.getBoolean("terminal.forceNew") != null) {
                    properties.put("terminal.forceNew", connection.getBoolean("terminal.forceNew"));
                }
                if (connection.getString("encoding") != null) {
                    properties.put("encoding", connection.getString("encoding"));
                }
                if (connection.getString("process.working_dir") != null) {
                    properties.put("process.working_dir", connection.getString("process.working_dir"));
                }
                ILauncherDelegate delegate = (delegateId = (String)properties.get("delegateId")) != null ? LauncherDelegateManager.getInstance().getLauncherDelegate(delegateId, false) : null;
                IMementoHandler iMementoHandler = mementoHandler = delegate != null ? (IMementoHandler)delegate.getAdapter(IMementoHandler.class) : null;
                if (mementoHandler != null) {
                    mementoHandler.restoreState(connection, properties);
                }
                if (delegate != null && !properties.isEmpty()) {
                    delegate.execute(properties, null);
                }
                ++n2;
            }
        }
    }

    void asyncExec(Runnable runnable) {
        Assert.isNotNull((Object)runnable);
        if (PlatformUI.getWorkbench() != null && PlatformUI.getWorkbench().getDisplay() != null && !PlatformUI.getWorkbench().getDisplay().isDisposed()) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(runnable);
        }
    }
}

