/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import org.eclipse.mylyn.internal.tasks.ui.editors.Messages;

public class AttachmentSizeFormatter {
    public static final String UNKNOWN_SIZE = "-";
    private final DecimalFormat decimalFormat;

    public static final AttachmentSizeFormatter getInstance() {
        return new AttachmentSizeFormatter();
    }

    public AttachmentSizeFormatter() {
        this(Locale.getDefault());
    }

    public AttachmentSizeFormatter(Locale locale) {
        this.decimalFormat = (DecimalFormat)NumberFormat.getInstance(locale);
    }

    public String format(String sizeInBytes) {
        if (sizeInBytes == null) {
            return UNKNOWN_SIZE;
        }
        try {
            return this.format(Long.parseLong(sizeInBytes));
        }
        catch (NumberFormatException e) {
            return UNKNOWN_SIZE;
        }
    }

    public String format(long size) {
        if (size < 0L) {
            return UNKNOWN_SIZE;
        }
        if (size < 1024L) {
            if (size == 1L) {
                return Messages.AttachmentSizeFormatter_1_byte;
            }
            DecimalFormat fmt = new DecimalFormat(Messages.AttachmentSizeFormatter_0_bytes);
            return fmt.format(size);
        }
        if (size >= 1024L && size <= 1048575L) {
            double formattedValue = (double)size / 1024.0;
            this.decimalFormat.applyPattern(Messages.AttachmentSizeFormatter_0_KB);
            return this.decimalFormat.format(formattedValue);
        }
        if (size >= 0x100000L && size <= 0x3FFFFFFFL) {
            double formattedValue = (double)size / 1048576.0;
            this.decimalFormat.applyPattern(Messages.AttachmentSizeFormatter_0_MB);
            return this.decimalFormat.format(formattedValue);
        }
        double formattedValue = (double)size / 1.073741824E9;
        this.decimalFormat.applyPattern(Messages.AttachmentSizeFormatter_0_GB);
        return this.decimalFormat.format(formattedValue);
    }
}

