/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.internal.enablement;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.wst.common.core.util.RegistryReader;
import org.eclipse.wst.common.frameworks.internal.WTPResourceHandler;
import org.eclipse.wst.common.frameworks.internal.enablement.AscendingGroupComparator;
import org.eclipse.wst.common.frameworks.internal.enablement.DescendingGroupComparator;
import org.eclipse.wst.common.frameworks.internal.enablement.FunctionGroup;
import org.eclipse.wst.common.frameworks.internal.enablement.FunctionGroupPatternBinding;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

public class FunctionGroupRegistry
extends RegistryReader {
    private static FunctionGroupRegistry INSTANCE = null;
    public static final String GROUP_ELEMENT = "functionGroup";
    public static final String GROUP_ID_ATTR = "functionGroupID";
    public static final String FUNCTION_GROUP_PATTERN_BINDING_ELMT = "functionGroupPatternBinding";
    public static final String PATTERN_ATTR = "pattern";
    private Map groupMapById;
    private List knownGroups;
    private Map patternBindingsByGroupId = new HashMap();

    private FunctionGroupRegistry() {
        super("org.eclipse.wst.common.frameworks", GROUP_ELEMENT);
    }

    public static FunctionGroupRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new FunctionGroupRegistry();
            INSTANCE.readRegistry();
        }
        return INSTANCE;
    }

    public void readRegistry() {
        super.readRegistry();
        this.setPatternBindings();
    }

    private void setPatternBindings() {
        for (Map.Entry entry : this.patternBindingsByGroupId.entrySet()) {
            String groupId = (String)entry.getKey();
            Set value = (Set)entry.getValue();
            FunctionGroup aGroup = this.getGroupByID(groupId);
            if (aGroup == null) continue;
            aGroup.setFunctionGroupPatternBindings(value);
        }
    }

    public boolean readElement(IConfigurationElement element) {
        if (element.getName().equals(GROUP_ELEMENT)) {
            this.readGroup(element);
            return true;
        }
        if (element.getName().equals(FUNCTION_GROUP_PATTERN_BINDING_ELMT)) {
            this.readPatternBinding(element);
            return true;
        }
        return false;
    }

    private void readPatternBinding(IConfigurationElement element) {
        String groupID = element.getAttribute(GROUP_ID_ATTR);
        String pattern = element.getAttribute(PATTERN_ATTR);
        if (!this.isNullOrEmpty(groupID) && !this.isNullOrEmpty(pattern)) {
            Pattern aPattern = Pattern.compile(pattern);
            FunctionGroupPatternBinding binding = new FunctionGroupPatternBinding(groupID, aPattern);
            this.addPatternBinding(groupID, binding);
        }
    }

    private void addPatternBinding(String groupID, FunctionGroupPatternBinding binding) {
        HashSet<FunctionGroupPatternBinding> bindings = (HashSet<FunctionGroupPatternBinding>)this.patternBindingsByGroupId.get(groupID);
        if (bindings == null) {
            bindings = new HashSet<FunctionGroupPatternBinding>();
            this.patternBindingsByGroupId.put(groupID, bindings);
        }
        bindings.add(binding);
    }

    private boolean isNullOrEmpty(String aString) {
        return aString == null || aString.length() == 0;
    }

    private void readGroup(IConfigurationElement element) {
        String groupID = element.getAttribute(GROUP_ID_ATTR);
        if (!this.isNullOrEmpty(groupID)) {
            FunctionGroup group = new FunctionGroup(groupID, element);
            this.getGroupMapById().put(groupID, group);
            this.getKnownGroups().add(group);
        }
    }

    private List getAscendingSortedGroups(IProject project) {
        Comparator ascendingGrpComparator = AscendingGroupComparator.singleton();
        List groupList = this.getKnownGroups(project);
        Collections.sort(groupList, ascendingGrpComparator);
        return groupList;
    }

    private List getDescendingSortedGroups(IProject project) {
        Comparator descendingGrpComparator = DescendingGroupComparator.singleton();
        List groupList = this.getKnownGroups(project);
        Collections.sort(groupList, descendingGrpComparator);
        return groupList;
    }

    public List getKnownGroups(IProject project) {
        ArrayList<FunctionGroup> groupByProjectList = new ArrayList<FunctionGroup>(this.getKnownGroups().size());
        List groupList = this.getKnownGroups();
        int i = 0;
        while (i < groupList.size()) {
            FunctionGroup group = (FunctionGroup)groupList.get(i);
            if (group.isEnabled(project)) {
                groupByProjectList.add(group);
            }
            ++i;
        }
        return groupByProjectList;
    }

    public List getAscendingPriorityGroupNames(IProject project) {
        List sortedGroup = this.getAscendingSortedGroups(project);
        return this.getGroupListNames(sortedGroup, new ArrayList(sortedGroup.size()));
    }

    public List getDescendingPriorityGroupNames(IProject project) {
        List sortedGroup = this.getDescendingSortedGroups(project);
        return this.getGroupListNames(sortedGroup, new ArrayList(sortedGroup.size()));
    }

    private List getGroupListNames(List sortedGroup, List sortedGroupNames) {
        int i = 0;
        while (i < sortedGroup.size()) {
            FunctionGroup grp = (FunctionGroup)sortedGroup.get(i);
            sortedGroupNames.add(grp.getGroupID());
            ++i;
        }
        return sortedGroupNames;
    }

    public Iterator getGroupIDs() {
        return this.getGroupMapById().keySet().iterator();
    }

    public FunctionGroup getGroupByID(String groupID) {
        return (FunctionGroup)this.getGroupMapById().get(groupID);
    }

    public boolean isGroupEnabled(IProject project, String groupID) {
        FunctionGroup group = this.getGroupByID(groupID);
        if (group != null) {
            return group.isEnabled(project);
        }
        return false;
    }

    public List getKnownGroups() {
        if (this.knownGroups == null) {
            this.knownGroups = new ArrayList();
        }
        return this.knownGroups;
    }

    protected Map getGroupMapById() {
        if (this.groupMapById == null) {
            this.groupMapById = new HashMap();
        }
        return this.groupMapById;
    }

    public int compare(String groupID1, String groupID2) {
        FunctionGroup group1 = this.getGroupByID(groupID1);
        FunctionGroup group2 = this.getGroupByID(groupID2);
        if (group1 == null) {
            WTPCommonPlugin.logError(new IllegalArgumentException(WTPResourceHandler.getString("28", new Object[]{groupID1})));
            return -1;
        }
        if (group2 == null) {
            WTPCommonPlugin.logError(new IllegalArgumentException(WTPResourceHandler.getString("28", new Object[]{groupID2})));
            return 1;
        }
        return group1.compareTo(group2);
    }

    public int getGroupPriority(String grpId) {
        FunctionGroup group = this.getGroupByID(grpId);
        return group != null ? group.getPriority() : -1;
    }

    public int getFunctionPriority(String enablementID) {
        int priority = Integer.MAX_VALUE;
        for (FunctionGroup group : this.getKnownGroups()) {
            if (!group.isMatch(enablementID)) continue;
            priority = Math.min(priority, group.getPriority());
        }
        return priority;
    }
}

