/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.makefile;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.cdt.make.core.makefile.IDirective;
import org.eclipse.cdt.make.core.makefile.IParent;
import org.eclipse.cdt.make.internal.core.makefile.Directive;

public abstract class Parent
extends Directive
implements IParent {
    ArrayList<Directive> children = new ArrayList();

    public Parent(Directive parent) {
        super(parent);
    }

    public IDirective[] getDirectives(boolean expand) {
        if (expand) {
            ArrayList<IDirective> directives = new ArrayList<IDirective>();
            this.getDirectives();
            for (IDirective iDirective : this.children) {
                directives.add(iDirective);
                if (!(iDirective instanceof Parent)) continue;
                directives.addAll(Arrays.asList(((Parent)iDirective).getDirectives(expand)));
            }
            return directives.toArray(new IDirective[directives.size()]);
        }
        return this.getDirectives();
    }

    @Override
    public IDirective[] getDirectives() {
        this.children.trimToSize();
        return this.children.toArray(new IDirective[0]);
    }

    public void addDirective(Directive directive) {
        this.children.add(directive);
        directive.setParent(this);
    }

    public void addDirectives(Directive[] directives) {
        this.children.addAll(Arrays.asList(directives));
        int i = 0;
        while (i < directives.length) {
            directives[i].setParent(this);
            ++i;
        }
    }

    public void clearDirectives() {
        this.children.clear();
    }

    public Directive[] getStatements() {
        this.children.trimToSize();
        return this.children.toArray(new Directive[0]);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        IDirective[] directives = this.getDirectives();
        int i = 0;
        while (i < directives.length) {
            sb.append(directives[i]);
            ++i;
        }
        return sb.toString();
    }
}

