/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.exporter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.codegen.ecore.genmodel.GenAnnotation;
import org.eclipse.emf.codegen.ecore.genmodel.GenBase;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.ecore.genmodel.util.GenModelUtil;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticException;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.converter.ModelConverter;
import org.eclipse.emf.converter.util.ConverterUtil;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.exporter.ExporterPlugin;
import org.eclipse.emf.exporter.util.ExporterUtil;

public abstract class ModelExporter
extends ModelConverter {
    public static final String GENANNOTATION_SOURCE_PREFIX = "http://www.eclipse.org/emf/2002/GenModel/exporter/";
    public static final String GENANNOTATION_KEY_DIRECTORY_URI = "directoryURI";
    public static final String GENANNOTATION_SOURCE_SELECTED_EPACKAGES = "selectedPackages";
    public static final String GENANNOTATION_SOURCE_SELECTED_REFERENCES = "selectedReferencedPackages";
    protected Map<EPackage, GenPackage> ePackageToGenPackageMap;
    protected URI directoryURI;
    protected Map<GenBase, EMap<String, String>> genBaseToDetailsMap;
    protected boolean saveExporter = false;
    protected boolean saveEPackageArtifactURI = false;

    public void dispose() {
        if (this.genBaseToDetailsMap != null) {
            this.genBaseToDetailsMap.clear();
            this.genBaseToDetailsMap = null;
        }
        if (this.ePackageToGenPackageMap != null) {
            this.ePackageToGenPackageMap.clear();
            this.ePackageToGenPackageMap = null;
        }
        super.dispose();
    }

    protected String getConverterGenAnnotationSource() {
        return GENANNOTATION_SOURCE_PREFIX + this.getID();
    }

    protected Map<EPackage, GenPackage> getEPackageToGenPackageMap() {
        if (this.ePackageToGenPackageMap == null) {
            this.ePackageToGenPackageMap = new HashMap<EPackage, GenPackage>();
        }
        return this.ePackageToGenPackageMap;
    }

    protected Map<GenBase, EMap<String, String>> getGenBaseToGenAnnotationDetailsMap() {
        if (this.genBaseToDetailsMap == null) {
            this.genBaseToDetailsMap = new HashMap<GenBase, EMap<String, String>>();
        }
        return this.genBaseToDetailsMap;
    }

    protected EMap<String, String> getExporterGenAnnotationDetails(GenBase genBase) {
        EMap eMap = this.getGenBaseToGenAnnotationDetailsMap().get(genBase);
        if (eMap == null) {
            GenAnnotation genAnnotation = genBase.getGenAnnotation(this.getConverterGenAnnotationSource());
            if (genAnnotation != null) {
                eMap = genAnnotation.getDetails();
                this.getGenBaseToGenAnnotationDetailsMap().put(genBase, (EMap<String, String>)eMap);
            } else {
                eMap = ECollections.emptyEMap();
            }
        }
        return eMap;
    }

    protected List<GenAnnotation> getExporterNestedGenAnnotations(GenBase genBase) {
        EList nestedAnnotations;
        GenAnnotation exportAnnotation;
        if (genBase != null && (exportAnnotation = genBase.getGenAnnotation(this.getConverterGenAnnotationSource())) != null && !exportAnnotation.getGenAnnotations().isEmpty() && (nestedAnnotations = exportAnnotation.getGenAnnotations()) != null) {
            return nestedAnnotations;
        }
        return Collections.emptyList();
    }

    protected EMap<String, String> getExporterNestedGenAnnotationDetails(GenBase genBase, String nestedGenAnnotationSource) {
        GenAnnotation nestedGenAnnotation;
        GenAnnotation genAnnotation = genBase.getGenAnnotation(this.getConverterGenAnnotationSource());
        if (genAnnotation != null && (nestedGenAnnotation = genAnnotation.getGenAnnotation(nestedGenAnnotationSource)) != null) {
            return nestedGenAnnotation.getDetails();
        }
        return ECollections.emptyEMap();
    }

    public List<URI> getArtifactURIs(GenPackage genPackage) {
        List<GenAnnotation> nestedAnnotations = this.getExporterNestedGenAnnotations((GenBase)genPackage);
        if (!nestedAnnotations.isEmpty()) {
            UniqueEList uris = new UniqueEList(nestedAnnotations.size());
            URI genModelURI = genPackage.getGenModel().eResource() != null ? genPackage.getGenModel().eResource().getURI() : null;
            for (GenAnnotation uriAnnotation : nestedAnnotations) {
                URI uri = URI.createURI((String)uriAnnotation.getSource());
                if (genModelURI != null) {
                    uri = uri.resolve(genModelURI);
                }
                uris.add(uri);
            }
            for (GenPackage referencedGenPackage : this.getReferencedGenPackages()) {
                List<URI> localURIs;
                ReferencedGenPackageExportInfo genPackageInfo = this.getReferencedGenPackageExportInfo(referencedGenPackage);
                if (genPackageInfo.getArtifactURI() == null || (localURIs = genPackageInfo.getNSURIToLocalArtifactURIs().get(genPackage.getNSURI())) == null) continue;
                uris.addAll(localURIs);
            }
            return uris;
        }
        return Collections.emptyList();
    }

    public void setGenModel(GenModel genModel) throws DiagnosticException {
        this.dispose();
        this.genModel = genModel;
        genModel = this.getGenModel();
        Diagnostic diagnostic = null;
        if (genModel != null) {
            GenAnnotation referencedPackagesAnnotation;
            genModel.reconcile();
            genModel.setValidateModel(true);
            diagnostic = genModel.diagnose();
            if (this.getDirectoryURI() == null) {
                String location = (String)this.getExporterGenAnnotationDetails((GenBase)genModel).get((Object)GENANNOTATION_KEY_DIRECTORY_URI);
                this.setDirectoryURI(location);
            }
            if (genModel.eResource() != null && this.getDirectoryURI() != null) {
                this.setDirectoryURI(this.getDirectoryURI().resolve(genModel.eResource().getURI()));
            }
            GenPackagesTreeIterator i = new GenPackagesTreeIterator(genModel);
            while (i.hasNext()) {
                GenPackage genPackage = (GenPackage)i.next();
                if (!this.isValidEPackage(genPackage)) continue;
                EPackage ePackage = genPackage.getEcorePackage();
                this.getEPackageToGenPackageMap().put(ePackage, genPackage);
                this.getEPackages().add(genPackage.getEcorePackage());
            }
            ConverterUtil.GenPackageList exporterUsedGenPackages = new ConverterUtil.GenPackageList((Collection)genModel.getUsedGenPackages());
            GenAnnotation genModelAnnotation = genModel.getGenAnnotation(this.getConverterGenAnnotationSource());
            if (genModelAnnotation != null && (referencedPackagesAnnotation = genModelAnnotation.getGenAnnotation(GENANNOTATION_SOURCE_SELECTED_REFERENCES)) != null) {
                for (Object o : referencedPackagesAnnotation.getReferences()) {
                    if (!(o instanceof GenPackage)) continue;
                    exporterUsedGenPackages.add((GenPackage)o);
                }
            }
            GenPackagesTreeIterator i2 = new GenPackagesTreeIterator((Collection<GenPackage>)exporterUsedGenPackages);
            while (i2.hasNext()) {
                GenPackage genPackage = (GenPackage)i2.next();
                if (!this.isValidEPackage(genPackage)) continue;
                EPackage ePackage = genPackage.getEcorePackage();
                this.getEPackageToGenPackageMap().put(ePackage, genPackage);
                if (this.isValidReferencedGenPackage(genPackage)) {
                    this.getReferencedGenPackages().add(genPackage);
                }
                this.getEPackages().add(ePackage);
            }
        }
        this.adjustGenModel();
        if (diagnostic != null && diagnostic.getSeverity() != 0) {
            throw new DiagnosticException(diagnostic);
        }
    }

    protected void adjustGenModel() {
        boolean defaultLocationSet = false;
        for (Map.Entry entry : this.getEPackageToInfoMap().entrySet()) {
            EPackage ePackage = (EPackage)entry.getKey();
            EPackageExportInfo packageInfo = (EPackageExportInfo)((Object)entry.getValue());
            if (packageInfo.getArtifactLocation() != null) continue;
            packageInfo.setArtifactLocation(this.getDefaultArtifactLocation(ePackage));
            defaultLocationSet |= packageInfo.getArtifactLocation() == null;
        }
        if (defaultLocationSet) {
            this.makeEPackageConvertDataUnique();
        }
    }

    protected String getDefaultArtifactLocation(EPackage ePackage) {
        return null;
    }

    protected boolean isValidEPackage(GenPackage genPackage) {
        return genPackage.getEcorePackage() != null && genPackage.hasClassifiers();
    }

    protected boolean isValidReferencedGenPackage(GenPackage genPackage) {
        return genPackage.getEcorePackage() != null && genPackage.hasClassifiers();
    }

    protected List<EPackage> createEPackagesList() {
        return new ConverterUtil.EPackageList(){
            private static final long serialVersionUID = 1L;

            protected void didAdd(int index, EPackage newObject) {
                String location;
                EPackageExportInfo packageInfo = ModelExporter.this.getEPackageExportInfo(newObject);
                if (packageInfo.getArtifactLocation() == null && (location = (String)ModelExporter.this.getExporterNestedGenAnnotationDetails((GenBase)ModelExporter.this.getGenModel(), ModelExporter.GENANNOTATION_SOURCE_SELECTED_EPACKAGES).get((Object)newObject.getNsURI())) != null) {
                    packageInfo.setConvert(true);
                    packageInfo.setArtifactLocation(location);
                }
            }
        };
    }

    protected List<GenPackage> createReferencedGenPackagesList() {
        return new ConverterUtil.GenPackageList(){
            private static final long serialVersionUID = 1L;

            protected void didAdd(int index, GenPackage newObject) {
                List<GenAnnotation> uriAnnotations;
                ReferencedGenPackageExportInfo genPackageInfo;
                URI genModelURI = newObject.getGenModel().eResource() != null ? newObject.getGenModel().eResource().getURI() : null;
                String stringURI = (String)ModelExporter.this.getExporterNestedGenAnnotationDetails((GenBase)ModelExporter.this.getGenModel(), ModelExporter.GENANNOTATION_SOURCE_SELECTED_REFERENCES).get((Object)newObject.getNSURI());
                if (stringURI != null && (genPackageInfo = ModelExporter.this.getReferencedGenPackageExportInfo(newObject)).getArtifactURI() == null) {
                    genPackageInfo.setModelExporterID(ModelExporter.this.getID());
                    URI uri = URI.createURI((String)stringURI);
                    if (genModelURI != null) {
                        uri = uri.resolve(genModelURI);
                    }
                    genPackageInfo.setArtifactURI(uri);
                }
                if (!(uriAnnotations = ModelExporter.this.getExporterNestedGenAnnotations((GenBase)newObject)).isEmpty()) {
                    ReferencedGenPackageExportInfo genPackageInfo2 = null;
                    for (GenAnnotation uriAnnotation : uriAnnotations) {
                        if (uriAnnotation.getDetails().isEmpty()) continue;
                        if (genPackageInfo2 == null) {
                            genPackageInfo2 = ModelExporter.this.getReferencedGenPackageExportInfo(newObject);
                        }
                        for (Map.Entry entry : uriAnnotation.getDetails()) {
                            String packageNSURI = (String)entry.getKey();
                            String stringArtifactURIs = (String)entry.getValue();
                            if (stringArtifactURIs == null) continue;
                            String[] stringURIs = stringArtifactURIs.split(" ");
                            List<URI> uris = genPackageInfo2.getNSURIToLocalArtifactURIs().get(packageNSURI);
                            if (uris == null) {
                                uris = new ArrayList<URI>(stringURIs.length);
                                genPackageInfo2.getNSURIToLocalArtifactURIs().put(packageNSURI, uris);
                            }
                            int k = 0;
                            while (k < stringURIs.length) {
                                URI uri = URI.createURI((String)stringURIs[k]);
                                if (genModelURI != null) {
                                    uri = uri.resolve(genModelURI);
                                }
                                uris.add(uri);
                                ++k;
                            }
                        }
                    }
                }
            }
        };
    }

    public void loadGenModel(URI uri) throws DiagnosticException {
        this.setGenModel(uri == null ? null : GenModelUtil.getGenModel((Resource)this.createResourceSet().getResource(uri, true)));
    }

    public EPackageExportInfo getEPackageExportInfo(EPackage ePackage) {
        return (EPackageExportInfo)this.getEPackageConvertInfo(ePackage);
    }

    protected ModelConverter.EPackageConvertInfo createEPackageInfo(EPackage ePackage) {
        return new EPackageExportInfo();
    }

    public ReferencedGenPackageExportInfo getReferencedGenPackageExportInfo(GenPackage genPackage) {
        return (ReferencedGenPackageExportInfo)this.getReferenceGenPackageConvertInfo(genPackage);
    }

    protected ModelConverter.ReferencedGenPackageConvertInfo createGenPackageConvertInfo(GenPackage genPackage) {
        ReferencedGenPackageExportInfo genPackageInfo = new ReferencedGenPackageExportInfo();
        genPackageInfo.setValidReference(!this.getExporterNestedGenAnnotations((GenBase)genPackage).isEmpty());
        return genPackageInfo;
    }

    protected ModelConverter.ReferencedEPackageFilter createReferencedEPackageFilterToConvert() {
        return new ModelConverter.ReferencedEPackageFilter(this){

            protected boolean isValidReference(GenPackage genPackage) {
                return super.isValidReference(genPackage) && ModelExporter.this.getReferencedGenPackageExportInfo(genPackage).getArtifactURI() != null;
            }
        };
    }

    protected boolean canConvert(EPackage ePackage) {
        return super.canConvert(ePackage) && this.getEPackageExportInfo(ePackage).getArtifactLocation() != null;
    }

    public Diagnostic export(Monitor monitor) throws Exception {
        HashMap<String, GenPackage> nsURIToReferencedGenPackage = null;
        HashMap<GenPackage, URI> referencedGenPackageToArtifactURI = null;
        if (this.referencedGenPackageToInfoMap != null) {
            referencedGenPackageToArtifactURI = new HashMap<GenPackage, URI>(this.referencedGenPackageToInfoMap.size());
            nsURIToReferencedGenPackage = new HashMap<String, GenPackage>(this.referencedGenPackageToInfoMap.size());
            List referencedGenPackages = this.computeValidReferencedGenPackages();
            for (GenPackage genPackage : referencedGenPackages) {
                URI artifactURI = this.getReferencedGenPackageExportInfo(genPackage).getArtifactURI();
                referencedGenPackageToArtifactURI.put(genPackage, artifactURI);
                nsURIToReferencedGenPackage.put(genPackage.getNSURI(), genPackage);
            }
        }
        HashMap<GenPackage, URI> genPackageToArtifactURI = null;
        HashMap<GenPackage, ConverterUtil.GenPackageList> genPackageToReferencedGenPackages = null;
        if (this.ePackageToInfoMap != null && this.ePackageToGenPackageMap != null) {
            genPackageToArtifactURI = new HashMap<GenPackage, URI>(this.ePackageToInfoMap.size());
            genPackageToReferencedGenPackages = new HashMap<GenPackage, ConverterUtil.GenPackageList>(this.ePackageToInfoMap.size());
            List ePackages = this.computeEPackagesToConvert();
            for (EPackage ePackage : ePackages) {
                EPackageExportInfo exportInfo;
                String artifactLocation;
                GenPackage genPackage = this.ePackageToGenPackageMap.get(ePackage);
                if (genPackage == null) continue;
                if (nsURIToReferencedGenPackage != null) {
                    List requiredEPackages = ConverterUtil.computeRequiredPackages((EPackage)ePackage);
                    ConverterUtil.GenPackageList requiredGenPackages = new ConverterUtil.GenPackageList(requiredEPackages.size());
                    for (EPackage requiredEPackage : requiredEPackages) {
                        GenPackage referencedGenPackage = (GenPackage)nsURIToReferencedGenPackage.get(requiredEPackage.getNsURI());
                        if (referencedGenPackage == null) continue;
                        requiredGenPackages.add(referencedGenPackage);
                    }
                    if (!requiredGenPackages.isEmpty()) {
                        genPackageToReferencedGenPackages.put(genPackage, requiredGenPackages);
                    }
                }
                if ((artifactLocation = (exportInfo = this.getEPackageExportInfo(ePackage)).getArtifactLocation()) == null) continue;
                genPackageToArtifactURI.put(genPackage, this.computeArtifactURI(artifactLocation));
            }
        }
        if (genPackageToArtifactURI == null || genPackageToArtifactURI.isEmpty()) {
            throw new DiagnosticException((Diagnostic)new BasicDiagnostic(4, "org.eclipse.emf.exporter", 0, ExporterPlugin.INSTANCE.getString("_UI_NoPackagesToExport_error"), null));
        }
        ExportData exportData = new ExportData();
        exportData.genPackageToArtifactURI = genPackageToArtifactURI;
        exportData.referencedGenPackagesToArtifactURI = referencedGenPackageToArtifactURI != null && !referencedGenPackageToArtifactURI.isEmpty() ? referencedGenPackageToArtifactURI : Collections.emptyMap();
        exportData.genPackageToReferencedGenPackages = genPackageToReferencedGenPackages != null && !genPackageToReferencedGenPackages.isEmpty() ? genPackageToReferencedGenPackages : Collections.emptyMap();
        return this.doExport(monitor, exportData);
    }

    protected Diagnostic doExport(Monitor monitor, ExportData exportData) throws Exception {
        return Diagnostic.OK_INSTANCE;
    }

    public Diagnostic checkEPackageArtifactLocation(String location, String packageName) {
        String message = null;
        message = location == null || location.equals("") ? (packageName == null ? ExporterPlugin.INSTANCE.getString("_UI_ArtifactFileNameCannotBeEmpty_message") : ExporterPlugin.INSTANCE.getString("_UI_ArtifactFileNameForPackageCannotBeEmpty_message", new Object[]{packageName})) : this.doCheckEPackageArtifactLocation(location, packageName);
        if (message == null) {
            return Diagnostic.OK_INSTANCE;
        }
        return new BasicDiagnostic(4, "org.eclipse.emf.converter", 0, message, null);
    }

    protected String doCheckEPackageArtifactLocation(String location, String packageName) {
        return null;
    }

    public URI getDirectoryURI() {
        return this.directoryURI;
    }

    public void setDirectoryURI(URI directoryURI) {
        this.directoryURI = directoryURI;
    }

    public void setDirectoryURI(String location) {
        this.directoryURI = this.createEncodedURI(location);
    }

    protected URI computeArtifactURI(String location) {
        URI artifactURI = this.createEncodedURI(location);
        URI directoryURI = this.getDirectoryURI();
        if (directoryURI != null) {
            artifactURI = artifactURI.resolve(directoryURI);
        }
        return artifactURI;
    }

    protected URI createEncodedURI(String location) {
        return location != null ? URI.createURI((String)location, (boolean)true, (int)0) : null;
    }

    public Diagnostic validateDirectoryURI(String uri) {
        if (uri != null && uri.length() > 0 && !uri.endsWith("/")) {
            return new BasicDiagnostic(4, "org.eclipse.emf.converter", 8, ExporterPlugin.INSTANCE.getString("_UI_DirectoryURI_error"), null);
        }
        return Diagnostic.OK_INSTANCE;
    }

    public boolean isSaveEPackageArtifactURI() {
        return this.saveEPackageArtifactURI;
    }

    public void setSaveEPackageArtifactURI(boolean saveEPackageArtifactURI) {
        this.saveEPackageArtifactURI = saveEPackageArtifactURI;
    }

    public boolean isSaveExporter() {
        return this.saveExporter;
    }

    public void setSaveExporter(boolean saveExporter) {
        this.saveExporter = saveExporter;
    }

    public void save() throws Exception {
        Resource genModelResource = this.getGenModel().eResource();
        boolean changed = false;
        if (this.isSaveExporter()) {
            changed |= this.saveExporter();
        }
        if (this.isSaveEPackageArtifactURI()) {
            changed |= this.saveEPackageArtifactURI();
        }
        if (changed |= genModelResource.isModified()) {
            String readOnlyFiles;
            if (EMFPlugin.IS_ECLIPSE_RUNNING && (readOnlyFiles = ConverterUtil.WorkspaceResourceValidator.validate(Collections.singletonList(genModelResource))) != null) {
                throw new Exception(ExporterPlugin.INSTANCE.getString("_UI_ReadOnlyFiles_error", new String[]{readOnlyFiles}));
            }
            genModelResource.save(this.getGenModelSaveOptions());
        }
    }

    protected boolean saveExporter() {
        GenAnnotation nestedGenAnnotation;
        List referencedGenPackages;
        GenAnnotation nestedGenAnnotation2;
        List ePackages;
        boolean changed = false;
        GenAnnotation genModelAnnotation = this.getGenModel().getGenAnnotation(this.getConverterGenAnnotationSource());
        URI directoryURI = this.getDirectoryURI();
        if (directoryURI == null) {
            if (genModelAnnotation != null) {
                String oldValue = (String)genModelAnnotation.getDetails().removeKey((Object)GENANNOTATION_KEY_DIRECTORY_URI);
                changed |= oldValue != null;
            }
        } else {
            Object oldValue;
            String stringURI;
            if (this.getGenModel().eResource() != null) {
                directoryURI = directoryURI.deresolve(this.getGenModel().eResource().getURI());
            }
            if (genModelAnnotation == null) {
                genModelAnnotation = ExporterUtil.findOrCreateGenAnnotation((GenBase)this.getGenModel(), this.getConverterGenAnnotationSource());
                changed = true;
            }
            changed |= !(stringURI = directoryURI.toString()).equals(oldValue = genModelAnnotation.getDetails().put((Object)GENANNOTATION_KEY_DIRECTORY_URI, (Object)stringURI));
        }
        if ((ePackages = this.computeEPackagesToConvert()).isEmpty()) {
            if (genModelAnnotation != null && (nestedGenAnnotation2 = genModelAnnotation.getGenAnnotation(GENANNOTATION_SOURCE_SELECTED_EPACKAGES)) != null) {
                genModelAnnotation.getGenAnnotations().remove((Object)nestedGenAnnotation2);
                changed = true;
            }
        } else {
            if (genModelAnnotation == null) {
                genModelAnnotation = ExporterUtil.findOrCreateGenAnnotation((GenBase)this.getGenModel(), this.getConverterGenAnnotationSource());
                changed = true;
            }
            nestedGenAnnotation2 = ExporterUtil.findOrCreateGenAnnotation((GenBase)genModelAnnotation, GENANNOTATION_SOURCE_SELECTED_EPACKAGES);
            HashSet<String> nsURIs = new HashSet<String>();
            for (EPackage ePackage : ePackages) {
                String location = this.getEPackageExportInfo(ePackage).getArtifactLocation();
                if (location == null) continue;
                nsURIs.add(ePackage.getNsURI());
                Object oldValue = nestedGenAnnotation2.getDetails().put((Object)ePackage.getNsURI(), (Object)location);
                changed |= !location.equals(oldValue);
            }
            changed |= nestedGenAnnotation2.getDetails().keySet().retainAll(nsURIs);
        }
        if ((referencedGenPackages = this.computeValidReferencedGenPackages()).isEmpty()) {
            if (genModelAnnotation != null && (nestedGenAnnotation = genModelAnnotation.getGenAnnotation(GENANNOTATION_SOURCE_SELECTED_REFERENCES)) != null) {
                changed |= genModelAnnotation.getGenAnnotations().remove((Object)nestedGenAnnotation);
            }
        } else {
            if (genModelAnnotation == null) {
                genModelAnnotation = ExporterUtil.findOrCreateGenAnnotation((GenBase)this.getGenModel(), this.getConverterGenAnnotationSource());
                changed = true;
            }
            nestedGenAnnotation = ExporterUtil.findOrCreateGenAnnotation((GenBase)genModelAnnotation, GENANNOTATION_SOURCE_SELECTED_REFERENCES);
            HashSet<String> nsURIs = new HashSet<String>();
            for (GenPackage genPackage : referencedGenPackages) {
                Object oldValue;
                String stringURI;
                nsURIs.add(genPackage.getNSURI());
                URI uri = this.getReferencedGenPackageExportInfo(genPackage).getArtifactURI();
                if (genPackage.getGenModel().eResource() != null) {
                    uri = uri.deresolve(genPackage.getGenModel().eResource().getURI());
                }
                changed |= !(stringURI = uri.toString()).equals(oldValue = nestedGenAnnotation.getDetails().put((Object)genPackage.getNSURI(), (Object)stringURI));
                if (this.getGenModel().getUsedGenPackages().contains((Object)genPackage)) {
                    changed |= nestedGenAnnotation.getReferences().remove((Object)genPackage);
                    continue;
                }
                changed |= nestedGenAnnotation.getReferences().add((Object)genPackage);
            }
            changed |= nestedGenAnnotation.getDetails().keySet().retainAll(nsURIs);
        }
        return changed;
    }

    protected boolean saveEPackageArtifactURI() {
        ConverterUtil.GenPackageList localGenPackages = new ConverterUtil.GenPackageList();
        ConverterUtil.EPackageList externalEPackages = new ConverterUtil.EPackageList();
        boolean isLocalGePackage = false;
        List ePackages = this.computeEPackagesToConvert();
        for (EPackage ePackage : ePackages) {
            GenPackagesTreeIterator j = new GenPackagesTreeIterator(this.getGenModel());
            while (j.hasNext()) {
                GenPackage genPackage = (GenPackage)j.next();
                if (genPackage.getEcorePackage() != ePackage) continue;
                isLocalGePackage = localGenPackages.add(genPackage);
                break;
            }
            if (!isLocalGePackage) {
                externalEPackages.add(ePackage);
                continue;
            }
            isLocalGePackage = false;
        }
        boolean changed = false;
        if (!localGenPackages.isEmpty()) {
            URI genModelURI = this.getGenModel().eResource() != null ? this.getGenModel().eResource().getURI() : null;
            HashMap<String, String> externalPackageToLocalURIMap = new HashMap<String, String>(externalEPackages.size());
            for (EPackage ePackage : externalEPackages) {
                String location = this.getEPackageExportInfo(ePackage).getArtifactLocation();
                if (location == null) continue;
                URI uri = this.computeArtifactURI(location);
                if (genModelURI != null) {
                    uri = uri.deresolve(genModelURI);
                }
                String stringURI = uri.toString();
                externalPackageToLocalURIMap.put(ePackage.getNsURI(), stringURI);
            }
            for (GenPackage genPackage : localGenPackages) {
                String stringURI;
                GenAnnotation uriAnnotation;
                EPackage ePackage = genPackage.getEcorePackage();
                String location = this.getEPackageExportInfo(ePackage).getArtifactLocation();
                if (location == null) continue;
                GenAnnotation genPackageAnnotation = genPackage.getGenAnnotation(this.getConverterGenAnnotationSource());
                if (genPackageAnnotation == null) {
                    genPackageAnnotation = ExporterUtil.findOrCreateGenAnnotation((GenBase)genPackage, this.getConverterGenAnnotationSource());
                    changed = true;
                }
                URI uri = this.computeArtifactURI(location);
                if (genModelURI != null) {
                    uri = uri.deresolve(genModelURI);
                }
                if ((uriAnnotation = genPackageAnnotation.getGenAnnotation(stringURI = uri.toString())) == null) {
                    uriAnnotation = ExporterUtil.findOrCreateGenAnnotation((GenBase)genPackageAnnotation, stringURI);
                    if (!externalPackageToLocalURIMap.isEmpty()) {
                        uriAnnotation.getDetails().putAll(externalPackageToLocalURIMap);
                    }
                    changed = true;
                    continue;
                }
                if (externalPackageToLocalURIMap.isEmpty()) {
                    if (uriAnnotation.getDetails().isEmpty()) continue;
                    uriAnnotation.getDetails().clear();
                    changed = true;
                    continue;
                }
                if (externalPackageToLocalURIMap.equals(uriAnnotation.getDetails().map())) continue;
                uriAnnotation.getDetails().clear();
                uriAnnotation.getDetails().putAll(externalPackageToLocalURIMap);
                changed = true;
            }
        }
        return changed;
    }

    protected String getDefaultArtifactFileName(EPackage ePackage) {
        String fileName;
        int lastIndex;
        if (ePackage.eResource() != null && ePackage.getESuperPackage() == null && (lastIndex = (fileName = ePackage.eResource().getURI().lastSegment()).lastIndexOf(46)) > 0) {
            return fileName.substring(0, lastIndex);
        }
        return ConverterUtil.getQualifiedName((EPackage)ePackage);
    }

    protected void printExportData(ExportData exportData) {
        URI artifactURI;
        GenPackage genPackage;
        System.out.println("\nExport Data =======================================");
        for (Map.Entry<GenPackage, URI> entry : exportData.genPackageToArtifactURI.entrySet()) {
            genPackage = entry.getKey();
            artifactURI = entry.getValue();
            List<GenPackage> referencedGenPackages = exportData.genPackageToReferencedGenPackages.get(genPackage);
            System.out.println("\nGenPackage: " + genPackage.getNSURI());
            System.out.println("Resource: " + genPackage.eResource().getURI());
            System.out.println("Artifact: " + artifactURI.toString());
            if (referencedGenPackages == null) continue;
            System.out.println("Referenced GenPackages:");
            for (GenPackage referencedGenPackage : referencedGenPackages) {
                System.out.println("\tGenPackage: " + referencedGenPackage.getNSURI());
                System.out.println("\tResource: " + referencedGenPackage.eResource().getURI());
            }
        }
        if (!exportData.referencedGenPackagesToArtifactURI.isEmpty()) {
            System.out.println("\n-Referenced GenPackages-----------------------------");
            for (Map.Entry<GenPackage, URI> entry : exportData.referencedGenPackagesToArtifactURI.entrySet()) {
                genPackage = entry.getKey();
                artifactURI = entry.getValue();
                System.out.println("\nReferenced GenPackage: " + genPackage.getNSURI());
                System.out.println("Resource: " + genPackage.eResource().getURI());
                System.out.println("Artifact: " + artifactURI.toString());
            }
        }
        System.out.println("\n====================================================");
    }

    public static class EPackageExportInfo
    extends ModelConverter.EPackageConvertInfo {
        public String getArtifactLocation() {
            return this.getConvertData();
        }

        public void setArtifactLocation(String artifactLocation) {
            this.setConvertData(artifactLocation);
        }
    }

    public static class ExportData {
        public Map<GenPackage, URI> genPackageToArtifactURI;
        public Map<GenPackage, List<GenPackage>> genPackageToReferencedGenPackages;
        public Map<GenPackage, URI> referencedGenPackagesToArtifactURI;
    }

    protected static class GenPackagesTreeIterator
    extends AbstractTreeIterator<GenPackage> {
        private static final long serialVersionUID = 1L;

        public GenPackagesTreeIterator(GenModel genModel) {
            this((Collection<GenPackage>)genModel.getGenPackages());
        }

        public GenPackagesTreeIterator(Collection<GenPackage> genPackages) {
            super(genPackages, false);
        }

        protected Iterator<GenPackage> getChildren(Object object) {
            return object instanceof Collection ? ((Collection)object).iterator() : ((GenPackage)object).getNestedGenPackages().iterator();
        }
    }

    public static class ReferencedGenPackageExportInfo
    extends ModelConverter.ReferencedGenPackageConvertInfo {
        protected String modelExporterID;
        protected URI artifactURI;
        protected Map<String, List<URI>> nsURIToLocalArtifactURIs;

        public String getModelExporterID() {
            return this.modelExporterID;
        }

        public void setModelExporterID(String modelExporterID) {
            this.modelExporterID = modelExporterID;
        }

        public URI getArtifactURI() {
            return this.artifactURI;
        }

        public void setArtifactURI(URI artifactURI) {
            this.artifactURI = artifactURI;
        }

        public Map<String, List<URI>> getNSURIToLocalArtifactURIs() {
            if (this.nsURIToLocalArtifactURIs == null) {
                this.nsURIToLocalArtifactURIs = new HashMap<String, List<URI>>();
            }
            return this.nsURIToLocalArtifactURIs;
        }
    }
}

