/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.provider;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.apiguardian.api.API;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.support.AnnotationConsumer;
import org.junit.jupiter.params.support.ParameterDeclarations;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.Preconditions;

@API(status=API.Status.MAINTAINED, since="5.13.3")
public abstract class AnnotationBasedArgumentsProvider<A extends Annotation>
implements ArgumentsProvider,
AnnotationConsumer<A> {
    private final List<A> annotations = new ArrayList<A>();

    @Override
    public final void accept(A annotation) {
        Preconditions.notNull(annotation, (String)"annotation must not be null");
        this.annotations.add(annotation);
    }

    @Override
    public Stream<? extends Arguments> provideArguments(ParameterDeclarations parameters, ExtensionContext context) {
        return this.annotations.stream().flatMap(annotation -> this.provideArguments(parameters, context, annotation));
    }

    @Deprecated(since="5.13")
    @API(status=API.Status.DEPRECATED, since="5.13")
    protected Stream<? extends Arguments> provideArguments(ExtensionContext context, A annotation) {
        throw new JUnitException("AnnotationBasedArgumentsProvider does not override the provideArguments(ParameterDeclarations, ExtensionContext, Annotation) method. Please report this issue to the maintainers of %s.".formatted(this.getClass().getName()));
    }

    protected Stream<? extends Arguments> provideArguments(ParameterDeclarations parameters, ExtensionContext context, A annotation) {
        return this.provideArguments(context, annotation);
    }
}

