/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.html;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class HTMLUtil {
    public static StringBuilder createHTMLStartTag(String elementName, Map elementAttributes, boolean insertLineBreak) {
        StringBuilder element = new StringBuilder();
        if (elementName != null) {
            element.append((CharSequence)HTMLUtil.openHTMLStartTag(elementName));
            if (elementAttributes != null && !elementAttributes.isEmpty()) {
                element.append(" ").append(HTMLUtil.createAttributeList(elementAttributes));
            }
            element.append((CharSequence)HTMLUtil.closeHTMLTag(insertLineBreak));
        }
        return element;
    }

    public static StringBuilder createHTMLStartTag(String elementName, boolean insertLineBreak) {
        return HTMLUtil.createHTMLStartTag(elementName, null, insertLineBreak);
    }

    public static StringBuilder createHTMLStartTag(String elementName) {
        return HTMLUtil.createHTMLStartTag(elementName, null, true);
    }

    public static StringBuilder createHTMLEndTag(String elementName, boolean addNewLine) {
        StringBuilder closingElement = new StringBuilder();
        if (elementName != null) {
            closingElement.append("<").append("/").append(elementName).append((CharSequence)HTMLUtil.closeHTMLTag(addNewLine));
        }
        return closingElement;
    }

    public static String createAttributeList(Map attributes) {
        if (attributes == null) {
            return null;
        }
        StringBuilder attributeList = new StringBuilder();
        Set attrNames = attributes.keySet();
        Iterator it = attrNames.iterator();
        while (it.hasNext()) {
            Object name = it.next();
            Object value = attributes.get(name);
            if (!(name instanceof String) || !(value instanceof String)) continue;
            attributeList.append((CharSequence)HTMLUtil.createAttribute((String)name, (String)value));
            if (!it.hasNext()) continue;
            attributeList.append(" ");
        }
        return attributeList.toString();
    }

    public static StringBuilder createAttribute(String attrName, String attrValue) {
        StringBuilder attribute = new StringBuilder();
        if (attrName != null && attrValue != null) {
            attribute.append(attrName).append("=").append("\"").append(attrValue).append("\"");
        }
        return attribute;
    }

    public static StringBuilder openHTMLStartTag(String elementName) {
        return new StringBuilder().append("<").append(elementName);
    }

    public static StringBuilder closeHTMLTag() {
        return HTMLUtil.closeHTMLTag(true);
    }

    public static StringBuilder closeHTMLTag(boolean newLine) {
        StringBuilder closing = new StringBuilder().append(">");
        if (newLine) {
            closing.append("\n");
        }
        return closing;
    }

    public static boolean equalCharArrayContent(char[] a, char[] b) {
        if (a.length != b.length) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            if (a[i] != b[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

