/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.resource;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.core.services.XtendGrammarAccess;
import org.eclipse.xtend.core.xtend.RichStringLiteral;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.ITextRegionWithLineInformation;
import org.eclipse.xtext.util.TextRegionWithLineInformation;
import org.eclipse.xtext.xbase.jvmmodel.JvmLocationInFileProvider;

@Singleton
public class XtendLocationInFileProvider
extends JvmLocationInFileProvider {
    @Inject
    private XtendGrammarAccess grammarAccess;

    protected boolean useKeyword(Keyword keyword, EObject context) {
        if (keyword == this.grammarAccess.getMemberAccess().getNewKeyword_2_2_2()) {
            return true;
        }
        return super.useKeyword(keyword, context);
    }

    public ITextRegion getSignificantTextRegion(EObject element) {
        if (element instanceof RichStringLiteral) {
            ICompositeNode elementNode = this.findNodeFor(element);
            if (elementNode == null) {
                return ITextRegion.EMPTY_REGION;
            }
            ITextRegion result = ITextRegion.EMPTY_REGION;
            for (INode node : elementNode.getLeafNodes()) {
                EObject grammarElement;
                if (this.isHidden(node) || !((grammarElement = node.getGrammarElement()) instanceof RuleCall)) continue;
                RuleCall ruleCall = (RuleCall)grammarElement;
                ITextRegionWithLineInformation region = node.getTextRegionWithLineInformation();
                int offset = region.getOffset();
                int length = region.getLength();
                if (this.grammarAccess.getRICH_TEXTRule() == ruleCall.getRule()) {
                    offset += 3;
                    length -= 6;
                } else if (this.grammarAccess.getRICH_TEXT_STARTRule() == ruleCall.getRule()) {
                    offset += 3;
                    length -= 4;
                } else if (this.grammarAccess.getRICH_TEXT_ENDRule() == ruleCall.getRule()) {
                    ++offset;
                    length -= 4;
                } else if (this.grammarAccess.getRICH_TEXT_INBETWEENRule() == ruleCall.getRule()) {
                    ++offset;
                    length -= 2;
                } else if (this.grammarAccess.getCOMMENT_RICH_TEXT_ENDRule() == ruleCall.getRule()) {
                    offset += 2;
                    length -= 5;
                } else {
                    if (this.grammarAccess.getCOMMENT_RICH_TEXT_INBETWEENRule() != ruleCall.getRule()) continue;
                    offset += 2;
                    length -= 3;
                }
                result = result.merge((ITextRegion)this.toZeroBasedRegion((ITextRegionWithLineInformation)new TextRegionWithLineInformation(offset, length, region.getLineNumber(), region.getEndLineNumber())));
            }
            return result;
        }
        return super.getSignificantTextRegion(element);
    }
}

