/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.sync;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.helper.task.TaskHelper;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.listener.NotificationUtil;
import org.eclipse.sirius.common.tools.api.util.EObjectCouple;
import org.eclipse.sirius.common.tools.api.util.EqualityHelper;
import org.eclipse.sirius.common.tools.api.util.RefreshIdsHolder;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.ComputedStyleDescriptionRegistry;
import org.eclipse.sirius.diagram.ContainerLayout;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DNodeList;
import org.eclipse.sirius.diagram.DNodeListElement;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DiagramFactory;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramMappingsManager;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramMappingsManagerRegistry;
import org.eclipse.sirius.diagram.business.api.helper.SiriusDiagramHelper;
import org.eclipse.sirius.diagram.business.api.helper.concern.ConcernService;
import org.eclipse.sirius.diagram.business.api.helper.display.DisplayServiceManager;
import org.eclipse.sirius.diagram.business.api.helper.layers.LayerService;
import org.eclipse.sirius.diagram.business.api.query.ContainerMappingQuery;
import org.eclipse.sirius.diagram.business.api.query.DiagramElementMappingQuery;
import org.eclipse.sirius.diagram.business.api.query.DragAndDropTargetQuery;
import org.eclipse.sirius.diagram.business.api.query.EObjectQuery;
import org.eclipse.sirius.diagram.business.api.query.IEdgeMappingQuery;
import org.eclipse.sirius.diagram.business.api.refresh.RefreshExtensionService;
import org.eclipse.sirius.diagram.business.internal.helper.decoration.DecorationHelperInternal;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.EdgeMappingHelper;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.LayerHelper;
import org.eclipse.sirius.diagram.business.internal.sync.DDiagramElementSynchronizer;
import org.eclipse.sirius.diagram.business.internal.sync.DEdgeCandidate;
import org.eclipse.sirius.diagram.business.internal.sync.DEdgeSynchronizerHelper;
import org.eclipse.sirius.diagram.business.internal.sync.DNodeCandidate;
import org.eclipse.sirius.diagram.business.internal.sync.DNodeSynchronizerHelper;
import org.eclipse.sirius.diagram.business.internal.sync.MappingsUpdater;
import org.eclipse.sirius.diagram.business.internal.sync.VisualIDMap;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.AdditionalLayer;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.ContainerMappingImport;
import org.eclipse.sirius.diagram.description.DescriptionPackage;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.EdgeMappingImport;
import org.eclipse.sirius.diagram.description.IEdgeMapping;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.description.MappingBasedDecoration;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.diagram.description.NodeMappingImport;
import org.eclipse.sirius.diagram.model.business.internal.description.spec.EdgeMappingImportWrapper;
import org.eclipse.sirius.diagram.model.business.internal.helper.MappingHelper;
import org.eclipse.sirius.diagram.model.business.internal.operations.DDiagramSpecOperations;
import org.eclipse.sirius.diagram.model.business.internal.query.DDiagramInternalQuery;
import org.eclipse.sirius.diagram.model.business.internal.query.DNodeContainerExperimentalQuery;
import org.eclipse.sirius.diagram.tools.api.Messages;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.FeatureNotFoundException;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.MetaClassNotFoundException;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.cache.KeyCache;
import org.eclipse.sirius.ext.base.collect.GSetIntersection;
import org.eclipse.sirius.ext.base.collect.MultipleCollection;
import org.eclipse.sirius.ext.base.collect.SetIntersection;
import org.eclipse.sirius.tools.api.command.ui.NoUICallback;
import org.eclipse.sirius.tools.api.command.ui.UICallBack;
import org.eclipse.sirius.tools.api.profiler.SiriusTasksKey;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.description.RepresentationElementMapping;
import org.eclipse.sirius.viewpoint.description.SemanticBasedDecoration;

public class DDiagramSynchronizer {
    private static final EObject FAKE_MAPPING = EcoreFactory.eINSTANCE.createEObject();
    private static Map<String, String> visualIDMap = Collections.unmodifiableMap(new VisualIDMap());
    private DSemanticDiagram diagram;
    private final IInterpreter interpreter;
    private final DiagramDescription description;
    private final ModelAccessor accessor;
    private DDiagramElementSynchronizer sync;
    private final Collection<EObjectCouple> ignoredDuringRefreshProcess = new ArrayList<EObjectCouple>();
    private Session session;
    private DEdgeSynchronizerHelper edgeHelper;
    private DNodeSynchronizerHelper nodHelper;
    private DiagramMappingsManager diagramMappingsManager;
    private SetMultimap<EObjectCouple, DDiagramElement> previousCandidatesCache;
    private MappingsUpdater mappingsUpdater;
    private HashSet<DDiagramElement> edgesDones;
    private boolean forceRetrieve;
    private RefreshIdsHolder ids;
    private DecorationHelperInternal decorationHelper;

    public DDiagramSynchronizer(IInterpreter interpreter, DiagramDescription description, ModelAccessor accessor) {
        this.interpreter = interpreter;
        this.description = description;
        this.accessor = accessor;
    }

    public DSemanticDiagram getDiagram() {
        return this.diagram;
    }

    public RefreshIdsHolder getFactory() {
        return this.ids;
    }

    public DDiagramElementSynchronizer getElementSynchronizer() {
        return this.sync;
    }

    public void setDiagram(DSemanticDiagram diagram) {
        this.diagram = diagram;
        this.session = SessionManager.INSTANCE.getSession(diagram.getTarget());
        this.decorationHelper = new DecorationHelperInternal((DDiagram)diagram, this.interpreter, this.accessor);
        this.sync = new DDiagramElementSynchronizer(this.diagram, this.interpreter, this.accessor);
        this.initDiagramRelatedFields();
    }

    public void initDiagram(EObject target, IProgressMonitor monitor) {
        try {
            monitor.beginTask(Messages.DDiagramSynchronizer_initDiagramMsg, 4);
            this.session = SessionManager.INSTANCE.getSession(target);
            this.diagram = this.createEmptyDiagram(target);
            this.decorationHelper = new DecorationHelperInternal((DDiagram)this.diagram, this.interpreter, this.accessor);
            monitor.worked(1);
            this.applyInitializationOperation(target);
            monitor.worked(1);
            this.sync = new DDiagramElementSynchronizer(this.diagram, this.interpreter, this.accessor);
            ConcernService.setCurrentConcern((DDiagram)this.diagram, this.description.getDefaultConcern());
            this.activateInitialLayers();
            monitor.worked(1);
            if (this.diagram.getFilterVariableHistory() == null) {
                this.diagram.setFilterVariableHistory(DiagramFactory.eINSTANCE.createFilterVariableHistory());
            }
            this.initDiagramRelatedFields();
            monitor.worked(1);
        }
        finally {
            monitor.done();
        }
    }

    private DSemanticDiagram createEmptyDiagram(EObject target) {
        DSemanticDiagram result = this.description.createDiagram();
        result.setDescription(this.description);
        result.setTarget(target);
        return result;
    }

    private void applyInitializationOperation(EObject target) {
        if (this.description.getDiagramInitialisation() != null && this.description.getDiagramInitialisation().getFirstModelOperations() != null) {
            try {
                new TaskHelper(this.accessor, this.createUICallBack()).buildTaskFromModelOperation((DRepresentation)this.diagram, target, this.description.getDiagramInitialisation().getFirstModelOperations()).execute();
            }
            catch (MetaClassNotFoundException metaClassNotFoundException) {
            }
            catch (FeatureNotFoundException featureNotFoundException) {}
        }
    }

    private UICallBack createUICallBack() {
        return new NoUICallback();
    }

    private void initDiagramRelatedFields() {
        this.ids = RefreshIdsHolder.getOrCreateHolder((EObject)this.diagram);
        this.edgeHelper = new DEdgeSynchronizerHelper(this, this.diagram, this.accessor);
        this.nodHelper = new DNodeSynchronizerHelper(this, this.diagram, this.accessor);
        this.diagramMappingsManager = DiagramMappingsManagerRegistry.INSTANCE.getDiagramMappingsManager(this.session, (DDiagram)this.diagram);
        this.mappingsUpdater = new MappingsUpdater((DDiagram)this.diagram, this.diagramMappingsManager, this, this.ids);
    }

    public void activateInitialLayers() {
        ArrayList<Layer> layersToActivate = new ArrayList<Layer>();
        ArrayList<AdditionalLayer> transientLayersToActivate = new ArrayList<AdditionalLayer>();
        LayerHelper.getInitialActiveLayers(this.description, this.session.getSelectedViewpoints(false), layersToActivate, transientLayersToActivate);
        this.diagram.getActivatedLayers().addAll(layersToActivate);
        this.diagram.getActivatedTransientLayers().addAll(transientLayersToActivate);
    }

    private void activateNewMandatoryAdditionalLayers() {
        ArrayList<Layer> layersToActivate = new ArrayList<Layer>();
        ArrayList<AdditionalLayer> transientLayersToActivate = new ArrayList<AdditionalLayer>();
        LayerHelper.getMandatoriesAdditionalLayers(this.description, this.session.getSelectedViewpoints(false), layersToActivate, transientLayersToActivate);
        layersToActivate.removeAll((Collection<?>)this.diagram.getActivatedLayers());
        transientLayersToActivate.removeAll((Collection<?>)this.diagram.getActivatedTransientLayers());
        this.diagram.getActivatedLayers().addAll(layersToActivate);
        this.diagram.getActivatedTransientLayers().addAll(transientLayersToActivate);
    }

    public void refresh(IProgressMonitor monitor) {
        DslCommonPlugin.PROFILER.startWork(SiriusTasksKey.REFRESH_DIAGRAM_KEY);
        this.refreshOperation(monitor);
        DslCommonPlugin.PROFILER.stopWork(SiriusTasksKey.REFRESH_DIAGRAM_KEY);
    }

    private void refreshOperation(IProgressMonitor monitor) {
        try {
            KeyCache.DEFAULT.clear();
            EqualityHelper.setUriFragmentCacheEnabled((boolean)true);
            LayerHelper.setActiveParentLayersCacheEnabled(this.diagramMappingsManager, true);
            if (this.accessor.getPermissionAuthority().canEditInstance((EObject)this.diagram)) {
                RuntimeLoggerManager.INSTANCE.clear((EObject)this.description);
                this.activateNewMandatoryAdditionalLayers();
                HashMap<DiagramElementMapping, Collection<EdgeTarget>> mappingsToEdgeTargets = new HashMap<DiagramElementMapping, Collection<EdgeTarget>>();
                HashMap<EdgeMapping, Collection<MappingBasedDecoration>> edgeToMappingBasedDecoration = new HashMap<EdgeMapping, Collection<MappingBasedDecoration>>();
                HashMap<String, Collection<SemanticBasedDecoration>> edgeToSemanticBasedDecoration = new HashMap<String, Collection<SemanticBasedDecoration>>();
                List<NodeMapping> nodeMappings = this.diagramMappingsManager.getNodeMappings();
                List<EdgeMapping> edgeMappings = this.diagramMappingsManager.getEdgeMappings();
                List<ContainerMapping> containerMappings = this.diagramMappingsManager.getContainerMappings();
                RefreshExtensionService.getInstance().beforeRefresh((DDiagram)this.diagram);
                boolean override = RefreshExtensionService.getInstance().aroundRefresh((DDiagram)this.diagram);
                if (!override) {
                    int mappingNumbers = nodeMappings.size() + edgeMappings.size() + containerMappings.size();
                    monitor.beginTask(Messages.DDiagramSynchronizer_refreshMappingsMsg, mappingNumbers);
                    this.computePreviousCandidatesCache();
                    this.mappingsUpdater.updateMappings();
                    this.computePreviousCandidatesCache();
                    this.fillIgnoredElements();
                    HashSet<DNodeCandidate> elementsCreated = LayerService.withoutLayersMode(this.description) ? null : new HashSet<DNodeCandidate>();
                    for (NodeMapping nodeMapping : nodeMappings) {
                        this.refreshNodeMapping(mappingsToEdgeTargets, (DragAndDropTarget)this.diagram, nodeMapping, elementsCreated, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                    if (elementsCreated != null) {
                        elementsCreated.clear();
                    }
                    for (ContainerMapping containerMapping : containerMappings) {
                        this.refreshContainerMapping(mappingsToEdgeTargets, (DragAndDropTarget)this.diagram, containerMapping, elementsCreated, false, false, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                    this.handleImportersIssues();
                    this.decorationHelper.computeDecorations(mappingsToEdgeTargets, edgeToSemanticBasedDecoration, edgeToMappingBasedDecoration);
                    this.edgesDones = new HashSet();
                    Predicate predicate = edgeMapping -> edgeMappings.contains(edgeMapping);
                    this.processEdgeMappingsRefresh(edgeMappings, mappingsToEdgeTargets, edgeToMappingBasedDecoration, edgeToSemanticBasedDecoration, (Predicate<EdgeMapping>)predicate, monitor);
                    this.edgesDones.clear();
                    this.deleteIgnoredElementsAndDuplicates();
                    this.removeOrphanComputedStyleDescriptions();
                }
                RefreshExtensionService.getInstance().postRefresh((DDiagram)this.diagram);
                this.clearCache();
            }
            KeyCache.DEFAULT.clear();
        }
        finally {
            EqualityHelper.setUriFragmentCacheEnabled((boolean)false);
            LayerHelper.setActiveParentLayersCacheEnabled(this.diagramMappingsManager, false);
            monitor.done();
        }
    }

    private void processEdgeMappingsRefresh(List<EdgeMapping> edgeMappings, final Map<DiagramElementMapping, Collection<EdgeTarget>> mappingsToEdgeTargets, Map<EdgeMapping, Collection<MappingBasedDecoration>> edgeToMappingBasedDecoration, Map<String, Collection<SemanticBasedDecoration>> edgeToSemanticBasedDecoration, final Predicate<EdgeMapping> isEdgeMappingOfCurrentDiagramDescription, IProgressMonitor monitor) {
        Predicate<EdgeMapping> edgeMappingWithoutEdgeAsSourceOrTarget = new Predicate<EdgeMapping>(){

            public boolean apply(EdgeMapping input) {
                Iterable edgeSourceMappings = Iterables.filter((Iterable)Iterables.filter((Iterable)input.getSourceMapping(), EdgeMapping.class), (Predicate)isEdgeMappingOfCurrentDiagramDescription);
                Iterable edgeTargetMappings = Iterables.filter((Iterable)Iterables.filter((Iterable)input.getTargetMapping(), EdgeMapping.class), (Predicate)isEdgeMappingOfCurrentDiagramDescription);
                return Iterables.isEmpty((Iterable)edgeSourceMappings) && Iterables.isEmpty((Iterable)edgeTargetMappings);
            }
        };
        Predicate<EdgeMapping> refreshedEdgeMapping = new Predicate<EdgeMapping>(){

            public boolean apply(EdgeMapping input) {
                boolean hasBeenRefreshed = mappingsToEdgeTargets.keySet().contains(input);
                if (!hasBeenRefreshed) {
                    Option parentLayer = new EObjectQuery((EObject)input).getFirstAncestorOfType(DescriptionPackage.eINSTANCE.getLayer());
                    hasBeenRefreshed = parentLayer.some() && !DDiagramSynchronizer.this.getDiagram().getActivatedLayers().contains(parentLayer.get());
                }
                return hasBeenRefreshed;
            }
        };
        Predicate<EdgeMapping> unrefreshedEdgeMappingWithRefreshedEdgeAsSourceOrTarget = new Predicate<EdgeMapping>((Predicate)refreshedEdgeMapping){
            private final /* synthetic */ Predicate val$refreshedEdgeMapping;
            {
                this.val$refreshedEdgeMapping = predicate2;
            }

            public boolean apply(EdgeMapping input) {
                boolean result = !mappingsToEdgeTargets.keySet().contains(input);
                Iterable edgeSourceMappings = Iterables.filter((Iterable)Iterables.filter((Iterable)input.getSourceMapping(), EdgeMapping.class), (Predicate)isEdgeMappingOfCurrentDiagramDescription);
                Iterable edgeTargetMappings = Iterables.filter((Iterable)Iterables.filter((Iterable)input.getTargetMapping(), EdgeMapping.class), (Predicate)isEdgeMappingOfCurrentDiagramDescription);
                return result && Iterables.all((Iterable)edgeSourceMappings, (Predicate)this.val$refreshedEdgeMapping) && Iterables.all((Iterable)edgeTargetMappings, (Predicate)this.val$refreshedEdgeMapping);
            }
        };
        for (EdgeMapping mapping : Iterables.filter(edgeMappings, (Predicate)edgeMappingWithoutEdgeAsSourceOrTarget)) {
            this.refreshEdgeMapping(this.diagramMappingsManager, mappingsToEdgeTargets, mapping, edgeToMappingBasedDecoration, edgeToSemanticBasedDecoration, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            mappingsToEdgeTargets.put((DiagramElementMapping)mapping, (Collection<EdgeTarget>)DDiagramSpecOperations.getEdgesFromMapping((DDiagram)this.diagram, (EdgeMapping)mapping));
        }
        ArrayList<EdgeMapping> remaingEdgeMappingsToRefresh = new ArrayList<EdgeMapping>(edgeMappings);
        remaingEdgeMappingsToRefresh.removeAll(mappingsToEdgeTargets.keySet());
        boolean noRefreshImpliesCycleDetected = true;
        while (!mappingsToEdgeTargets.keySet().containsAll(edgeMappings)) {
            for (EdgeMapping mapping : Iterables.filter(remaingEdgeMappingsToRefresh, (Predicate)unrefreshedEdgeMappingWithRefreshedEdgeAsSourceOrTarget)) {
                this.refreshEdgeMapping(this.diagramMappingsManager, mappingsToEdgeTargets, mapping, edgeToMappingBasedDecoration, edgeToSemanticBasedDecoration, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                mappingsToEdgeTargets.put((DiagramElementMapping)mapping, (Collection<EdgeTarget>)DDiagramSpecOperations.getEdgesFromMapping((DDiagram)this.diagram, (EdgeMapping)mapping));
                noRefreshImpliesCycleDetected = false;
            }
            remaingEdgeMappingsToRefresh = new ArrayList<EdgeMapping>(edgeMappings);
            remaingEdgeMappingsToRefresh.removeAll(mappingsToEdgeTargets.keySet());
            if (noRefreshImpliesCycleDetected) {
                return;
            }
            noRefreshImpliesCycleDetected = true;
        }
    }

    private void computePreviousCandidatesCache() {
        this.previousCandidatesCache = LinkedHashMultimap.create();
        this.retrievePreviousCandidates((DragAndDropTarget)this.diagram, (Multimap<EObjectCouple, DDiagramElement>)this.previousCandidatesCache);
    }

    private void clearCache() {
        this.previousCandidatesCache = null;
    }

    private void removeOrphanComputedStyleDescriptions() {
        DDiagramInternalQuery dDiagramInternalQuery = new DDiagramInternalQuery((DDiagram)this.diagram);
        ComputedStyleDescriptionRegistry computedStyleDescriptionRegistry = dDiagramInternalQuery.getComputedStyleDescriptionRegistry(false);
        if (computedStyleDescriptionRegistry != null) {
            Collection usedComputedStyleDescritions = dDiagramInternalQuery.getUsedComputedStyleDescritions();
            computedStyleDescriptionRegistry.getComputedStyleDescriptions().retainAll(usedComputedStyleDescritions);
        }
    }

    private void handleImportersIssues() {
        for (DiagramElementMapping mapping : this.diagramMappingsManager.getOtherImportersMappings()) {
            EObjectCouple key = new EObjectCouple((EObject)this.diagram, (EObject)mapping, this.ids);
            this.ignoredDuringRefreshProcess.remove(key);
            Set elements = this.previousCandidatesCache.get((Object)key);
            if (elements == null) {
                return;
            }
            for (DiagramElementMapping subMapping : MappingHelper.getAllMappings((DiagramElementMapping)mapping)) {
                for (DDiagramElement element : elements) {
                    key = new EObjectCouple((EObject)element, (EObject)subMapping, this.ids);
                    this.ignoredDuringRefreshProcess.remove(key);
                }
            }
        }
    }

    private void fillIgnoredElements() {
        this.ignoredDuringRefreshProcess.addAll(this.previousCandidatesCache.keySet());
    }

    private void deleteIgnoredElementsAndDuplicates() {
        DisplayServiceManager.INSTANCE.getDisplayService().activateCache();
        DiagramMappingsManager mappingManager = DiagramMappingsManagerRegistry.INSTANCE.getDiagramMappingsManager(this.session, (DDiagram)this.diagram);
        NotificationUtil.sendNotification((EObject)this.diagram, (int)0, (int)2);
        for (EObjectCouple ignoredElement : this.ignoredDuringRefreshProcess) {
            Set elements = this.previousCandidatesCache.get((Object)ignoredElement);
            for (DDiagramElement element : elements) {
                EObject semanticElement = element.getTarget();
                if (semanticElement == null) {
                    this.accessor.eDelete((EObject)element, this.session != null ? this.session.getSemanticCrossReferencer() : null);
                }
                if (!this.shouldKeepElement(mappingManager, element)) {
                    this.accessor.eDelete((EObject)element, this.session != null ? this.session.getSemanticCrossReferencer() : null);
                    continue;
                }
                this.hideElementToUser(element);
            }
        }
        NotificationUtil.sendNotification((EObject)this.diagram, (int)1, (int)2);
        DisplayServiceManager.INSTANCE.getDisplayService().deactivateCache();
    }

    private void hideElementToUser(DDiagramElement element) {
        if (element.isVisible()) {
            element.setVisible(false);
        }
    }

    private boolean shouldKeepElement(DiagramMappingsManager mappingManager, DDiagramElement element) {
        return element.getParentDiagram() != null && !DisplayServiceManager.INSTANCE.getDisplayService().computeVisibility(mappingManager, (DDiagram)this.diagram, element);
    }

    private void convertType(EObject eObject) {
        EStructuralFeature typeEFeature = eObject.eClass().getEStructuralFeature("type");
        if (typeEFeature != null && visualIDMap.containsKey(eObject.eGet(typeEFeature))) {
            eObject.eSet(typeEFeature, (Object)visualIDMap.get(eObject.eGet(typeEFeature)));
        }
    }

    private AbstractDNode handleListAttributeChangeOnMapping(AbstractDNode node, ContainerMapping containerMapping, DragAndDropTarget viewContainer, IProgressMonitor monitor) {
        boolean isListContainer = new ContainerMappingQuery(containerMapping).isListContainer();
        if (node instanceof DNodeContainer && isListContainer || node instanceof DNodeList && !isListContainer) {
            DNodeCandidate newCandidate = new DNodeCandidate((AbstractNodeMapping)containerMapping, node.getTarget(), viewContainer, this.ids);
            HashSet<DNodeCandidate> newCandidates = new HashSet<DNodeCandidate>(1);
            newCandidates.add(newCandidate);
            List<AbstractDNode> newContents = this.createNewContent(newCandidates, true, viewContainer, (AbstractNodeMapping)containerMapping, false, monitor);
            if (!newContents.isEmpty()) {
                SiriusDiagramHelper.removeNodeFromContainer(viewContainer, false, node);
                AbstractDNode newNode = newContents.get(0);
                this.convertGmfModelTypes(node, newNode);
                return newNode;
            }
        }
        return node;
    }

    private void convertGmfModelTypes(AbstractDNode node, AbstractDNode newNode) {
        Collection settings = this.session.getSemanticCrossReferencer().getInverseReferences((EObject)node);
        for (EStructuralFeature.Setting setting : settings) {
            EObject referencer = setting.getEObject();
            if (setting.getEStructuralFeature().isMany()) {
                ArrayList values = Lists.newArrayList((Iterable)((List)setting.get(false)));
                values.remove(referencer);
                values.add(newNode);
                setting.set((Object)values);
            } else {
                setting.set((Object)newNode);
            }
            this.convertType(referencer);
            List<?> children = this.getChildren(referencer);
            for (Object eChild : children) {
                if (!(eChild instanceof EObject)) continue;
                this.convertType((EObject)eChild);
                ArrayList<EObject> toRemove = new ArrayList<EObject>();
                for (Object childOfChild : this.getChildren((EObject)eChild)) {
                    if (!(childOfChild instanceof EObject)) continue;
                    toRemove.add((EObject)childOfChild);
                }
                for (EObject eObject : toRemove) {
                    EcoreUtil.remove((EObject)eObject);
                }
            }
        }
    }

    private List<?> getChildren(EObject eObject) {
        EStructuralFeature childrenEFeature = eObject.eClass().getEStructuralFeature("children");
        if (childrenEFeature != null) {
            EList children = (EList)eObject.eGet(childrenEFeature);
            return children;
        }
        return Collections.emptyList();
    }

    private AbstractDNode handleListAttributeChangeOnContainerMapping(AbstractDNode node, AbstractNodeMapping nodeMapping, DDiagramElementContainer diagramElementContainer, IProgressMonitor monitor) {
        ContainerMapping containerMapping = diagramElementContainer.getActualMapping();
        boolean isListContainer = new ContainerMappingQuery(containerMapping).isListContainer();
        if (node instanceof DNode && isListContainer || node instanceof DNodeListElement && !isListContainer) {
            DNodeCandidate newCandidate = new DNodeCandidate(nodeMapping, node.getTarget(), (DragAndDropTarget)diagramElementContainer, this.ids);
            HashSet<DNodeCandidate> newCandidates = new HashSet<DNodeCandidate>(1);
            newCandidates.add(newCandidate);
            List<AbstractDNode> newContents = this.createNewContent(newCandidates, true, (DragAndDropTarget)diagramElementContainer, nodeMapping, false, monitor);
            if (!newContents.isEmpty()) {
                SiriusDiagramHelper.removeNodeFromContainer((DragAndDropTarget)diagramElementContainer, false, node);
                return newContents.get(0);
            }
        }
        return node;
    }

    private void refreshContainerMapping(Map<DiagramElementMapping, Collection<EdgeTarget>> mappingsToEdgeTargets, DragAndDropTarget viewContainer, ContainerMapping mapping, Set<DNodeCandidate> semanticFilter, boolean border, boolean orderBySemantic, IProgressMonitor monitor) {
        SetIntersection<DNodeCandidate> status = this.computeCurrentStatus(viewContainer, (AbstractNodeMapping)mapping, semanticFilter);
        Collection newElements = status.getNewElements();
        try {
            monitor.beginTask(Messages.DDiagramSynchronizer_refreshContainerMsg, 3);
            this.deleteCandidatesToRemove(status, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            ArrayList<AbstractDNode> keptNodes = new ArrayList<AbstractDNode>();
            ArrayList<AbstractDNode> createdNodes = new ArrayList<AbstractDNode>();
            if (orderBySemantic) {
                this.handleKeptAndNewNodesWithOrder(viewContainer, (DiagramElementMapping)mapping, status, keptNodes, createdNodes, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            } else {
                this.handleKeptNodes(viewContainer, status, keptNodes, false, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                createdNodes.addAll(this.createNewContent(newElements, viewContainer, (AbstractNodeMapping)mapping, border, (IProgressMonitor)new SubProgressMonitor(monitor, 1)));
            }
            MultipleCollection addedNodes = new MultipleCollection();
            addedNodes.addAll(createdNodes);
            addedNodes.addAll(keptNodes);
            this.putOrAdd(mappingsToEdgeTargets, (DiagramElementMapping)mapping, (Collection<DDiagramElement>)addedNodes);
            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
            try {
                subMonitor.beginTask("", addedNodes.size());
                for (DDiagramElement newElem : addedNodes) {
                    if (!(newElem instanceof DDiagramElementContainer)) continue;
                    DDiagramElementContainer newNode = (DDiagramElementContainer)newElem;
                    this.refreshMappingsInContainerMapping(mappingsToEdgeTargets, newNode, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subMonitor, 1));
                }
            }
            finally {
                subMonitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    private void refreshMappingsInContainerMapping(Map<DiagramElementMapping, Collection<EdgeTarget>> mappingsToEdgeTargets, DDiagramElementContainer newNode, IProgressMonitor monitor) {
        if (this.accessor.getPermissionAuthority().canEditInstance((EObject)newNode)) {
            try {
                monitor.beginTask(Messages.DDiagramSynchronizer_refreshContainerChildsMsg, 1);
                this.refreshBorderNodeMapping(mappingsToEdgeTargets, (AbstractDNode)newNode, null, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                if (newNode instanceof DNodeContainer) {
                    DNodeContainer newContainer = (DNodeContainer)newNode;
                    List<ContainerMapping> childMappings = this.diagramMappingsManager.getContainerMappings(newContainer);
                    List<NodeMapping> childNodeMappings = this.diagramMappingsManager.getNodeMappings(newContainer);
                    HashSet<DNodeCandidate> elementsCreated = LayerService.withoutLayersMode(this.description) ? null : new HashSet<DNodeCandidate>();
                    boolean stackContainer = new DNodeContainerExperimentalQuery(newContainer).isRegionContainer();
                    for (ContainerMapping containerMapping : childMappings) {
                        this.refreshContainerMapping(mappingsToEdgeTargets, (DragAndDropTarget)newNode, containerMapping, elementsCreated, false, stackContainer, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                    if (elementsCreated != null) {
                        elementsCreated.clear();
                    }
                    if (!stackContainer) {
                        for (NodeMapping nodeMapping : childNodeMappings) {
                            this.refreshNodeMapping(mappingsToEdgeTargets, (DragAndDropTarget)newNode, nodeMapping, elementsCreated, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        }
                    }
                } else if (newNode instanceof DNodeList) {
                    List<NodeMapping> childNodeMappings = this.diagramMappingsManager.getNodeMappings((DNodeList)newNode);
                    HashSet<DNodeCandidate> elementsCreated = LayerService.withoutLayersMode(this.description) ? null : new HashSet<DNodeCandidate>();
                    for (NodeMapping child : childNodeMappings) {
                        this.refreshNodeMapping(mappingsToEdgeTargets, (DragAndDropTarget)newNode, child, elementsCreated, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    private void refreshNodeMapping(Map<DiagramElementMapping, Collection<EdgeTarget>> mappingsToAbstractNodes, DragAndDropTarget viewContainer, NodeMapping mapping, Set<DNodeCandidate> semanticFilter, IProgressMonitor monitor) {
        SetIntersection<DNodeCandidate> status = this.computeCurrentStatus(viewContainer, (AbstractNodeMapping)mapping, semanticFilter);
        try {
            monitor.beginTask(Messages.DDiagramSynchronizer_refreshNodeMsg, 3);
            this.deleteCandidatesToRemove(status, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            ArrayList<AbstractDNode> keptNodes = new ArrayList<AbstractDNode>();
            ArrayList<AbstractDNode> createdNodes = new ArrayList<AbstractDNode>();
            this.handleKeptAndNewNodesWithOrder(viewContainer, (DiagramElementMapping)mapping, status, keptNodes, createdNodes, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            MultipleCollection addedNodes = new MultipleCollection();
            addedNodes.addAll(createdNodes);
            addedNodes.addAll(keptNodes);
            this.putOrAdd(mappingsToAbstractNodes, (DiagramElementMapping)mapping, (Collection<DDiagramElement>)addedNodes);
            for (AbstractDNode newNode : Iterables.filter((Iterable)addedNodes, AbstractDNode.class)) {
                this.refreshBorderNodeMapping(mappingsToAbstractNodes, newNode, semanticFilter, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        finally {
            monitor.done();
        }
    }

    private void refreshBorderNodeMapping(Map<DiagramElementMapping, Collection<EdgeTarget>> mappingsToAbstractNodes, AbstractDNode newNode, Set<DNodeCandidate> semanticFilter, IProgressMonitor monitor) {
        if (newNode instanceof DragAndDropTarget && this.accessor.getPermissionAuthority().canEditInstance((EObject)newNode)) {
            DragAndDropTarget newNodeDDT = (DragAndDropTarget)newNode;
            List<NodeMapping> borderedNodeMappings = this.diagramMappingsManager.getBorderedNodeMappings(newNode);
            try {
                monitor.beginTask(Messages.DDiagramSynchronizer_borderNodeRefreshMsg, 4 * borderedNodeMappings.size());
                for (NodeMapping bordermapping : borderedNodeMappings) {
                    SetIntersection<DNodeCandidate> borderStatus = this.computeCurrentStatus(newNodeDDT, (AbstractNodeMapping)bordermapping, semanticFilter);
                    this.deleteCandidatesToRemove(borderStatus, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    ArrayList<AbstractDNode> keptNodes = new ArrayList<AbstractDNode>();
                    ArrayList<AbstractDNode> createdNodes = new ArrayList<AbstractDNode>();
                    createdNodes.addAll(this.createNewContent(borderStatus.getNewElements(), newNodeDDT, (AbstractNodeMapping)bordermapping, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1)));
                    this.handleKeptNodes(newNodeDDT, borderStatus, keptNodes, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    MultipleCollection addedBorderNodes = new MultipleCollection();
                    addedBorderNodes.addAll(createdNodes);
                    addedBorderNodes.addAll(keptNodes);
                    this.putOrAdd(mappingsToAbstractNodes, (DiagramElementMapping)bordermapping, (Collection<DDiagramElement>)addedBorderNodes);
                    for (AbstractDNode bNewNode : Iterables.filter((Iterable)addedBorderNodes, AbstractDNode.class)) {
                        this.refreshBorderNodeMapping(mappingsToAbstractNodes, bNewNode, semanticFilter, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                    monitor.worked(1);
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    private SetIntersection<DNodeCandidate> computeCurrentStatus(DragAndDropTarget viewcontainer, AbstractNodeMapping mapping, Set<DNodeCandidate> semanticFilter) {
        GSetIntersection biSet = new GSetIntersection();
        this.addPreviousCandidates((SetIntersection<DNodeCandidate>)biSet, viewcontainer, mapping);
        this.addNowNodeCandidates((SetIntersection<DNodeCandidate>)biSet, viewcontainer, mapping, semanticFilter);
        return biSet;
    }

    private void deleteCandidatesToRemove(SetIntersection<DNodeCandidate> status, IProgressMonitor monitor) {
        try {
            Iterable candidatesToRemove = status.getRemovedElements();
            monitor.beginTask(Messages.DDiagramSynchronizer_deleteNodesMsg, Iterables.size((Iterable)candidatesToRemove));
            for (DNodeCandidate nodeToDelete : candidatesToRemove) {
                if (!nodeToDelete.comesFromDiagramElement()) continue;
                this.accessor.eDelete((EObject)nodeToDelete.getOriginalElement(), this.session != null ? this.session.getSemanticCrossReferencer() : null);
                monitor.worked(1);
            }
        }
        finally {
            monitor.done();
        }
    }

    private void handleKeptAndNewNodesWithOrder(DragAndDropTarget viewContainer, DiagramElementMapping mapping, SetIntersection<DNodeCandidate> status, Collection<AbstractDNode> keptNodes, Collection<AbstractDNode> createdNodes, IProgressMonitor monitor) {
        try {
            Iterable allElements = status.getAllElements();
            monitor.beginTask("", Iterables.size((Iterable)allElements));
            boolean createContents = this.accessor.getPermissionAuthority().canCreateIn((EObject)viewContainer) && new DiagramElementMappingQuery(mapping).isSynchronizedAndCreateElement((DDiagram)this.diagram);
            RefreshOrderHelper refreshOrderHelper = new RefreshOrderHelper(viewContainer, (RepresentationElementMapping)mapping);
            int mappingBeginIndex = refreshOrderHelper.getMappingBeginIndex();
            int currentGlobalPosition = 0;
            for (DNodeCandidate candidate : allElements) {
                int positionToAppend = mappingBeginIndex + currentGlobalPosition;
                if (candidate.getOriginalElement() != null) {
                    AbstractDNode node = this.handleKeptNode(viewContainer, candidate, keptNodes, false, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    if (!refreshOrderHelper.getOldGlobalPosition((DDiagramElement)node).equals(positionToAppend)) {
                        refreshOrderHelper.getOwnedDDiagramElements().move(positionToAppend, (Object)node);
                    }
                } else if (createContents) {
                    AbstractDNode createdNode = this.sync.createNewNode(this.diagramMappingsManager, candidate, false, positionToAppend);
                    createdNodes.add(createdNode);
                }
                ++currentGlobalPosition;
                monitor.worked(1);
            }
        }
        finally {
            monitor.done();
        }
    }

    private void handleKeptNodes(DragAndDropTarget viewContainer, SetIntersection<DNodeCandidate> status, Collection<AbstractDNode> keptNodes, boolean border, IProgressMonitor monitor) {
        Iterable keptNodeCandidates = status.getKeptElements();
        try {
            monitor.beginTask(Messages.DDiagramSynchronizer_refreshNodesMsg, Iterables.size((Iterable)keptNodeCandidates));
            for (DNodeCandidate keptCandidate : keptNodeCandidates) {
                this.handleKeptNode(viewContainer, keptCandidate, keptNodes, border, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        finally {
            monitor.done();
        }
    }

    private AbstractDNode handleKeptNode(DragAndDropTarget viewContainer, DNodeCandidate keptCandidate, Collection<AbstractDNode> keptNodes, boolean border, IProgressMonitor monitor) {
        AbstractDNode keptNode = keptCandidate.getOriginalElement();
        try {
            monitor.beginTask(Messages.DDiagramSynchronizer_nodeRefreshMsg, 3);
            AbstractNodeMapping nodeMapping = keptCandidate.getMapping();
            if (keptNode instanceof DDiagramElementContainer && nodeMapping instanceof ContainerMapping) {
                ContainerMapping keptNodeMapping = (ContainerMapping)nodeMapping;
                if ((keptNode = this.handleListAttributeChangeOnMapping(keptNode, keptNodeMapping, viewContainer, (IProgressMonitor)new SubProgressMonitor(monitor, 1))) instanceof DNodeContainer) {
                    DNodeContainer dnc = (DNodeContainer)keptNode;
                    ContainerLayout childrenPresentation = keptNodeMapping.getChildrenPresentation();
                    if (dnc.getChildrenPresentation() != childrenPresentation) {
                        dnc.setChildrenPresentation(childrenPresentation);
                    }
                }
            } else if (!border && viewContainer instanceof DDiagramElementContainer && nodeMapping instanceof NodeMapping) {
                keptNode = this.handleListAttributeChangeOnContainerMapping(keptNode, nodeMapping, (DDiagramElementContainer)viewContainer, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            this.sync.refresh((DDiagramElement)keptNode);
            monitor.worked(1);
            this.sync.refreshStyle(keptNode, nodeMapping);
            monitor.worked(1);
            keptNodes.add(keptNode);
        }
        finally {
            monitor.done();
        }
        return keptNode;
    }

    public Collection<DEdgeCandidate> computeEdgeCandidates(EdgeMapping mapping, Map<DiagramElementMapping, Collection<EdgeTarget>> mappingsToEdgeTargets) {
        return this.edgeHelper.computeNowEdgeCandidates(mapping, mappingsToEdgeTargets);
    }

    public Set<DDiagramElement> getPreviousDiagramElements(DragAndDropTarget container, DiagramElementMapping mapping) {
        if (this.forceRetrieve) {
            LinkedHashSet<DDiagramElement> previousDiagramElements = new LinkedHashSet<DDiagramElement>();
            for (DDiagramElement dDiagramElement : DragAndDropTargetQuery.on(container).getLogicalChildren()) {
                DiagramElementMapping elementMapping = dDiagramElement.getDiagramElementMapping();
                if (elementMapping instanceof AbstractNodeMapping && new DiagramElementMappingQuery(elementMapping).areInSameHiearchy(mapping)) {
                    previousDiagramElements.add(dDiagramElement);
                    continue;
                }
                if (!(elementMapping instanceof IEdgeMapping) || !new DiagramElementMappingQuery(elementMapping).areInSameHiearchy(mapping)) continue;
                previousDiagramElements.add(dDiagramElement);
            }
            return previousDiagramElements;
        }
        EObjectCouple key = new EObjectCouple((EObject)container, (EObject)mapping, this.ids);
        if (this.previousCandidatesCache == null) {
            this.computePreviousCandidatesCache();
        }
        return this.previousCandidatesCache.get((Object)key);
    }

    private void addNowNodeCandidates(SetIntersection<DNodeCandidate> biSet, DragAndDropTarget container, AbstractNodeMapping mapping, Set<DNodeCandidate> semanticFilter) {
        Collection<DNodeCandidate> nowCandidates = this.computeNodeCandidates(container, mapping, semanticFilter);
        for (DNodeCandidate candidate : nowCandidates) {
            biSet.addInNew((Object)candidate);
        }
    }

    public void forceRetrieve() {
        this.forceRetrieve = true;
    }

    public void resetforceRetrieve() {
        this.forceRetrieve = false;
    }

    public Collection<DNodeCandidate> computeNodeCandidates(DragAndDropTarget container, AbstractNodeMapping mapping, Set<DNodeCandidate> semanticFilter) {
        return this.nodHelper.computeNodeCandidates(container, mapping, semanticFilter, this.ids);
    }

    private void retrievePreviousCandidates(DragAndDropTarget container, Multimap<EObjectCouple, DDiagramElement> candidates) {
        for (DDiagramElement dDiagramElement : DragAndDropTargetQuery.on(container).getLogicalChildren()) {
            RepresentationElementMapping mapping = dDiagramElement.getMapping();
            EObjectCouple key = mapping == null ? new EObjectCouple((EObject)container, FAKE_MAPPING, this.ids) : new EObjectCouple((EObject)container, (EObject)mapping, this.ids);
            candidates.put((Object)key, (Object)dDiagramElement);
            if (!(dDiagramElement instanceof DragAndDropTarget)) continue;
            this.retrievePreviousCandidates((DragAndDropTarget)dDiagramElement, candidates);
        }
    }

    private void addPreviousCandidates(SetIntersection<DNodeCandidate> biSet, DragAndDropTarget container, AbstractNodeMapping mapping) {
        EObjectCouple key = new EObjectCouple((EObject)container, (EObject)mapping, this.ids);
        this.ignoredDuringRefreshProcess.remove(key);
        Set candidates = this.previousCandidatesCache.get((Object)key);
        if (candidates == null) {
            candidates = Collections.emptySet();
        }
        this.addCandidates(biSet, candidates.iterator(), mapping);
    }

    private <T extends DDiagramElement> void addCandidates(SetIntersection<DNodeCandidate> biSet, Iterator<T> it, AbstractNodeMapping mapping) {
        while (it.hasNext()) {
            DDiagramElement element = (DDiagramElement)it.next();
            DiagramElementMapping elementMapping = element.getDiagramElementMapping();
            if (!EqualityHelper.areEquals((EObject)elementMapping, (EObject)mapping) && mapping.eResource() != null) continue;
            DNodeCandidate abstractDNodeCandidate = new DNodeCandidate((AbstractDNode)element, this.ids);
            biSet.addInOld((Object)abstractDNodeCandidate);
        }
    }

    private List<AbstractDNode> createNewContent(Collection<DNodeCandidate> candidatesToCreate, DragAndDropTarget container, AbstractNodeMapping mapping, boolean border, IProgressMonitor monitor) {
        return this.createNewContent(candidatesToCreate, false, container, mapping, border, monitor);
    }

    private List<AbstractDNode> createNewContent(Collection<DNodeCandidate> candidatesToCreate, boolean force, DragAndDropTarget container, AbstractNodeMapping mapping, boolean border, IProgressMonitor monitor) {
        try {
            monitor.beginTask(Messages.DDiagramSynchronizer_nodeCreationMsg, candidatesToCreate.size());
            if (!candidatesToCreate.isEmpty() && this.accessor.getPermissionAuthority().canCreateIn((EObject)container) && (force || new DiagramElementMappingQuery((DiagramElementMapping)mapping).isSynchronizedAndCreateElement((DDiagram)this.diagram))) {
                ArrayList<AbstractDNode> createdNodes = new ArrayList<AbstractDNode>(candidatesToCreate.size());
                for (DNodeCandidate candidate : candidatesToCreate) {
                    AbstractDNode createdNode = this.sync.createNewNode(this.diagramMappingsManager, candidate, border);
                    createdNodes.add(createdNode);
                    monitor.worked(1);
                }
                ArrayList<AbstractDNode> arrayList = createdNodes;
                return arrayList;
            }
        }
        finally {
            monitor.done();
        }
        return new ArrayList<AbstractDNode>();
    }

    public Collection<DEdge> createEdgeMapping(DiagramMappingsManager mappingManager, Map<DiagramElementMapping, Collection<EdgeTarget>> mappingsToEdgeTargets, EdgeMapping mapping, Map<EdgeMapping, Collection<MappingBasedDecoration>> edgeToMappingBasedDecoration, Map<String, Collection<SemanticBasedDecoration>> edgeToSemanticBasedDecoration, Collection<EObject> expectedSemantics) {
        this.edgesDones = new LinkedHashSet<DDiagramElement>();
        Collection<DEdge> newEdges = this.createDEdgeOnMapping(mappingManager, mappingsToEdgeTargets, mapping, edgeToMappingBasedDecoration, edgeToSemanticBasedDecoration, expectedSemantics);
        this.edgesDones.clear();
        return newEdges;
    }

    private Collection<DEdge> createDEdgeOnMapping(DiagramMappingsManager mappingManager, Map<DiagramElementMapping, Collection<EdgeTarget>> mappingsToEdgeTargets, EdgeMapping mapping, Map<EdgeMapping, Collection<MappingBasedDecoration>> edgeToMappingBasedDecoration, Map<String, Collection<SemanticBasedDecoration>> edgeToSemanticBasedDecoration, Collection<EObject> expectedSemantics) {
        LinkedHashSet<DEdge> newEdges = new LinkedHashSet<DEdge>();
        if (this.accessor.getPermissionAuthority().canEditInstance((EObject)this.diagram)) {
            SetIntersection<DEdgeCandidate> status = this.createEdgeCandidates(mappingsToEdgeTargets, mapping, edgeToMappingBasedDecoration, edgeToSemanticBasedDecoration);
            for (DEdgeCandidate candidate : status.getNewElements()) {
                boolean candidateIsSync = new DiagramElementMappingQuery((DiagramElementMapping)mapping).isSynchronizedAndCreateElement((DDiagram)this.diagram);
                if (!candidateIsSync && !expectedSemantics.contains(candidate.getSemantic())) continue;
                newEdges.add(this.sync.createNewEdge(mappingManager, candidate, mappingsToEdgeTargets, edgeToMappingBasedDecoration, edgeToSemanticBasedDecoration));
            }
        }
        return newEdges;
    }

    private void refreshEdgeMapping(DiagramMappingsManager mappingManager, Map<DiagramElementMapping, Collection<EdgeTarget>> mappingsToEdgeTargets, EdgeMapping mapping, Map<EdgeMapping, Collection<MappingBasedDecoration>> edgeToMappingBasedDecoration, Map<String, Collection<SemanticBasedDecoration>> edgeToSemanticBasedDecoration, IProgressMonitor monitor) {
        if (this.accessor.getPermissionAuthority().canEditInstance((EObject)this.diagram)) {
            SetIntersection<DEdgeCandidate> status = this.createEdgeCandidates(mappingsToEdgeTargets, mapping, edgeToMappingBasedDecoration, edgeToSemanticBasedDecoration);
            if (new DiagramElementMappingQuery((DiagramElementMapping)mapping).isSynchronizedAndCreateElement((DDiagram)this.diagram)) {
                try {
                    Collection newElements = status.getNewElements();
                    monitor.beginTask(Messages.DDiagramSynchronizer_refreshEdgeMsg, newElements.size());
                    for (DEdgeCandidate candidate : newElements) {
                        this.edgesDones.add((DDiagramElement)this.sync.createNewEdge(mappingManager, candidate, mappingsToEdgeTargets, edgeToMappingBasedDecoration, edgeToSemanticBasedDecoration));
                        monitor.worked(1);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        }
    }

    private SetIntersection<DEdgeCandidate> createEdgeCandidates(Map<DiagramElementMapping, Collection<EdgeTarget>> mappingsToEdgeTargets, EdgeMapping mapping, Map<EdgeMapping, Collection<MappingBasedDecoration>> edgeToMappingBasedDecoration, Map<String, Collection<SemanticBasedDecoration>> edgeToSemanticBasedDecoration) {
        GSetIntersection status = new GSetIntersection();
        EObjectCouple key = new EObjectCouple((EObject)this.diagram, (EObject)mapping, this.ids);
        this.ignoredDuringRefreshProcess.remove(key);
        this.handleSubMappings((IEdgeMapping)mapping);
        this.handleSuperMappings((IEdgeMapping)mapping);
        ArrayList<DEdgeCandidate> invalidCandidates = new ArrayList<DEdgeCandidate>();
        for (DEdge edge : DDiagramSpecOperations.getEdgesFromMapping((DDiagram)this.diagram, (EdgeMapping)mapping)) {
            DEdgeCandidate edgeCandidate = new DEdgeCandidate(edge, this.ids);
            if (edgeCandidate.isInvalid()) {
                invalidCandidates.add(edgeCandidate);
                continue;
            }
            status.addInOld((Object)edgeCandidate);
        }
        Collection<DEdgeCandidate> edgesCandidates = this.computeEdgeCandidates(mapping, mappingsToEdgeTargets);
        for (DEdgeCandidate edgeCandidate : edgesCandidates) {
            status.addInNew((Object)edgeCandidate);
        }
        for (DEdgeCandidate edgeCandidate : Iterables.concat((Iterable)status.getRemovedElements(), invalidCandidates)) {
            if (this.isDefinedInAnotherLayer(edgeCandidate, mappingsToEdgeTargets)) continue;
            DslCommonPlugin.PROFILER.startWork(SiriusTasksKey.CLEANING_EDGES_KEY);
            this.accessor.eDelete((EObject)edgeCandidate.getEdge(), this.session != null ? this.session.getSemanticCrossReferencer() : null);
            DslCommonPlugin.PROFILER.stopWork(SiriusTasksKey.CLEANING_EDGES_KEY);
        }
        for (DEdgeCandidate edgeCandidate : status.getKeptElements()) {
            DslCommonPlugin.PROFILER.startWork(SiriusTasksKey.UPDATE_ALL_EDGES_KEY);
            if (!this.edgesDones.contains(edgeCandidate.getEdge())) {
                if (mapping instanceof EdgeMappingImportWrapper) {
                    EdgeMappingImport wrapped = ((EdgeMappingImportWrapper)mapping).getWrappedEdgeMappingImport();
                    if (edgeCandidate.getMapping() != wrapped) {
                        edgeCandidate.getEdge().setActualMapping((IEdgeMapping)wrapped);
                    }
                } else if (edgeCandidate.getMapping() != mapping) {
                    edgeCandidate.getEdge().setActualMapping((IEdgeMapping)mapping);
                }
                this.sync.computeEdgeDecorations(edgeCandidate.getEdge(), edgeToMappingBasedDecoration, edgeToSemanticBasedDecoration);
                Option<EdgeMapping> edgeMapping = new IEdgeMappingQuery((IEdgeMapping)mapping).getEdgeMapping();
                if (edgeMapping.some()) {
                    this.sync.createStyle(edgeCandidate.getEdge(), (EdgeMapping)edgeMapping.get(), (DDiagram)this.diagram);
                    this.sync.refresh(edgeCandidate.getEdge());
                    this.sync.refreshStyle(edgeCandidate.getEdge(), (EdgeMapping)edgeMapping.get(), (DDiagram)this.diagram);
                    this.sync.updatePath(edgeCandidate.getEdge(), (EdgeMapping)edgeMapping.get(), mappingsToEdgeTargets);
                }
                this.edgesDones.add((DDiagramElement)edgeCandidate.getEdge());
            }
            DslCommonPlugin.PROFILER.stopWork(SiriusTasksKey.UPDATE_ALL_EDGES_KEY);
        }
        return status;
    }

    private void handleSubMappings(IEdgeMapping mapping) {
        if (mapping instanceof EdgeMappingImport) {
            IEdgeMapping importedEdgeMaping = ((EdgeMappingImport)mapping).getImportedMapping();
            EObjectCouple key = new EObjectCouple((EObject)this.diagram, (EObject)importedEdgeMaping, this.ids);
            this.ignoredDuringRefreshProcess.remove(key);
            this.handleSubMappings(importedEdgeMaping);
        }
    }

    private void handleSuperMappings(IEdgeMapping mapping) {
        Iterator<EObjectCouple> iterator = this.ignoredDuringRefreshProcess.iterator();
        while (iterator.hasNext()) {
            EObjectCouple couple = iterator.next();
            EdgeMappingImport edgeMappingImport = null;
            if (couple.getObj2() instanceof EdgeMappingImportWrapper) {
                edgeMappingImport = ((EdgeMappingImportWrapper)couple.getObj2()).getWrappedEdgeMappingImport();
            } else if (couple.getObj2() instanceof EdgeMappingImport) {
                edgeMappingImport = (EdgeMappingImport)couple.getObj2();
            }
            if (edgeMappingImport == null || !couple.getObj1().equals(this.diagram) || !EdgeMappingHelper.isImported(mapping, edgeMappingImport)) continue;
            iterator.remove();
        }
    }

    private boolean isDefinedInAnotherLayer(DEdgeCandidate edgeCandidate, Map<DiagramElementMapping, Collection<EdgeTarget>> mappingsToEdgeTargets) {
        Iterator targetMappings;
        Iterator sourceMappings;
        if (edgeCandidate.getEdge() == null) {
            return false;
        }
        DEdge edge = edgeCandidate.getEdge();
        EdgeTarget source = edge.getSourceNode();
        EdgeTarget target = edge.getTargetNode();
        boolean sourceIsValid = source != null && (!(source instanceof DDiagramElement) || ((DDiagramElement)source).getParentDiagram() == this.diagram);
        boolean targetIsValid = target != null && (!(target instanceof DDiagramElement) || ((DDiagramElement)target).getParentDiagram() == this.diagram);
        Option<EdgeMapping> actualMapping = new IEdgeMappingQuery(edgeCandidate.getMapping()).getEdgeMapping();
        if (actualMapping.some()) {
            sourceMappings = ((EdgeMapping)actualMapping.get()).getSourceMapping().iterator();
            targetMappings = ((EdgeMapping)actualMapping.get()).getTargetMapping().iterator();
        } else {
            sourceMappings = Collections.emptyIterator();
            targetMappings = Collections.emptyIterator();
        }
        boolean sourceIsNotDisplayed = this.nodeIsNotDisplayed(sourceMappings, source, mappingsToEdgeTargets);
        boolean targetIsNotDisplayed = this.nodeIsNotDisplayed(targetMappings, target, mappingsToEdgeTargets);
        return sourceIsValid && targetIsValid && (sourceIsNotDisplayed || targetIsNotDisplayed);
    }

    private boolean nodeIsNotDisplayed(Iterator<DiagramElementMapping> mappingsToConsider, EdgeTarget node, Map<DiagramElementMapping, Collection<EdgeTarget>> elementsInDiagram) {
        boolean sourceIsNotDisplayed = true;
        while (mappingsToConsider.hasNext() && sourceIsNotDisplayed) {
            DiagramElementMapping sourceMapping = mappingsToConsider.next();
            Collection<EdgeTarget> elementsFromMapping = this.getDiagramElementFromMapping(sourceMapping, elementsInDiagram);
            if (elementsFromMapping == null || !elementsFromMapping.contains(node)) continue;
            sourceIsNotDisplayed = false;
        }
        return sourceIsNotDisplayed;
    }

    private Collection<EdgeTarget> getDiagramElementFromMapping(DiagramElementMapping sourceMapping, Map<DiagramElementMapping, Collection<EdgeTarget>> mappingsToEdgeTargets) {
        return mappingsToEdgeTargets.get(sourceMapping);
    }

    private void putOrAdd(Map map, DiagramElementMapping mapping, Collection<DDiagramElement> addedNodes) {
        Collection existing = (Collection)map.get(mapping);
        if (existing == null) {
            existing = new MultipleCollection();
            existing.addAll(addedNodes);
            map.put(mapping, existing);
        } else {
            existing.addAll(addedNodes);
        }
        ContainerMapping mappingToAdd = null;
        if (mapping instanceof ContainerMappingImport) {
            mappingToAdd = ((ContainerMappingImport)mapping).getImportedMapping();
        } else if (mapping instanceof NodeMappingImport) {
            mappingToAdd = ((NodeMappingImport)mapping).getImportedMapping();
        }
        if (mappingToAdd != null) {
            this.putOrAdd(map, (DiagramElementMapping)mappingToAdd, addedNodes);
        }
    }

    public void setTool(boolean b) {
        this.edgeHelper.setTool(b);
    }

    private static final class RefreshOrderHelper {
        final DragAndDropTarget viewContainer;
        final Map<EObject, Integer> oldChildPositionInGlobalList = new HashMap<EObject, Integer>();
        private RepresentationElementMapping mapping;
        private int mappingBeginIndex;

        RefreshOrderHelper(DragAndDropTarget viewContainer, RepresentationElementMapping mapping) {
            this.viewContainer = viewContainer;
            this.mapping = mapping;
            this.init();
        }

        public void init() {
            EList<EObject> ownedDDiagramElements = this.getOwnedDDiagramElements();
            this.mappingBeginIndex = ownedDDiagramElements.size();
            int position = 0;
            for (DDiagramElement diagElement : Iterables.filter(ownedDDiagramElements, DDiagramElement.class)) {
                if (this.mapping.equals(diagElement.getMapping())) {
                    if (position < this.mappingBeginIndex) {
                        this.mappingBeginIndex = position;
                    }
                    this.oldChildPositionInGlobalList.put((EObject)diagElement, position);
                }
                ++position;
            }
            if (this.mappingBeginIndex < 0) {
                this.mappingBeginIndex = ownedDDiagramElements.size() - 1;
            }
        }

        protected Object getOldGlobalPosition(DDiagramElement element) {
            if (this.oldChildPositionInGlobalList.containsKey(element)) {
                return this.oldChildPositionInGlobalList.get(element);
            }
            return -1;
        }

        protected int getMappingBeginIndex() {
            return this.mappingBeginIndex;
        }

        protected EReference getOwnedDiagramElementsToUpdate() {
            EReference ref = null;
            if (this.viewContainer instanceof DDiagram) {
                ref = DiagramPackage.eINSTANCE.getDDiagram_OwnedDiagramElements();
            } else if (this.viewContainer instanceof DNodeList) {
                ref = DiagramPackage.eINSTANCE.getDNodeList_OwnedElements();
            } else if (this.viewContainer instanceof DNodeContainer) {
                ref = DiagramPackage.eINSTANCE.getDNodeContainer_OwnedDiagramElements();
            }
            if (ref == null) {
                throw new IllegalArgumentException();
            }
            return ref;
        }

        protected EList<EObject> getOwnedDDiagramElements() {
            EList eGetResult = (EList)this.viewContainer.eGet((EStructuralFeature)this.getOwnedDiagramElementsToUpdate());
            return eGetResult;
        }
    }
}

