/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical.resolver;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.IImplicitDependencies;
import org.eclipse.emf.ecore.resource.URIConverter;

public class CachingImplicitDependencies
implements IImplicitDependencies {
    private IImplicitDependencies delegate;
    private Map<URIConverter, Map<URI, Set<URI>>> cache;

    public CachingImplicitDependencies(IImplicitDependencies delegate) {
        this.delegate = delegate;
        this.cache = Maps.newHashMap();
    }

    @Override
    public Set<URI> of(URI uri, URIConverter uriConverter) {
        Set<URI> dependencies;
        HashMap cachedURIDependencies = this.cache.get(uriConverter);
        if (cachedURIDependencies == null) {
            cachedURIDependencies = Maps.newHashMap();
            this.cache.put(uriConverter, cachedURIDependencies);
        }
        if ((dependencies = (Set<URI>)cachedURIDependencies.get(uri)) == null) {
            dependencies = this.delegate.of(uri, uriConverter);
            cachedURIDependencies.put(uri, dependencies);
        }
        return dependencies;
    }
}

