/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.ui.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.lm.Module;
import org.eclipse.emf.cdo.lm.client.ISystemDescriptor;
import org.eclipse.emf.cdo.lm.client.ISystemManager;
import org.eclipse.emf.cdo.lm.ui.actions.LMAction;
import org.eclipse.emf.cdo.lm.ui.bundle.OM;
import org.eclipse.emf.cdo.lm.util.LMOperations;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbenchPage;

public class DeleteModuleAction
extends LMAction<Module> {
    private ISystemDescriptor systemDescriptor;

    public DeleteModuleAction(IWorkbenchPage page, Module module) {
        super(page, "Delete Module" + INTERACTIVE, "Delete the Module '" + module.getName() + "'", OM.getImageDescriptor("icons/Delete.gif"), "Delete the Module '" + module.getName() + "'.", "icons/wizban/Delete.png", module);
    }

    @Override
    public String getAuthorizableOperationID() {
        return LMOperations.DELETE_MODULE;
    }

    @Override
    protected void preRun() throws Exception {
        Module module = (Module)this.getContext();
        module.getName();
        this.systemDescriptor = ISystemManager.INSTANCE.getDescriptor((EObject)module);
        super.preRun();
    }

    @Override
    protected void fillDialogArea(LMAction.LMDialog dialog, Composite parent) {
        Module module = (Module)this.getContext();
        Label oldLabel = new Label(parent, 0);
        oldLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        oldLabel.setText("Confirm the deletion of module '" + module.getName() + "'.\nNote that checkouts will be removed, too. ");
        this.validateDialog();
    }

    @Override
    protected void doRun(Module module, IProgressMonitor monitor) throws Exception {
        this.systemDescriptor.deleteModule(module, monitor);
    }
}

