/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.fetch;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.build.IAntScript;
import org.eclipse.pde.build.IFetchFactory;
import org.eclipse.pde.internal.build.Messages;
import org.eclipse.pde.internal.build.Utils;

public class P2IUFetchFactory
implements IFetchFactory {
    private static final String ATTRIBUTE_DESTINATION = "destination";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_SOURCE = "source";
    private static final String ATTRIBUTE_VERSION = "version";
    private static final String KEY_REPOSITORY = "repository";
    private static final String KEY_ID = "id";
    private static final String KEY_VERSION = "version";
    private static final String SEPARATOR = ",";
    private static final String TASK_IU = "iu";
    private static final String TASK_REPO2RUNNABLE = "p2.repo2runnable";
    private static final String TARGET_GET_IUS_FROM_REPO = "FetchIUsFromRepo";
    private final Map<String, ArrayList<IUFetchInfo>> iusToFetchBySource = new LinkedHashMap<String, ArrayList<IUFetchInfo>>(2);

    private static void throwException(String message, Exception e) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 0, message, (Throwable)e));
    }

    @Override
    public void addTargets(IAntScript script) {
        script.println();
        script.printTargetDeclaration(TARGET_GET_IUS_FROM_REPO, null, null, null, null);
        LinkedHashMap<String, String> args = new LinkedHashMap<String, String>(2);
        for (Map.Entry<String, ArrayList<IUFetchInfo>> entry : this.iusToFetchBySource.entrySet()) {
            String sourceRepository = entry.getKey();
            ArrayList<IUFetchInfo> iusToFetch = entry.getValue();
            script.printEchoTask(null, NLS.bind((String)Messages.fetching_p2Repo, (Object[])new String[]{sourceRepository, Utils.getPropertyFormat("transformedRepoLocation")}), "info");
            args.clear();
            args.put(ATTRIBUTE_SOURCE, sourceRepository);
            args.put(ATTRIBUTE_DESTINATION, Utils.getPropertyFormat("transformedRepoLocation"));
            script.printStartTag(TASK_REPO2RUNNABLE, args);
            script.incrementIdent();
            for (IUFetchInfo iuFetchInfo : iusToFetch) {
                args.clear();
                args.put("id", iuFetchInfo.id);
                args.put("version", iuFetchInfo.version);
                script.printElement(TASK_IU, args);
            }
            script.decrementIdent();
            script.printEndTag(TASK_REPO2RUNNABLE);
            script.println();
        }
        script.printTargetEnd();
        script.println();
        this.iusToFetchBySource.clear();
    }

    @Override
    public void generateRetrieveElementCall(Map<String, Object> entryInfos, IPath destination, IAntScript script) {
        String sourceRepository;
        if (this.iusToFetchBySource.isEmpty()) {
            script.printAntCallTask(TARGET_GET_IUS_FROM_REPO, true, null);
        }
        if (!this.iusToFetchBySource.containsKey(sourceRepository = (String)entryInfos.get(KEY_REPOSITORY))) {
            this.iusToFetchBySource.put(sourceRepository, new ArrayList());
        }
        IUFetchInfo iuFetchInfo = new IUFetchInfo((String)entryInfos.get("id"), (String)entryInfos.get("version"));
        List iusToFetch = this.iusToFetchBySource.get(sourceRepository);
        if (!iusToFetch.contains(iuFetchInfo)) {
            iusToFetch.add(iuFetchInfo);
        }
    }

    @Override
    public void generateRetrieveFilesCall(Map<String, Object> entryInfos, IPath destination, String[] files, IAntScript script) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put(ATTRIBUTE_SOURCE, (String)entryInfos.get(KEY_REPOSITORY));
        args.put(ATTRIBUTE_DESTINATION, destination.toOSString());
        script.printStartTag(TASK_REPO2RUNNABLE, args);
        script.incrementIdent();
        args.clear();
        args.put("id", (String)entryInfos.get("id"));
        args.put("version", (String)entryInfos.get("version"));
        script.printElement(TASK_IU, args);
        script.decrementIdent();
        script.printEndTag(TASK_REPO2RUNNABLE);
        script.println();
        args.clear();
        args.put("message", "#empty");
        args.put("file", new File(destination.toFile(), "build.properties").getAbsolutePath());
        script.printElement("echo", args);
        args.clear();
        args.put("todir", destination.toOSString());
        args.put("flatten", "true");
        script.printStartTag("move", args);
        script.incrementIdent();
        args.clear();
        args.put("dir", destination.toOSString());
        String[] stringArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            args.put("includes", "features/*/" + file);
            script.printElement("fileset", args);
            ++n2;
        }
        script.decrementIdent();
        script.printEndTag("move");
    }

    @Override
    public void parseMapFileEntry(String rawEntry, Properties overrideTags, Map<String, Object> entryInfos) throws CoreException {
        String[] arguments = Utils.getArrayFromStringWithBlank(rawEntry, SEPARATOR);
        HashMap<String, String> table = new HashMap<String, String>();
        String[] stringArray = arguments;
        int n = arguments.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            int index = arg.indexOf(61);
            if (index == -1) {
                P2IUFetchFactory.throwException(NLS.bind((String)Messages.error_incorrectDirectoryEntry, (Object)entryInfos.get("element")), null);
            }
            String key = arg.substring(0, index);
            String value = arg.substring(index + 1);
            table.put(key, value);
            ++n2;
        }
        entryInfos.put("id", table.get("id"));
        if (table.containsKey("version")) {
            entryInfos.put("version", table.get("version"));
        } else {
            entryInfos.put("version", "");
        }
        entryInfos.put(KEY_REPOSITORY, table.get(KEY_REPOSITORY));
        if (entryInfos.get("id") == null || entryInfos.get(KEY_REPOSITORY) == null) {
            P2IUFetchFactory.throwException(NLS.bind((String)Messages.error_directoryEntryRequiresIdAndRepo, (Object)entryInfos.get("element")), null);
        }
    }

    private static class IUFetchInfo {
        String id;
        String version;

        public IUFetchInfo(String id, String version) {
            this.id = id;
            this.version = version;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            IUFetchInfo other = (IUFetchInfo)obj;
            if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
                return false;
            }
            return !(this.version == null ? other.version != null : !this.version.equals(other.version));
        }
    }
}

