/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTargetExtension2;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IOrdinaryClassFile;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.manipulation.SharedASTProviderCore;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaClassPrepareBreakpoint;
import org.eclipse.jdt.debug.core.IJavaFieldVariable;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.debug.core.IJavaMethodBreakpoint;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaWatchpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.core.LambdaMethod;
import org.eclipse.jdt.internal.corext.template.java.CompilationUnitContext;
import org.eclipse.jdt.internal.corext.template.java.CompilationUnitContextType;
import org.eclipse.jdt.internal.debug.core.JavaDebugUtils;
import org.eclipse.jdt.internal.debug.core.breakpoints.LambdaCollector;
import org.eclipse.jdt.internal.debug.core.breakpoints.LambdaLocationLocatorHelper;
import org.eclipse.jdt.internal.debug.core.breakpoints.ValidBreakpointLocationLocator;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.jdt.internal.debug.ui.DebugWorkingCopyManager;
import org.eclipse.jdt.internal.debug.ui.IJDIPreferencesConstants;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionDelegateHelper;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.debug.ui.actions.BreakpointLocationVerifierJob;
import org.eclipse.jdt.internal.debug.ui.actions.BreakpointToggleUtils;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.text.template.contentassist.TemplateEngine;
import org.eclipse.jdt.internal.ui.text.template.contentassist.TemplateProposal;
import org.eclipse.jdt.ui.IWorkingCopyManager;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.FilteredList;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.SimpleMarkerAnnotation;

public class ToggleBreakpointAdapter
implements IToggleBreakpointsTargetExtension2 {
    private static final String EMPTY_STRING = "";
    private static final String TRUNCATION_SIGN = "... ";
    private static final String LAMBDA_SEPARATOR = " ";
    private static final int MAX_LAMBDA_LINE_LENGTH = 25;
    private static final int MAX_TOTAL_LAMBDA_LINE_LENGTH = 50;
    private static final String ZERO_WIDTH_SPACE = "\u200b";

    public ToggleBreakpointAdapter() {
        ActionDelegateHelper.getDefault();
    }

    protected static IType getType(ITextSelection selection) {
        IMember member = ActionDelegateHelper.getDefault().getCurrentMember(selection);
        IType type = null;
        if (member instanceof IType) {
            type = (IType)member;
        } else if (member != null) {
            type = member.getDeclaringType();
        }
        try {
            while (type != null && !type.isBinary() && type.isLocal()) {
                type = type.getDeclaringType();
            }
        }
        catch (JavaModelException e) {
            JDIDebugUIPlugin.log(e);
        }
        return type;
    }

    protected static IType getType(IJavaElement element) {
        switch (element.getElementType()) {
            case 8: {
                return ((IField)element).getDeclaringType();
            }
            case 9: {
                return ((IMethod)element).getDeclaringType();
            }
            case 7: {
                return (IType)element;
            }
        }
        return null;
    }

    public void toggleLineBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        ToggleBreakpointAdapter.toggleLineBreakpoints(part, selection, false, null);
    }

    public static void toggleLineBreakpoints(final IWorkbenchPart part, final ISelection selection, final boolean bestMatch, final ValidBreakpointLocationLocator locator) {
        Job job = new Job("Toggle Line Breakpoint"){

            protected IStatus run(IProgressMonitor monitor) {
                return ToggleBreakpointAdapter.doLineBreakpointToggle(selection, part, locator, bestMatch, monitor);
            }
        };
        job.setPriority(10);
        job.setSystem(true);
        job.schedule();
    }

    public boolean canToggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
        if (ToggleBreakpointAdapter.isRemote(part, selection)) {
            return false;
        }
        return selection instanceof ITextSelection;
    }

    public void toggleMethodBreakpoints(final IWorkbenchPart part, final ISelection finalSelection) {
        Job job = new Job("Toggle Method Breakpoints"){

            protected IStatus run(IProgressMonitor monitor) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                try {
                    IStatus iStatus = ToggleBreakpointAdapter.doToggleMethodBreakpoints(part, finalSelection, monitor);
                    return iStatus;
                }
                catch (CoreException e) {
                    IStatus iStatus = e.getStatus();
                    return iStatus;
                }
                finally {
                    BreakpointToggleUtils.setUnsetTracepoint(false);
                }
            }
        };
        job.setPriority(10);
        job.setSystem(true);
        job.schedule();
    }

    public void toggleLambdaMethodBreakpoints(final IWorkbenchPart part, final ISelection finalSelection, final ValidBreakpointLocationLocator loc) {
        Job job = new Job("Toggle Lambda Method Breakpoints"){

            protected IStatus run(IProgressMonitor monitor) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                try {
                    IStatus iStatus = ToggleBreakpointAdapter.doToggleLambdaMethodBreakpoints(part, finalSelection, loc, monitor);
                    return iStatus;
                }
                catch (CoreException e) {
                    IStatus iStatus = e.getStatus();
                    return iStatus;
                }
                finally {
                    BreakpointToggleUtils.setUnsetTracepoint(false);
                }
            }
        };
        job.setPriority(10);
        job.setSystem(true);
        job.schedule();
    }

    static void toggleLambdaEntryMethodBreakpoints(final IWorkbenchPart part, final ISelection finalSelection, final String lambdaMethodName, final String lambdaMethodSignature, final LambdaProperties lambdaProperties) {
        Job job = new Job("Toggle Lambda Entry Method Breakpoints"){

            protected IStatus run(IProgressMonitor monitor) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                try {
                    IStatus iStatus = ToggleBreakpointAdapter.doToggleLambdaEntryMethodBreakpoints(part, finalSelection, lambdaMethodName, lambdaMethodSignature, lambdaProperties, monitor);
                    return iStatus;
                }
                catch (CoreException e) {
                    IStatus iStatus = e.getStatus();
                    return iStatus;
                }
                finally {
                    BreakpointToggleUtils.setUnsetTracepoint(false);
                }
            }
        };
        job.setPriority(10);
        job.setSystem(true);
        job.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static IStatus doToggleLambdaEntryMethodBreakpoints(IWorkbenchPart part, ISelection selection, String lambdaMethodName, String lambdaMethodSignature, LambdaProperties lambdaProperties, IProgressMonitor monitor) throws CoreException {
        ITextEditor textEditor = ToggleBreakpointAdapter.getTextEditor(part);
        if (textEditor == null || !(selection instanceof ITextSelection)) {
            return Status.OK_STATUS;
        }
        ITextSelection textSelection = (ITextSelection)selection;
        IEditorInput editorInput = textEditor.getEditorInput();
        ITypeRoot root = ToggleBreakpointAdapter.getTypeRoot(editorInput);
        if (root instanceof ICompilationUnit) {
            ICompilationUnit unit;
            ICompilationUnit iCompilationUnit = unit = (ICompilationUnit)root;
            synchronized (iCompilationUnit) {
                unit.reconcile(0, false, null, null);
            }
            IJavaElement[] elements = unit.codeSelect(textSelection.getOffset(), textSelection.getLength());
            if (elements == null || elements.length == 0) {
                BreakpointToggleUtils.report(ActionMessages.LambdaEntryBreakpointToggleAction_Unavailable, part);
                return Status.OK_STATUS;
            }
            IMethod method = null;
            if (elements[0] instanceof IMethod) {
                method = (IMethod)elements[0];
            } else if (elements[0].getParent() instanceof IMethod) {
                method = (IMethod)elements[0].getParent();
            }
            if (method != null) {
                ToggleBreakpointAdapter.doToggleMethodBreakpoint(method, lambdaMethodName, lambdaMethodSignature, lambdaProperties, part, selection, monitor);
            } else {
                BreakpointToggleUtils.report(ActionMessages.LambdaEntryBreakpointToggleAction_Unavailable, part);
            }
        }
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static IStatus doToggleLambdaMethodBreakpoints(IWorkbenchPart part, ISelection selection, ValidBreakpointLocationLocator loc, IProgressMonitor monitor) throws CoreException {
        ITextEditor textEditor = ToggleBreakpointAdapter.getTextEditor(part);
        if (textEditor == null || !(selection instanceof ITextSelection)) {
            return Status.OK_STATUS;
        }
        ITextSelection textSelection = (ITextSelection)selection;
        IEditorInput editorInput = textEditor.getEditorInput();
        ITypeRoot root = ToggleBreakpointAdapter.getTypeRoot(editorInput);
        if (root instanceof ICompilationUnit) {
            ICompilationUnit unit;
            ICompilationUnit iCompilationUnit = unit = (ICompilationUnit)root;
            synchronized (iCompilationUnit) {
                unit.reconcile(0, false, null, null);
            }
            IJavaElement[] elements = unit.codeSelect(textSelection.getOffset(), textSelection.getLength());
            if (elements == null || elements.length == 0) {
                ValidBreakpointLocationLocator locNew = new ValidBreakpointLocationLocator(loc.getCompilationUnit(), textSelection.getStartLine() + 1, true, true);
                locNew.getCompilationUnit().accept((ASTVisitor)locNew);
                ToggleBreakpointAdapter.toggleLineBreakpoints(part, selection, false, locNew);
                return Status.OK_STATUS;
            }
            IMethod method = null;
            if (elements[0] instanceof IMethod) {
                method = (IMethod)elements[0];
            } else if (elements[0].getParent() instanceof IMethod) {
                method = (IMethod)elements[0].getParent();
            }
            if (method != null) {
                ToggleBreakpointAdapter.doToggleMethodBreakpoint(method, loc.getLambdaMethodName(), loc.getfLambdaMethodSignature(), null, part, selection, monitor);
            } else {
                ValidBreakpointLocationLocator locNew = new ValidBreakpointLocationLocator(loc.getCompilationUnit(), textSelection.getStartLine() + 1, true, true);
                locNew.getCompilationUnit().accept((ASTVisitor)locNew);
                ToggleBreakpointAdapter.toggleLineBreakpoints(part, selection, false, locNew);
            }
        }
        return Status.OK_STATUS;
    }

    static IStatus doToggleMethodBreakpoints(IWorkbenchPart part, ISelection finalSelection, IProgressMonitor monitor) throws CoreException {
        BreakpointToggleUtils.report(null, part);
        ISelection selection = finalSelection;
        if (!(selection instanceof IStructuredSelection)) {
            selection = ToggleBreakpointAdapter.translateToMembers(part, selection);
        }
        boolean isInterface = ToggleBreakpointAdapter.isInterface(selection, part);
        if (!(selection instanceof IStructuredSelection)) {
            BreakpointToggleUtils.report(ActionMessages.ToggleBreakpointAdapter_4, part);
            return Status.OK_STATUS;
        }
        IMethod[] members = ToggleBreakpointAdapter.getMethods((IStructuredSelection)selection, isInterface);
        if (members.length == 0) {
            if (isInterface) {
                BreakpointToggleUtils.report(ActionMessages.ToggleBreakpointAdapter_6, part);
            } else {
                BreakpointToggleUtils.report(ActionMessages.ToggleBreakpointAdapter_9, part);
            }
            return Status.OK_STATUS;
        }
        IMethod[] iMethodArray = members;
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod member = iMethodArray[n2];
            ToggleBreakpointAdapter.doToggleMethodBreakpoint(member, part, finalSelection, monitor);
            ++n2;
        }
        return Status.OK_STATUS;
    }

    private static void doToggleMethodBreakpoint(IMethod member, IWorkbenchPart part, ISelection finalSelection, IProgressMonitor monitor) throws CoreException {
        ToggleBreakpointAdapter.doToggleMethodBreakpoint(member, null, null, null, part, finalSelection, monitor);
    }

    private static void doToggleMethodBreakpoint(IMethod member, String lambdaMethodName, String lambdaMethodSignature, LambdaProperties lambdaProperties, IWorkbenchPart part, ISelection finalSelection, IProgressMonitor monitor) throws CoreException {
        IJavaBreakpoint breakpoint;
        int lambdaPosition = 0;
        if (lambdaProperties != null) {
            lambdaPosition = lambdaProperties.lambdaPosition();
        }
        if ((breakpoint = ToggleBreakpointAdapter.getMethodBreakpoint((IMember)member, lambdaPosition)) != null) {
            if (BreakpointToggleUtils.isToggleTracepoint()) {
                ToggleBreakpointAdapter.deleteTracepoint(breakpoint, part, monitor);
                BreakpointToggleUtils.setUnsetTracepoint(false);
            } else {
                if (ValidBreakpointLocationLocator.LOCATION_METHOD_CLOSE) {
                    ValidBreakpointLocationLocator.LOCATION_METHOD_CLOSE = false;
                }
                ToggleBreakpointAdapter.deleteBreakpoint(breakpoint, part, monitor);
            }
            return;
        }
        int start = -1;
        int end = -1;
        ISourceRange range = member.getNameRange();
        if (range != null) {
            start = range.getOffset();
            end = start + range.getLength();
        }
        HashMap<String, Object> attributes = new HashMap<String, Object>(10);
        BreakpointUtils.addJavaBreakpointAttributes(attributes, (IJavaElement)member);
        IType type = member.getDeclaringType();
        String mname = Optional.ofNullable(lambdaMethodName).orElse(member.getElementName());
        Object signature = Optional.ofNullable(lambdaMethodSignature).orElse(member.getSignature());
        if (member.isConstructor()) {
            mname = "<init>";
            if (type.isEnum()) {
                signature = "(Ljava.lang.String;I" + ((String)signature).substring(1);
            }
        }
        if (!type.isBinary() && lambdaMethodName == null && (signature = ToggleBreakpointAdapter.resolveMethodSignature(member)) == null) {
            BreakpointToggleUtils.report(ActionMessages.ManageMethodBreakpointActionDelegate_methodNonAvailable, part);
            return;
        }
        IResource resource = BreakpointUtils.getBreakpointResource((IMember)member);
        String qualifiedName = ToggleBreakpointAdapter.getQualifiedName(type);
        IJavaMethodBreakpoint methodBreakpoint = JDIDebugModel.createMethodBreakpoint((IResource)resource, (String)qualifiedName, (String)mname, (String)signature, (boolean)true, (boolean)false, (boolean)false, (int)-1, (int)start, (int)end, (int)0, (boolean)true, attributes);
        if (BreakpointToggleUtils.isToggleTracepoint() && finalSelection instanceof ITextSelection && part instanceof JavaEditor) {
            String pattern = ToggleBreakpointAdapter.getCodeTemplate((ITextSelection)finalSelection, (JavaEditor)part);
            if (pattern != null) {
                pattern = pattern.trim();
                pattern = pattern.replaceAll("\\\t", EMPTY_STRING);
                methodBreakpoint.setCondition(pattern);
                methodBreakpoint.setConditionEnabled(true);
                methodBreakpoint.setConditionSuspendOnTrue(true);
            }
            BreakpointToggleUtils.setUnsetTracepoint(false);
        }
        if (lambdaProperties != null) {
            methodBreakpoint.setLambdaBreakpoint(true);
            methodBreakpoint.setInlineLambdaPosition(lambdaPosition);
            if (lambdaProperties.isInline()) {
                methodBreakpoint.setLambdaName(lambdaProperties.getLambdaName());
            }
        }
        if (ValidBreakpointLocationLocator.LOCATION_METHOD_CLOSE) {
            methodBreakpoint.setEntry(false);
            methodBreakpoint.setExit(true);
            ValidBreakpointLocationLocator.LOCATION_METHOD_CLOSE = false;
        }
        if (BreakpointToggleUtils.isTriggerpoint() && finalSelection instanceof ITextSelection && part instanceof JavaEditor) {
            methodBreakpoint.setTriggerPoint(true);
            BreakpointToggleUtils.setTriggerpoint(false);
        }
        if (BreakpointToggleUtils.isHitpoint() && finalSelection instanceof ITextSelection && part instanceof JavaEditor) {
            methodBreakpoint.setHitCount(BreakpointToggleUtils.getHitCount());
            BreakpointToggleUtils.setHitpoint(false);
        }
    }

    static IStatus doLineBreakpointToggle(ISelection selection, IWorkbenchPart part, ValidBreakpointLocationLocator locator, boolean bestMatch, IProgressMonitor monitor) {
        ITextEditor editor = ToggleBreakpointAdapter.getTextEditor(part);
        if (editor == null || !(selection instanceof ITextSelection)) {
            return Status.CANCEL_STATUS;
        }
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        ITextSelection tsel = (ITextSelection)selection;
        if (tsel.getStartLine() < 0) {
            return Status.CANCEL_STATUS;
        }
        try {
            int lnumber;
            BreakpointToggleUtils.report(null, part);
            ISelection sel = selection;
            if (!(selection instanceof IStructuredSelection)) {
                sel = ToggleBreakpointAdapter.translateToMembers(part, selection);
            }
            if (!(sel instanceof IStructuredSelection)) {
                BreakpointToggleUtils.report(ActionMessages.ToggleBreakpointAdapter_3, part);
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            IMember member = (IMember)((IStructuredSelection)sel).getFirstElement();
            IType type = null;
            type = member.getElementType() == 7 ? (IType)member : member.getDeclaringType();
            if (type == null) {
                Status status = new Status(1, DebugUIPlugin.getUniqueIdentifier(), ActionMessages.ToggleBreakpointAdapter_ErrorMessage);
                Display.getDefault().asyncExec(() -> ToggleBreakpointAdapter.lambda$0((IStatus)status));
                Status status2 = status;
                return status2;
            }
            if (locator == null && BreakpointToggleUtils.isToggleTracepoint()) {
                CompilationUnit cUnit = ToggleBreakpointAdapter.parseCompilationUnit(type.getTypeRoot());
                locator = new ValidBreakpointLocationLocator(cUnit, tsel.getStartLine() + 1, true, bestMatch);
                cUnit.accept((ASTVisitor)locator);
            }
            String tname = null;
            IJavaProject project = type.getJavaProject();
            tname = locator == null || project != null && !project.isOnClasspath((IJavaElement)type) ? ToggleBreakpointAdapter.createQualifiedTypeName(type) : locator.getFullyQualifiedTypeName();
            if (tname == null) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            IResource resource = BreakpointUtils.getBreakpointResource((IMember)type);
            IJavaLineBreakpoint existingBreakpoint = JDIDebugModel.lineBreakpointExists((IResource)resource, (String)tname, (int)(lnumber = locator == null ? tsel.getStartLine() + 1 : locator.getLineLocation()));
            if (existingBreakpoint != null) {
                if (BreakpointToggleUtils.isToggleTracepoint()) {
                    ToggleBreakpointAdapter.deleteTracepoint((IJavaBreakpoint)existingBreakpoint, (IWorkbenchPart)editor, monitor);
                    BreakpointToggleUtils.setUnsetTracepoint(false);
                } else if (BreakpointToggleUtils.isTriggerpoint()) {
                    ToggleBreakpointAdapter.deleteBreakpoint((IJavaBreakpoint)existingBreakpoint, (IWorkbenchPart)editor, monitor);
                    BreakpointToggleUtils.setTriggerpoint(false);
                } else if (BreakpointToggleUtils.isHitpoint()) {
                    ToggleBreakpointAdapter.deleteBreakpoint((IJavaBreakpoint)existingBreakpoint, (IWorkbenchPart)editor, monitor);
                    BreakpointToggleUtils.setHitpoint(false);
                } else {
                    ToggleBreakpointAdapter.deleteBreakpoint((IJavaBreakpoint)existingBreakpoint, (IWorkbenchPart)editor, monitor);
                }
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            HashMap<String, Object> attributes = new HashMap<String, Object>(10);
            IDocumentProvider documentProvider = editor.getDocumentProvider();
            if (documentProvider == null) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            try {
                IDocument document = documentProvider.getDocument((Object)editor.getEditorInput());
                int charstart = -1;
                int charend = -1;
                try {
                    IRegion line = document.getLineInformation(lnumber - 1);
                    charstart = line.getOffset();
                    charend = charstart + line.getLength();
                }
                catch (BadLocationException ble) {
                    JDIDebugUIPlugin.log(ble);
                }
                BreakpointUtils.addJavaBreakpointAttributes(attributes, (IJavaElement)type);
                IJavaLineBreakpoint breakpoint = JDIDebugModel.createLineBreakpoint((IResource)resource, (String)tname, (int)lnumber, (int)charstart, (int)charend, (int)0, (boolean)true, attributes);
                if (BreakpointToggleUtils.isToggleTracepoint()) {
                    String pattern;
                    if (selection instanceof ITextSelection && part instanceof JavaEditor && (pattern = ToggleBreakpointAdapter.getCodeTemplate((ITextSelection)selection, (JavaEditor)part)) != null) {
                        pattern = pattern.trim();
                        pattern = pattern.replaceAll("\\\t", EMPTY_STRING);
                        breakpoint.setCondition(pattern);
                        breakpoint.setConditionEnabled(true);
                        breakpoint.setConditionSuspendOnTrue(true);
                    }
                    BreakpointToggleUtils.setUnsetTracepoint(false);
                }
                if (BreakpointToggleUtils.isTriggerpoint()) {
                    if (selection instanceof ITextSelection && part instanceof JavaEditor) {
                        breakpoint.setTriggerPoint(true);
                    }
                    BreakpointToggleUtils.setTriggerpoint(false);
                }
                if (BreakpointToggleUtils.isHitpoint()) {
                    if (selection instanceof ITextSelection && part instanceof JavaEditor) {
                        breakpoint.setHitCount(BreakpointToggleUtils.getHitCount());
                    }
                    BreakpointToggleUtils.setHitpoint(false);
                }
                if (locator == null) {
                    new BreakpointLocationVerifierJob(document, ToggleBreakpointAdapter.parseCompilationUnit(type.getTypeRoot()), breakpoint, lnumber, tname, type, (IEditorPart)editor, bestMatch).schedule();
                }
            }
            catch (CoreException ce) {
                IStatus iStatus = ce.getStatus();
                return iStatus;
            }
        }
        finally {
            BreakpointToggleUtils.setUnsetTracepoint(false);
        }
        return Status.OK_STATUS;
    }

    public static void toggleClassBreakpoints(final IWorkbenchPart part, final ISelection selection) {
        Job job = new Job("Toggle Class Load Breakpoints"){

            protected IStatus run(IProgressMonitor monitor) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                try {
                    return ToggleBreakpointAdapter.doToggleClassBreakpoints(part, selection, monitor);
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
            }
        };
        job.setPriority(10);
        job.setSystem(true);
        job.schedule();
    }

    static IStatus doToggleClassBreakpoints(IWorkbenchPart part, ISelection selection, IProgressMonitor monitor) throws CoreException {
        BreakpointToggleUtils.report(null, part);
        ISelection sel = selection;
        if (!(selection instanceof IStructuredSelection)) {
            sel = ToggleBreakpointAdapter.translateToMembers(part, selection);
        }
        if (ToggleBreakpointAdapter.isInterface(sel, part)) {
            BreakpointToggleUtils.report(ActionMessages.ToggleBreakpointAdapter_1, part);
            return Status.OK_STATUS;
        }
        if (!(sel instanceof IStructuredSelection)) {
            BreakpointToggleUtils.report(ActionMessages.ToggleBreakpointAdapter_0, part);
            return Status.OK_STATUS;
        }
        IMember member = (IMember)((IStructuredSelection)sel).getFirstElement();
        IType type = (IType)member;
        IJavaBreakpoint existing = ToggleBreakpointAdapter.getClassLoadBreakpoint(type);
        if (existing != null) {
            ToggleBreakpointAdapter.deleteBreakpoint(existing, part, monitor);
            return Status.OK_STATUS;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(10);
        BreakpointUtils.addJavaBreakpointAttributes(map, (IJavaElement)type);
        ISourceRange range = type.getNameRange();
        int start = -1;
        int end = -1;
        if (range != null) {
            start = range.getOffset();
            end = start + range.getLength();
        }
        IResource resource = BreakpointUtils.getBreakpointResource(member);
        String qualifiedName = ToggleBreakpointAdapter.getQualifiedName(type);
        IJavaClassPrepareBreakpoint classBreakpoint = JDIDebugModel.createClassPrepareBreakpoint((IResource)resource, (String)qualifiedName, (int)0, (int)start, (int)end, (boolean)true, map);
        if (BreakpointToggleUtils.isTriggerpoint()) {
            classBreakpoint.setTriggerPoint(true);
            BreakpointToggleUtils.setTriggerpoint(false);
        }
        if (BreakpointToggleUtils.isHitpoint()) {
            classBreakpoint.setHitCount(BreakpointToggleUtils.getHitCount());
            BreakpointToggleUtils.setHitpoint(false);
        }
        return Status.OK_STATUS;
    }

    protected static IJavaBreakpoint getClassLoadBreakpoint(IType type) throws CoreException {
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(JDIDebugModel.getPluginIdentifier());
        int i = 0;
        while (i < breakpoints.length) {
            IJavaBreakpoint breakpoint = (IJavaBreakpoint)breakpoints[i];
            if (breakpoint instanceof IJavaClassPrepareBreakpoint && ToggleBreakpointAdapter.getQualifiedName(type).equals(breakpoint.getTypeName())) {
                return breakpoint;
            }
            ++i;
        }
        return null;
    }

    static String getQualifiedName(IType type) throws JavaModelException {
        String name;
        IJavaProject project = type.getJavaProject();
        if (project == null || !project.isOnClasspath((IJavaElement)type) || !ToggleBreakpointAdapter.needsBindings(type)) {
            return ToggleBreakpointAdapter.createQualifiedTypeName(type);
        }
        CompilationUnit cuNode = ToggleBreakpointAdapter.parseCompilationUnit(type.getTypeRoot());
        ISourceRange nameRange = type.getNameRange();
        if (cuNode == null || !SourceRange.isAvailable((ISourceRange)nameRange)) {
            return ToggleBreakpointAdapter.createQualifiedTypeName(type);
        }
        ASTNode node = NodeFinder.perform((ASTNode)cuNode, (ISourceRange)nameRange);
        if (!(node instanceof SimpleName)) {
            return ToggleBreakpointAdapter.createQualifiedTypeName(type);
        }
        Object binding = node.getLocationInParent() == SimpleType.NAME_PROPERTY && node.getParent().getLocationInParent() == ClassInstanceCreation.TYPE_PROPERTY ? ((ClassInstanceCreation)node.getParent().getParent()).resolveTypeBinding() : ((SimpleName)node).resolveBinding();
        if (binding instanceof ITypeBinding && (name = ((ITypeBinding)binding).getBinaryName()) != null) {
            return name;
        }
        return ToggleBreakpointAdapter.createQualifiedTypeName(type);
    }

    static boolean needsBindings(IType type) throws JavaModelException {
        if (type.isMember()) {
            if (type.isLocal() && !type.isAnonymous()) {
                return true;
            }
            IJavaElement parent = type.getParent();
            IType ptype = null;
            while (parent != null) {
                if (parent.getElementType() == 7 && (ptype = (IType)parent).isLocal() && !ptype.isAnonymous()) {
                    return true;
                }
                parent = parent.getParent();
            }
        }
        return false;
    }

    static String createQualifiedTypeName(IType type) {
        Object tname = ToggleBreakpointAdapter.pruneAnonymous(type);
        try {
            String packName = null;
            if (type.isBinary()) {
                packName = type.getPackageFragment().getElementName();
            } else {
                IPackageDeclaration[] pd = type.getCompilationUnit().getPackageDeclarations();
                if (pd.length > 0) {
                    packName = pd[0].getElementName();
                }
            }
            if (packName != null && !packName.equals(EMPTY_STRING)) {
                tname = packName + "." + (String)tname;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return tname;
    }

    private static String pruneAnonymous(IType type) {
        StringBuilder buffer = new StringBuilder();
        IType parent = type;
        while (parent != null) {
            if (parent.getElementType() == 7) {
                IType atype = parent;
                try {
                    if (!atype.isAnonymous()) {
                        if (buffer.length() > 0) {
                            buffer.insert(0, '$');
                        }
                        buffer.insert(0, atype.getElementName());
                    }
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
            }
            parent = parent.getParent();
        }
        return buffer.toString();
    }

    private static IJavaElement getJavaElement(IEditorInput input) {
        IJavaElement je = JavaUI.getEditorInputJavaElement((IEditorInput)input);
        if (je != null) {
            return je;
        }
        return DebugWorkingCopyManager.getWorkingCopy(input, false);
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
        if (ToggleBreakpointAdapter.isRemote(part, selection)) {
            return false;
        }
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            return ToggleBreakpointAdapter.getMethods(ss, ToggleBreakpointAdapter.isInterface(selection, part)).length > 0;
        }
        return selection instanceof ITextSelection && ToggleBreakpointAdapter.isMethod((ITextSelection)selection, part);
    }

    protected static boolean isRemote(IWorkbenchPart part, ISelection selection) {
        IStructuredSelection ss;
        Object element;
        if (selection instanceof IStructuredSelection && (element = (ss = (IStructuredSelection)selection).getFirstElement()) instanceof IMember) {
            IMember member = (IMember)element;
            return !member.getJavaProject().getProject().exists();
        }
        ITextEditor editor = ToggleBreakpointAdapter.getTextEditor(part);
        if (editor != null) {
            IEditorInput input = editor.getEditorInput();
            Object adapter = Platform.getAdapterManager().getAdapter((Object)input, "org.eclipse.team.core.history.IFileRevision");
            return adapter != null;
        }
        return false;
    }

    protected static ITextEditor getTextEditor(IWorkbenchPart part) {
        if (part instanceof ITextEditor) {
            return (ITextEditor)part;
        }
        return (ITextEditor)part.getAdapter(ITextEditor.class);
    }

    protected static IMethod[] getMethods(IStructuredSelection selection, boolean isInterace) {
        if (selection.isEmpty()) {
            return new IMethod[0];
        }
        ArrayList<IMethod> methods = new ArrayList<IMethod>(selection.size());
        for (Object thing : selection) {
            try {
                if (!(thing instanceof IMethod)) continue;
                IMethod method = (IMethod)thing;
                if (isInterace) {
                    if (!Flags.isDefaultMethod((int)method.getFlags()) && !Flags.isStatic((int)method.getFlags())) continue;
                    methods.add(method);
                    continue;
                }
                if (Flags.isAbstract((int)method.getFlags())) continue;
                methods.add(method);
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
        return methods.toArray(new IMethod[methods.size()]);
    }

    protected static IMethod[] getInterfaceMethods(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return new IMethod[0];
        }
        ArrayList<IMethod> methods = new ArrayList<IMethod>(selection.size());
        for (Object thing : selection) {
            try {
                IMethod method;
                if (!(thing instanceof IMethod) || !Flags.isDefaultMethod((int)(method = (IMethod)thing).getFlags())) continue;
                methods.add(method);
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
        return methods.toArray(new IMethod[methods.size()]);
    }

    private static boolean isMethod(ITextSelection selection, IWorkbenchPart part) {
        IJavaElement element;
        ITextEditor editor = ToggleBreakpointAdapter.getTextEditor(part);
        if (editor != null && (element = ToggleBreakpointAdapter.getJavaElement(editor.getEditorInput())) != null) {
            try {
                if (element instanceof ICompilationUnit) {
                    element = ((ICompilationUnit)element).getElementAt(selection.getOffset());
                } else if (element instanceof IClassFile) {
                    element = ((IClassFile)element).getElementAt(selection.getOffset());
                }
                if (element != null && element.getElementType() == 9) {
                    IMethod method = (IMethod)element;
                    return !method.getDeclaringType().isAnonymous();
                }
            }
            catch (JavaModelException e) {
                return false;
            }
        }
        return false;
    }

    protected static List<Object> getFields(IStructuredSelection selection) throws CoreException {
        if (selection.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> fields = new ArrayList<Object>(selection.size());
        for (Object thing : selection) {
            if (thing instanceof IField) {
                fields.add(thing);
                continue;
            }
            if (!(thing instanceof IJavaFieldVariable)) continue;
            IField field = ToggleBreakpointAdapter.getField((IJavaFieldVariable)thing);
            if (field == null) {
                fields.add(thing);
                continue;
            }
            fields.add(field);
        }
        return fields;
    }

    private static boolean isInterface(ISelection selection, IWorkbenchPart part) {
        try {
            ISelection sel = selection;
            if (!(sel instanceof IStructuredSelection)) {
                sel = ToggleBreakpointAdapter.translateToMembers(part, selection);
            }
            if (sel instanceof IStructuredSelection) {
                Object obj = ((IStructuredSelection)sel).getFirstElement();
                if (obj instanceof IMember) {
                    IMember member = (IMember)((IStructuredSelection)sel).getFirstElement();
                    if (member.getElementType() == 7) {
                        return ((IType)member).isInterface();
                    }
                    IType type = member.getDeclaringType();
                    return type != null && type.isInterface();
                }
                if (obj instanceof IJavaFieldVariable) {
                    IJavaFieldVariable var = (IJavaFieldVariable)obj;
                    IType type = JavaDebugUtils.resolveType((IJavaType)var.getDeclaringType());
                    return type != null && type.isInterface();
                }
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return false;
    }

    private static boolean isField(ITextSelection selection, IWorkbenchPart part) {
        IJavaElement element;
        ITextEditor editor = ToggleBreakpointAdapter.getTextEditor(part);
        if (editor != null && (element = ToggleBreakpointAdapter.getJavaElement(editor.getEditorInput())) != null) {
            try {
                if (element instanceof ICompilationUnit) {
                    element = ((ICompilationUnit)element).getElementAt(selection.getOffset());
                } else if (element instanceof IClassFile) {
                    element = ((IClassFile)element).getElementAt(selection.getOffset());
                }
                return element != null && element.getElementType() == 8;
            }
            catch (JavaModelException e) {
                return false;
            }
        }
        return false;
    }

    private static boolean isFields(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        try {
            for (Object thing : selection) {
                if (thing instanceof IField) {
                    int flags = ((IField)thing).getFlags();
                    return !Flags.isFinal((int)flags);
                }
                if (!(thing instanceof IJavaFieldVariable)) continue;
                IJavaFieldVariable fv = (IJavaFieldVariable)thing;
                return !fv.isFinal();
            }
        }
        catch (DebugException | JavaModelException e) {
            return false;
        }
        return false;
    }

    public void toggleWatchpoints(final IWorkbenchPart part, final ISelection finalSelection) {
        Job job = new Job("Toggle Watchpoints"){

            protected IStatus run(IProgressMonitor monitor) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                try {
                    return ToggleBreakpointAdapter.doToggleWatchpoints(part, finalSelection, monitor);
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
            }
        };
        job.setPriority(10);
        job.setSystem(true);
        job.schedule();
    }

    static IStatus doToggleWatchpoints(IWorkbenchPart part, ISelection finalSelection, IProgressMonitor monitor) throws CoreException {
        BreakpointToggleUtils.report(null, part);
        ISelection selection = finalSelection;
        if (!(selection instanceof IStructuredSelection)) {
            selection = ToggleBreakpointAdapter.translateToMembers(part, finalSelection);
        }
        if (ToggleBreakpointAdapter.isInterface(selection, part)) {
            BreakpointToggleUtils.report(ActionMessages.ToggleBreakpointAdapter_5, part);
            return Status.OK_STATUS;
        }
        boolean allowed = false;
        if (!(selection instanceof IStructuredSelection)) {
            BreakpointToggleUtils.report(ActionMessages.ToggleBreakpointAdapter_2, part);
            return Status.OK_STATUS;
        }
        List<Object> fields = ToggleBreakpointAdapter.getFields((IStructuredSelection)selection);
        if (fields.isEmpty()) {
            BreakpointToggleUtils.report(ActionMessages.ToggleBreakpointAdapter_10, part);
            return Status.OK_STATUS;
        }
        IField javaField = null;
        String typeName = null;
        String fieldName = null;
        for (Object element : fields) {
            IWorkspaceRoot resource;
            if (element instanceof IField) {
                javaField = (IField)element;
                IType type = javaField.getDeclaringType();
                typeName = ToggleBreakpointAdapter.getQualifiedName(type);
                fieldName = javaField.getElementName();
                int f = javaField.getFlags();
                boolean fin = Flags.isFinal((int)f);
                if (fin) {
                    fin = javaField.getConstant() != null;
                }
                allowed = !fin;
            } else if (element instanceof IJavaFieldVariable) {
                IJavaFieldVariable var = (IJavaFieldVariable)element;
                typeName = var.getDeclaringType().getName();
                fieldName = var.getName();
                boolean fin = var.isFinal();
                if (fin) {
                    fin = javaField.getConstant() != null;
                }
                allowed = !fin;
            }
            IJavaWatchpoint breakpoint = ToggleBreakpointAdapter.getWatchpoint(typeName, fieldName);
            if (breakpoint != null) {
                ToggleBreakpointAdapter.deleteBreakpoint((IJavaBreakpoint)breakpoint, part, monitor);
                continue;
            }
            if (!allowed) {
                return ToggleBreakpointAdapter.doLineBreakpointToggle(finalSelection, part, null, true, monitor);
            }
            int start = -1;
            int end = -1;
            HashMap<String, Object> attributes = new HashMap<String, Object>(10);
            if (javaField == null) {
                resource = ResourcesPlugin.getWorkspace().getRoot();
            } else {
                IType type = javaField.getDeclaringType();
                ISourceRange range = javaField.getNameRange();
                if (range != null) {
                    start = range.getOffset();
                    end = start + range.getLength();
                }
                BreakpointUtils.addJavaBreakpointAttributes(attributes, (IJavaElement)javaField);
                resource = BreakpointUtils.getBreakpointResource((IMember)type);
            }
            IJavaWatchpoint watchPoint = JDIDebugModel.createWatchpoint((IResource)resource, (String)typeName, (String)fieldName, (int)-1, (int)start, (int)end, (int)0, (boolean)true, attributes);
            if (BreakpointToggleUtils.isTriggerpoint()) {
                watchPoint.setTriggerPoint(true);
                BreakpointToggleUtils.setTriggerpoint(false);
            }
            if (!BreakpointToggleUtils.isHitpoint()) continue;
            watchPoint.setHitCount(BreakpointToggleUtils.getHitCount());
            BreakpointToggleUtils.setHitpoint(false);
        }
        return Status.OK_STATUS;
    }

    private static IJavaWatchpoint getWatchpoint(String typeName, String fieldName) throws CoreException {
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = breakpointManager.getBreakpoints(JDIDebugModel.getPluginIdentifier());
        int i = 0;
        while (i < breakpoints.length) {
            IJavaWatchpoint watchpoint;
            IBreakpoint breakpoint = breakpoints[i];
            if (breakpoint instanceof IJavaWatchpoint && typeName.equals((watchpoint = (IJavaWatchpoint)breakpoint).getTypeName()) && fieldName.equals(watchpoint.getFieldName())) {
                return watchpoint;
            }
            ++i;
        }
        return null;
    }

    public static String resolveMethodSignature(IMethod method) throws JavaModelException {
        String signature = method.getSignature();
        String[] parameterTypes = Signature.getParameterTypes((String)signature);
        int length = parameterTypes.length;
        String[] resolvedParameterTypes = new String[length];
        int i = 0;
        while (i < length) {
            resolvedParameterTypes[i] = ToggleBreakpointAdapter.resolveTypeSignature(method, parameterTypes[i]);
            if (resolvedParameterTypes[i] == null) {
                return null;
            }
            ++i;
        }
        String resolvedReturnType = ToggleBreakpointAdapter.resolveTypeSignature(method, Signature.getReturnType((String)signature));
        if (resolvedReturnType == null) {
            return null;
        }
        return Signature.createMethodSignature((String[])resolvedParameterTypes, (String)resolvedReturnType);
    }

    private static String resolveTypeSignature(IMethod method, String typeSignature) throws JavaModelException {
        int count = Signature.getArrayCount((String)typeSignature);
        String elementTypeSignature = Signature.getElementType((String)typeSignature);
        if (elementTypeSignature.length() == 1) {
            return typeSignature;
        }
        String elementTypeName = Signature.toString((String)elementTypeSignature);
        IType type = method.getDeclaringType();
        String[][] resolvedElementTypeNames = type.resolveType(elementTypeName);
        if (resolvedElementTypeNames == null || resolvedElementTypeNames.length != 1) {
            ITypeParameter typeParameter = method.getTypeParameter(elementTypeName);
            if (!typeParameter.exists()) {
                typeParameter = type.getTypeParameter(elementTypeName);
            }
            if (typeParameter.exists()) {
                String[] bounds = typeParameter.getBounds();
                if (bounds.length == 0) {
                    return "Ljava/lang/Object;";
                }
                String bound = Signature.createTypeSignature((String)bounds[0], (boolean)false);
                String signature = ToggleBreakpointAdapter.resolveTypeSignature(method, bound);
                if (signature == null) {
                    return null;
                }
                return Signature.createArraySignature((String)signature, (int)count);
            }
            return null;
        }
        String[] types = resolvedElementTypeNames[0];
        types[1] = types[1].replace('.', '$');
        String resolvedElementTypeName = Signature.toQualifiedName((String[])types);
        String resolvedElementTypeSignature = EMPTY_STRING;
        if (types[0].equals(EMPTY_STRING)) {
            resolvedElementTypeName = resolvedElementTypeName.substring(1);
            resolvedElementTypeSignature = Signature.createTypeSignature((String)resolvedElementTypeName, (boolean)true);
        } else {
            resolvedElementTypeSignature = Signature.createTypeSignature((String)resolvedElementTypeName, (boolean)true).replace('.', '/');
        }
        return Signature.createArraySignature((String)resolvedElementTypeSignature, (int)count);
    }

    protected static IResource getResource(IEditorPart editor) {
        IEditorInput editorInput = editor.getEditorInput();
        IResource resource = (IResource)editorInput.getAdapter(IFile.class);
        if (resource == null) {
            resource = ResourcesPlugin.getWorkspace().getRoot();
        }
        return resource;
    }

    protected static IMethod getMethodHandle(IEditorPart editorPart, String typeName, String methodName, String signature) throws CoreException {
        IJavaElement element = (IJavaElement)editorPart.getEditorInput().getAdapter(IJavaElement.class);
        IType type = null;
        if (element instanceof ICompilationUnit) {
            IType[] types = ((ICompilationUnit)element).getAllTypes();
            int i = 0;
            while (i < types.length) {
                if (types[i].getFullyQualifiedName().equals(typeName)) {
                    type = types[i];
                    break;
                }
                ++i;
            }
        } else if (element instanceof IOrdinaryClassFile) {
            type = ((IOrdinaryClassFile)element).getType();
        }
        if (type != null) {
            String[] sigs = Signature.getParameterTypes((String)signature);
            return type.getMethod(methodName, sigs);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected static IJavaBreakpoint getMethodBreakpoint(IMember element, int lambdaPosition) {
        IBreakpoint[] breakpoints;
        if (!(element instanceof IMethod)) {
            return null;
        }
        IMethod iMethod = (IMethod)element;
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] iBreakpointArray = breakpoints = breakpointManager.getBreakpoints(JDIDebugModel.getPluginIdentifier());
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint breakpoint = iBreakpointArray[n2];
            if (breakpoint instanceof IJavaMethodBreakpoint) {
                IJavaMethodBreakpoint methodBreakpoint = (IJavaMethodBreakpoint)breakpoint;
                try {
                    ISourceRange sourceRange;
                    void method;
                    IMember container = BreakpointUtils.getMember((IJavaLineBreakpoint)methodBreakpoint);
                    if (container == null ? method.getDeclaringType().getFullyQualifiedName().equals(methodBreakpoint.getTypeName()) && method.getElementName().equals(methodBreakpoint.getMethodName()) && methodBreakpoint.getMethodSignature().equals(ToggleBreakpointAdapter.resolveMethodSignature((IMethod)method)) : container instanceof IMethod && (method instanceof LambdaMethod ? (sourceRange = element.getSourceRange()) != null && methodBreakpoint.getInlineLambdaPosition() == lambdaPosition && methodBreakpoint.getCharStart() == sourceRange.getOffset() : method.getDeclaringType().getFullyQualifiedName().equals(container.getDeclaringType().getFullyQualifiedName()) && method.isSimilar((IMethod)container))) {
                        return methodBreakpoint;
                    }
                }
                catch (CoreException e) {
                    JDIDebugUIPlugin.log(e);
                }
            }
            ++n2;
        }
        return null;
    }

    protected static CompilationUnit parseCompilationUnit(ITextEditor editor) {
        return ToggleBreakpointAdapter.parseCompilationUnit(ToggleBreakpointAdapter.getTypeRoot(editor.getEditorInput()));
    }

    static CompilationUnit parseCompilationUnit(ITypeRoot root) {
        if (root != null) {
            return SharedASTProviderCore.getAST((ITypeRoot)root, (SharedASTProviderCore.WAIT_FLAG)SharedASTProviderCore.WAIT_YES, null);
        }
        return null;
    }

    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        if (ToggleBreakpointAdapter.isRemote(part, selection)) {
            return false;
        }
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            return ToggleBreakpointAdapter.isFields(ss);
        }
        return selection instanceof ITextSelection && ToggleBreakpointAdapter.isField((ITextSelection)selection, part);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ISelection translateToMembers(IWorkbenchPart part, ISelection selection) throws CoreException {
        ITextEditor textEditor = ToggleBreakpointAdapter.getTextEditor(part);
        if (textEditor == null || !(selection instanceof ITextSelection)) {
            return selection;
        }
        ITextSelection textSelection = (ITextSelection)selection;
        IEditorInput editorInput = textEditor.getEditorInput();
        IDocumentProvider documentProvider = textEditor.getDocumentProvider();
        if (documentProvider == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        IDocument document = documentProvider.getDocument((Object)editorInput);
        int offset = textSelection.getOffset();
        if (document != null) {
            try {
                IRegion region = document.getLineInformationOfOffset(offset);
                int end = region.getOffset() + region.getLength();
                while (Character.isWhitespace(document.getChar(offset)) && offset < end) {
                    ++offset;
                }
            }
            catch (BadLocationException region) {
                // empty catch block
            }
        }
        IMember m = null;
        ITypeRoot root = ToggleBreakpointAdapter.getTypeRoot(editorInput);
        if (root instanceof ICompilationUnit) {
            ICompilationUnit unit;
            ICompilationUnit iCompilationUnit = unit = (ICompilationUnit)root;
            synchronized (iCompilationUnit) {
                unit.reconcile(0, false, null, null);
            }
        }
        if (root != null) {
            IField field;
            IJavaElement e = root.getElementAt(offset);
            if (e instanceof IMember) {
                m = (IMember)e;
            }
            if (m != null && m.getParent() instanceof IType && ((IType)m.getParent()).isRecord() && m instanceof IField && (field = (IField)m).isRecordComponent()) {
                m = (IMember)field.getParent();
            }
        }
        if (m != null) {
            return new StructuredSelection(m);
        }
        return selection;
    }

    private static ITypeRoot getTypeRoot(IEditorInput input) {
        ITypeRoot root = (ITypeRoot)input.getAdapter(IClassFile.class);
        if (root == null) {
            IWorkingCopyManager manager = JavaUI.getWorkingCopyManager();
            root = manager.getWorkingCopy(input);
        }
        if (root == null) {
            root = DebugWorkingCopyManager.getWorkingCopy(input, false);
        }
        return root;
    }

    private static IField getField(IJavaFieldVariable variable) throws CoreException {
        IField field;
        String varName = null;
        try {
            varName = variable.getName();
        }
        catch (DebugException x) {
            JDIDebugUIPlugin.log(x);
            return null;
        }
        IJavaType declaringType = variable.getDeclaringType();
        IType type = JavaDebugUtils.resolveType((IJavaType)declaringType);
        if (type != null && (field = type.getField(varName)).exists()) {
            return field;
        }
        return null;
    }

    public void toggleBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        ISelection sel = ToggleBreakpointAdapter.translateToMembers(part, selection);
        if (!(sel instanceof IStructuredSelection)) {
            return;
        }
        IMember member = (IMember)((IStructuredSelection)sel).getFirstElement();
        int mtype = member.getElementType();
        if (mtype == 8 || mtype == 9 || mtype == 10) {
            this.toggleFieldOrMethodBreakpoints(part, selection);
        } else if (member.getElementType() == 7) {
            if (BreakpointToggleUtils.isToggleTracepoint()) {
                BreakpointToggleUtils.report(ActionMessages.TracepointToggleAction_Unavailable, part);
                BreakpointToggleUtils.setUnsetTracepoint(false);
                return;
            }
            ToggleBreakpointAdapter.toggleClassBreakpoints(part, sel);
        } else {
            ToggleBreakpointAdapter.toggleLineBreakpoints(part, selection, true, null);
        }
    }

    public static IJavaLineBreakpoint findExistingBreakpoint(ITextEditor editor, ITextSelection ts) {
        IDocumentProvider documentProvider = editor.getDocumentProvider();
        if (documentProvider == null) {
            return null;
        }
        IEditorInput editorInput = editor.getEditorInput();
        IAnnotationModel annotationModel = documentProvider.getAnnotationModel((Object)editorInput);
        if (annotationModel == null) {
            return null;
        }
        IDocument document = documentProvider.getDocument((Object)editorInput);
        if (document == null) {
            return null;
        }
        Iterator iterator = annotationModel.getAnnotationIterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof SimpleMarkerAnnotation)) continue;
            SimpleMarkerAnnotation markerAnnotation = (SimpleMarkerAnnotation)object;
            IMarker marker = markerAnnotation.getMarker();
            try {
                IBreakpoint oldBreakpoint;
                Position position;
                int line;
                if (!marker.isSubtypeOf(IBreakpoint.BREAKPOINT_MARKER) || (line = document.getLineOfOffset((position = annotationModel.getPosition((Annotation)markerAnnotation)).getOffset())) != ts.getStartLine() || !((oldBreakpoint = DebugPlugin.getDefault().getBreakpointManager().getBreakpoint(marker)) instanceof IJavaLineBreakpoint)) continue;
                return (IJavaLineBreakpoint)oldBreakpoint;
            }
            catch (BadLocationException e) {
                JDIDebugUIPlugin.log(e);
            }
            catch (CoreException e) {
                ToggleBreakpointAdapter.logBadAnnotation(markerAnnotation, e);
            }
        }
        return null;
    }

    private void toggleFieldOrMethodBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        CompilationUnit unit;
        if (!(selection instanceof ITextSelection)) {
            return;
        }
        ITextSelection ts = (ITextSelection)selection;
        ITextEditor editor = ToggleBreakpointAdapter.getTextEditor(part);
        if (editor == null) {
            return;
        }
        IJavaLineBreakpoint breakpoint = ToggleBreakpointAdapter.findExistingBreakpoint(editor, ts);
        if (breakpoint != null) {
            if (BreakpointToggleUtils.isToggleTracepoint()) {
                ToggleBreakpointAdapter.deleteTracepoint((IJavaBreakpoint)breakpoint, part, null);
                BreakpointToggleUtils.setUnsetTracepoint(false);
            } else if (BreakpointToggleUtils.isTriggerpoint()) {
                ToggleBreakpointAdapter.deleteBreakpoint((IJavaBreakpoint)breakpoint, part, null);
                BreakpointToggleUtils.setTriggerpoint(false);
            } else if (BreakpointToggleUtils.isHitpoint()) {
                ToggleBreakpointAdapter.deleteBreakpoint((IJavaBreakpoint)breakpoint, part, null);
                BreakpointToggleUtils.setHitpoint(false);
            } else {
                IJavaMethodBreakpoint javaMB;
                IJavaMethodBreakpoint javaMBp;
                if (breakpoint instanceof IJavaMethodBreakpoint && !(javaMBp = (IJavaMethodBreakpoint)breakpoint).isLambdaBreakpoint()) {
                    ToggleBreakpointAdapter.deleteBreakpoint((IJavaBreakpoint)breakpoint, part, null);
                    return;
                }
                if (!BreakpointToggleUtils.isToggleLambdaEntryBreakpoint() && breakpoint instanceof IJavaMethodBreakpoint && (javaMB = (IJavaMethodBreakpoint)breakpoint).isLambdaBreakpoint()) {
                    ToggleBreakpointAdapter.deleteBreakpoint((IJavaBreakpoint)breakpoint, part, null);
                    return;
                }
                if (!BreakpointToggleUtils.isToggleLambdaEntryBreakpoint() && breakpoint instanceof IJavaMethodBreakpoint) {
                    return;
                }
            }
        }
        if ((unit = ToggleBreakpointAdapter.parseCompilationUnit(editor)) == null) {
            JDIDebugUIPlugin.log("Failed to parse CU for: " + editor.getTitle(), new IllegalStateException());
            return;
        }
        ValidBreakpointLocationLocator loc = null;
        boolean lambdaEntryBP = false;
        if (BreakpointToggleUtils.isToggleLambdaEntryBreakpoint()) {
            loc = new ValidBreakpointLocationLocator(unit, ts.getStartLine() + 1, true, true, ts.getOffset(), ts.getLength());
            lambdaEntryBP = true;
            BreakpointToggleUtils.setUnsetLambdaEntryBreakpoint(false);
        } else {
            loc = new ValidBreakpointLocationLocator(unit, ts.getStartLine() + 1, true, true, ts.getOffset(), ts.getLength(), true);
        }
        unit.accept((ASTVisitor)loc);
        if (loc.getLocationType() == 4) {
            this.toggleLambdaMethodBreakpoints(part, (ISelection)ts, loc);
        } else if (loc.getLocationType() == 2) {
            this.toggleMethodBreakpoints(part, (ISelection)ts);
        } else if (loc.getLocationType() == 3) {
            if (BreakpointToggleUtils.isToggleTracepoint()) {
                BreakpointToggleUtils.report(ActionMessages.TracepointToggleAction_Unavailable, part);
                BreakpointToggleUtils.setUnsetTracepoint(false);
                return;
            }
            this.toggleWatchpoints(part, (ISelection)ts);
        } else if (loc.getLocationType() == 1) {
            if (lambdaEntryBP) {
                ToggleBreakpointAdapter.toggleLambdaBreakpoint(part, ts, editor);
            } else {
                ToggleBreakpointAdapter.toggleLineBreakpoints(part, (ISelection)ts, false, loc);
            }
        }
    }

    private static void toggleLambdaBreakpoint(IWorkbenchPart part, ITextSelection ts, ITextEditor editor) throws CoreException {
        IDocumentProvider documentProvider = editor.getDocumentProvider();
        if (documentProvider == null) {
            BreakpointToggleUtils.report(ActionMessages.LambdaEntryBreakpointToggleAction_Unavailable, part);
            throw new CoreException(Status.CANCEL_STATUS);
        }
        IEditorInput editorInput = editor.getEditorInput();
        IDocument document = documentProvider.getDocument((Object)editorInput);
        if (document == null) {
            BreakpointToggleUtils.report(ActionMessages.LambdaEntryBreakpointToggleAction_Unavailable, part);
            throw new CoreException(Status.CANCEL_STATUS);
        }
        try {
            int lambdaPosition;
            IRegion region = document.getLineInformation(ts.getStartLine());
            List<LambdaExpression> lambdaExpresions = ToggleBreakpointAdapter.findLambdaExpressions(editor, region);
            if (lambdaExpresions.isEmpty()) {
                return;
            }
            if (lambdaExpresions.size() == 1) {
                lambdaPosition = 0;
            } else {
                lambdaPosition = ToggleBreakpointAdapter.selectLambda(lambdaExpresions);
                if (lambdaPosition == -1) {
                    return;
                }
            }
            LambdaExpression selectedLambda = lambdaExpresions.get(lambdaPosition);
            IMethodBinding methodBinding = selectedLambda.resolveMethodBinding();
            if (methodBinding == null) {
                BreakpointToggleUtils.report(ActionMessages.LambdaEntryBreakpointToggleAction_Unavailable, part);
                return;
            }
            String lambdaMethodName = LambdaLocationLocatorHelper.toMethodName((IMethodBinding)methodBinding);
            String lambdaMethodSignature = LambdaLocationLocatorHelper.toMethodSignature((IMethodBinding)methodBinding);
            TextSelection textSelection = new TextSelection(document, selectedLambda.getStartPosition(), selectedLambda.getLength());
            boolean inline = lambdaExpresions.size() > 1;
            LambdaProperties lambdaProperties = new LambdaProperties(lambdaExpresions.get(lambdaPosition).toString(), lambdaPosition, inline);
            ToggleBreakpointAdapter.toggleLambdaEntryMethodBreakpoints(part, (ISelection)textSelection, lambdaMethodName, lambdaMethodSignature, lambdaProperties);
        }
        catch (BadLocationException e) {
            BreakpointToggleUtils.report(ActionMessages.LambdaEntryBreakpointToggleAction_Unavailable, part);
        }
    }

    public static List<LambdaExpression> findLambdaExpressions(ITextEditor editor, IRegion region) {
        LambdaCollector lambdas = new LambdaCollector(region.getOffset(), region.getOffset() + region.getLength());
        CompilationUnit unitForLambdas = ToggleBreakpointAdapter.parseCompilationUnit(editor);
        if (unitForLambdas == null) {
            JDIDebugUIPlugin.log("Failed to parse CU for: " + editor.getTitle(), new IllegalStateException());
            return List.of();
        }
        unitForLambdas.accept((ASTVisitor)lambdas);
        return lambdas.getLambdaExpressions();
    }

    private static void logBadAnnotation(SimpleMarkerAnnotation annotation, CoreException e) {
        StringBuilder message = new StringBuilder("Editor annotation with non existing marker found: ");
        message.append("text: ").append(annotation.getText());
        message.append(", type: ").append(annotation.getType());
        message.append(", ").append(annotation.getMarker());
        JDIDebugUIPlugin.log(message.toString(), e);
    }

    public static void deleteBreakpoint(IJavaBreakpoint breakpoint, IWorkbenchPart part, IProgressMonitor monitor) throws CoreException {
        final Shell shell = part != null ? part.getSite().getShell() : null;
        final boolean[] result = new boolean[]{true};
        final IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(JDIDebugUIPlugin.getUniqueIdentifier());
        boolean prompt = prefs.getBoolean(IJDIPreferencesConstants.PREF_PROMPT_DELETE_CONDITIONAL_BREAKPOINT, true);
        if (prompt && breakpoint instanceof IJavaLineBreakpoint && ((IJavaLineBreakpoint)breakpoint).getCondition() != null) {
            Display display;
            Display display2 = display = shell != null && !shell.isDisposed() ? shell.getDisplay() : PlatformUI.getWorkbench().getDisplay();
            if (!display.isDisposed()) {
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialogWithToggle dialog = MessageDialogWithToggle.openOkCancelConfirm((Shell)shell, (String)ActionMessages.ToggleBreakpointAdapter_confirmDeleteTitle, (String)ActionMessages.ToggleBreakpointAdapter_confirmDeleteMessage, (String)ActionMessages.ToggleBreakpointAdapter_confirmDeleteShowAgain, (boolean)false, null, null);
                        if (dialog.getToggleState()) {
                            prefs.putBoolean(IJDIPreferencesConstants.PREF_PROMPT_DELETE_CONDITIONAL_BREAKPOINT, false);
                        }
                        result[0] = dialog.getReturnCode() == 0;
                    }
                });
            }
        }
        if (result[0]) {
            DebugUITools.deleteBreakpoints((IBreakpoint[])new IBreakpoint[]{breakpoint}, (Shell)shell, (IProgressMonitor)monitor);
        }
    }

    private static void deleteTracepoint(IJavaBreakpoint breakpoint, IWorkbenchPart part, IProgressMonitor monitor) throws CoreException {
        final Shell shell = part != null ? part.getSite().getShell() : null;
        final IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(JDIDebugUIPlugin.getUniqueIdentifier());
        boolean prompt = prefs.getBoolean(IJDIPreferencesConstants.PREF_PROMPT_DELETE_CONDITIONAL_BREAKPOINT, true);
        if (!prompt || !(breakpoint instanceof IJavaLineBreakpoint)) {
            DebugUITools.deleteBreakpoints((IBreakpoint[])new IBreakpoint[]{breakpoint}, (Shell)shell, (IProgressMonitor)monitor);
            return;
        }
        final boolean[] result = new boolean[]{true};
        String condition = ((IJavaLineBreakpoint)breakpoint).getCondition();
        boolean conditionChanged = true;
        if (condition != null) {
            int index = condition.indexOf(59);
            if (index != -1) {
                int lastIndex = condition.lastIndexOf(59);
                if (index == lastIndex) {
                    conditionChanged = false;
                }
            } else if (condition.indexOf("print") != -1) {
                conditionChanged = false;
            }
        }
        if (conditionChanged && condition != null) {
            Display display;
            Display display2 = display = shell != null && !shell.isDisposed() ? shell.getDisplay() : PlatformUI.getWorkbench().getDisplay();
            if (!display.isDisposed()) {
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialogWithToggle dialog = MessageDialogWithToggle.openOkCancelConfirm((Shell)shell, (String)ActionMessages.ToggleBreakpointAdapter_confirmDeleteTitle, (String)ActionMessages.ToggleBreakpointAdapter_confirmDeleteMessage, (String)ActionMessages.ToggleBreakpointAdapter_confirmDeleteShowAgain, (boolean)false, null, null);
                        if (dialog.getToggleState()) {
                            prefs.putBoolean(IJDIPreferencesConstants.PREF_PROMPT_DELETE_CONDITIONAL_BREAKPOINT, false);
                        }
                        result[0] = dialog.getReturnCode() == 0;
                    }
                });
            }
        }
        if (result[0]) {
            DebugUITools.deleteBreakpoints((IBreakpoint[])new IBreakpoint[]{breakpoint}, (Shell)shell, (IProgressMonitor)monitor);
        }
    }

    public boolean canToggleBreakpoints(IWorkbenchPart part, ISelection selection) {
        if (ToggleBreakpointAdapter.isRemote(part, selection)) {
            return false;
        }
        return this.canToggleLineBreakpoints(part, selection);
    }

    public void toggleBreakpointsWithEvent(IWorkbenchPart part, ISelection selection, Event event) throws CoreException {
        IBreakpoint bp;
        IVerticalRulerInfo info;
        ITextEditor editor;
        if (event == null) {
            this.toggleBreakpoints(part, selection);
            return;
        }
        if ((event.stateMask & SWT.MOD2) > 0) {
            IBreakpoint bp2;
            IVerticalRulerInfo info2;
            ITextEditor editor2 = ToggleBreakpointAdapter.getTextEditor(part);
            if (editor2 != null && (info2 = (IVerticalRulerInfo)editor2.getAdapter(IVerticalRulerInfo.class)) != null && (bp2 = BreakpointUtils.getBreakpointFromEditor(editor2, info2)) != null) {
                bp2.setEnabled(!bp2.isEnabled());
                return;
            }
        } else if ((event.stateMask & SWT.MOD1) > 0 && (editor = ToggleBreakpointAdapter.getTextEditor(part)) != null && (info = (IVerticalRulerInfo)editor.getAdapter(IVerticalRulerInfo.class)) != null && (bp = BreakpointUtils.getBreakpointFromEditor(editor, info)) != null) {
            PreferencesUtil.createPropertyDialogOn((Shell)editor.getSite().getShell(), (IAdaptable)bp, null, null, null).open();
            return;
        }
        this.toggleBreakpoints(part, selection);
    }

    public boolean canToggleBreakpointsWithEvent(IWorkbenchPart part, ISelection selection, Event event) {
        return this.canToggleBreakpoints(part, selection);
    }

    private static String getCodeTemplate(ITextSelection textSelection, JavaEditor part) {
        ISourceViewer viewer = part.getViewer();
        if (viewer == null) {
            return null;
        }
        TemplateContextType contextType = JavaPlugin.getDefault().getTemplateContextRegistry().getContextType("java-statements");
        AtomicReference templateBuffer = new AtomicReference();
        Display.getDefault().syncExec(() -> ToggleBreakpointAdapter.lambda$1(textSelection, part, (ITextViewer)viewer, contextType, templateBuffer));
        return (String)templateBuffer.get();
    }

    private static void doGetCodeTemplate(ITextSelection textSelection, JavaEditor part, ITextViewer viewer, TemplateContextType contextType, AtomicReference<String> templateBuffer) {
        ITextEditor editor = ToggleBreakpointAdapter.getTextEditor((IWorkbenchPart)part);
        if (editor == null) {
            return;
        }
        IDocumentProvider documentProvider = editor.getDocumentProvider();
        if (documentProvider == null) {
            return;
        }
        ICompilationUnit cunit = ToggleBreakpointAdapter.getCompilationUnit(editor);
        if (cunit == null) {
            return;
        }
        TemplateEngine statementEngine = new TemplateEngine(contextType);
        statementEngine.reset();
        IDocument document = documentProvider.getDocument((Object)editor.getEditorInput());
        try {
            TemplateProposal[] templateProposals;
            IRegion line = document.getLineInformation(textSelection.getStartLine() + 1);
            Point selectedRange = new Point(textSelection.getOffset(), textSelection.getLength());
            statementEngine.complete(viewer, selectedRange, line.getOffset(), cunit);
            TemplateProposal[] templateProposalArray = templateProposals = statementEngine.getResults();
            int n = templateProposals.length;
            int n2 = 0;
            while (n2 < n) {
                TemplateProposal templateProposal = templateProposalArray[n2];
                Template template = templateProposal.getTemplate();
                if (template.getName().equals("systrace")) {
                    CompilationUnitContextType cuContextType = (CompilationUnitContextType)JavaPlugin.getDefault().getTemplateContextRegistry().getContextType(template.getContextTypeId());
                    DocumentTemplateContext context = cuContextType.createContext(document, line.getOffset(), 0, cunit);
                    context.setVariable("selection", EMPTY_STRING);
                    ((CompilationUnitContext)context).setForceEvaluation(true);
                    templateBuffer.set(context.evaluate(template).getString());
                    return;
                }
                ++n2;
            }
        }
        catch (BadLocationException | TemplateException throwable) {
            // empty catch block
        }
    }

    private static ICompilationUnit getCompilationUnit(ITextEditor editor) {
        IJavaElement element = ToggleBreakpointAdapter.getJavaElement(editor.getEditorInput());
        if (element == null) {
            return null;
        }
        if (element instanceof IOrdinaryClassFile) {
            try {
                return ((IOrdinaryClassFile)element).getWorkingCopy(new WorkingCopyOwner(){}, null);
            }
            catch (JavaModelException e) {
                return null;
            }
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile file = root.getFile(element.getPath());
        return JavaCore.createCompilationUnitFrom((IFile)file);
    }

    static int selectLambda(List<LambdaExpression> lambdaExps) {
        HashMap seen = new HashMap();
        List<String> lambdaNames = lambdaExps.stream().map(expr -> ToggleBreakpointAdapter.shortenLambdaExpression(expr.toString())).map(name -> {
            int count = seen.getOrDefault(name, 0);
            seen.put(name, count + 1);
            if (count == 0) {
                return name;
            }
            return name + ZERO_WIDTH_SPACE.repeat(count);
        }).toList();
        LambdaLabelProvider lambdaLabelProvider = new LambdaLabelProvider(lambdaExps, lambdaNames);
        LambdaSelectionDialog dialog = new LambdaSelectionDialog(DebugUIPlugin.getShellForModalDialog(), (ILabelProvider)lambdaLabelProvider, lambdaExps, lambdaNames);
        dialog.setMultipleSelection(false);
        dialog.setTitle(ActionMessages.LambdaSelectionDialog_title);
        dialog.setElements(lambdaExps.toArray());
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            Object result = dialog.getFirstResult();
            return lambdaExps.indexOf(result);
        }
        return -1;
    }

    static String shortenLambdaExpression(String input) {
        input = input.strip();
        StringBuilder result = new StringBuilder();
        if (!input.contains("\n")) {
            if (input.length() > 50) {
                result.append(input, 0, 50).append(TRUNCATION_SIGN);
            } else {
                result.append(input);
            }
            return result.toString();
        }
        boolean shortened = false;
        String[] stringArray = input.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object line = stringArray[n2];
            if (result.length() > 0) {
                result.append(LAMBDA_SEPARATOR);
            }
            if (((String)(line = ((String)line).strip())).length() > 25) {
                line = ((String)line).substring(0, 25) + TRUNCATION_SIGN;
                shortened = true;
            }
            result.append((String)line);
            if (result.length() > 50) {
                shortened = true;
                break;
            }
            ++n2;
        }
        if (shortened && result.lastIndexOf(TRUNCATION_SIGN) != result.length() - TRUNCATION_SIGN.length()) {
            result.append(TRUNCATION_SIGN);
        }
        return result.toString().trim();
    }

    private static /* synthetic */ void lambda$0(IStatus iStatus) {
        int n = ErrorDialog.openError((Shell)JDIDebugUIPlugin.getShell(), (String)ActionMessages.ToggleBreakpointAdapter_ErrorTitle, null, (IStatus)iStatus);
    }

    private static /* synthetic */ void lambda$1(ITextSelection iTextSelection, JavaEditor javaEditor, ITextViewer iTextViewer, TemplateContextType templateContextType, AtomicReference atomicReference) {
        ToggleBreakpointAdapter.doGetCodeTemplate(iTextSelection, javaEditor, iTextViewer, templateContextType, atomicReference);
    }

    private static final class LambdaLabelProvider
    extends LabelProvider {
        private List<LambdaExpression> lambdaExps;
        private List<String> lambdaNames;

        public LambdaLabelProvider(List<LambdaExpression> lambdaExps, List<String> lambdaNames) {
            this.lambdaExps = lambdaExps;
            this.lambdaNames = lambdaNames;
        }

        public String getText(Object element) {
            int index;
            if (element instanceof LambdaExpression && (index = this.lambdaExps.indexOf(element)) != -1) {
                return this.lambdaNames.get(index);
            }
            return super.getText(element);
        }
    }

    private static final class LambdaPositionComparator
    implements Comparator<Object> {
        private List<String> lambdaNames;

        public LambdaPositionComparator(List<String> lambdaNames) {
            this.lambdaNames = lambdaNames;
        }

        @Override
        public int compare(Object o1, Object o2) {
            int index1 = this.lambdaNames.indexOf(o1);
            int index2 = this.lambdaNames.indexOf(o2);
            return index1 - index2;
        }
    }

    private record LambdaProperties(String lambdaName, int lambdaPosition, boolean isInline) {
        public String getLambdaName() {
            return ToggleBreakpointAdapter.shortenLambdaExpression(this.lambdaName);
        }
    }

    private static final class LambdaSelectionDialog
    extends ElementListSelectionDialog {
        private final List<LambdaExpression> lambdaExps;
        private final List<String> lambdaNames;

        private LambdaSelectionDialog(Shell parent, ILabelProvider renderer, List<LambdaExpression> lambdaExps, List<String> lambdaNames) {
            super(parent, renderer);
            this.lambdaExps = lambdaExps;
            this.lambdaNames = lambdaNames;
        }

        protected FilteredList createFilteredList(Composite parent) {
            final FilteredList filteredList = super.createFilteredList(parent);
            filteredList.setComparator((Comparator)new LambdaPositionComparator(this.lambdaNames));
            filteredList.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int index = filteredList.getSelectionIndex();
                    if (index < 0) {
                        return;
                    }
                    IWorkbenchPage page = JDIDebugUIPlugin.getActivePage();
                    if (page == null) {
                        return;
                    }
                    IEditorPart editorPart = page.getActiveEditor();
                    if (editorPart instanceof ITextEditor) {
                        ITextEditor textEditor = (ITextEditor)editorPart;
                        LambdaExpression lambda = lambdaExps.get(index);
                        int start = lambda.getStartPosition();
                        int length = lambda.getLength();
                        textEditor.selectAndReveal(start, length);
                    }
                }
            });
            return filteredList;
        }

        protected void setShellStyle(int newShellStyle) {
            super.setShellStyle(newShellStyle & 0xFFFEFFFF);
        }
    }
}

