/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsProvidersKeeper;
import org.eclipse.cdt.core.language.settings.providers.LanguageSettingsManager;
import org.eclipse.cdt.core.language.settings.providers.ScannerDiscoveryLegacySupport;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationData;
import org.eclipse.cdt.managedbuilder.buildproperties.IBuildPropertyManager;
import org.eclipse.cdt.managedbuilder.buildproperties.IBuildPropertyType;
import org.eclipse.cdt.managedbuilder.buildproperties.IBuildPropertyValue;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedProject;
import org.eclipse.cdt.managedbuilder.internal.ui.Messages;
import org.eclipse.cdt.managedbuilder.ui.properties.ManagedBuilderUIPlugin;
import org.eclipse.cdt.ui.newui.INewCfgDialog;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewCfgDialog
implements INewCfgDialog {
    private static final String NULL = "[null]";
    private static final String SEPARATOR = " > ";
    private static final String ART = "org.eclipse.cdt.build.core.buildArtefactType";
    private static final String NOT = Messages.NewCfgDialog_3;
    private Text configName;
    private Text configDescription;
    private Combo cloneConfigSelector;
    private Combo realConfigSelector;
    private Button b_cloneFromProject;
    private Button b_cloneFromExtension;
    private Button b_importFromOtherProject;
    private Button b_importPredefined;
    private Combo importSelector;
    private Combo importDefSelector;
    private Label statusLabel;
    private ICProjectDescription des;
    private IConfiguration[] cfgds;
    private IConfiguration[] rcfgs;
    private IConfiguration parentConfig;
    private String newName = "";
    private String newDescription = "";
    private String title;
    private Map<String, IConfiguration> imported;
    private Map<String, IConfiguration> importedDef;
    protected Shell parentShell;

    public int open() {
        if (this.parentShell == null) {
            return 1;
        }
        LocalDialog dlg = new LocalDialog(this.parentShell);
        return dlg.open();
    }

    public void setShell(Shell shell) {
        this.parentShell = shell;
    }

    public void setProject(ICProjectDescription prj) {
        this.des = prj;
        ICConfigurationDescription[] descs = this.des.getConfigurations();
        this.cfgds = new IConfiguration[descs.length];
        ArrayList<IConfiguration> lst = new ArrayList<IConfiguration>();
        int i = 0;
        while (i < descs.length) {
            IProjectType pType;
            this.cfgds[i] = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)descs[i]);
            IConfiguration cfg = this.cfgds[i];
            while (cfg != null && !cfg.isExtensionElement()) {
                cfg = cfg.getParent();
            }
            if (cfg != null && (pType = cfg.getProjectType()) != null) {
                IConfiguration[] cfs;
                IConfiguration[] iConfigurationArray = cfs = pType.getConfigurations();
                int n = cfs.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfiguration c = iConfigurationArray[n2];
                    if (c != null && !lst.contains(c)) {
                        lst.add(c);
                    }
                    ++n2;
                }
            }
            ++i;
        }
        this.rcfgs = lst.toArray(new IConfiguration[lst.size()]);
    }

    public void setTitle(String _title) {
        this.title = _title;
    }

    private String[] getConfigNamesAndDescriptions(IConfiguration[] arr, boolean check) {
        String[] names = new String[arr.length];
        int i = 0;
        while (i < arr.length) {
            names[i] = this.getNameAndDescription(arr[i]);
            ++i;
        }
        if (check) {
            boolean doubles = false;
            int i2 = 0;
            while (i2 < names.length) {
                int j = 0;
                while (j < names.length) {
                    if (i2 != j && names[i2].equals(names[j])) {
                        doubles = true;
                        break;
                    }
                    ++j;
                }
                ++i2;
            }
            if (doubles) {
                i2 = 0;
                while (i2 < names.length) {
                    IToolChain tc = arr[i2].getToolChain();
                    String s = tc == null ? NULL : tc.getName();
                    names[i2] = names[i2] + " : " + s;
                    ++i2;
                }
            }
        }
        return names;
    }

    private String getNameAndDescription(IConfiguration cfg) {
        String name = cfg.getName();
        if (name == null) {
            name = NULL;
        }
        if (cfg.getDescription() == null || cfg.getDescription().isEmpty()) {
            return name;
        }
        return name + "( " + cfg.getDescription() + " )";
    }

    protected boolean isDuplicateName(String newName) {
        int i = 0;
        while (i < this.cfgds.length) {
            if (this.cfgds[i].getName().equals(newName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean isSimilarName(String newName) {
        int i = 0;
        while (i < this.cfgds.length) {
            if (this.cfgds[i].getName().equalsIgnoreCase(newName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean validateName(String name) {
        if (name.trim().length() == 0) {
            return false;
        }
        char[] chars = name.toCharArray();
        if (Character.isWhitespace(chars[0])) {
            return false;
        }
        int index = 0;
        while (index < chars.length) {
            if (!Character.isLetterOrDigit(chars[index])) {
                switch (chars[index]) {
                    case '\"': 
                    case '*': 
                    case '/': 
                    case ':': 
                    case '<': 
                    case '>': 
                    case '?': 
                    case '\\': {
                        return false;
                    }
                }
            }
            ++index;
        }
        return true;
    }

    private void newConfiguration() {
        String id = ManagedBuildManager.calculateChildId((String)this.parentConfig.getId(), null);
        IManagedProject imp = ManagedBuildManager.getBuildInfo((IResource)this.des.getProject()).getManagedProject();
        if (imp == null || !(imp instanceof ManagedProject)) {
            return;
        }
        ManagedProject mp = (ManagedProject)imp;
        try {
            CConfigurationData data;
            ICProjectDescription prjDesOther;
            ICConfigurationDescription base;
            IResource owner;
            ICConfigurationDescription cfgDescription = null;
            Configuration cfg = new Configuration(mp, (Configuration)this.parentConfig, id, false, true);
            if (this.b_cloneFromProject.getSelection()) {
                ICConfigurationDescription base2 = ManagedBuildManager.getDescriptionForConfiguration((IConfiguration)this.parentConfig);
                cfgDescription = this.des.createConfiguration(id, this.newName, base2);
                cfgDescription.setDescription(this.newDescription);
            } else if (this.b_importFromOtherProject.getSelection() && (owner = this.parentConfig.getOwner()) != null && (base = (prjDesOther = CCorePlugin.getDefault().getProjectDescription(owner.getProject(), true)).getConfigurationByName(this.parentConfig.getName())) != null) {
                cfgDescription = this.des.createConfiguration(id, this.newName, base);
                cfgDescription.setDescription(this.newDescription);
            }
            if (cfgDescription == null && (cfgDescription = this.des.createConfiguration("org.eclipse.cdt.managedbuilder.core.configurationDataProvider", data = cfg.getConfigurationData())) instanceof ILanguageSettingsProvidersKeeper) {
                String[] defaultIds = cfg.getDefaultLanguageSettingsProviderIds();
                if (defaultIds == null) {
                    defaultIds = ScannerDiscoveryLegacySupport.getDefaultProviderIdsLegacy((ICConfigurationDescription)cfgDescription);
                }
                ((ILanguageSettingsProvidersKeeper)cfgDescription).setDefaultLanguageSettingsProvidersIds(defaultIds);
                List providers = LanguageSettingsManager.createLanguageSettingsProviders((String[])defaultIds);
                ((ILanguageSettingsProvidersKeeper)cfgDescription).setLanguageSettingProviders(providers);
            }
            if (cfgDescription != null) {
                cfg.setConfigurationDescription(cfgDescription);
                cfg.setName(this.newName);
                cfg.setDescription(this.newDescription);
                String target = cfg.getArtifactName();
                if (target == null || target.length() == 0) {
                    cfg.setArtifactName(mp.getDefaultArtifactName());
                }
                cfg.exportArtifactInfo();
            }
            if (cfgDescription == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.managedbuilder.ui", -1, Messages.NewCfgDialog_2, null));
            }
        }
        catch (CoreException e) {
            ManagedBuilderUIPlugin.log(e);
        }
    }

    private String[] getImportItems() {
        this.imported = new HashMap<String, IConfiguration>();
        if (this.des != null) {
            IProject[] ps;
            IProject[] iProjectArray = ps = this.des.getProject().getWorkspace().getRoot().getProjects();
            int n = ps.length;
            int n2 = 0;
            while (n2 < n) {
                ICConfigurationDescription[] cfgs;
                IProject p = iProjectArray[n2];
                ICProjectDescription prjd = CoreModel.getDefault().getProjectDescription(p, false);
                if (prjd != null && (cfgs = prjd.getConfigurations()) != null && cfgs.length != 0) {
                    ICConfigurationDescription[] iCConfigurationDescriptionArray = cfgs;
                    int n3 = cfgs.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ICConfigurationDescription d = iCConfigurationDescriptionArray[n4];
                        IConfiguration cfg = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)d);
                        if (cfg != null) {
                            this.imported.put(p.getName() + SEPARATOR + d.getName(), cfg);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        ArrayList<String> lst = new ArrayList<String>(this.imported.keySet());
        Collections.sort(lst);
        lst.add(0, NOT);
        return lst.toArray(new String[lst.size()]);
    }

    private String[] getImportDefItems() {
        this.importedDef = new HashMap<String, IConfiguration>();
        IBuildPropertyManager bpm = ManagedBuildManager.getBuildPropertyManager();
        IBuildPropertyType bpt = bpm.getPropertyType(ART);
        IBuildPropertyValue[] iBuildPropertyValueArray = bpt.getSupportedValues();
        int n = iBuildPropertyValueArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildPropertyValue v = iBuildPropertyValueArray[n2];
            String id = v.getId();
            IToolChain[] tcs = ManagedBuildManager.getExtensionsToolChains((String)ART, (String)id, (boolean)false);
            if (tcs != null && tcs.length != 0) {
                IToolChain[] iToolChainArray = tcs;
                int n3 = tcs.length;
                int n4 = 0;
                while (n4 < n3) {
                    IToolChain tc = iToolChainArray[n4];
                    if (!tc.isSystemObject() && !tc.isAbstract() && tc.isSupported()) {
                        String pre = ManagedBuildManager.isPlatformOk((IToolChain)tc) ? "  " : "X ";
                        IConfiguration[] iConfigurationArray = ManagedBuildManager.getExtensionConfigurations((IToolChain)tc, (String)ART, (String)id);
                        int n5 = iConfigurationArray.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IConfiguration c = iConfigurationArray[n6];
                            if (!c.isSystemObject() && c.isSupported()) {
                                this.importedDef.put(pre + v.getName() + SEPARATOR + tc.getName() + SEPARATOR + c.getName(), c);
                            }
                            ++n6;
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        ArrayList<String> lst = new ArrayList<String>(this.importedDef.keySet());
        Collections.sort(lst);
        lst.add(0, NOT);
        return lst.toArray(new String[lst.size()]);
    }

    private IConfiguration getConfigFromName(String s, Map<String, IConfiguration> imp) {
        if (imp == null) {
            return null;
        }
        return imp.get(s);
    }

    private class LocalDialog
    extends Dialog {
        LocalDialog(Shell parentShell) {
            super(parentShell);
            this.setShellStyle(this.getShellStyle() | 0x10);
        }

        protected void buttonPressed(int buttonId) {
            if (buttonId == 0) {
                NewCfgDialog.this.newName = NewCfgDialog.this.configName.getText().trim();
                NewCfgDialog.this.newDescription = NewCfgDialog.this.configDescription.getText().trim();
                if (NewCfgDialog.this.b_cloneFromProject.getSelection()) {
                    NewCfgDialog.this.parentConfig = NewCfgDialog.this.cfgds[NewCfgDialog.this.cloneConfigSelector.getSelectionIndex()];
                } else if (NewCfgDialog.this.b_cloneFromExtension.getSelection()) {
                    NewCfgDialog.this.parentConfig = NewCfgDialog.this.rcfgs[NewCfgDialog.this.realConfigSelector.getSelectionIndex()];
                } else if (NewCfgDialog.this.b_importFromOtherProject.getSelection()) {
                    NewCfgDialog.this.parentConfig = NewCfgDialog.this.getConfigFromName(NewCfgDialog.this.importSelector.getText(), NewCfgDialog.this.imported);
                } else if (NewCfgDialog.this.b_importPredefined.getSelection()) {
                    NewCfgDialog.this.parentConfig = NewCfgDialog.this.getConfigFromName(NewCfgDialog.this.importDefSelector.getText(), NewCfgDialog.this.importedDef);
                }
                if (NewCfgDialog.this.parentConfig != null) {
                    NewCfgDialog.this.newConfiguration();
                }
            } else {
                NewCfgDialog.this.newName = null;
                NewCfgDialog.this.newDescription = null;
                NewCfgDialog.this.parentConfig = null;
            }
            super.buttonPressed(buttonId);
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            if (NewCfgDialog.this.title != null) {
                shell.setText(NewCfgDialog.this.title);
            }
        }

        protected void createButtonsForButtonBar(Composite parent) {
            super.createButtonsForButtonBar(parent);
            NewCfgDialog.this.configName.setFocus();
            if (NewCfgDialog.this.configName != null) {
                NewCfgDialog.this.configName.setText(NewCfgDialog.this.newName);
            }
            this.setButtons();
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setFont(parent.getFont());
            composite.setLayout((Layout)new GridLayout(3, false));
            composite.setLayoutData((Object)new GridData(768));
            Group group1 = new Group(composite, 0);
            group1.setFont(composite.getFont());
            GridLayout layout1 = new GridLayout(3, false);
            group1.setLayout((Layout)layout1);
            GridData gd = new GridData(768);
            gd.horizontalSpan = 3;
            group1.setLayoutData((Object)gd);
            Label warningLabel = new Label((Composite)group1, 65);
            warningLabel.setFont(parent.getFont());
            warningLabel.setText(Messages.NewConfiguration_label_warning);
            gd = new GridData(4, 1, true, false, 3, 1);
            gd.widthHint = 300;
            warningLabel.setLayoutData((Object)gd);
            Label nameLabel = new Label((Composite)group1, 16384);
            nameLabel.setFont(parent.getFont());
            nameLabel.setText(Messages.NewConfiguration_label_name);
            gd = new GridData(768);
            gd.horizontalSpan = 1;
            gd.grabExcessHorizontalSpace = false;
            nameLabel.setLayoutData((Object)gd);
            NewCfgDialog.this.configName = new Text((Composite)group1, 2052);
            NewCfgDialog.this.configName.setFont(group1.getFont());
            NewCfgDialog.this.configName.setText(NewCfgDialog.this.newName);
            NewCfgDialog.this.configName.setFocus();
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            gd.widthHint = 200;
            NewCfgDialog.this.configName.setLayoutData((Object)gd);
            NewCfgDialog.this.configName.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    LocalDialog.this.setButtons();
                }
            });
            Label descriptionLabel = new Label((Composite)group1, 16384);
            descriptionLabel.setFont(parent.getFont());
            descriptionLabel.setText(Messages.NewConfiguration_label_description);
            gd = new GridData(768);
            gd.horizontalSpan = 1;
            gd.grabExcessHorizontalSpace = false;
            descriptionLabel.setLayoutData((Object)gd);
            NewCfgDialog.this.configDescription = new Text((Composite)group1, 2052);
            NewCfgDialog.this.configDescription.setFont(group1.getFont());
            NewCfgDialog.this.configDescription.setText(NewCfgDialog.this.newDescription);
            NewCfgDialog.this.configDescription.setFocus();
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            gd.widthHint = 200;
            NewCfgDialog.this.configDescription.setLayoutData((Object)gd);
            Group group = new Group(composite, 0);
            group.setFont(composite.getFont());
            group.setText(Messages.NewConfiguration_label_group);
            GridLayout layout = new GridLayout(2, false);
            group.setLayout((Layout)layout);
            gd = new GridData(768);
            gd.horizontalSpan = 3;
            group.setLayoutData((Object)gd);
            NewCfgDialog.this.b_cloneFromProject = new Button((Composite)group, 16);
            NewCfgDialog.this.b_cloneFromProject.setText(Messages.NewCfgDialog_0);
            gd = new GridData(1);
            NewCfgDialog.this.b_cloneFromProject.setLayoutData((Object)gd);
            NewCfgDialog.this.b_cloneFromProject.setSelection(true);
            NewCfgDialog.this.b_cloneFromProject.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    LocalDialog.this.setButtons();
                }
            });
            NewCfgDialog.this.cloneConfigSelector = new Combo((Composite)group, 2060);
            NewCfgDialog.this.cloneConfigSelector.setFont(group.getFont());
            NewCfgDialog.this.cloneConfigSelector.setItems(NewCfgDialog.this.getConfigNamesAndDescriptions(NewCfgDialog.this.cfgds, false));
            int index = NewCfgDialog.this.cloneConfigSelector.indexOf(NewCfgDialog.this.newName);
            NewCfgDialog.this.cloneConfigSelector.select(index < 0 ? 0 : index);
            gd = new GridData(768);
            NewCfgDialog.this.cloneConfigSelector.setLayoutData((Object)gd);
            NewCfgDialog.this.cloneConfigSelector.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    LocalDialog.this.setButtons();
                }
            });
            NewCfgDialog.this.b_cloneFromExtension = new Button((Composite)group, 16);
            NewCfgDialog.this.b_cloneFromExtension.setText(Messages.NewCfgDialog_1);
            gd = new GridData(1);
            NewCfgDialog.this.b_cloneFromExtension.setLayoutData((Object)gd);
            NewCfgDialog.this.b_cloneFromExtension.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    LocalDialog.this.setButtons();
                }
            });
            String[] extCfgs = NewCfgDialog.this.getConfigNamesAndDescriptions(NewCfgDialog.this.rcfgs, true);
            NewCfgDialog.this.realConfigSelector = new Combo((Composite)group, 2060);
            NewCfgDialog.this.realConfigSelector.setFont(group.getFont());
            NewCfgDialog.this.realConfigSelector.setItems(extCfgs);
            index = NewCfgDialog.this.realConfigSelector.indexOf(NewCfgDialog.this.newName);
            NewCfgDialog.this.realConfigSelector.select(index < 0 ? 0 : index);
            gd = new GridData(768);
            NewCfgDialog.this.realConfigSelector.setLayoutData((Object)gd);
            NewCfgDialog.this.realConfigSelector.setEnabled(false);
            NewCfgDialog.this.realConfigSelector.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    LocalDialog.this.setButtons();
                }
            });
            if (extCfgs.length == 0) {
                NewCfgDialog.this.b_cloneFromExtension.setEnabled(false);
            }
            NewCfgDialog.this.b_importFromOtherProject = new Button((Composite)group, 16);
            NewCfgDialog.this.b_importFromOtherProject.setText(Messages.NewCfgDialog_4);
            gd = new GridData(1);
            NewCfgDialog.this.b_importFromOtherProject.setLayoutData((Object)gd);
            NewCfgDialog.this.b_importFromOtherProject.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    LocalDialog.this.setButtons();
                }
            });
            NewCfgDialog.this.importSelector = new Combo((Composite)group, 2060);
            NewCfgDialog.this.importSelector.setFont(group.getFont());
            NewCfgDialog.this.importSelector.setItems(NewCfgDialog.this.getImportItems());
            NewCfgDialog.this.importSelector.select(0);
            NewCfgDialog.this.importSelector.setVisibleItemCount(Math.min(10, NewCfgDialog.this.importSelector.getItemCount()));
            gd = new GridData(768);
            NewCfgDialog.this.importSelector.setLayoutData((Object)gd);
            NewCfgDialog.this.importSelector.setEnabled(false);
            NewCfgDialog.this.importSelector.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    LocalDialog.this.setButtons();
                }
            });
            NewCfgDialog.this.b_importPredefined = new Button((Composite)group, 16);
            NewCfgDialog.this.b_importPredefined.setText(Messages.NewCfgDialog_5);
            gd = new GridData(1);
            NewCfgDialog.this.b_importPredefined.setLayoutData((Object)gd);
            NewCfgDialog.this.b_importPredefined.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    LocalDialog.this.setButtons();
                }
            });
            NewCfgDialog.this.importDefSelector = new Combo((Composite)group, 2060);
            NewCfgDialog.this.importDefSelector.setFont(group.getFont());
            NewCfgDialog.this.importDefSelector.setItems(NewCfgDialog.this.getImportDefItems());
            NewCfgDialog.this.importDefSelector.select(0);
            NewCfgDialog.this.importDefSelector.setVisibleItemCount(Math.min(10, NewCfgDialog.this.importDefSelector.getItemCount()));
            gd = new GridData(768);
            NewCfgDialog.this.importDefSelector.setLayoutData((Object)gd);
            NewCfgDialog.this.importDefSelector.setEnabled(false);
            NewCfgDialog.this.importDefSelector.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    LocalDialog.this.setButtons();
                }
            });
            NewCfgDialog.this.statusLabel = new Label(composite, 0x1000000);
            gd = new GridData(768);
            gd.horizontalSpan = 3;
            NewCfgDialog.this.statusLabel.setLayoutData((Object)gd);
            NewCfgDialog.this.statusLabel.setFont(composite.getFont());
            NewCfgDialog.this.statusLabel.setForeground(JFaceResources.getColorRegistry().get("ERROR_COLOR"));
            return composite;
        }

        private void setButtons() {
            String s = null;
            String currentName = NewCfgDialog.this.configName.getText();
            while (currentName.length() > 0 && Character.isWhitespace(currentName.charAt(currentName.length() - 1))) {
                currentName = currentName.substring(0, currentName.length() - 1);
            }
            if (currentName.length() == 0) {
                s = "";
            } else if (NewCfgDialog.this.cfgds.length == 0) {
                s = "";
            } else if (NewCfgDialog.this.isDuplicateName(currentName)) {
                s = NLS.bind((String)Messages.NewConfiguration_error_duplicateName, (Object)currentName);
            } else if (NewCfgDialog.this.isSimilarName(currentName)) {
                s = NLS.bind((String)Messages.NewConfiguration_error_caseName, (Object)currentName);
            } else if (!NewCfgDialog.this.validateName(currentName)) {
                s = Messages.NewConfiguration_error_invalidName;
            }
            if (NewCfgDialog.this.statusLabel == null) {
                return;
            }
            Button b = this.getButton(0);
            if (s != null) {
                NewCfgDialog.this.statusLabel.setText(s);
                NewCfgDialog.this.statusLabel.setVisible(true);
                if (b != null) {
                    b.setEnabled(false);
                }
            } else {
                NewCfgDialog.this.statusLabel.setVisible(false);
                if (b != null) {
                    b.setEnabled(true);
                }
            }
            if (NewCfgDialog.this.b_importFromOtherProject.getSelection() && NewCfgDialog.this.importSelector.getSelectionIndex() == 0 && b != null) {
                b.setEnabled(false);
            }
            if (NewCfgDialog.this.b_importPredefined.getSelection() && NewCfgDialog.this.importDefSelector.getSelectionIndex() == 0 && b != null) {
                b.setEnabled(false);
            }
            NewCfgDialog.this.cloneConfigSelector.setEnabled(NewCfgDialog.this.b_cloneFromProject.getSelection());
            NewCfgDialog.this.realConfigSelector.setEnabled(NewCfgDialog.this.b_cloneFromExtension.getSelection());
            NewCfgDialog.this.importSelector.setEnabled(NewCfgDialog.this.b_importFromOtherProject.getSelection());
            NewCfgDialog.this.importDefSelector.setEnabled(NewCfgDialog.this.b_importPredefined.getSelection());
        }
    }
}

