/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.extension;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContextProvider;
import org.junit.jupiter.engine.extension.DefaultRepetitionInfo;
import org.junit.jupiter.engine.extension.RepeatedTestDisplayNameFormatter;
import org.junit.jupiter.engine.extension.RepeatedTestInvocationContext;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.util.Preconditions;

class RepeatedTestExtension
implements TestTemplateInvocationContextProvider {
    RepeatedTestExtension() {
    }

    public boolean supportsTestTemplate(ExtensionContext context) {
        return AnnotationSupport.isAnnotated((Optional)context.getTestMethod(), RepeatedTest.class);
    }

    public Stream<RepeatedTestInvocationContext> provideTestTemplateInvocationContexts(ExtensionContext context) {
        Method testMethod = context.getRequiredTestMethod();
        String displayName = context.getDisplayName();
        RepeatedTest repeatedTest = (RepeatedTest)AnnotationSupport.findAnnotation((AnnotatedElement)testMethod, RepeatedTest.class).get();
        int totalRepetitions = this.totalRepetitions(repeatedTest, testMethod);
        AtomicInteger failureCount = new AtomicInteger();
        int failureThreshold = this.failureThreshold(repeatedTest, testMethod);
        RepeatedTestDisplayNameFormatter formatter = this.displayNameFormatter(repeatedTest, testMethod, displayName);
        return IntStream.rangeClosed(1, totalRepetitions).mapToObj(repetition -> new DefaultRepetitionInfo(repetition, totalRepetitions, failureCount, failureThreshold)).map(repetitionInfo -> new RepeatedTestInvocationContext((DefaultRepetitionInfo)repetitionInfo, formatter));
    }

    private int totalRepetitions(RepeatedTest repeatedTest, Method method) {
        int repetitions = repeatedTest.value();
        Preconditions.condition((repetitions > 0 ? 1 : 0) != 0, () -> "Configuration error: @RepeatedTest on method [%s] must be declared with a positive 'value'.".formatted(method));
        return repetitions;
    }

    private int failureThreshold(RepeatedTest repeatedTest, Method method) {
        int failureThreshold = repeatedTest.failureThreshold();
        if (failureThreshold != Integer.MAX_VALUE) {
            int repetitions = repeatedTest.value();
            Preconditions.condition((failureThreshold > 0 && failureThreshold < repetitions ? 1 : 0) != 0, () -> "Configuration error: @RepeatedTest on method [%s] must declare a 'failureThreshold' greater than zero and less than the total number of repetitions [%d].".formatted(method, repetitions));
        }
        return failureThreshold;
    }

    private RepeatedTestDisplayNameFormatter displayNameFormatter(RepeatedTest repeatedTest, Method method, String displayName) {
        String pattern = Preconditions.notBlank((String)repeatedTest.name().strip(), () -> "Configuration error: @RepeatedTest on method [%s] must be declared with a non-empty name.".formatted(method));
        return new RepeatedTestDisplayNameFormatter(pattern, displayName);
    }
}

