/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.RecordDeclaration;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.jdt.core.refactoring.descriptors.ConvertToRecordDescriptor;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.core.manipulation.BindingLabelProviderCore;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.core.refactoring.descriptors.RefactoringSignatureDescriptorFactory;
import org.eclipse.jdt.internal.corext.codemanipulation.GetterSetterUtil;
import org.eclipse.jdt.internal.corext.dom.ASTFlattener;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.AbortSearchException;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jdt.internal.corext.dom.SelectionAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptorUtil;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.util.Progress;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.TextEditGroup;

public class ConvertToRecordRefactoring
extends Refactoring {
    private int fSelectionStart;
    private int fSelectionLength;
    private ICompilationUnit fCu;
    private CompilationUnit fASTRoot;
    private MethodDeclaration fConstructor;
    private AbstractTypeDeclaration fTypeDeclaration;
    private ITypeBinding fTypeBinding;
    Map<IVariableBinding, IMethodBinding> fGetterMap = new HashMap<IVariableBinding, IMethodBinding>();
    TextChangeManager fChangeManager;
    CompilationUnitRewrite fBaseCURewrite;

    public ConvertToRecordRefactoring(ICompilationUnit unit, CompilationUnit node, int selectionStart, int selectionLength) {
        Assert.isTrue((selectionStart >= 0 ? 1 : 0) != 0);
        Assert.isTrue((selectionLength >= 0 ? 1 : 0) != 0);
        this.fSelectionStart = selectionStart;
        this.fSelectionLength = selectionLength;
        this.fCu = unit;
        this.fASTRoot = node;
    }

    public ConvertToRecordRefactoring(ICompilationUnit unit, int selectionStart, int selectionLength) {
        this(unit, null, selectionStart, selectionLength);
    }

    public String getName() {
        return RefactoringCoreMessages.ConvertToRecordRefactoring_name;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        try {
            int modifiers;
            IVariableBinding[] fields;
            pm.beginTask("", 1);
            RefactoringStatus result = Checks.validateModifiesFiles(ResourceUtil.getFiles(new ICompilationUnit[]{this.fCu}), this.getValidationContext(), pm);
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            ASTNode selected = ConvertToRecordRefactoring.getSelectedNode(this.fASTRoot, this.fSelectionStart, this.fSelectionLength);
            ASTNode selectedType = ASTNodes.getFirstAncestorOrNull(selected, AbstractTypeDeclaration.class, RecordDeclaration.class, AnonymousClassDeclaration.class);
            if (!(selectedType instanceof TypeDeclaration)) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ConvertToRecordRefactoring_no_type);
                return refactoringStatus;
            }
            this.fTypeDeclaration = (TypeDeclaration)selectedType;
            this.fTypeBinding = this.fTypeDeclaration.resolveBinding();
            if (this.fTypeBinding == null) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ConvertToRecordRefactoring_unexpected_error);
                return refactoringStatus;
            }
            if (this.fTypeBinding.getSuperclass() != null && !this.fTypeBinding.getSuperclass().isEqualTo((IBinding)this.fASTRoot.getAST().resolveWellKnownType("java.lang.Object"))) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ConvertToRecordRefactoring_cannot_extend);
                return refactoringStatus;
            }
            if (this.fTypeBinding.getInterfaces().length != 0) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ConvertToRecordRefactoring_not_simple_case);
                return refactoringStatus;
            }
            int typeModifiers = this.fTypeBinding.getModifiers();
            if (Modifier.isSealed((int)typeModifiers)) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ConvertToRecordRefactoring_not_simple_case);
                return refactoringStatus;
            }
            IVariableBinding[] iVariableBindingArray = fields = this.fTypeBinding.getDeclaredFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                IVariableBinding field = iVariableBindingArray[n2];
                modifiers = field.getModifiers();
                if (!Modifier.isPrivate((int)modifiers)) {
                    RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ConvertToRecordRefactoring_not_private);
                    return refactoringStatus;
                }
                ++n2;
            }
            IMethodBinding[] methodBindings = this.fTypeBinding.getDeclaredMethods();
            boolean hasConstructor = false;
            IMethodBinding[] iMethodBindingArray = methodBindings;
            modifiers = methodBindings.length;
            int n3 = 0;
            while (n3 < modifiers) {
                IMethodBinding method = iMethodBindingArray[n3];
                if (method.isConstructor()) {
                    if (hasConstructor) {
                        RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ConvertToRecordRefactoring_has_constructors);
                        return refactoringStatus;
                    }
                    hasConstructor = true;
                }
                ++n3;
            }
            if (!hasConstructor) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ConvertToRecordRefactoring_not_simple_case);
                return refactoringStatus;
            }
            IJavaElement iJavaElement = this.fTypeBinding.getJavaElement();
            if (iJavaElement instanceof IType) {
                IType sourceType = (IType)iJavaElement;
                IMethod[] methods = sourceType.getMethods();
                IVariableBinding[] iVariableBindingArray2 = fields;
                int n4 = fields.length;
                int n5 = 0;
                while (n5 < n4) {
                    IVariableBinding field = iVariableBindingArray2[n5];
                    IMethodBinding getter = this.findGetter(this.fTypeBinding, field);
                    if (getter == null) {
                        RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ConvertToRecordRefactoring_not_simple_case);
                        return refactoringStatus;
                    }
                    this.fGetterMap.put(field, getter);
                    ++n5;
                }
                if (methods.length < fields.length + 1) {
                    RefactoringStatus refactoringStatus = RefactoringStatus.createWarningStatus((String)RefactoringCoreMessages.ConvertToRecordRefactoring_not_enough_getters);
                    return refactoringStatus;
                }
                if (methods.length > fields.length + 1) {
                    RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ConvertToRecordRefactoring_not_simple_case);
                    return refactoringStatus;
                }
                try {
                    this.fTypeDeclaration.accept(new ASTVisitor(){

                        public boolean visit(FieldDeclaration node) {
                            List fragments = node.fragments();
                            for (VariableDeclarationFragment fragment : fragments) {
                                if (fragment.getInitializer() == null) continue;
                                throw new AbortSearchException();
                            }
                            return false;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public boolean visit(MethodDeclaration node) {
                            List<Statement> statements = ASTNodes.asList((Statement)node.getBody());
                            if (node.isConstructor()) {
                                if (ConvertToRecordRefactoring.this.fConstructor != null) {
                                    throw new AbortSearchException();
                                }
                                ConvertToRecordRefactoring.this.fConstructor = node;
                                for (Statement statement2 : statements) {
                                    ExpressionStatement expStmt;
                                    Expression expression;
                                    if (statement2 instanceof ExpressionStatement && (expression = (expStmt = (ExpressionStatement)statement2).getExpression()) instanceof Assignment) {
                                        SimpleName simpleName;
                                        IBinding binding;
                                        Assignment assignment = (Assignment)expression;
                                        Expression leftHandSide = assignment.getLeftHandSide();
                                        Expression rightHandSide = assignment.getRightHandSide();
                                        if (rightHandSide instanceof SimpleName && (binding = (simpleName = (SimpleName)rightHandSide).resolveBinding()) instanceof IVariableBinding) {
                                            IVariableBinding simpleNameBinding = (IVariableBinding)binding;
                                            String getterName = GetterSetterUtil.getGetterName(ConvertToRecordRefactoring.this.fCu.getJavaProject(), simpleNameBinding.getName(), simpleNameBinding.getModifiers(), ConvertToRecordRefactoring.this.isBoolean(simpleNameBinding), null);
                                            if (this.isGetterField(leftHandSide, getterName)) continue;
                                        }
                                    }
                                    throw new AbortSearchException();
                                }
                            } else {
                                void retStmt;
                                Statement statement;
                                if (statements.size() != 1 || !((statement = statements.get(0)) instanceof ReturnStatement)) {
                                    throw new AbortSearchException();
                                }
                                ReturnStatement statement2 = (ReturnStatement)statement;
                                Expression exp = retStmt.getExpression();
                                if (!this.isGetterField(exp, node.getName().getFullyQualifiedName())) {
                                    throw new AbortSearchException();
                                }
                            }
                            return false;
                        }

                        private boolean isGetterField(Expression exp, String name) {
                            IMethodBinding getMethod;
                            SimpleName simpleName;
                            IBinding simpleNameBinding;
                            IVariableBinding varBinding = null;
                            if (exp instanceof FieldAccess) {
                                FieldAccess fieldAccess = (FieldAccess)exp;
                                varBinding = fieldAccess.resolveFieldBinding();
                            } else if (exp instanceof SimpleName && (simpleNameBinding = (simpleName = (SimpleName)exp).resolveBinding()) instanceof IVariableBinding) {
                                varBinding = (IVariableBinding)simpleNameBinding;
                            }
                            return varBinding != null && (getMethod = ConvertToRecordRefactoring.this.fGetterMap.get(varBinding)) != null && getMethod.getName().equals(name);
                        }
                    });
                }
                catch (AbortSearchException e) {
                    RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ConvertToRecordRefactoring_not_simple_case);
                    pm.done();
                    return refactoringStatus;
                }
            }
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    private boolean isBoolean(IVariableBinding field) {
        boolean isBoolean;
        AST ast = this.fASTRoot.getAST();
        boolean bl = isBoolean = ast.resolveWellKnownType("boolean") == field.getType();
        if (!isBoolean) {
            isBoolean = ast.resolveWellKnownType("java.lang.Boolean") == field.getType();
        }
        return isBoolean;
    }

    private IMethodBinding findGetter(ITypeBinding declaringType, IVariableBinding variableBinding) {
        ITypeBinding returnType = variableBinding.getType();
        String getterName = GetterSetterUtil.getGetterName(variableBinding, this.fCu.getJavaProject(), null, this.isBoolean(variableBinding));
        if (declaringType == null) {
            return null;
        }
        IMethodBinding getter = Bindings.findMethodInHierarchy(declaringType, getterName, new ITypeBinding[0]);
        if (getter != null && getter.getReturnType().isAssignmentCompatible(returnType) && Modifier.isStatic((int)getter.getModifiers()) == Modifier.isStatic((int)variableBinding.getModifiers())) {
            return getter;
        }
        return null;
    }

    public static ASTNode getSelectedNode(CompilationUnit cu, int selectionOffset, int selectionLength) {
        SelectionAnalyzer analyzer = new SelectionAnalyzer(Selection.createFromStartLength(selectionOffset, selectionLength), false);
        cu.accept((ASTVisitor)analyzer);
        return analyzer.getFirstSelectedNode();
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        this.fBaseCURewrite = new CompilationUnitRewrite(this.fCu, this.fASTRoot);
        this.fChangeManager = new TextChangeManager();
        return status;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        pm.beginTask(RefactoringCoreMessages.ExtractClassRefactoring_progress_create_change, 10);
        try {
            DynamicValidationRefactoringChange change;
            ICompilationUnit typeCU = this.fCu;
            ArrayList<TextChange> changes = new ArrayList<TextChange>();
            this.createNewRecord();
            this.updateReferences(pm);
            this.fChangeManager.manage(typeCU, (TextChange)this.fBaseCURewrite.createChange(true, pm));
            changes.addAll(Arrays.asList(this.fChangeManager.getAllChanges()));
            HashMap<String, String> arguments = new HashMap<String, String>();
            String project = null;
            IJavaProject javaProject = this.fCu.getJavaProject();
            if (javaProject != null) {
                project = javaProject.getElementName();
            }
            int flags = 524294;
            String description = Messages.format(RefactoringCoreMessages.ConvertToRecordRefactoring_descriptor_description_short, BasicElementLabels.getJavaElementName(this.fTypeDeclaration.getName().getFullyQualifiedName()));
            String header = Messages.format(RefactoringCoreMessages.ConvertToRecordRefactoring_descriptor_description, new String[]{BindingLabelProviderCore.getBindingLabel((IBinding)this.fTypeBinding, 2235681801344L)});
            JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(project, (Object)this, header);
            comment.addSetting(Messages.format(RefactoringCoreMessages.InlineMethodRefactoring_original_pattern, BindingLabelProviderCore.getBindingLabel((IBinding)this.fTypeBinding, 2235681801344L)));
            ConvertToRecordDescriptor descriptor = RefactoringSignatureDescriptorFactory.createConvertToRecordDescriptor(project, description, comment.asString(), arguments, flags);
            arguments.put("input", JavaRefactoringDescriptorUtil.elementToHandle(project, (IJavaElement)this.fCu));
            arguments.put("selection", Integer.toString(this.fSelectionStart) + " " + Integer.toString(this.fSelectionLength));
            DynamicValidationRefactoringChange dynamicValidationRefactoringChange = change = new DynamicValidationRefactoringChange(descriptor, RefactoringCoreMessages.ConvertToRecordRefactoring_name, changes.toArray(new Change[changes.size()]));
            return dynamicValidationRefactoringChange;
        }
        finally {
            pm.done();
        }
    }

    private void createNewRecord() {
        AST ast = this.fBaseCURewrite.getAST();
        ASTRewrite rewrite = this.fBaseCURewrite.getASTRewrite();
        rewrite.setTargetSourceRangeComputer(new TargetSourceRangeComputer(){

            public TargetSourceRangeComputer.SourceRange computeSourceRange(ASTNode nodeWithComment) {
                if (Boolean.TRUE.equals(nodeWithComment.getProperty("untouchComment"))) {
                    return new TargetSourceRangeComputer.SourceRange(nodeWithComment.getStartPosition(), nodeWithComment.getLength());
                }
                return super.computeSourceRange(nodeWithComment);
            }
        });
        RecordDeclaration newRecordDeclaration = null;
        Javadoc javadoc = this.fTypeDeclaration.getJavadoc();
        if (javadoc instanceof Javadoc) {
            Javadoc javadoc2 = javadoc;
            StringBuilder builder = new StringBuilder();
            builder.append(ASTFlattener.asString((ASTNode)javadoc2));
            builder.append("\n");
            List modifiers = this.fTypeDeclaration.modifiers();
            for (IExtendedModifier modifier : modifiers) {
                builder.append(modifier.toString());
                builder.append(" ");
            }
            builder.append("record " + this.fTypeDeclaration.getName().getFullyQualifiedName() + " (");
            List parameters = this.fConstructor.parameters();
            String separator = "";
            for (SingleVariableDeclaration parameter : parameters) {
                builder.append(separator);
                builder.append(ASTFlattener.asString((ASTNode)parameter));
                separator = ", ";
            }
            builder.append(") {}");
            newRecordDeclaration = (RecordDeclaration)rewrite.createStringPlaceholder(builder.toString(), 103);
        } else {
            newRecordDeclaration = ast.newRecordDeclaration();
            newRecordDeclaration.setName((SimpleName)rewrite.createCopyTarget((ASTNode)this.fTypeDeclaration.getName()));
            List modifiers = this.fTypeDeclaration.modifiers();
            List recordModifiers = newRecordDeclaration.modifiers();
            for (IExtendedModifier modifier : modifiers) {
                IExtendedModifier newModifier = (IExtendedModifier)rewrite.createCopyTarget((ASTNode)modifier);
                recordModifiers.add(newModifier);
            }
            List components = newRecordDeclaration.recordComponents();
            List parameters = this.fConstructor.parameters();
            for (SingleVariableDeclaration parameter : parameters) {
                SingleVariableDeclaration newSingleVariableDeclaration = (SingleVariableDeclaration)rewrite.createCopyTarget((ASTNode)parameter);
                components.add(newSingleVariableDeclaration);
            }
        }
        ASTNodes.replaceButKeepComment(rewrite, (ASTNode)this.fTypeDeclaration, (ASTNode)newRecordDeclaration, null);
    }

    private RefactoringStatus updateReferences(IProgressMonitor pm) throws CoreException {
        RefactoringStatus status = new RefactoringStatus();
        pm.beginTask(RefactoringCoreMessages.ConvertToRecordRefactoring_progress_updating_references, 100);
        try {
            pm.worked(10);
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            ArrayList<IMethod> methods = new ArrayList<IMethod>();
            for (Map.Entry<IVariableBinding, IMethodBinding> entry : this.fGetterMap.entrySet()) {
                IMethodBinding methodBinding = entry.getValue();
                IMethod method = (IMethod)methodBinding.getJavaElement();
                if (method == null) continue;
                methods.add(method);
            }
            if (methods.isEmpty()) {
                RefactoringStatus refactoringStatus = status;
                return refactoringStatus;
            }
            SearchPattern pattern = RefactoringSearchEngine.createOrPattern((IJavaElement[])methods.toArray(new IMethod[methods.size()]), 3);
            SearchResultGroup[] results = RefactoringSearchEngine.search(pattern, RefactoringScopeFactory.create(this.fTypeBinding.getJavaElement()), pm, status);
            IProgressMonitor spm = Progress.subMonitor(pm, 90);
            spm.beginTask(RefactoringCoreMessages.ConvertToRecordRefactoring_progress_updating_references, results.length * 10);
            try {
                SearchResultGroup[] searchResultGroupArray = results;
                int n = results.length;
                int n2 = 0;
                while (n2 < n) {
                    SearchResultGroup group = searchResultGroupArray[n2];
                    ICompilationUnit unit = group.getCompilationUnit();
                    CompilationUnitRewrite cuRewrite = unit.equals(this.fBaseCURewrite.getCu()) ? this.fBaseCURewrite : new CompilationUnitRewrite(unit);
                    spm.worked(1);
                    status.merge(this.replaceReferences(group, cuRewrite));
                    if (cuRewrite != this.fBaseCURewrite) {
                        this.fChangeManager.manage(unit, (TextChange)cuRewrite.createChange(true, Progress.subMonitor(spm, 9)));
                    }
                    if (spm.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    ++n2;
                }
            }
            finally {
                spm.done();
            }
        }
        finally {
            pm.done();
        }
        return status;
    }

    private RefactoringStatus replaceReferences(SearchResultGroup group, CompilationUnitRewrite cuRewrite) {
        TextEditGroup editGroup = cuRewrite.createGroupDescription(RefactoringCoreMessages.ConvertToRecordRefactoring_group_replace_getters);
        AST ast = cuRewrite.getAST();
        ASTRewrite rewrite = cuRewrite.getASTRewrite();
        RefactoringStatus status = new RefactoringStatus();
        SearchMatch[] searchMatchArray = group.getSearchResults();
        int n = searchMatchArray.length;
        int n2 = 0;
        while (n2 < n) {
            SearchMatch searchMatch = searchMatchArray[n2];
            ASTNode node = NodeFinder.perform((ASTNode)cuRewrite.getRoot(), (int)searchMatch.getOffset(), (int)searchMatch.getLength());
            if (node instanceof MethodInvocation) {
                MethodInvocation methodInvocation = (MethodInvocation)node;
                SimpleName methodName = methodInvocation.getName();
                String newName = methodName.getFullyQualifiedName();
                for (Map.Entry<IVariableBinding, IMethodBinding> entry : this.fGetterMap.entrySet()) {
                    if (!entry.getValue().getName().equals(methodName.getFullyQualifiedName())) continue;
                    newName = entry.getKey().getName();
                    break;
                }
                SimpleName newMethodName = ast.newSimpleName(newName);
                rewrite.replace((ASTNode)methodName, (ASTNode)newMethodName, editGroup);
            }
            ++n2;
        }
        return status;
    }
}

