/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.github.ui.gist;

import java.util.Iterator;
import java.util.Set;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.mylyn.internal.github.core.gist.GistAttribute;
import org.eclipse.mylyn.internal.github.ui.gist.GistAttachmentPart;
import org.eclipse.mylyn.internal.github.ui.issue.IssueSummaryPart;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorActionPart;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPage;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPart;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorPartDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.services.IServiceLocator;

public class GistTaskEditorPage
extends AbstractTaskEditorPage {
    public GistTaskEditorPage(TaskEditor editor, String connectorKind) {
        super(editor, connectorKind);
        this.setNeedsPrivateSection(true);
        this.setNeedsSubmitButton(true);
    }

    private CommandContributionItem createCommandContributionItem(String commandId) {
        CommandContributionItemParameter parameter = new CommandContributionItemParameter((IServiceLocator)this.getSite(), commandId, commandId, 8);
        return new CommandContributionItem(parameter);
    }

    private void addCloneAction(IToolBarManager manager) {
        if (TasksUiUtil.isOutgoingNewTask((ITask)this.getTask(), (String)"githubGists")) {
            return;
        }
        manager.prependToGroup("open", (IContributionItem)this.createCommandContributionItem("org.eclipse.mylyn.github.ui.command.cloneGist"));
    }

    public void fillToolBar(IToolBarManager toolBarManager) {
        super.fillToolBar(toolBarManager);
        this.addCloneAction(toolBarManager);
    }

    protected Set<TaskEditorPartDescriptor> createPartDescriptors() {
        Set partDescriptors = super.createPartDescriptors();
        Iterator descriptorIt = partDescriptors.iterator();
        while (descriptorIt.hasNext()) {
            TaskEditorPartDescriptor partDescriptor = (TaskEditorPartDescriptor)descriptorIt.next();
            String id = partDescriptor.getId();
            if (!id.equals("org.eclipse.mylyn.tasks.ui.editors.parts.attributes") && !id.equals("org.eclipse.mylyn.tasks.ui.editors.parts.summary") && !id.equals("org.eclipse.mylyn.tasks.ui.editors.parts.attachments") && !id.equals("org.eclipse.mylyn.tasks.ui.editors.parts.actions")) continue;
            descriptorIt.remove();
        }
        if (!this.getModel().getTaskData().isNew()) {
            partDescriptors.add(new TaskEditorPartDescriptor("org.eclipse.mylyn.tasks.ui.editors.parts.summary"){

                public AbstractTaskEditorPart createPart() {
                    return new IssueSummaryPart(GistAttribute.AUTHOR_GRAVATAR.getMetadata().getId(), null);
                }
            }.setPath("header"));
            partDescriptors.add(new TaskEditorPartDescriptor("org.eclipse.mylyn.tasks.ui.editors.parts.attachments"){

                public AbstractTaskEditorPart createPart() {
                    return new GistAttachmentPart();
                }
            }.setPath("attachments"));
        }
        partDescriptors.add(new TaskEditorPartDescriptor("org.eclipse.mylyn.tasks.ui.editors.parts.actions"){

            public AbstractTaskEditorPart createPart() {
                return new TaskEditorActionPart(){

                    protected void addAttachContextButton(Composite buttonComposite, FormToolkit toolkit) {
                    }
                };
            }
        }.setPath("actions"));
        return partDescriptors;
    }
}

