/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.sshd.agent.connector;

import com.sun.jna.LastErrorException;
import com.sun.jna.Native;
import com.sun.jna.platform.unix.LibCAPI;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sshd.common.SshException;
import org.eclipse.jgit.internal.transport.sshd.agent.connector.Sockets;
import org.eclipse.jgit.internal.transport.sshd.agent.connector.Texts;
import org.eclipse.jgit.internal.transport.sshd.agent.connector.UnixSockets;
import org.eclipse.jgit.transport.sshd.agent.AbstractConnector;
import org.eclipse.jgit.transport.sshd.agent.ConnectorFactory;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.jgit.util.SystemReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnixDomainSocketConnector
extends AbstractConnector {
    public static final ConnectorFactory.ConnectorDescriptor DESCRIPTOR = new ConnectorFactory.ConnectorDescriptor(){

        public String getIdentityAgent() {
            return "SSH_AUTH_SOCK";
        }

        public String getDisplayName() {
            return Texts.get().unixDefaultAgent;
        }
    };
    private static final Logger LOG = LoggerFactory.getLogger(UnixDomainSocketConnector.class);
    private static UnixSockets library;
    private static boolean libraryLoaded;
    private final String socketFile;
    private AtomicBoolean connected = new AtomicBoolean();
    private volatile int socketFd = -1;

    static {
        libraryLoaded = false;
    }

    private static synchronized UnixSockets getLibrary() {
        if (!libraryLoaded) {
            libraryLoaded = true;
            try {
                library = (UnixSockets)Native.load((String)"c", UnixSockets.class);
            }
            catch (Exception | NoClassDefFoundError | UnsatisfiedLinkError e) {
                LOG.error(Texts.get().logErrorLoadLibrary, e);
            }
        }
        return library;
    }

    public UnixDomainSocketConnector(String socketFile) {
        String file = socketFile;
        if (StringUtils.isEmptyOrNull((String)file) || "SSH_AUTH_SOCK".equals(file)) {
            file = SystemReader.getInstance().getenv("SSH_AUTH_SOCK");
        }
        this.socketFile = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean connect() throws IOException {
        if (StringUtils.isEmptyOrNull((String)this.socketFile)) {
            return false;
        }
        int fd = this.socketFd;
        UnixDomainSocketConnector unixDomainSocketConnector = this;
        synchronized (unixDomainSocketConnector) {
            UnixSockets sockets;
            block12: {
                block11: {
                    if (!this.connected.get()) break block11;
                    return true;
                }
                sockets = UnixDomainSocketConnector.getLibrary();
                if (sockets != null) break block12;
                return false;
            }
            try {
                fd = sockets.socket(1, 1, 0);
                sockets.fcntl(fd, 2, 1);
                Sockets.SockAddr sockAddr = new Sockets.SockAddr(this.socketFile, StandardCharsets.UTF_8);
                sockets.connect(fd, sockAddr, sockAddr.size());
                this.connected.set(true);
            }
            catch (LastErrorException e) {
                if (fd >= 0) {
                    try {
                        sockets.close(fd);
                    }
                    catch (LastErrorException e1) {
                        e.addSuppressed((Throwable)e1);
                    }
                }
                throw new IOException(MessageFormat.format(Texts.get().msgConnectFailed, this.socketFile), e);
            }
        }
        this.socketFd = fd;
        return this.connected.get();
    }

    public synchronized void close() throws IOException {
        int fd = this.socketFd;
        if (this.connected.getAndSet(false) && fd >= 0) {
            this.socketFd = -1;
            try {
                UnixDomainSocketConnector.getLibrary().close(fd);
            }
            catch (LastErrorException e) {
                throw new IOException(MessageFormat.format(Texts.get().msgCloseFailed, Integer.toString(fd)), e);
            }
        }
    }

    public byte[] rpc(byte command, byte[] message) throws IOException {
        this.prepareMessage(command, message);
        int fd = this.socketFd;
        if (!this.connected.get() || fd < 0) {
            throw new IllegalStateException("Not connected to SSH agent");
        }
        this.writeFully(fd, message);
        byte[] lengthBuf = new byte[4];
        this.readFully(fd, lengthBuf);
        int length = this.toLength(command, lengthBuf);
        byte[] payload = new byte[length];
        this.readFully(fd, payload);
        return payload;
    }

    private void writeFully(int fd, byte[] message) throws IOException {
        int toWrite = message.length;
        try {
            byte[] buf = message;
            while (toWrite > 0) {
                int written = UnixDomainSocketConnector.getLibrary().write(fd, buf, new LibCAPI.size_t((long)buf.length)).intValue();
                if (written < 0) {
                    throw new IOException(MessageFormat.format(Texts.get().msgSendFailed, Integer.toString(message.length), Integer.toString(toWrite)));
                }
                if (written <= 0 || (toWrite -= written) <= 0) continue;
                buf = Arrays.copyOfRange(buf, written, buf.length);
            }
        }
        catch (LastErrorException e) {
            throw new IOException(MessageFormat.format(Texts.get().msgSendFailed, Integer.toString(message.length), Integer.toString(toWrite)), e);
        }
    }

    private void readFully(int fd, byte[] data) throws IOException {
        int n = 0;
        int offset = 0;
        while (offset < data.length && (n = this.read(fd, data, offset, data.length - offset)) > 0) {
            offset += n;
        }
        if (offset < data.length) {
            throw new SshException(MessageFormat.format(Texts.get().msgShortRead, Integer.toString(data.length), Integer.toString(offset), Integer.toString(n)));
        }
    }

    private int read(int fd, byte[] buffer, int offset, int length) throws IOException {
        try {
            LibCAPI.size_t toRead = new LibCAPI.size_t((long)length);
            if (offset == 0) {
                return UnixDomainSocketConnector.getLibrary().read(fd, buffer, toRead).intValue();
            }
            byte[] data = new byte[length];
            int read = UnixDomainSocketConnector.getLibrary().read(fd, data, toRead).intValue();
            if (read > 0) {
                System.arraycopy(data, 0, buffer, offset, read);
            }
            return read;
        }
        catch (LastErrorException e) {
            throw new IOException(MessageFormat.format(Texts.get().msgReadFailed, Integer.toString(length)), e);
        }
    }
}

