/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.launching;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.dltk.launching.EnvironmentVariable;

public final class EnvironmentResolver {
    public static EnvironmentVariable[] resolve(Map<String, String> penv, EnvironmentVariable[] variables) {
        return EnvironmentResolver.resolve(penv, variables, false);
    }

    public static EnvironmentVariable[] resolve(Map<String, String> penv, EnvironmentVariable[] variables, boolean keepUnresolved) {
        if (variables == null) {
            return null;
        }
        HashMap<String, String> env = new HashMap<String, String>();
        HashMap<String, String> selfDep = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : penv.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            env.put(name, value);
        }
        int i = 0;
        while (i < variables.length) {
            String name = variables[i].getName();
            if (env.containsKey(name)) {
                selfDep.put(name, (String)env.get(name));
                env.remove(name);
            }
            ++i;
        }
        HashMap<String, String> resolved = new HashMap<String, String>();
        ArrayList<EnvironmentVariable> result = new ArrayList<EnvironmentVariable>();
        ArrayList<REnvironmentVariable> unresolved = new ArrayList<REnvironmentVariable>();
        int i2 = 0;
        while (i2 < variables.length) {
            REnvironmentVariable var = new REnvironmentVariable(new EnvironmentVariable(variables[i2]));
            EnvironmentResolver.fillDependencies(var, variables);
            unresolved.add(var);
            ++i2;
        }
        int maxCycles = 1000;
        while (unresolved.size() > 0) {
            if (--maxCycles < 0) break;
            Iterator iterator = unresolved.iterator();
            while (iterator.hasNext()) {
                REnvironmentVariable var = (REnvironmentVariable)iterator.next();
                if (EnvironmentResolver.isResolved(var.var)) {
                    result.add(var.var);
                    resolved.put(var.var.getName(), var.var.getValue());
                    iterator.remove();
                    continue;
                }
                if (EnvironmentResolver.isCyclic(var, unresolved)) {
                    if (EnvironmentResolver.isSelfCyclic(var)) {
                        EnvironmentResolver.resolveVariable(var, env);
                        EnvironmentResolver.resolveVariable(var, selfDep);
                        if (EnvironmentResolver.isResolved(var.var)) continue;
                    }
                    if (keepUnresolved) {
                        result.add(var.var);
                    }
                    iterator.remove();
                    continue;
                }
                EnvironmentResolver.resolveVariable(var, resolved);
                EnvironmentResolver.resolveVariable(var, env);
                if (EnvironmentResolver.isResolved(var.var) || !EnvironmentResolver.isUnresolvable(var, unresolved)) continue;
                if (keepUnresolved) {
                    result.add(var.var);
                }
                iterator.remove();
            }
        }
        return result.toArray(new EnvironmentVariable[result.size()]);
    }

    private static boolean isSelfCyclic(REnvironmentVariable var) {
        if (var.dependencies.isEmpty()) {
            return false;
        }
        return var.dependencies.contains(var.var.getName());
    }

    private static void fillDependencies(REnvironmentVariable var, EnvironmentVariable[] variables) {
        int j = 0;
        while (j < variables.length) {
            if (EnvironmentResolver.containVar(var.var, variables[j].getName())) {
                var.dependencies.add(variables[j].getName());
            }
            ++j;
        }
    }

    private static boolean isUnresolvable(REnvironmentVariable var, List<REnvironmentVariable> unresolved) {
        boolean step;
        EnvironmentVariable t = var.var;
        do {
            step = false;
            for (REnvironmentVariable rvar : unresolved) {
                if (rvar.var.getName().equals(t.getName()) || !EnvironmentResolver.containVar(t, rvar.var.getName())) continue;
                t = EnvironmentResolver.resolveVariable(t, rvar.var.getName(), rvar.var.getValue());
                step = true;
            }
        } while (step);
        return !EnvironmentResolver.isResolved(t);
    }

    private static EnvironmentVariable resolveVariable(EnvironmentVariable var, String name, String value) {
        Object result = var.getValue();
        String pattern = "$" + name;
        if (value.indexOf(pattern) != -1) {
            return null;
        }
        int pos = ((String)result).indexOf(pattern);
        while (pos != -1) {
            result = ((String)result).substring(0, pos) + value + ((String)result).substring(pos + pattern.length());
            pos = ((String)result).indexOf(pattern, pos);
        }
        return new EnvironmentVariable(var.getName(), (String)result);
    }

    private static boolean isCyclic(REnvironmentVariable var, List<REnvironmentVariable> unresolved) {
        if (var.dependencies.size() == 0) {
            return false;
        }
        for (REnvironmentVariable env2 : unresolved) {
            if (!var.dependencies.contains(env2.var.getName()) || !env2.dependencies.contains(var.var.getName())) continue;
            return true;
        }
        return false;
    }

    private static void resolveVariable(REnvironmentVariable var, Map<String, String> env) {
        EnvironmentVariable v = var.var;
        for (Map.Entry<String, String> entry : env.entrySet()) {
            String varName = entry.getKey();
            if (!EnvironmentResolver.containVar(v, varName)) continue;
            v = EnvironmentResolver.resolveVariable(v, varName, entry.getValue());
        }
        var.var = v;
    }

    public static boolean isResolved(EnvironmentVariable var) {
        if (var == null) {
            throw new IllegalArgumentException();
        }
        String name = var.getValue();
        return name.indexOf("$") == -1;
    }

    public static boolean containVar(EnvironmentVariable var, String vName) {
        String ref;
        if (var == null) {
            throw new IllegalArgumentException();
        }
        String value = var.getValue();
        int pos = value.indexOf(ref = "$" + vName);
        return pos != -1 && (pos + ref.length() >= value.length() || !Character.isLetterOrDigit(value.charAt(pos + ref.length())));
    }

    public static EnvironmentVariable find(EnvironmentVariable[] vars, String name) {
        if (vars != null && name != null) {
            EnvironmentVariable[] environmentVariableArray = vars;
            int n = vars.length;
            int n2 = 0;
            while (n2 < n) {
                EnvironmentVariable var = environmentVariableArray[n2];
                if (name.equals(var.getName())) {
                    return var;
                }
                ++n2;
            }
        }
        return null;
    }

    private static class REnvironmentVariable {
        EnvironmentVariable var;
        final Set<String> dependencies = new HashSet<String>();

        public REnvironmentVariable(EnvironmentVariable var) {
            this.var = var;
        }
    }
}

