/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.server.core.builtin;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.server.core.builtin.DefaultPHPServerConfiguration;
import org.eclipse.php.internal.server.core.builtin.IPHPServer;
import org.eclipse.php.internal.server.core.builtin.IPHPServerWorkingCopy;
import org.eclipse.php.internal.server.core.builtin.Messages;
import org.eclipse.php.internal.server.core.builtin.PHPRuntime;
import org.eclipse.php.internal.server.core.builtin.PHPServerConfiguration;
import org.eclipse.php.internal.server.core.builtin.PHPServerHelper;
import org.eclipse.php.internal.server.core.builtin.Trace;
import org.eclipse.php.internal.server.core.manager.ServersManager;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerPort;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.model.ServerDelegate;
import org.osgi.framework.Version;

public class PHPServer
extends ServerDelegate
implements IPHPServer,
IPHPServerWorkingCopy {
    private static final IModule[] EMPTY_LIST = new IModule[0];
    public static final String TYPE_ID = "org.eclipse.php.server.builtin";
    public static final String PROPERTY_DEBUG = "debug";
    private static final String DEPLOY_DIR = "htdocs";
    protected transient PHPServerConfiguration configuration;
    private int currentVersion;
    private int loadedVersion;
    private Object versionLock = new Object();

    public IStatus canModifyModules(IModule[] add, IModule[] remove) {
        if (add == null || add.length == 0) {
            return Status.OK_STATUS;
        }
        PHPRuntime phpRuntime = this.getPHPRuntime();
        Version runtimeVersion = null;
        if (phpRuntime != null) {
            runtimeVersion = Version.parseVersion((String)phpRuntime.getExecutableInstall().getVersion());
        }
        IModule[] iModuleArray = add;
        int n = add.length;
        int n2 = 0;
        while (n2 < n) {
            IModule element;
            IModule module = element = iModuleArray[n2];
            Version moduleVersion = Version.parseVersion((String)module.getModuleType().getVersion());
            if (runtimeVersion != null && runtimeVersion.compareTo(moduleVersion) < 0) {
                String message = String.format(Messages.PHPServer_incompatible_version, module.getName(), moduleVersion, runtimeVersion);
                return new Status(4, "org.eclipse.php.server.core", 0, message, null);
            }
            if (!"php.web".equals(module.getModuleType().getId())) {
                return new Status(4, "org.eclipse.php.server.core", 0, Messages.errorWebModulesOnly, null);
            }
            ++n2;
        }
        return Status.OK_STATUS;
    }

    public IModule[] getChildModules(IModule[] module) {
        return EMPTY_LIST;
    }

    public IModule[] getRootModules(IModule module) throws CoreException {
        if ("php.web".equals(module.getModuleType().getId())) {
            IStatus status = this.canModifyModules(new IModule[]{module}, null);
            if (status == null || !status.isOK()) {
                throw new CoreException(status);
            }
            return new IModule[]{module};
        }
        return EMPTY_LIST;
    }

    public void modifyModules(IModule[] add, IModule[] remove, IProgressMonitor monitor) throws CoreException {
        IStatus status = this.canModifyModules(add, remove);
        if (status == null || !status.isOK()) {
            throw new CoreException(status);
        }
    }

    public ServerPort[] getServerPorts() {
        if (this.getServer().getServerConfiguration() == null) {
            return new ServerPort[0];
        }
        try {
            List<ServerPort> list = this.getPHPServerConfiguration().getServerPorts();
            ServerPort[] sp = new ServerPort[list.size()];
            list.toArray(sp);
            return sp;
        }
        catch (Exception e) {
            return new ServerPort[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importRuntimeConfiguration(IRuntime runtime, IProgressMonitor monitor) throws CoreException {
        Object object = this.versionLock;
        synchronized (object) {
            this.configuration = null;
            this.currentVersion = 0;
            this.loadedVersion = 0;
        }
        if (runtime == null) {
            return;
        }
        IPath path = runtime.getLocation();
        IFolder folder = this.getServer().getServerConfiguration();
        DefaultPHPServerConfiguration tcConfig = new DefaultPHPServerConfiguration(folder);
        tcConfig.importFromPath(path, this.getPHPRuntime().getExecutableInstall(), monitor);
        Object ce = this.versionLock;
        synchronized (ce) {
            if (this.configuration == null) {
                this.configuration = tcConfig;
            }
        }
        String serverName = this.getServer().getName();
        Server server = ServersManager.getServer((String)serverName);
        if (server == null) {
            try {
                server = new Server(serverName, this.getServer().getHost(), this.getRootUrl().toString(), this.getDocumentRootDirectory());
                ServersManager.addServer((Server)server);
                ServersManager.save();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    public IPath getRuntimeBaseDirectory() {
        return PHPServerHelper.getStandardBaseDirectory(this);
    }

    public PHPRuntime getPHPRuntime() {
        if (this.getServer().getRuntime() == null) {
            return null;
        }
        return (PHPRuntime)this.getServer().getRuntime().loadAdapter(PHPRuntime.class, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PHPServerConfiguration getPHPServerConfiguration() throws CoreException {
        PHPServerConfiguration tcConfig;
        int current;
        Object object = this.versionLock;
        synchronized (object) {
            current = this.currentVersion;
            tcConfig = this.configuration;
        }
        if (tcConfig == null || this.loadedVersion != current) {
            IFolder folder = this.getServer().getServerConfiguration();
            if (folder == null || !folder.exists()) {
                String path = null;
                if (folder != null) {
                    path = folder.getFullPath().toOSString();
                    IProject project = folder.getProject();
                    if (project != null && project.exists() && !project.isOpen()) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.php.server.core", 0, NLS.bind((String)Messages.errorConfigurationProjectClosed, (Object)path, (Object)project.getName()), null));
                    }
                }
                throw new CoreException((IStatus)new Status(4, "org.eclipse.php.server.core", 0, NLS.bind((String)Messages.errorNoConfiguration, (Object)path), null));
            }
            if (tcConfig == null) {
                tcConfig = new DefaultPHPServerConfiguration(folder);
            }
            tcConfig.load(folder, null);
            Object path = this.versionLock;
            synchronized (path) {
                if (this.configuration == null || this.loadedVersion < current) {
                    this.configuration = tcConfig;
                    this.loadedVersion = current;
                }
            }
        }
        return tcConfig;
    }

    public void saveConfiguration(IProgressMonitor monitor) throws CoreException {
        PHPServerConfiguration tcConfig = this.configuration;
        if (tcConfig == null) {
            return;
        }
        tcConfig.save(this.getServer().getServerConfiguration(), monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configurationChanged() {
        Object object = this.versionLock;
        synchronized (object) {
            ++this.currentVersion;
        }
    }

    public URL getModuleRootURL(IModule module) {
        block8: {
            block7: {
                if (module != null) break block7;
                return null;
            }
            PHPServerConfiguration config = this.getPHPServerConfiguration();
            if (config != null) break block8;
            return null;
        }
        try {
            URL url = this.getRootUrl();
            if (url != null) {
                Object path = url.toString();
                if (!((String)path).endsWith("/")) {
                    path = (String)path + "/";
                }
                if (!((String)(path = (String)path + module.getName())).endsWith("/")) {
                    path = (String)path + "/";
                }
                return new URL((String)path);
            }
        }
        catch (Exception e) {
            Trace.trace((byte)2, "Could not get root URL", e);
        }
        return null;
    }

    @Override
    public void setDocumentRootDirectory(String instanceDir) {
        this.setAttribute("documentRootDir", instanceDir);
    }

    @Override
    public String getDocumentRootDirectory() {
        return this.getAttribute("documentRootDir", null);
    }

    public void setDefaults(IProgressMonitor monitor) {
        this.setAttribute("auto-publish-setting", 2);
        this.setAttribute("auto-publish-time", 1);
    }

    public IPath getServerDeployDirectory() {
        Path deployPath = new Path(DEPLOY_DIR);
        if (!deployPath.isAbsolute()) {
            IPath base = this.getRuntimeBaseDirectory();
            deployPath = base.append((IPath)deployPath);
        }
        return deployPath;
    }

    @Override
    public URL getRootUrl() {
        PHPServerConfiguration config;
        block4: {
            try {
                config = this.getPHPServerConfiguration();
                if (config != null) break block4;
                return null;
            }
            catch (Exception e) {
                Trace.trace((byte)2, "Could not get root URL", e);
                return null;
            }
        }
        String url = "http://" + this.getServer().getHost();
        int port = config.getMainPort().getPort();
        port = ServerUtil.getMonitoredPort((IServer)this.getServer(), (int)port, (String)"web");
        if (port != 80) {
            url = url + ":" + port;
        }
        return new URL(url);
    }

    public void registerPHPServer() {
        Server phpServer = new Server(this.getServer().getId());
        this.setupServer(phpServer);
        ServersManager.addServer((Server)phpServer);
        ServersManager.save();
    }

    public void updatePHPServer() {
        Server phpServer = ServersManager.findServer((String)this.getServer().getId());
        if (phpServer == null) {
            this.registerPHPServer();
        } else {
            this.setupServer(phpServer);
            ServersManager.save();
        }
    }

    public void removePHPServer() {
        Server phpServer = ServersManager.findServer((String)this.getServer().getId());
        if (phpServer != null) {
            ServersManager.getInstance();
            ServersManager.removeServer((String)phpServer.getUniqueId());
        }
    }

    /*
     * Unable to fully structure code
     */
    private void setupServer(Server phpServer) {
        server = this.getServer();
        phpServer.setName(server.getName());
        phpServer.setAttribute("serverType", "org.eclipse.php.server.builtin");
        sb = new StringBuilder("http://");
        sb.append(server.getHost());
        if (server.getServerPorts(null)[0].getPort() != 80) {
            sb.append(':').append(phpServer.getPort());
        }
        try {
            phpServer.setBaseURL(sb.toString());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        phpServer.setDebuggerId(server.getAttribute("debug", "org.eclipse.php.debug.core.noneDebugger"));
        documentRoot = null;
        var8_6 = server.getModules();
        var7_7 = var8_6.length;
        var6_8 = 0;
        while (var6_8 < var7_7) {
            block6: {
                module = var8_6[var6_8];
                loc = module.getProject().getLocation();
                if (documentRoot != null) ** GOTO lbl27
                documentRoot = loc;
                break block6;
lbl-1000:
                // 1 sources

                {
                    documentRoot = documentRoot.removeLastSegments(1);
lbl27:
                    // 2 sources

                    ** while (!documentRoot.isPrefixOf((IPath)loc))
                }
            }
            ++var6_8;
        }
        if (documentRoot == null) {
            documentRoot = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        }
        phpServer.setDocumentRoot(documentRoot.toOSString());
    }
}

