/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.autoEdit;

import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.format.IIndentationStrategyExtension1;

public class IndentationExtensionRegistry {
    private static IndentationExtensionRegistry instance;
    private SortedMap<Integer, IIndentationStrategyExtension1> extensions = new TreeMap<Integer, IIndentationStrategyExtension1>();
    private static final String EXTENSION_ID = "org.eclipse.php.core.indentationStrategy";

    private IndentationExtensionRegistry() {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_ID);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                IIndentationStrategyExtension1 extension = (IIndentationStrategyExtension1)element.createExecutableExtension("class");
                Integer priority = Integer.parseInt(element.getAttribute("priority"));
                this.extensions.put(priority, extension);
            }
            catch (CoreException e) {
                PHPCorePlugin.log((Throwable)e);
            }
            ++n2;
        }
    }

    public static IndentationExtensionRegistry getInstance() {
        if (instance == null) {
            instance = new IndentationExtensionRegistry();
        }
        return instance;
    }

    public SortedMap<Integer, IIndentationStrategyExtension1> getExtensions() {
        return this.extensions;
    }

    public boolean hasExtensions() {
        return this.extensions.size() > 0;
    }
}

