/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.input;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.runtime.IPath;
import org.eclipse.php.internal.core.ast.util.Util;
import org.eclipse.ui.editors.text.ILocationProviderExtension;
import org.eclipse.ui.internal.editors.text.NonExistingFileEditorInput;

public class NonExistingPHPFileEditorInput
extends NonExistingFileEditorInput
implements ILocationProviderExtension {
    private static final Map<IPath, NonExistingPHPFileEditorInput> registry = Collections.synchronizedMap(new HashMap());

    public NonExistingPHPFileEditorInput(IFileStore fileStore, String namePrefix) {
        super(fileStore, namePrefix);
        registry.put(this.getPath((Object)this), this);
    }

    public IPath getPath(Object element) {
        IPath path = super.getPath(element);
        return path.addFileExtension(Util.defaultPHPExtension());
    }

    public String getName() {
        String result = super.getName();
        return result + "." + Util.defaultPHPExtension();
    }

    public URI getURI(Object element) {
        IPath path = this.getPath(element);
        if (path != null) {
            return URIUtil.toURI((IPath)path);
        }
        return null;
    }

    public static NonExistingPHPFileEditorInput findEditorInput(IPath path) {
        return registry.get(path);
    }

    public static void dispose(IPath path) {
        registry.remove(path);
    }
}

