/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.views.latency.dialogs;

import java.util.Vector;
import org.eclipse.linuxtools.lttng.core.latency.analyzer.EventMatcher;
import org.eclipse.linuxtools.lttng.core.util.EventsPair;
import org.eclipse.linuxtools.lttng.ui.views.latency.Messages;
import org.eclipse.linuxtools.lttng.ui.views.latency.dialogs.AbstractDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class AddDialog
extends AbstractDialog {
    protected Table fStartTable;
    protected Table fEndTable;
    protected Table fListTable;
    protected TableColumn[] fStartColumns;
    protected TableColumn[] fEndColumns;
    protected TableColumn[] fListColumns;
    static final String[] START_COLUMN_NAMES = new String[]{"", Messages.LatencyView_Dialogs_AddEvents_Columns_Start};
    static final String[] END_COLUMN_NAMES = new String[]{"", Messages.LatencyView_Dialogs_AddEvents_Columns_End};
    static final String[] LIST_COLUMN_NAMES = new String[]{"#", Messages.LatencyView_Dialogs_AddEvents_Columns_List_Trigger, Messages.LatencyView_Dialogs_AddEvents_Columns_List_End};
    static final int[] COLUMN_WIDTHS = new int[]{25, 250, 250};
    protected Vector<String> fEventTypes = EventMatcher.getInstance().getTypeList();
    protected Vector<String> fEventStartTypes;
    protected Vector<String> fEventEndTypes;
    protected String fStartType;
    protected String fEndType;

    public AddDialog(Shell parentShell, String title, String message) {
        super(parentShell, title, message);
        EventsPair pair = this.getMatchPairs();
        this.fEventStartTypes = (Vector)pair.getFirst();
        this.fEventEndTypes = (Vector)pair.getSecond();
    }

    protected void createStartColumns() {
        this.fStartColumns = new TableColumn[START_COLUMN_NAMES.length];
        int i = 0;
        while (i < START_COLUMN_NAMES.length) {
            this.fStartColumns[i] = new TableColumn(this.fStartTable, 16384);
            this.fStartColumns[i].setText(START_COLUMN_NAMES[i]);
            this.fStartColumns[i].setWidth(COLUMN_WIDTHS[i]);
            ++i;
        }
    }

    protected void createEndColumns() {
        this.fEndColumns = new TableColumn[END_COLUMN_NAMES.length];
        int i = 0;
        while (i < END_COLUMN_NAMES.length) {
            this.fEndColumns[i] = new TableColumn(this.fEndTable, 16384);
            this.fEndColumns[i].setText(END_COLUMN_NAMES[i]);
            this.fEndColumns[i].setWidth(COLUMN_WIDTHS[i]);
            ++i;
        }
    }

    protected void createListColumns() {
        this.fListColumns = new TableColumn[LIST_COLUMN_NAMES.length];
        int i = 0;
        while (i < LIST_COLUMN_NAMES.length) {
            this.fListColumns[i] = new TableColumn(this.fListTable, 16384);
            this.fListColumns[i].setText(LIST_COLUMN_NAMES[i]);
            this.fListColumns[i].setWidth(COLUMN_WIDTHS[i]);
            ++i;
        }
    }

    protected void createStartColumn(Composite parent) {
        GridData layoutData = new GridData(4, 4, true, true);
        this.fStartTable = new Table(parent, 68132);
        this.fStartTable.setLayoutData((Object)layoutData);
        this.fStartTable.setHeaderVisible(true);
        this.fStartTable.setLinesVisible(true);
        this.createStartColumns();
        int i = 0;
        while (i < this.fEventTypes.size()) {
            TableItem item = new TableItem(this.fStartTable, 131072);
            String[] columns = new String[]{this.fEventTypes.get(i), this.fEventTypes.get(i)};
            item.setText(columns);
            ++i;
        }
        this.fStartTable.setItemCount(this.fEventTypes.size());
        this.fStartTable.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 32) {
                    TableItem[] items;
                    TableItem[] tableItemArray = items = AddDialog.this.fStartTable.getItems();
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem item = tableItemArray[n2];
                        if (item != event.item) {
                            item.setChecked(false);
                        }
                        ++n2;
                    }
                }
            }
        });
    }

    protected void createEndColumn(Composite parent) {
        GridData layoutData = new GridData(4, 4, true, true);
        this.fEndTable = new Table(parent, 68132);
        this.fEndTable.setLayoutData((Object)layoutData);
        this.fEndTable.setHeaderVisible(true);
        this.fEndTable.setLinesVisible(true);
        this.createEndColumns();
        int i = 0;
        while (i < this.fEventTypes.size()) {
            TableItem item = new TableItem(this.fEndTable, 131072);
            String[] columns = new String[]{this.fEventTypes.get(i), this.fEventTypes.get(i)};
            item.setText(columns);
            ++i;
        }
        this.fEndTable.setItemCount(this.fEventTypes.size());
        this.fEndTable.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 32) {
                    TableItem[] items;
                    TableItem[] tableItemArray = items = AddDialog.this.fEndTable.getItems();
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem item = tableItemArray[n2];
                        if (item != event.item) {
                            item.setChecked(false);
                        }
                        ++n2;
                    }
                }
            }
        });
    }

    protected void createListColumn(Composite parent) {
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.horizontalSpan = 2;
        this.fListTable = new Table(parent, 68100);
        this.fListTable.setLayoutData((Object)layoutData);
        this.fListTable.setHeaderVisible(true);
        this.fListTable.setLinesVisible(true);
        this.createListColumns();
        int i = 0;
        while (i < this.fEventStartTypes.size()) {
            TableItem item = new TableItem(this.fListTable, 131072);
            String max = String.valueOf(this.fEventStartTypes.size());
            String number = this.formatListNumber(i + 1, max.length());
            String[] columns = new String[]{number, this.fEventStartTypes.get(i), this.fEventEndTypes.get(i)};
            item.setText(columns);
            ++i;
        }
        this.fListTable.setItemCount(103);
        this.fListTable.remove(this.fEventTypes.size(), 102);
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        GridLayout layout = new GridLayout(2, true);
        parent.setLayout((Layout)layout);
        this.createStartColumn(parent);
        this.createEndColumn(parent);
        this.createListColumn(parent);
        return parent;
    }

    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 131072;
        parent.setLayoutData((Object)gridData);
        Button addButton = this.createButton(parent, 53445, Messages.LatencyView_Dialogs_AddEvents_Buttons_Add, false);
        addButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (AddDialog.this.isValidInput()) {
                    EventMatcher.getInstance().addMatch(AddDialog.this.fStartType, AddDialog.this.fEndType);
                    AddDialog.this.fEventStartTypes.add(AddDialog.this.fStartType);
                    AddDialog.this.fEventEndTypes.add(AddDialog.this.fEndType);
                    AddDialog.this.saveMatchPairs(AddDialog.this.fEventStartTypes, AddDialog.this.fEventEndTypes);
                    EventsPair pairs = EventMatcher.getInstance().getEvents();
                    AddDialog.this.fEventStartTypes = (Vector)pairs.getFirst();
                    AddDialog.this.fEventEndTypes = (Vector)pairs.getSecond();
                    AddDialog.this.fListTable.removeAll();
                    int i = 0;
                    while (i < AddDialog.this.fEventStartTypes.size()) {
                        TableItem item = new TableItem(AddDialog.this.fListTable, 131072);
                        String max = String.valueOf(AddDialog.this.fEventStartTypes.size());
                        String number = AddDialog.this.formatListNumber(i + 1, max.length());
                        String[] columns = new String[]{number, AddDialog.this.fEventStartTypes.get(i), AddDialog.this.fEventEndTypes.get(i)};
                        item.setText(columns);
                        ++i;
                    }
                    AddDialog.this.saveMatchPairs(AddDialog.this.fEventStartTypes, AddDialog.this.fEventEndTypes);
                }
                AddDialog.this.fRedrawGraphs = true;
            }
        });
        Button closeButton = this.createButton(parent, 1, Messages.LatencyView_Dialogs_AddEvents_Buttons_Close, false);
        closeButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                AddDialog.this.setReturnCode(1);
                if (AddDialog.this.fRedrawGraphs) {
                    AddDialog.this.redrawGraphs();
                }
                AddDialog.this.close();
            }
        });
    }

    protected boolean isValidInput() {
        this.setErrorMessage(null);
        boolean valid = true;
        TableItem[] items = this.fStartTable.getItems();
        this.fStartType = null;
        boolean startHasSelectedItem = false;
        int i = 0;
        while (i < items.length && !startHasSelectedItem) {
            if (items[i].getChecked()) {
                this.fStartType = items[i].getText();
                startHasSelectedItem = true;
            }
            ++i;
        }
        items = this.fEndTable.getItems();
        this.fEndType = null;
        boolean endHasSelectedItem = false;
        int i2 = 0;
        while (i2 < items.length && !endHasSelectedItem) {
            if (items[i2].getChecked()) {
                this.fEndType = items[i2].getText();
                endHasSelectedItem = true;
            }
            ++i2;
        }
        if (!startHasSelectedItem && !endHasSelectedItem) {
            this.setErrorMessage(Messages.LatencyView_Dialogs_AddEvents_Errors_NoSelection);
            valid = false;
        } else if (!startHasSelectedItem) {
            this.setErrorMessage(Messages.LatencyView_Dialogs_AddEvents_Errors_StartNotSelected);
            valid = false;
        } else if (!endHasSelectedItem) {
            this.setErrorMessage(Messages.LatencyView_Dialogs_AddEvents_Errors_EndNotSelected);
            valid = false;
        }
        if (startHasSelectedItem && endHasSelectedItem && this.fStartType.equalsIgnoreCase(this.fEndType)) {
            this.setErrorMessage(Messages.LatencyView_Dialogs_AddEvents_Errors_SameSelected);
            valid = false;
        }
        if (startHasSelectedItem && endHasSelectedItem) {
            EventsPair pairs = this.getMatchPairs();
            Vector startEvents = (Vector)pairs.getFirst();
            Vector endEvents = (Vector)pairs.getSecond();
            boolean startAlreadyUsed = false;
            boolean endAlreadyUsed = false;
            boolean startAsEndAlreadyUsed = false;
            boolean endAsStartAlreadyUsed = false;
            if (startEvents.contains(this.fStartType)) {
                startAlreadyUsed = true;
            }
            if (endEvents.contains(this.fEndType)) {
                endAlreadyUsed = true;
            }
            if (startEvents.contains(this.fEndType)) {
                endAsStartAlreadyUsed = true;
            }
            if (endEvents.contains(this.fStartType)) {
                startAsEndAlreadyUsed = true;
            }
            if (startAlreadyUsed && endAlreadyUsed) {
                this.setErrorMessage(Messages.LatencyView_Dialogs_AddEvents_Errors_AlreadyMatched);
                valid = false;
            } else if (startAlreadyUsed) {
                this.setErrorMessage(Messages.LatencyView_Dialogs_AddEvents_Errors_StartAlreadyMatched);
                valid = false;
            } else if (endAlreadyUsed) {
                this.setErrorMessage(Messages.LatencyView_Dialogs_AddEvents_Errors_EndAlreadyMatched);
                valid = false;
            }
            if (startAsEndAlreadyUsed) {
                this.setErrorMessage(Messages.LatencyView_Dialogs_AddEvents_Errors_StartAsEnd);
                valid = false;
            }
            if (endAsStartAlreadyUsed) {
                this.setErrorMessage(Messages.LatencyView_Dialogs_AddEvents_Errors_EndAsStart);
                valid = false;
            }
        }
        return valid;
    }
}

