/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.views.latency.dialogs;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.linuxtools.lttng.core.latency.analyzer.EventMatcher;
import org.eclipse.linuxtools.lttng.ui.views.latency.Messages;
import org.eclipse.linuxtools.lttng.ui.views.latency.dialogs.ListDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;

public class DeleteDialog
extends ListDialog {
    public DeleteDialog(Shell parentShell, String title, String message) {
        super(parentShell, title, message);
        this.fStyle = 68098;
    }

    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 131072;
        parent.setLayoutData((Object)gridData);
        Button deleteButton = this.createButton(parent, 53446, Messages.LatencyView_Dialogs_DeleteEvents_Buttons_Delete, false);
        deleteButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TableItem selectedItem = DeleteDialog.this.fTable.getSelection()[0];
                if (selectedItem == null) {
                    return;
                }
                int[] selectedIndices = DeleteDialog.this.fTable.getSelectionIndices();
                StringBuffer deletePairs = new StringBuffer("");
                int i = 0;
                while (i < selectedIndices.length) {
                    int index = selectedIndices[i];
                    deletePairs.append("\t* ").append((String)DeleteDialog.this.fEventStartTypes.get(index)).append(" / ").append((String)DeleteDialog.this.fEventEndTypes.get(index));
                    if (i < selectedIndices.length - 1) {
                        deletePairs.append("\n");
                    }
                    ++i;
                }
                boolean confirmDeletion = MessageDialog.openQuestion((Shell)DeleteDialog.this.getShell(), (String)Messages.LatencyView_Dialogs_DeleteEvents_Confirm_Title, (String)(String.valueOf(Messages.LatencyView_Dialogs_DeleteEvents_Confirm_Message) + "\n\n" + deletePairs.toString()));
                if (confirmDeletion) {
                    int i2 = selectedIndices.length - 1;
                    while (i2 >= 0) {
                        int selectedIndex = selectedIndices[i2];
                        EventMatcher.getInstance().removeMatch((String)DeleteDialog.this.fEventStartTypes.get(selectedIndex), (String)DeleteDialog.this.fEventEndTypes.get(selectedIndex));
                        DeleteDialog.this.fTable.remove(selectedIndex);
                        DeleteDialog.this.fEventStartTypes.remove(selectedIndex);
                        DeleteDialog.this.fEventEndTypes.remove(selectedIndex);
                        --i2;
                    }
                    DeleteDialog.this.saveMatchPairs(DeleteDialog.this.fEventStartTypes, DeleteDialog.this.fEventEndTypes);
                    DeleteDialog.this.fTable.setItemCount(DeleteDialog.this.fEventStartTypes.size());
                    TableItem[] newItems = DeleteDialog.this.fTable.getItems();
                    DeleteDialog.this.fTable.removeAll();
                    int i3 = 0;
                    while (i3 < newItems.length) {
                        TableItem item = new TableItem(DeleteDialog.this.fTable, 131072);
                        String max = String.valueOf(DeleteDialog.this.fEventStartTypes.size());
                        String number = DeleteDialog.this.formatListNumber(i3 + 1, max.length());
                        String[] columns = new String[]{number, (String)DeleteDialog.this.fEventStartTypes.get(i3), (String)DeleteDialog.this.fEventEndTypes.get(i3)};
                        item.setText(columns);
                        ++i3;
                    }
                    DeleteDialog.this.fRedrawGraphs = true;
                }
            }
        });
        Button closeButton = this.createButton(parent, 1, Messages.LatencyView_Dialogs_AddEvents_Buttons_Close, false);
        closeButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DeleteDialog.this.saveMatchPairs(DeleteDialog.this.fEventStartTypes, DeleteDialog.this.fEventEndTypes);
                DeleteDialog.this.setReturnCode(1);
                if (DeleteDialog.this.fRedrawGraphs) {
                    DeleteDialog.this.redrawGraphs();
                }
                DeleteDialog.this.close();
            }
        });
    }
}

