/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.dashboardextension.dialogs;

import java.text.MessageFormat;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.linuxtools.systemtap.ui.dashboardextension.internal.Localization;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.datasets.IDataSet;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.filters.IDataSetFilter;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.structures.GraphData;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.wizards.filter.AvailableFilterTypes;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.wizards.filter.SelectFilterWizard;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.wizards.graph.GraphFactory;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.wizards.graph.SelectGraphWizard;
import org.eclipse.linuxtools.systemtap.ui.structures.TreeNode;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class ExportScriptDialog
extends Dialog {
    private IDataSet data;
    private Tree treeGraphs;
    private Text txtDisplay;
    private Text txtCategory;
    private Text txtDescription;
    private Button btnAdd;
    private Button btnRemove;
    private Button btnAddFilter;
    private String display;
    private String category;
    private String description;
    private GraphData[] graphData;
    private TreeNode filters;
    private boolean canceled;
    private TreeItem selectedTreeItem;

    public ExportScriptDialog(Shell parentShell, IDataSet data) {
        super(parentShell);
        this.data = data;
        this.canceled = false;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Localization.getString("ExportScriptDialog.ExportScript"));
        shell.setSize(330, 375);
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = new Composite(parent, 0);
        Label lblDisplay = new Label(comp, 0);
        lblDisplay.setText(Localization.getString("ExportScriptDialog.Display"));
        lblDisplay.setBounds(10, 12, 100, 25);
        Label lblCategory = new Label(comp, 0);
        lblCategory.setText(Localization.getString("ExportScriptDialog.Category"));
        lblCategory.setBounds(10, 42, 100, 25);
        Label lblDescription = new Label(comp, 0);
        lblDescription.setText(Localization.getString("ExportScriptDialog.Description"));
        lblDescription.setBounds(10, 72, 100, 25);
        Label lblGraphs = new Label(comp, 0);
        lblGraphs.setText(Localization.getString("ExportScriptDialog.Graphs"));
        lblGraphs.setBounds(10, 150, 100, 25);
        this.txtDisplay = new Text(comp, 2048);
        this.txtDisplay.setBounds(120, 10, 200, 25);
        this.txtCategory = new Text(comp, 2048);
        this.txtCategory.setBounds(120, 40, 200, 25);
        this.txtDescription = new Text(comp, 2114);
        this.txtDescription.setBounds(120, 70, 200, 75);
        this.treeGraphs = new Tree(comp, 2052);
        this.treeGraphs.setBounds(10, 175, 200, 125);
        this.btnAdd = new Button(comp, 8);
        this.btnAdd.setText(Localization.getString("ExportScriptDialog.Add"));
        this.btnAdd.setBounds(220, 175, 100, 26);
        this.btnAddFilter = new Button(comp, 8);
        this.btnAddFilter.setText(Localization.getString("ExportScriptDialog.AddFilter"));
        this.btnAddFilter.setBounds(220, 205, 100, 26);
        this.btnAddFilter.setEnabled(false);
        this.btnRemove = new Button(comp, 8);
        this.btnRemove.setText(Localization.getString("ExportScriptDialog.Remove"));
        this.btnRemove.setBounds(220, 265, 100, 26);
        this.btnRemove.setEnabled(false);
        this.treeGraphs.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ExportScriptDialog.this.selectedTreeItem = (TreeItem)e.item;
                if (ExportScriptDialog.this.selectedTreeItem.getParentItem() == null) {
                    ExportScriptDialog.this.btnAddFilter.setEnabled(true);
                } else {
                    ExportScriptDialog.this.btnAddFilter.setEnabled(false);
                }
                ExportScriptDialog.this.btnRemove.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.btnAdd.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SelectGraphWizard wizard = new SelectGraphWizard(ExportScriptDialog.this.data);
                IWorkbench workbench = PlatformUI.getWorkbench();
                wizard.init(workbench, null);
                WizardDialog dialog = new WizardDialog(workbench.getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
                dialog.create();
                dialog.open();
                GraphData gd = wizard.getGraphData();
                if (gd != null) {
                    TreeItem item = new TreeItem(ExportScriptDialog.this.treeGraphs, 0);
                    item.setText(String.valueOf(GraphFactory.getGraphName((String)gd.graphID)) + ":" + gd.title);
                    item.setData((Object)gd);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.btnAddFilter.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SelectFilterWizard wizard = new SelectFilterWizard(ExportScriptDialog.this.data.getTitles());
                IWorkbench workbench = PlatformUI.getWorkbench();
                wizard.init(workbench, null);
                WizardDialog dialog = new WizardDialog(workbench.getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
                dialog.create();
                dialog.open();
                IDataSetFilter f = wizard.getFilter();
                if (f != null) {
                    TreeItem item = new TreeItem(ExportScriptDialog.this.treeGraphs.getSelection()[0], 0);
                    item.setText(AvailableFilterTypes.getFilterName((String)f.getID()));
                    item.setData((Object)f);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.btnRemove.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ExportScriptDialog.this.selectedTreeItem.dispose();
                ExportScriptDialog.this.btnRemove.setEnabled(false);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return comp;
    }

    protected void buttonPressed(int buttonID) {
        if (buttonID == 0) {
            if (this.txtDisplay.getText().length() <= 0 || this.txtCategory.getText().length() <= 0 || this.txtDescription.getText().length() <= 0 || this.treeGraphs.getItemCount() <= 0) {
                String msg = MessageFormat.format(Localization.getString("ExportScriptDialog.FillFields"), null);
                MessageDialog.openWarning((Shell)this.getShell(), (String)Localization.getString("ExportScriptDialog.Error"), (String)msg);
                return;
            }
            this.display = this.txtDisplay.getText();
            this.category = this.txtCategory.getText();
            this.description = this.txtDescription.getText();
            this.buildGraphData();
            this.buildFilterData();
        } else {
            this.canceled = true;
        }
        super.buttonPressed(buttonID);
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public String getCategory() {
        return this.category;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDisplay() {
        return this.display;
    }

    public GraphData[] getGraphs() {
        return this.graphData;
    }

    public TreeNode getGraphFilters() {
        return this.filters;
    }

    public void dispose() {
        if (this.txtDisplay != null) {
            this.txtDisplay.dispose();
        }
        if (this.txtCategory != null) {
            this.txtCategory.dispose();
        }
        if (this.txtDescription != null) {
            this.txtDescription.dispose();
        }
        if (this.treeGraphs != null) {
            this.treeGraphs.dispose();
        }
        if (this.btnAdd != null) {
            this.btnAdd.dispose();
        }
        if (this.btnRemove != null) {
            this.btnRemove.dispose();
        }
        if (this.btnAddFilter != null) {
            this.btnAddFilter.dispose();
        }
        if (this.selectedTreeItem != null) {
            this.selectedTreeItem.dispose();
        }
        this.txtDisplay = null;
        this.txtCategory = null;
        this.txtDescription = null;
        this.treeGraphs = null;
        this.btnAdd = null;
        this.btnRemove = null;
        this.btnAddFilter = null;
        this.selectedTreeItem = null;
        this.data = null;
    }

    private void buildGraphData() {
        TreeItem[] children = this.treeGraphs.getItems();
        this.graphData = new GraphData[children.length];
        int i = 0;
        while (i < this.graphData.length) {
            this.graphData[i] = (GraphData)children[i].getData();
            ++i;
        }
    }

    private void buildFilterData() {
        TreeItem[] items = this.treeGraphs.getItems();
        this.filters = new TreeNode((Object)"", false);
        int i = 0;
        while (i < items.length) {
            TreeItem[] filterItems = items[i].getItems();
            TreeNode graphLevel = new TreeNode((Object)"graph", false);
            this.filters.add(graphLevel);
            int j = 0;
            while (j < filterItems.length) {
                graphLevel.add(new TreeNode(filterItems[j].getData(), false));
                ++j;
            }
            ++i;
        }
    }
}

