/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.widgets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.linuxtools.tmf.ui.internal.Messages;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.TmfTimeAnalysisProvider;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.model.ITmfTimeAnalysisEntry;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.model.TimeEvent;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.widgets.GroupItem;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.widgets.Item;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.widgets.TraceItem;
import org.eclipse.osgi.util.NLS;

class ItemData {
    public Object[] _items = new Object[0];
    private Object[] _traces = new Object[0];
    private boolean[] traceFilter = new boolean[0];
    private Map<String, GroupItem> _groupTable = new HashMap<String, GroupItem>();
    private boolean _flatList = false;
    private TmfTimeAnalysisProvider utilsImp;
    private Vector<ITmfTimeAnalysisEntry> filteredOut = new Vector();

    public ItemData(TmfTimeAnalysisProvider utils) {
        this.utilsImp = utils;
    }

    protected void groupTraces(boolean on) {
        if (this._flatList == on) {
            this._flatList = !on;
            this.updateItems();
        }
    }

    void clearGroups() {
        for (GroupItem group : this._groupTable.values()) {
            group._traces.clear();
        }
    }

    void deleteEmptyGroups() {
        Iterator<GroupItem> it = this._groupTable.values().iterator();
        while (it.hasNext()) {
            GroupItem group = it.next();
            if (group._traces.size() != 0) continue;
            it.remove();
        }
    }

    TraceItem findTraceItem(ITmfTimeAnalysisEntry trace) {
        if (trace == null) {
            return null;
        }
        int traceId = trace.getId();
        TraceItem traceItem = null;
        int i = 0;
        while (i < this._items.length) {
            Object item = this._items[i];
            if (item instanceof TraceItem) {
                TraceItem ti = (TraceItem)item;
                if (ti._trace.getId() == traceId) {
                    traceItem = ti;
                    break;
                }
            }
            ++i;
        }
        return traceItem;
    }

    Integer findTraceItemIndex(ITmfTimeAnalysisEntry trace) {
        if (trace == null) {
            return null;
        }
        int i = 0;
        while (i < this._items.length) {
            Object item = this._items[i];
            if (item instanceof TraceItem) {
                TraceItem ti = (TraceItem)item;
                if (ti._trace == trace) {
                    return i;
                }
            }
            ++i;
        }
        return null;
    }

    public void updateItems() {
        ArrayList<Item> itemList = new ArrayList<Item>();
        String name = "";
        for (GroupItem group : this._groupTable.values()) {
            if (!this._flatList) {
                itemList.add(group);
            }
            if (!this._flatList && !group._expanded) continue;
            for (ITmfTimeAnalysisEntry trace : group._traces) {
                TraceItem traceItem = this.findTraceItem(trace);
                name = this.utilsImp.composeTraceName(trace, false);
                traceItem = new TraceItem(trace, name);
                itemList.add(traceItem);
            }
        }
        this._items = itemList.toArray();
    }

    public int expandItem(int idx, boolean expand) {
        if (idx < 0 || idx >= this._items.length) {
            return 0;
        }
        int ret = 0;
        Item item = (Item)this._items[idx];
        if (item._hasChildren && !item._expanded) {
            item._expanded = expand;
            ret = this._items.length;
            this.updateItems();
            ret = this._items.length - ret;
        }
        return ret;
    }

    public void refreshData(Object[] traces) {
        if (traces == null || traces.length == 0) {
            this.traceFilter = null;
        } else if (this.traceFilter == null || traces.length != this.traceFilter.length) {
            this.traceFilter = new boolean[traces.length];
            Arrays.fill(this.traceFilter, true);
        }
        this._traces = traces;
        this.refreshData();
    }

    public void refreshPartial(ITmfTimeAnalysisEntry parent, TimeEvent childItem) {
    }

    public void refreshData() {
        this.clearGroups();
        this.filteredOut.clear();
        String undef = Messages.TmfTimeStatesCtrl_UNDEFINED_GROUP;
        ArrayList<GroupItem> groupList = new ArrayList<GroupItem>();
        int i = 0;
        while (i < this._traces.length) {
            ITmfTimeAnalysisEntry trace = (ITmfTimeAnalysisEntry)this._traces[i];
            if (!this.traceFilter[i]) {
                this.filteredOut.add(trace);
            } else {
                GroupItem group;
                String groupName = trace.getGroupName();
                if (groupName == null) {
                    groupName = undef;
                }
                if ((group = this._groupTable.get(groupName)) == null) {
                    group = new GroupItem(NLS.bind((String)Messages.TmfTimeStatesCtrl_TRACE_GROUP_LABEL, (Object)groupName));
                    group._expanded = !groupName.equalsIgnoreCase("system") && !groupName.equalsIgnoreCase(undef);
                    this._groupTable.put(groupName, group);
                    groupList.add(group);
                }
                group.add(trace);
            }
            ++i;
        }
        this.deleteEmptyGroups();
        this.updateItems();
    }

    public Object[] getTraces() {
        return this._traces;
    }

    public boolean[] getTraceFilter() {
        return this.traceFilter;
    }

    public Vector<ITmfTimeAnalysisEntry> getFilteredOut() {
        return this.filteredOut;
    }
}

