/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.statistics;

import java.util.Vector;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.event.TmfTimeRange;
import org.eclipse.linuxtools.tmf.core.experiment.TmfExperiment;
import org.eclipse.linuxtools.tmf.core.request.ITmfDataRequest;
import org.eclipse.linuxtools.tmf.core.request.ITmfEventRequest;
import org.eclipse.linuxtools.tmf.core.request.TmfEventRequest;
import org.eclipse.linuxtools.tmf.core.signal.TmfExperimentDisposedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfExperimentRangeUpdatedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfExperimentSelectedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalHandler;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.ui.views.TmfView;
import org.eclipse.linuxtools.tmf.ui.views.statistics.ITmfExtraEventInfo;
import org.eclipse.linuxtools.tmf.ui.views.statistics.Messages;
import org.eclipse.linuxtools.tmf.ui.views.statistics.model.AbsTmfStatisticsTree;
import org.eclipse.linuxtools.tmf.ui.views.statistics.model.ITmfColumnDataProvider;
import org.eclipse.linuxtools.tmf.ui.views.statistics.model.TmfBaseColumnData;
import org.eclipse.linuxtools.tmf.ui.views.statistics.model.TmfBaseColumnDataProvider;
import org.eclipse.linuxtools.tmf.ui.views.statistics.model.TmfBaseStatisticsTree;
import org.eclipse.linuxtools.tmf.ui.views.statistics.model.TmfStatisticsTreeNode;
import org.eclipse.linuxtools.tmf.ui.views.statistics.model.TmfStatisticsTreeRootFactory;
import org.eclipse.linuxtools.tmf.ui.views.statistics.model.TmfTreeContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class TmfStatisticsView
extends TmfView {
    public static final String ID = "org.eclipse.linuxtools.tmf.ui.views.statistics";
    public static final String TMF_STATISTICS_VIEW = "StatisticsView";
    protected static final Long STATS_INPUT_CHANGED_REFRESH = 5000L;
    protected static final int PAGE_SIZE = 50000;
    protected TreeViewer fTreeViewer;
    protected ITmfEventRequest<ITmfEvent> fRequest = null;
    protected boolean fStatisticsUpdateBusy = false;
    protected boolean fStatisticsUpdatePending = false;
    protected TmfTimeRange fStatisticsUpdateRange = null;
    protected final Object fStatisticsUpdateSyncObj = new Object();
    protected boolean fRequestData = false;
    private Cursor fWaitCursor = null;
    private static int fCountInstance = 0;
    private int fInstanceNb = ++fCountInstance;

    public TmfStatisticsView(String viewName) {
        super(viewName);
    }

    public TmfStatisticsView() {
        this(TMF_STATISTICS_VIEW);
    }

    @Override
    public void createPartControl(Composite parent) {
        final Vector<TmfBaseColumnData> columnDataList = this.getColumnDataProvider().getColumnData();
        parent.setLayout((Layout)new FillLayout());
        this.fTreeViewer = new TreeViewer(parent, 2816);
        this.fTreeViewer.setContentProvider((IContentProvider)new TmfTreeContentProvider());
        this.fTreeViewer.getTree().setHeaderVisible(true);
        this.fTreeViewer.setUseHashlookup(true);
        for (final TmfBaseColumnData columnData : columnDataList) {
            final TreeViewerColumn treeColumn = new TreeViewerColumn(this.fTreeViewer, columnData.getAlignment());
            treeColumn.getColumn().setText(columnData.getHeader());
            treeColumn.getColumn().setWidth(columnData.getWidth());
            treeColumn.getColumn().setToolTipText(columnData.getTooltip());
            if (columnData.getComparator() != null) {
                treeColumn.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (TmfStatisticsView.this.fTreeViewer.getTree().getSortDirection() == 128 || TmfStatisticsView.this.fTreeViewer.getTree().getSortColumn() != treeColumn.getColumn()) {
                            TmfStatisticsView.this.fTreeViewer.setComparator(columnData.getComparator());
                            TmfStatisticsView.this.fTreeViewer.getTree().setSortDirection(1024);
                        } else {
                            TmfStatisticsView.this.fTreeViewer.setComparator(new ViewerComparator(){

                                public int compare(Viewer viewer, Object e1, Object e2) {
                                    return -1 * columnData.getComparator().compare(viewer, e1, e2);
                                }
                            });
                            TmfStatisticsView.this.fTreeViewer.getTree().setSortDirection(128);
                        }
                        TmfStatisticsView.this.fTreeViewer.getTree().setSortColumn(treeColumn.getColumn());
                    }
                });
            }
            treeColumn.setLabelProvider((CellLabelProvider)columnData.getLabelProvider());
        }
        this.fTreeViewer.getTree().addListener(40, new Listener(){

            public void handleEvent(Event event) {
                if (((TmfBaseColumnData)columnDataList.get(event.index)).getPercentageProvider() != null) {
                    TmfStatisticsTreeNode node = (TmfStatisticsTreeNode)event.item.getData();
                    double percentage = ((TmfBaseColumnData)columnDataList.get(event.index)).getPercentageProvider().getPercentage(node);
                    if (percentage == 0.0) {
                        return;
                    }
                    if ((event.detail & 2) > 0) {
                        Color oldForeground = event.gc.getForeground();
                        event.gc.setForeground(event.item.getDisplay().getSystemColor(26));
                        event.gc.fillRectangle(event.x, event.y, event.width, event.height);
                        event.gc.setForeground(oldForeground);
                        event.detail &= 0xFFFFFFFD;
                    }
                    int barWidth = (int)((double)(TmfStatisticsView.this.fTreeViewer.getTree().getColumn(1).getWidth() - 8) * percentage);
                    int oldAlpha = event.gc.getAlpha();
                    Color oldForeground = event.gc.getForeground();
                    Color oldBackground = event.gc.getBackground();
                    event.gc.setAlpha(64);
                    event.gc.setForeground(event.item.getDisplay().getSystemColor(9));
                    event.gc.setBackground(event.item.getDisplay().getSystemColor(25));
                    event.gc.fillGradientRectangle(event.x, event.y, barWidth, event.height, true);
                    event.gc.drawRectangle(event.x, event.y, barWidth, event.height);
                    event.gc.setForeground(oldForeground);
                    event.gc.setBackground(oldBackground);
                    event.gc.setAlpha(oldAlpha);
                    event.detail &= 0xFFFFFFF7;
                }
            }
        });
        this.fTreeViewer.setComparator(columnDataList.get(0).getComparator());
        this.fTreeViewer.getTree().setSortColumn(this.fTreeViewer.getTree().getColumn(0));
        this.fTreeViewer.getTree().setSortDirection(1024);
        TmfExperiment experiment = TmfExperiment.getCurrentExperiment();
        if (experiment != null) {
            this.fRequestData = true;
            TmfExperimentSelectedSignal signal = new TmfExperimentSelectedSignal((Object)this, experiment);
            this.experimentSelected((TmfExperimentSelectedSignal<? extends ITmfEvent>)signal);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.fWaitCursor != null) {
            this.fWaitCursor.dispose();
        }
        TmfStatisticsTreeRootFactory.removeAll();
    }

    @Override
    public void setFocus() {
        this.fTreeViewer.getTree().setFocus();
    }

    public void modelInputChanged(boolean complete) {
        if (this.fTreeViewer.getTree().isDisposed()) {
            return;
        }
        this.fTreeViewer.getTree().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!TmfStatisticsView.this.fTreeViewer.getTree().isDisposed()) {
                    TmfStatisticsView.this.fTreeViewer.refresh();
                }
            }
        });
        if (complete) {
            this.sendPendingUpdate();
        }
    }

    public void modelIncomplete(String name) {
        Object input = this.fTreeViewer.getInput();
        if (input != null && input instanceof TmfStatisticsTreeNode) {
            TmfStatisticsTreeRootFactory.removeStatTreeRoot(this.getTreeID(name));
            this.resetUpdateSynchronization();
            this.modelInputChanged(false);
        }
        this.waitCursor(false);
    }

    @TmfSignalHandler
    public void experimentDisposed(TmfExperimentDisposedSignal<? extends ITmfEvent> signal) {
        if (signal.getExperiment() != TmfExperiment.getCurrentExperiment()) {
            return;
        }
        this.cancelOngoingRequest();
    }

    @TmfSignalHandler
    public void experimentSelected(TmfExperimentSelectedSignal<? extends ITmfEvent> signal) {
        if (signal != null) {
            TmfExperiment experiment = signal.getExperiment();
            String experimentName = experiment.getName();
            if (TmfStatisticsTreeRootFactory.containsTreeRoot(this.getTreeID(experimentName))) {
                int numNodeTraces;
                TmfStatisticsTreeNode experimentTreeNode = TmfStatisticsTreeRootFactory.getStatTreeRoot(this.getTreeID(experimentName));
                ITmfTrace[] traces = experiment.getTraces();
                int numTraces = experiment.getTraces().length;
                if (numTraces == (numNodeTraces = experimentTreeNode.getNbChildren())) {
                    boolean same = true;
                    int i = 0;
                    while (i < numTraces) {
                        String traceName = traces[i].getName();
                        if (!experimentTreeNode.containsChild(traceName)) {
                            same = false;
                            break;
                        }
                        ++i;
                    }
                    if (same) {
                        this.fTreeViewer.setInput((Object)experimentTreeNode);
                        this.resetUpdateSynchronization();
                        return;
                    }
                    experimentTreeNode.reset();
                }
            } else {
                TmfStatisticsTreeRootFactory.addStatsTreeRoot(this.getTreeID(experimentName), this.getStatisticData());
            }
            this.resetUpdateSynchronization();
            TmfStatisticsTreeNode treeModelRoot = TmfStatisticsTreeRootFactory.getStatTreeRoot(this.getTreeID(experiment.getName()));
            if (treeModelRoot.hasChildren()) {
                treeModelRoot.reset();
            }
            this.fTreeViewer.setInput((Object)treeModelRoot);
            if (this.fRequestData) {
                this.requestData(experiment, experiment.getTimeRange());
                this.fRequestData = false;
            }
        }
    }

    @TmfSignalHandler
    public void experimentRangeUpdated(TmfExperimentRangeUpdatedSignal signal) {
        TmfExperiment experiment = signal.getExperiment();
        if (!experiment.equals(TmfExperiment.getCurrentExperiment())) {
            return;
        }
        this.requestData(experiment, signal.getRange());
    }

    protected int getIndexPageSize() {
        return 50000;
    }

    protected long getInputChangedRefresh() {
        return STATS_INPUT_CHANGED_REFRESH;
    }

    protected AbsTmfStatisticsTree getStatisticData() {
        return new TmfBaseStatisticsTree();
    }

    protected ITmfColumnDataProvider getColumnDataProvider() {
        return new TmfBaseColumnDataProvider();
    }

    protected String getTreeID(String experimentName) {
        return String.valueOf(experimentName) + this.fInstanceNb;
    }

    protected void waitCursor(final boolean waitInd) {
        if (this.fTreeViewer == null || this.fTreeViewer.getTree().isDisposed()) {
            return;
        }
        Display display = this.fTreeViewer.getControl().getDisplay();
        if (this.fWaitCursor == null) {
            this.fWaitCursor = new Cursor((Device)display, 1);
        }
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (TmfStatisticsView.this.fTreeViewer != null && !TmfStatisticsView.this.fTreeViewer.getTree().isDisposed()) {
                    Cursor cursor = null;
                    if (waitInd) {
                        cursor = TmfStatisticsView.this.fWaitCursor;
                    }
                    TmfStatisticsView.this.fTreeViewer.getControl().setCursor(cursor);
                }
            }
        });
    }

    protected void requestData(final TmfExperiment<?> experiment, TmfTimeRange timeRange) {
        if (experiment != null) {
            if (this.checkUpdateBusy(timeRange)) {
                return;
            }
            int index = 0;
            for (TmfStatisticsTreeNode node : ((TmfStatisticsTreeNode)this.fTreeViewer.getInput()).getChildren()) {
                index += (int)node.getValue().nbEvents;
            }
            this.fRequest = new TmfEventRequest<ITmfEvent>(ITmfEvent.class, timeRange, index, Integer.MAX_VALUE, this.getIndexPageSize(), ITmfDataRequest.ExecutionType.BACKGROUND){

                public void handleData(ITmfEvent data) {
                    super.handleData(data);
                    if (data != null) {
                        AbsTmfStatisticsTree statisticsData = TmfStatisticsTreeRootFactory.getStatTree(TmfStatisticsView.this.getTreeID(experiment.getName()));
                        final String traceName = data.getTrace().getName();
                        ITmfExtraEventInfo extraInfo = new ITmfExtraEventInfo(){

                            @Override
                            public String getTraceName() {
                                if (traceName == null) {
                                    return Messages.TmfStatisticsView_UnknownTraceName;
                                }
                                return traceName;
                            }
                        };
                        statisticsData.registerEvent(data, extraInfo);
                        statisticsData.increase(data, extraInfo, 1);
                        if ((long)this.getNbRead() % TmfStatisticsView.this.getInputChangedRefresh() == 0L) {
                            TmfStatisticsView.this.modelInputChanged(false);
                        }
                    }
                }

                public void handleSuccess() {
                    super.handleSuccess();
                    TmfStatisticsView.this.modelInputChanged(true);
                    TmfStatisticsView.this.waitCursor(false);
                }

                public void handleFailure() {
                    super.handleFailure();
                    TmfStatisticsView.this.modelIncomplete(experiment.getName());
                }

                public void handleCancel() {
                    super.handleCancel();
                    TmfStatisticsView.this.modelIncomplete(experiment.getName());
                }
            };
            experiment.sendRequest(this.fRequest);
            this.waitCursor(true);
        }
    }

    protected void cancelOngoingRequest() {
        if (this.fRequest != null && !this.fRequest.isCompleted()) {
            this.fRequest.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetUpdateSynchronization() {
        Object object = this.fStatisticsUpdateSyncObj;
        synchronized (object) {
            this.fStatisticsUpdateBusy = false;
            this.fStatisticsUpdatePending = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkUpdateBusy(TmfTimeRange timeRange) {
        Object object = this.fStatisticsUpdateSyncObj;
        synchronized (object) {
            block4: {
                if (!this.fStatisticsUpdateBusy) break block4;
                this.fStatisticsUpdatePending = true;
                this.fStatisticsUpdateRange = timeRange;
                return true;
            }
            this.fStatisticsUpdateBusy = true;
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendPendingUpdate() {
        Object object = this.fStatisticsUpdateSyncObj;
        synchronized (object) {
            this.fStatisticsUpdateBusy = false;
            if (this.fStatisticsUpdatePending) {
                this.fStatisticsUpdatePending = false;
                this.requestData(TmfExperiment.getCurrentExperiment(), this.fStatisticsUpdateRange);
            }
        }
    }
}

