/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.uml2sd;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.linuxtools.tmf.core.event.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.event.TmfTimestamp;
import org.eclipse.linuxtools.tmf.ui.TmfUiPlugin;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.DiagramToolTip;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.ITimeCompressionListener;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.NGC;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.SDView;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.SDWidgetSelectionProvider;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.ScrollView;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.TimeCompressionBar;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.BaseMessage;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.BasicExecutionOccurrence;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.Frame;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.GraphNode;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.ITimeRange;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.Lifeline;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.Metrics;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.drawings.IColor;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.provider.ISDCollapseProvider;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.load.LoadersManager;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.preferences.SDViewPref;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.util.SDMessages;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.util.SDPrintDialog;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.util.SDPrintDialogUI;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.part.ViewPart;

public class SDWidget
extends ScrollView
implements SelectionListener,
IPropertyChangeListener,
DisposeListener,
ITimeCompressionListener {
    protected Frame frame;
    protected Image overView = null;
    protected MenuItem zoomIn = null;
    protected MenuItem zoomOut = null;
    protected SDWidgetSelectionProvider selProvider = null;
    public float zoomValue = 1.0f;
    protected boolean zoomInMode = false;
    protected boolean zoomOutMode = false;
    protected List<GraphNode> selectedNodeList = null;
    protected boolean ctrlSelection = false;
    protected ViewPart site = null;
    public GraphNode currentGraphNode = null;
    public GraphNode listStart = null;
    public ArrayList<GraphNode> prevList = null;
    protected TimeCompressionBar timeBar = null;
    protected DiagramToolTip toolTip = null;
    protected Accessible accessible = null;
    protected GraphNode toolTipNode;
    protected Lifeline dragAndDrop = null;
    protected int focusedWidget = -1;
    protected float printerZoom = 0.0f;
    protected int printerY = 0;
    protected int printerX = 0;
    protected boolean getDragAndDrop = false;
    protected int dragX = 0;
    protected int dragY = 0;
    protected boolean reorderMode = false;
    Image collapaseCaretImg = null;
    Image arrowUpCaretImg = null;
    Image currentCaretImage = null;
    protected ISDCollapseProvider collapseProvider = null;
    protected Caret insertionCartet = null;
    protected ArrayList<Lifeline[]> reorderList = null;
    protected boolean printing = false;
    protected Printer printer = null;
    protected boolean shiftSelection = false;
    protected DiagramToolTip scrollToolTip = null;
    protected AutoScroll local_auto_scroll_ = null;
    protected Timer local_auto_scroll_timer_ = null;

    public SDWidget(Composite c, int s) {
        super(c, s | 0x40000, true);
        this.setOverviewEnabled(true);
        this.selectedNodeList = new ArrayList<GraphNode>();
        this.selProvider = new SDWidgetSelectionProvider();
        SDViewPref.getInstance().addPropertyChangeListener(this);
        this.toolTip = new DiagramToolTip(this.getViewControl());
        super.addDisposeListener((DisposeListener)this);
        this.scrollToolTip = new DiagramToolTip((Control)c);
        this.getVerticalBar().addListener(4, new Listener(){

            public void handleEvent(Event event) {
                SDWidget.this.scrollToolTip.hideToolTip();
            }
        });
        this.accessible = this.getViewControl().getAccessible();
        this.accessible.addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID != -1) {
                    if (e.childID == 0) {
                        if (SDWidget.this.toolTipNode != null) {
                            if (SDWidget.this.toolTipNode instanceof Lifeline) {
                                Lifeline lifeline = (Lifeline)SDWidget.this.toolTipNode;
                                e.result = lifeline.getToolTipText();
                            } else {
                                e.result = String.valueOf(SDWidget.this.toolTipNode.getName()) + SDWidget.this.getPostfixForTooltip(true);
                            }
                        }
                    } else if (SDWidget.this.getFocusNode() != null) {
                        if (SDWidget.this.getFocusNode() instanceof Lifeline) {
                            e.result = MessageFormat.format(SDMessages._1, String.valueOf(SDWidget.this.getFocusNode().getName()));
                        }
                        if (SDWidget.this.getFocusNode() instanceof BaseMessage) {
                            BaseMessage mes = (BaseMessage)SDWidget.this.getFocusNode();
                            if (mes.getStartLifeline() != null && mes.getEndLifeline() != null) {
                                e.result = MessageFormat.format(SDMessages._2, String.valueOf(mes.getName()), String.valueOf(mes.getStartLifeline().getName()), mes.getStartOccurrence(), String.valueOf(mes.getEndLifeline().getName()), mes.getEndOccurrence());
                            } else if (mes.getStartLifeline() == null && mes.getEndLifeline() != null) {
                                e.result = MessageFormat.format(SDMessages._4, String.valueOf(mes.getName()), String.valueOf(mes.getEndLifeline().getName()), mes.getEndOccurrence());
                            } else if (mes.getStartLifeline() != null && mes.getEndLifeline() == null) {
                                e.result = MessageFormat.format(SDMessages._3, String.valueOf(mes.getName()), String.valueOf(mes.getStartLifeline().getName()), mes.getStartOccurrence());
                            }
                        } else if (SDWidget.this.getFocusNode() instanceof BasicExecutionOccurrence) {
                            BasicExecutionOccurrence exec = (BasicExecutionOccurrence)SDWidget.this.getFocusNode();
                            e.result = MessageFormat.format(SDMessages._5, String.valueOf(exec.getName()), String.valueOf(exec.getLifeline().getName()), exec.getStartOccurrence(), exec.getEndOccurrence());
                        }
                    }
                }
            }
        });
        this.accessible.addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getFocus(AccessibleControlEvent e) {
                e.childID = SDWidget.this.focusedWidget == -1 ? -1 : SDWidget.this.focusedWidget;
            }

            public void getRole(AccessibleControlEvent e) {
                switch (e.childID) {
                    case -1: {
                        e.detail = 10;
                        break;
                    }
                    case 0: {
                        e.detail = 13;
                        break;
                    }
                    case 1: {
                        e.detail = 41;
                    }
                }
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 0x100000;
                if (e.childID == -1) {
                    e.detail |= 4;
                } else {
                    e.detail |= 0x200000;
                    if (e.childID == SDWidget.this.focusedWidget) {
                        e.detail |= 0x16;
                    }
                }
            }
        });
        this.insertionCartet = new Caret((Canvas)this.getViewControl(), 0);
        this.insertionCartet.setVisible(false);
        this.collapaseCaretImg = TmfUiPlugin.getDefault().getImageFromPath("icons/obj16/arrow_colapse.bmp");
        this.arrowUpCaretImg = TmfUiPlugin.getDefault().getImageFromPath("icons/obj16/arrow_up.bmp");
        this.reorderList = new ArrayList();
        this.getViewControl().addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 16 || e.detail == 8) {
                    e.doit = true;
                }
            }
        });
        this.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 16 || e.detail == 8) {
                    e.doit = true;
                }
            }
        });
        this.getViewControl().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                SDViewPref.getInstance().setNoFocusSelection(false);
                SDWidget.this.ctrlSelection = false;
                SDWidget.this.shiftSelection = false;
                SDWidget.this.redraw();
            }

            public void focusLost(FocusEvent e) {
                SDViewPref.getInstance().setNoFocusSelection(true);
                SDWidget.this.redraw();
            }
        });
    }

    public void setTimeBar(TimeCompressionBar bar) {
        if (bar != null) {
            this.timeBar = bar;
            this.timeBar.addTimeCompressionListener(this);
        }
    }

    protected void setCollapseProvider(ISDCollapseProvider provider) {
        this.collapseProvider = provider;
    }

    @Override
    protected void keyPressedEvent(KeyEvent event) {
        if (!this.isFocusControl() && !this.getViewControl().isFocusControl()) {
            Control[] child = this.getParent().getChildren();
            int i = 0;
            while (i < child.length) {
                if (child[i].isFocusControl() && !(child[i] instanceof ScrollView)) {
                    this.getViewControl().setFocus();
                    break;
                }
                ++i;
            }
        }
        this.setFocus(-1);
        if (event.keyCode == 262144) {
            this.ctrlSelection = true;
        }
        if (event.keyCode == 131072) {
            this.shiftSelection = true;
            this.prevList = new ArrayList();
            this.prevList.addAll(this.getSelection());
        }
        GraphNode prevNode = this.getFocusNode();
        if (event.keyCode == 0x1000004) {
            this.traverseRight();
        }
        if (event.keyCode == 0x1000003) {
            this.traverseLeft();
        }
        if (event.keyCode == 0x1000002) {
            this.traverseDown();
        }
        if (event.keyCode == 0x1000001) {
            this.traverseUp();
        }
        if (event.keyCode == 0x1000007) {
            this.traverseHome();
        }
        if (event.keyCode == 0x1000008) {
            this.traverseEnd();
        }
        if (!this.shiftSelection && !this.ctrlSelection) {
            this.listStart = this.currentGraphNode;
        }
        if (event.character == ' ') {
            this.performSelection(this.currentGraphNode);
            if (!this.shiftSelection) {
                this.listStart = this.currentGraphNode;
            }
        }
        if (this.shiftSelection && prevNode != this.getFocusNode()) {
            this.clearSelection();
            this.addSelection(this.prevList);
            this.addSelection(this.frame.getNodeList(this.listStart, this.getFocusNode()));
            if (this.getFocusNode() instanceof Lifeline) {
                this.ensureVisible(this.getFocusNode().getX(), this.getFocusNode().getY(), this.getFocusNode().getWidth(), this.getFocusNode().getHeight(), 0x1000200, true);
            } else {
                this.ensureVisible(this.getFocusNode());
            }
        } else if (!this.ctrlSelection && !this.shiftSelection) {
            this.clearSelection();
            if (this.getFocusNode() != null) {
                this.addSelection(this.getFocusNode());
                if (this.getFocusNode() instanceof Lifeline) {
                    this.ensureVisible(this.getFocusNode().getX(), this.getFocusNode().getY(), this.getFocusNode().getWidth(), this.getFocusNode().getHeight(), 0x1000200, true);
                } else {
                    this.ensureVisible(this.getFocusNode());
                }
            }
        }
        if (this.currentGraphNode != null) {
            this.currentGraphNode.setFocused(true);
        }
        this.redraw();
        if (event.character == ' ' && (this.zoomInMode || this.zoomOutMode)) {
            int cx = Math.round((float)(this.getContentsX() + this.getVisibleWidth() / 2) / this.zoomValue);
            int cy = Math.round((float)(this.getContentsY() + this.getVisibleHeight() / 2) / this.zoomValue);
            if (this.zoomInMode) {
                if (this.zoomValue < 64.0f) {
                    this.zoomValue *= 1.25f;
                }
            } else {
                this.zoomValue /= 1.25f;
            }
            int x = Math.round((float)cx * this.zoomValue - (float)this.getVisibleWidth() / 2.0f);
            int y = Math.round((float)cy * this.zoomValue - (float)this.getVisibleHeight() / 2.0f);
            this.setContentsPos(x, y);
            if (this.timeBar != null) {
                this.timeBar.setZoom(this.zoomValue);
            }
            this.redraw();
        }
    }

    @Override
    protected void keyReleasedEvent(KeyEvent event) {
        this.setFocus(-1);
        if (event.keyCode == 262144) {
            this.ctrlSelection = false;
        }
        if (event.keyCode == 131072) {
            this.shiftSelection = false;
        }
        super.keyReleasedEvent(event);
        this.setFocus(1);
    }

    public void resizeContents(Frame frame) {
        int width = Math.round((float)(frame.getWidth() + 20) * this.zoomValue);
        int height = Math.round((float)(frame.getHeight() + 20) * this.zoomValue);
        this.resizeContents(width, height);
    }

    protected boolean checkFocusOnChilds(Control childs) {
        if (childs instanceof Composite) {
            Control[] child = ((Composite)childs).getChildren();
            int i = 0;
            while (i < child.length) {
                if (child[i].isFocusControl()) {
                    return true;
                }
                this.checkFocusOnChilds(child[i]);
                ++i;
            }
        }
        return false;
    }

    public boolean isFocusControl() {
        Control[] child = this.getChildren();
        int i = 0;
        while (i < child.length) {
            if (child[i].isFocusControl()) {
                return true;
            }
            this.checkFocusOnChilds(child[i]);
            ++i;
        }
        return false;
    }

    public void setFrame(Frame theFrame, boolean resetPosition) {
        this.reorderList.clear();
        this.selectedNodeList.clear();
        this.selProvider.setSelection((ISelection)new StructuredSelection());
        this.frame = theFrame;
        if (resetPosition) {
            this.setContentsPos(0, 0);
            this.resizeContents(this.frame);
            this.redraw();
        }
        if (this.overView != null) {
            this.overView.dispose();
        }
        this.overView = null;
        this.resizeContents(this.frame);
    }

    public Frame getFrame() {
        return this.frame;
    }

    public ISelectionProvider getSelectionProvider() {
        return this.selProvider;
    }

    @Override
    public boolean setContentsPos(int x, int y) {
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        if (this.frame == null) {
            return false;
        }
        if (x + this.getVisibleWidth() > this.getContentsWidth()) {
            x = this.getContentsWidth() - this.getVisibleWidth();
        }
        if (y + this.getVisibleHeight() > this.getContentsHeight()) {
            y = this.getContentsHeight() - this.getVisibleHeight();
        }
        int x1 = Math.round((float)x / this.zoomValue);
        int y2 = Math.round((float)y / this.zoomValue);
        int width = Math.round((float)this.getVisibleWidth() / this.zoomValue);
        int height = Math.round((float)this.getVisibleHeight() / this.zoomValue);
        this.frame.updateIndex(x1, y2, width, height);
        if (this.insertionCartet != null && this.insertionCartet.isVisible()) {
            this.insertionCartet.setVisible(false);
        }
        return super.setContentsPos(x, y);
    }

    @Override
    protected void contentsMouseHover(MouseEvent event) {
        GraphNode graphNode = null;
        if (this.frame != null) {
            int y;
            int x = Math.round((float)event.x / this.zoomValue);
            graphNode = this.frame.getNodeAt(x, y = Math.round((float)event.y / this.zoomValue));
            if (graphNode != null && SDViewPref.getInstance().tooltipEnabled()) {
                this.toolTipNode = graphNode;
                String postfix = this.getPostfixForTooltip(true);
                if (graphNode instanceof Lifeline) {
                    Lifeline lifeline = (Lifeline)graphNode;
                    this.toolTip.showToolTip(String.valueOf(lifeline.getToolTipText()) + postfix);
                    this.setFocus(0);
                } else {
                    this.toolTip.showToolTip(String.valueOf(graphNode.getName()) + postfix);
                    this.setFocus(0);
                }
            } else {
                this.toolTip.hideToolTip();
            }
        }
    }

    protected String getPostfixForTooltip(boolean accessible) {
        String postfix = "";
        if (this.currentGraphNode != null && this.currentGraphNode instanceof ITimeRange && this.toolTipNode instanceof ITimeRange && this.currentGraphNode != this.toolTipNode && ((ITimeRange)((Object)this.toolTipNode)).hasTimeInfo() && ((ITimeRange)((Object)this.currentGraphNode)).hasTimeInfo()) {
            postfix = " -> " + this.currentGraphNode.getName() + "\n" + SDMessages._138 + " ";
            ITmfTimestamp firstTime = ((ITimeRange)((Object)this.currentGraphNode)).getEndTime();
            ITmfTimestamp lastTime = ((ITimeRange)((Object)this.toolTipNode)).getEndTime();
            TmfTimestamp delta = (TmfTimestamp)lastTime.getDelta(firstTime);
            postfix = String.valueOf(postfix) + delta.toString();
        } else if (this.toolTipNode instanceof ITimeRange && ((ITimeRange)((Object)this.toolTipNode)).hasTimeInfo()) {
            postfix = "\n";
            ITmfTimestamp firstTime = ((ITimeRange)((Object)this.toolTipNode)).getStartTime();
            ITmfTimestamp lastTime = ((ITimeRange)((Object)this.toolTipNode)).getEndTime();
            if (firstTime != null) {
                if (lastTime != null && firstTime.compareTo(lastTime, true) != 0) {
                    postfix = String.valueOf(postfix) + "start: " + firstTime + "\n";
                    postfix = String.valueOf(postfix) + "end: " + lastTime + "\n";
                } else {
                    postfix = String.valueOf(postfix) + firstTime.toString();
                }
            } else if (lastTime != null) {
                postfix = String.valueOf(postfix) + lastTime.toString();
            }
        }
        return postfix;
    }

    protected void setFocus(int newFocusShape) {
        this.focusedWidget = newFocusShape;
        if (this.focusedWidget == -1) {
            this.getViewControl().getAccessible().setFocus(-1);
        } else {
            this.getViewControl().getAccessible().setFocus(this.focusedWidget);
        }
    }

    @Override
    protected void contentsMouseMoveEvent(MouseEvent e) {
        this.scrollToolTip.hideToolTip();
        this.toolTip.hideToolTip();
        if (!this.isFocusControl() && !this.getViewControl().isFocusControl()) {
            Control[] child = this.getParent().getChildren();
            int i = 0;
            while (i < child.length) {
                if (child[i].isFocusControl() && !(child[i] instanceof ScrollView)) {
                    this.getViewControl().setFocus();
                    break;
                }
                ++i;
            }
        }
        this.setFocus(-1);
        if ((e.stateMask & SWT.BUTTON_MASK) != 0 && (this.dragAndDrop != null || this.getDragAndDrop) && (this.reorderMode || this.collapseProvider != null)) {
            this.getDragAndDrop = false;
            if (this.currentGraphNode instanceof Lifeline) {
                this.dragAndDrop = (Lifeline)this.currentGraphNode;
            }
            if (this.dragAndDrop != null) {
                int dx = 0;
                int dy = 0;
                if (e.x > this.getContentsX() + this.getVisibleWidth()) {
                    dx = e.x - (this.getContentsX() + this.getVisibleWidth());
                } else if (e.x < this.getContentsX()) {
                    dx = -this.getContentsX() + e.x;
                }
                if (e.y > this.getContentsY() + this.getVisibleHeight()) {
                    dy = e.y - (this.getContentsY() + this.getVisibleHeight());
                } else if (e.y < this.getContentsY()) {
                    dy = -this.getContentsY() + e.y;
                }
                this.dragX = e.x;
                this.dragY = e.y;
                if (dx != 0 || dy != 0) {
                    if (this.local_auto_scroll_ == null) {
                        if (this.local_auto_scroll_timer_ == null) {
                            this.local_auto_scroll_timer_ = new Timer(true);
                        }
                        this.local_auto_scroll_ = new AutoScroll(this, dx, dy);
                        this.local_auto_scroll_timer_.schedule((TimerTask)this.local_auto_scroll_, 0L, 75L);
                    } else {
                        this.local_auto_scroll_.dx_ = dx;
                        this.local_auto_scroll_.dy_ = dy;
                    }
                } else if (this.local_auto_scroll_ != null) {
                    this.local_auto_scroll_.cancel();
                    this.local_auto_scroll_ = null;
                }
                this.dragX = Math.round((float)e.x / this.zoomValue);
                this.dragY = Math.round((float)e.y / this.zoomValue);
                this.redraw();
                Lifeline node = this.frame.getCloserLifeline(this.dragX);
                if (node != null && node != this.dragAndDrop) {
                    int y = 0;
                    int y1 = 0;
                    int height = Metrics.getLifelineHeaderFontHeigth() + 8;
                    int hMargin = 7;
                    int x = node.getX();
                    int width = node.getWidth();
                    y = this.frame.getVisibleAreaY() < node.getY() + node.getHeight() - height - hMargin ? this.contentsToViewY(Math.round((float)(node.getY() + node.getHeight()) * this.zoomValue)) : Math.round((float)height * this.zoomValue);
                    y1 = this.frame.getVisibleAreaY() < this.contentsToViewY(node.getY() - hMargin) ? this.contentsToViewY(Math.round((float)(node.getY() - hMargin) * this.zoomValue)) : Math.round((float)height * this.zoomValue);
                    int rx = Math.round((float)x * this.zoomValue);
                    this.insertionCartet.setVisible(true);
                    if (this.insertionCartet.getImage() != null && !this.insertionCartet.getImage().isDisposed()) {
                        this.insertionCartet.getImage().dispose();
                    }
                    if (rx <= e.x && Math.round((float)rx + (float)width * this.zoomValue) >= e.x) {
                        if (this.collapseProvider != null) {
                            ImageData data = this.collapaseCaretImg.getImageData();
                            data = data.scaledTo(Math.round((float)this.collapaseCaretImg.getBounds().width * this.zoomValue), Math.round((float)this.collapaseCaretImg.getBounds().height * this.zoomValue));
                            this.currentCaretImage = new Image((Device)Display.getCurrent(), data);
                            this.insertionCartet.setImage(this.currentCaretImage);
                            this.insertionCartet.setLocation(this.contentsToViewX(rx + Math.round((float)width / 2.0f * this.zoomValue)) - this.currentCaretImage.getBounds().width / 2, y);
                        }
                    } else if (this.reorderMode) {
                        if (rx > e.x) {
                            if (node.getIndex() > 1 && this.frame.getLifeline(node.getIndex() - 2) == this.dragAndDrop) {
                                return;
                            }
                            ImageData data = this.arrowUpCaretImg.getImageData();
                            data = data.scaledTo(Math.round((float)this.arrowUpCaretImg.getBounds().width * this.zoomValue), Math.round((float)this.arrowUpCaretImg.getBounds().height * this.zoomValue));
                            this.currentCaretImage = new Image((Device)Display.getCurrent(), data);
                            this.insertionCartet.setImage(this.currentCaretImage);
                            this.insertionCartet.setLocation(this.contentsToViewX(Math.round((float)(x - 22) * this.zoomValue)) - this.currentCaretImage.getBounds().width / 2, y1);
                        } else {
                            if (node.getIndex() < this.frame.lifeLinesCount() && this.frame.getLifeline(node.getIndex()) == this.dragAndDrop) {
                                return;
                            }
                            ImageData data = this.arrowUpCaretImg.getImageData();
                            data = data.scaledTo(Math.round((float)this.arrowUpCaretImg.getBounds().width * this.zoomValue), Math.round((float)this.arrowUpCaretImg.getBounds().height * this.zoomValue));
                            this.currentCaretImage = new Image((Device)Display.getCurrent(), data);
                            this.insertionCartet.setImage(this.currentCaretImage);
                            this.insertionCartet.setLocation(this.contentsToViewX(Math.round((float)(x + width + 22) * this.zoomValue)) - this.currentCaretImage.getBounds().width / 2 + 1, y1);
                        }
                    }
                } else {
                    this.insertionCartet.setVisible(false);
                }
            }
        } else {
            super.contentsMouseMoveEvent(e);
        }
    }

    @Override
    protected void contentsMouseUpEvent(MouseEvent event) {
        this.insertionCartet.setVisible(false);
        if (this.dragAndDrop != null) {
            if (this.overView != null && !this.overView.isDisposed()) {
                this.overView.dispose();
            }
            this.overView = null;
            Lifeline node = this.frame.getCloserLifeline(this.dragX);
            if (node != null) {
                int rx = Math.round((float)node.getX() * this.zoomValue);
                if (rx <= event.x && Math.round((float)rx + (float)node.getWidth() * this.zoomValue) >= event.x) {
                    if (this.collapseProvider != null && this.dragAndDrop != node) {
                        this.collapseProvider.collapseTwoLifelines(this.dragAndDrop, node);
                    }
                } else if (rx < event.x) {
                    this.frame.insertLifelineAfter(this.dragAndDrop, node);
                    if (node.getIndex() < this.frame.lifeLinesCount()) {
                        Lifeline[] temp = new Lifeline[]{this.dragAndDrop, this.frame.getLifeline(node.getIndex())};
                        this.reorderList.add(temp);
                    } else {
                        Lifeline[] lifelineArray = new Lifeline[2];
                        lifelineArray[0] = this.dragAndDrop;
                        Lifeline[] temp = lifelineArray;
                        this.reorderList.add(temp);
                    }
                } else {
                    this.frame.insertLifelineBefore(this.dragAndDrop, node);
                    Lifeline[] temp = new Lifeline[]{this.dragAndDrop, node};
                    this.reorderList.add(temp);
                }
            }
        }
        this.dragAndDrop = null;
        this.redraw();
        if (this.frame == null) {
            return;
        }
        this.frame.resetTimeCompression();
        if (this.local_auto_scroll_ != null) {
            this.local_auto_scroll_.cancel();
            this.local_auto_scroll_ = null;
        }
        super.contentsMouseUpEvent(event);
    }

    @Override
    protected void contentsMouseDownEvent(MouseEvent event) {
        if (this.currentGraphNode != null) {
            this.currentGraphNode.setFocused(false);
        }
        if (this.frame == null) {
            return;
        }
        this.frame.resetTimeCompression();
        this.ctrlSelection = (event.stateMask & 0x40000) != 0;
        if ((this.zoomInMode || this.zoomOutMode) && event.button == 1) {
            int cx = Math.round((float)event.x / this.zoomValue);
            int cy = Math.round((float)event.y / this.zoomValue);
            if (this.zoomInMode) {
                if (this.zoomValue < 64.0f) {
                    this.zoomValue *= 1.25f;
                }
            } else {
                this.zoomValue /= 1.25f;
            }
            int x = Math.round((float)cx * this.zoomValue - (float)this.getVisibleWidth() / 2.0f);
            int y = Math.round((float)cy * this.zoomValue - (float)this.getVisibleHeight() / 2.0f);
            this.setContentsPos(x, y);
            if (this.timeBar != null) {
                this.timeBar.setZoom(this.zoomValue);
            }
            this.redraw();
        } else {
            GraphNode node = null;
            if (this.frame != null) {
                int x = Math.round((float)event.x / this.zoomValue);
                int y = Math.round((float)event.y / this.zoomValue);
                node = this.frame.getNodeAt(x, y);
                if (event.button == 1 || node != null && !node.isSelected()) {
                    if (!this.shiftSelection) {
                        this.listStart = node;
                    }
                    if (this.shiftSelection) {
                        this.clearSelection();
                        this.addSelection(this.frame.getNodeList(this.listStart, node));
                    } else {
                        this.performSelection(node);
                    }
                    this.currentGraphNode = node;
                    if (node != null) {
                        node.setFocused(true);
                    }
                }
                this.redraw();
            }
        }
        if (this.dragAndDrop == null) {
            super.contentsMouseDownEvent(event);
        }
        this.getDragAndDrop = event.button == 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void performSelection(GraphNode node) {
        if (this.ctrlSelection || this.shiftSelection) {
            if (node == null) return;
            if (this.selectedNodeList.contains(node)) {
                this.removeSelection(node);
                return;
            } else {
                this.addSelection(node);
            }
            return;
        } else {
            this.clearSelection();
            if (node == null) return;
            this.addSelection(node);
        }
    }

    public List<GraphNode> getSelection() {
        return this.selectedNodeList;
    }

    public void addSelection(GraphNode node) {
        if (node == null) {
            return;
        }
        this.selectedNodeList.add(node);
        node.setSelected(true);
        this.currentGraphNode = node;
        StructuredSelection selection = new StructuredSelection(this.selectedNodeList);
        this.selProvider.setSelection((ISelection)selection);
    }

    public void addSelection(List<GraphNode> list) {
        int i = 0;
        while (i < list.size()) {
            if (!this.selectedNodeList.contains(list.get(i))) {
                this.selectedNodeList.add(list.get(i));
                list.get(i).setSelected(true);
            }
            ++i;
        }
        StructuredSelection selection = new StructuredSelection(this.selectedNodeList);
        this.selProvider.setSelection((ISelection)selection);
    }

    public void removeSelection(GraphNode node) {
        this.selectedNodeList.remove(node);
        node.setSelected(false);
        node.setFocused(false);
        StructuredSelection selection = new StructuredSelection(this.selectedNodeList);
        this.selProvider.setSelection((ISelection)selection);
    }

    public void removeSelection(List<GraphNode> list) {
        this.selectedNodeList.removeAll(list);
        int i = 0;
        while (i < list.size()) {
            list.get(i).setSelected(false);
            list.get(i).setFocused(false);
            ++i;
        }
        StructuredSelection selection = new StructuredSelection(this.selectedNodeList);
        this.selProvider.setSelection((ISelection)selection);
    }

    public void clearSelection() {
        int i = 0;
        while (i < this.selectedNodeList.size()) {
            this.selectedNodeList.get(i).setSelected(false);
            this.selectedNodeList.get(i).setFocused(false);
            ++i;
        }
        this.currentGraphNode = null;
        this.selectedNodeList.clear();
        this.selProvider.setSelection((ISelection)new StructuredSelection());
    }

    public void setSite(ViewPart viewSite) {
        this.site = viewSite;
        this.site.getSite().setSelectionProvider((ISelectionProvider)this.selProvider);
        IContextService service = (IContextService)this.site.getSite().getWorkbenchWindow().getService(IContextService.class);
        service.activateContext("org.eclipse.linuxtools.tmf.ui.view.uml2sd.context");
        service.activateContext("org.eclipse.ui.contexts.window");
    }

    protected Image getDrawBuffer(GC gc) {
        this.update();
        Rectangle area = this.getClientArea();
        Image dbuffer = null;
        GC gcim = null;
        try {
            dbuffer = new Image((Device)this.getDisplay(), area.width, area.height);
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        gcim = new GC((Drawable)dbuffer);
        NGC context = new NGC(this, gcim);
        Metrics.setLifelineFontHeight(context.getFontHeight(SDViewPref.getInstance().getFont("PREF_LIFELINE")));
        Metrics.setLifelineFontWidth(context.getFontWidth(SDViewPref.getInstance().getFont("PREF_LIFELINE")));
        Metrics.setLifelineWidth(SDViewPref.getInstance().getLifelineWidth());
        Metrics.setFrameFontHeight(context.getFontHeight(Frame.getUserPref().getFont("PREF_FRAME_NAME")));
        Metrics.setLifelineHeaderFontHeight(context.getFontHeight(Frame.getUserPref().getFont("PREF_LIFELINE_HEADER")));
        int syncMessFontH = context.getFontHeight(SDViewPref.getInstance().getFont("PREF_SYNC_MESS"));
        int syncMessRetFontH = context.getFontHeight(SDViewPref.getInstance().getFont("PREF_SYNC_MESS_RET"));
        int asyncMessFontH = context.getFontHeight(SDViewPref.getInstance().getFont("PREF_ASYNC_MESS"));
        int asyncMessRetFontH = context.getFontHeight(SDViewPref.getInstance().getFont("PREF_ASYNC_MESS_RET"));
        int messageFontHeight = 0;
        messageFontHeight = syncMessFontH > syncMessRetFontH ? syncMessFontH : syncMessRetFontH;
        if (messageFontHeight < asyncMessFontH) {
            messageFontHeight = asyncMessFontH;
        }
        if (messageFontHeight < asyncMessRetFontH) {
            messageFontHeight = asyncMessRetFontH;
        }
        Metrics.setMessageFontHeight(messageFontHeight);
        context.setFont(SDViewPref.getInstance().getFont("PREF_LIFELINE"));
        int width = (int)((float)(this.frame.getWidth() + 20) * this.zoomValue);
        int height = (int)((float)(this.frame.getHeight() + 20) * this.zoomValue);
        this.resizeContents(width, height);
        context.setBackground(Frame.getUserPref().getBackGroundColor("PREF_FRAME"));
        context.fillRectangle(0, 0, this.getContentsWidth(), 10);
        context.fillRectangle(0, 0, this.frame.getX(), this.getContentsHeight());
        context.fillRectangle(this.frame.getX() + this.frame.getWidth() + 1, 0, this.getContentsWidth() - (this.frame.getX() + this.frame.getWidth() + 1), this.getContentsHeight());
        context.fillRectangle(0, this.frame.getY() + this.frame.getHeight() + 1, this.getContentsWidth(), this.getContentsHeight() - (this.frame.getY() + this.frame.getHeight() + 1));
        gcim.setLineWidth(1);
        this.frame.draw(context);
        if (this.dragAndDrop != null) {
            Lifeline node = this.dragAndDrop;
            boolean isSelected = this.dragAndDrop.isSelected();
            boolean hasFocus = this.dragAndDrop.hasFocus();
            node.setSelected(false);
            node.setFocused(false);
            node.draw(context, this.dragX, this.dragY);
            node.setSelected(isSelected);
            node.setFocused(hasFocus);
        }
        gcim.dispose();
        context.dispose();
        return dbuffer;
    }

    @Override
    protected void drawContents(GC gc, int clipx, int clipy, int clipw, int cliph) {
        if (this.frame == null) {
            gc.setBackground(this.getDisplay().getSystemColor(1));
            gc.fillRectangle(0, 0, this.getVisibleWidth(), this.getVisibleHeight());
            gc.dispose();
            return;
        }
        Frame.setUserPref(SDViewPref.getInstance());
        Rectangle area = this.getClientArea();
        Image dbuffer = this.getDrawBuffer(gc);
        int height = Math.round((float)(this.frame.getHeight() + 20) * this.zoomValue);
        try {
            gc.drawImage(dbuffer, 0, 0, area.width, area.height, 0, 0, area.width, area.height);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        dbuffer.dispose();
        this.setHScrollBarIncrement(Math.round((float)SDViewPref.getInstance().getLifelineWidth() / 2.0f * this.zoomValue));
        this.setVScrollBarIncrement(Math.round((float)Metrics.getMessagesSpacing() * this.zoomValue));
        if (this.timeBar != null && this.frame.hasTimeInfo()) {
            this.timeBar.resizeContents(9, height + this.getHorizontalBarHeight());
            this.timeBar.setContentsPos(this.getContentsX(), this.getContentsY());
            this.timeBar.redraw();
            this.timeBar.update();
        }
        float xRatio = (float)this.getContentsWidth() / (float)this.getVisibleWidth();
        float yRatio = (float)this.getContentsHeight() / (float)this.getVisibleHeight();
        if (yRatio > xRatio) {
            this.setOverviewSize((int)((double)this.getVisibleHeight() * 0.75));
        } else {
            this.setOverviewSize((int)((double)this.getVisibleWidth() * 0.75));
        }
    }

    public GraphNode getMouseOverNode() {
        return this.currentGraphNode;
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.widget == this.zoomIn) {
            this.zoomValue *= 2.0f;
        } else if (event.widget == this.zoomOut) {
            this.zoomValue /= 2.0f;
        }
        this.redraw();
    }

    public void setZoomInMode(boolean value) {
        if (value) {
            this.setZoomOutMode(false);
        }
        this.zoomInMode = value;
    }

    public void setZoomOutMode(boolean value) {
        if (value) {
            this.setZoomInMode(false);
        }
        this.zoomOutMode = value;
    }

    public void moveTo(GraphNode node) {
        if (node == null) {
            return;
        }
        this.clearSelection();
        this.addSelection(node);
        this.ensureVisible(node);
    }

    public void ensureVisible(GraphNode node) {
        if (node == null) {
            return;
        }
        int x = Math.round((float)node.getX() * this.zoomValue);
        int y = Math.round((float)node.getY() * this.zoomValue);
        int width = Math.round((float)node.getWidth() * this.zoomValue);
        int height = Math.round((float)node.getHeight() * this.zoomValue);
        if (node instanceof BaseMessage && height == 0) {
            int header = 8 + Metrics.getLifelineHeaderFontHeigth();
            height = -Math.round((float)(Metrics.getMessagesSpacing() + header) * this.zoomValue);
            y += Math.round(10.0f * this.zoomValue);
        }
        if (node instanceof BasicExecutionOccurrence) {
            width = 1;
            height = 1;
        }
        if (node instanceof Lifeline) {
            y = this.getContentsY();
            height = this.getVisibleHeight();
        }
        this.ensureVisible(x, y, width, height, 0x1000000, true);
        this.redraw();
    }

    public float getZoomFactor() {
        return this.zoomValue;
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (this.frame != null && !this.isDisposed()) {
            this.frame.resetTimeCompression();
        }
        if (e.getProperty().equals("PREFOK")) {
            if (this.overView != null) {
                this.overView.dispose();
            }
            this.overView = null;
            this.redraw();
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        if (this.overView != null) {
            this.overView.dispose();
        }
        super.removeDisposeListener((DisposeListener)this);
        if (this.currentCaretImage != null && !this.currentCaretImage.isDisposed()) {
            this.currentCaretImage.dispose();
        }
        if (this.arrowUpCaretImg != null && !this.arrowUpCaretImg.isDisposed()) {
            this.arrowUpCaretImg.dispose();
        }
        if (this.collapaseCaretImg != null && !this.collapaseCaretImg.isDisposed()) {
            this.collapaseCaretImg.dispose();
        }
        SDViewPref.getInstance().removePropertyChangeListener(this);
        LoadersManager lm = LoadersManager.getInstance();
        if (this.site != null && this.site instanceof SDView) {
            ((SDView)this.site).resetProviders();
            if (lm != null) {
                lm.resetLoader(((SDView)this.site).getViewSite().getId());
            }
        }
    }

    public Image getOverview(Rectangle r) {
        float oldzoom = this.zoomValue;
        if (this.overView != null && (r.width != this.overView.getBounds().width || r.height != this.overView.getBounds().height)) {
            this.overView.dispose();
            this.overView = null;
        }
        if (this.overView == null) {
            int backX = this.getContentsX();
            int backY = this.getContentsY();
            this.setContentsPos(0, 0);
            this.overView = new Image((Device)this.getDisplay(), r.width, r.height);
            GC gcim = new GC((Drawable)this.overView);
            NGC context = new NGC(this, gcim);
            context.setBackground(SDViewPref.getInstance().getBackGroundColor("PREF_FRAME"));
            this.frame.draw(context);
            this.setContentsPos(backX, backY);
            gcim.dispose();
            context.dispose();
        }
        this.zoomValue = oldzoom;
        return this.overView;
    }

    @Override
    protected void drawOverview(GC gc, Rectangle r) {
        float oldzoom = this.zoomValue;
        this.zoomValue = this.getContentsWidth() > this.getContentsHeight() ? (float)r.width / (float)this.getContentsWidth() * oldzoom : (float)r.height / (float)this.getContentsHeight() * oldzoom;
        if (this.overView != null && (r.width != this.overView.getBounds().width || r.height != this.overView.getBounds().height)) {
            this.overView.dispose();
            this.overView = null;
        }
        if (this.overView == null) {
            int backX = this.getContentsX();
            int backY = this.getContentsY();
            this.setContentsPos(0, 0);
            this.overView = new Image((Device)this.getDisplay(), r.width, r.height);
            GC gcim = new GC((Drawable)this.overView);
            NGC context = new NGC(this, gcim);
            context.setBackground(SDViewPref.getInstance().getBackGroundColor("PREF_FRAME"));
            this.frame.draw(context);
            this.setContentsPos(backX, backY);
            gcim.dispose();
            context.dispose();
        }
        if (this.overView != null && r.width == this.overView.getBounds().width && r.height == this.overView.getBounds().height) {
            gc.drawImage(this.overView, 0, 0, r.width, r.height, 0, 0, r.width, r.height);
        }
        this.zoomValue = oldzoom;
        super.drawOverview(gc, r);
    }

    @Override
    public void deltaSelected(Lifeline lifeline, int startEvent, int nbEvent, IColor color) {
        this.frame.highlightTimeCompression(lifeline, startEvent, nbEvent, color);
        this.ensureVisible(lifeline);
        int y1 = lifeline.getY() + lifeline.getHeight() + (Metrics.getMessageFontHeigth() + Metrics.getMessagesSpacing()) * startEvent;
        int y2 = lifeline.getY() + lifeline.getHeight() + (Metrics.getMessageFontHeigth() + Metrics.getMessagesSpacing()) * (startEvent + nbEvent);
        this.ensureVisible(lifeline.getX(), y1 - (Metrics.getLifelineHeaderFontHeigth() + 8), lifeline.getWidth(), y2 - y1 + 3, 0x1000200, true);
        this.redraw();
        this.update();
    }

    public void resetZoomFactor() {
        int currentX = Math.round((float)this.getContentsX() / this.zoomValue);
        int currentY = Math.round((float)this.getContentsY() / this.zoomValue);
        this.zoomValue = 1.0f;
        if (this.timeBar != null && !this.timeBar.isDisposed()) {
            this.timeBar.setZoom(this.zoomValue);
        }
        this.redraw();
        this.update();
        this.setContentsPos(currentX, currentY);
    }

    public void setReorderMode(boolean mode) {
        this.reorderMode = mode;
    }

    public ArrayList<Lifeline[]> getLifelineReoderList() {
        return this.reorderList;
    }

    public void setFocus(GraphNode node) {
        if (node == null) {
            return;
        }
        if (this.currentGraphNode != null) {
            this.currentGraphNode.setFocused(false);
        }
        this.currentGraphNode = node;
        node.setFocused(true);
        this.ensureVisible(node);
        this.setFocus(0);
    }

    public GraphNode getFocusNode() {
        return this.currentGraphNode;
    }

    public void traverseRight() {
        GraphNode selectedNode = this.getFocusNode();
        if (selectedNode == null) {
            this.traverseLeft();
        }
        GraphNode node = null;
        if (selectedNode instanceof BaseMessage && ((BaseMessage)selectedNode).getEndLifeline() != null) {
            node = this.frame.getCalledMessage((BaseMessage)selectedNode);
        }
        if (selectedNode instanceof BasicExecutionOccurrence) {
            selectedNode = ((BasicExecutionOccurrence)selectedNode).getLifeline();
        }
        if (node == null && selectedNode instanceof Lifeline) {
            int i = 0;
            while (i < this.frame.lifeLinesCount()) {
                if (selectedNode == this.frame.getLifeline(i) && i < this.frame.lifeLinesCount() - 1) {
                    node = this.frame.getLifeline(i + 1);
                    break;
                }
                ++i;
            }
        }
        if (node != null) {
            this.setFocus(node);
            this.redraw();
        }
    }

    public void traverseLeft() {
        GraphNode selectedNode = this.getFocusNode();
        GraphNode node = null;
        if (selectedNode instanceof BaseMessage && ((BaseMessage)selectedNode).getStartLifeline() != null) {
            node = this.frame.getCallerMessage((BaseMessage)selectedNode);
        }
        if (selectedNode instanceof BasicExecutionOccurrence) {
            selectedNode = ((BasicExecutionOccurrence)selectedNode).getLifeline();
        }
        if (node == null) {
            if (selectedNode instanceof BaseMessage && ((BaseMessage)selectedNode).getEndLifeline() != null) {
                selectedNode = ((BaseMessage)selectedNode).getEndLifeline();
            }
            int i = 0;
            while (i < this.frame.lifeLinesCount()) {
                if (selectedNode == this.frame.getLifeline(i) && i > 0) {
                    node = this.frame.getLifeline(i - 1);
                    break;
                }
                ++i;
            }
            if (this.frame.lifeLinesCount() > 0 && node == null) {
                node = this.frame.getLifeline(0);
            }
        }
        if (node != null) {
            this.setFocus(node);
            this.redraw();
        }
    }

    public void traverseUp() {
        GraphNode selectedNode = this.getFocusNode();
        if (selectedNode == null) {
            this.traverseLeft();
        }
        GraphNode node = null;
        if (selectedNode instanceof BaseMessage) {
            node = this.frame.getPrevLifelineMessage(((BaseMessage)selectedNode).getStartLifeline(), (BaseMessage)selectedNode);
        } else if (selectedNode instanceof Lifeline) {
            node = this.frame.getPrevLifelineMessage((Lifeline)selectedNode, null);
            if (!(node instanceof Lifeline)) {
                node = null;
            }
        } else if (selectedNode instanceof BasicExecutionOccurrence && (node = this.frame.getPrevExecOccurrence((BasicExecutionOccurrence)selectedNode)) == null) {
            node = ((BasicExecutionOccurrence)selectedNode).getLifeline();
        }
        if (node == null && selectedNode instanceof BaseMessage && ((BaseMessage)selectedNode).getStartLifeline() != null) {
            node = ((BaseMessage)selectedNode).getStartLifeline();
        }
        if (node != null) {
            this.setFocus(node);
            this.redraw();
        }
    }

    public void traverseDown() {
        GraphNode node;
        GraphNode selectedNode = this.getFocusNode();
        if (selectedNode == null) {
            this.traverseLeft();
        }
        if (selectedNode instanceof BaseMessage) {
            node = this.frame.getNextLifelineMessage(((BaseMessage)selectedNode).getStartLifeline(), (BaseMessage)selectedNode);
        } else if (selectedNode instanceof Lifeline) {
            node = this.frame.getFirstExecution((Lifeline)selectedNode);
        } else if (selectedNode instanceof BasicExecutionOccurrence) {
            node = this.frame.getNextExecOccurrence((BasicExecutionOccurrence)selectedNode);
        } else {
            return;
        }
        if (node != null) {
            this.setFocus(node);
            this.redraw();
        }
    }

    public void traverseHome() {
        GraphNode selectedNode = this.getFocusNode();
        if (selectedNode == null) {
            this.traverseLeft();
        }
        GraphNode node = null;
        if (selectedNode instanceof BaseMessage) {
            node = ((BaseMessage)selectedNode).getStartLifeline() != null ? this.frame.getNextLifelineMessage(((BaseMessage)selectedNode).getStartLifeline(), null) : this.frame.getNextLifelineMessage(((BaseMessage)selectedNode).getEndLifeline(), null);
        } else if (selectedNode instanceof Lifeline) {
            node = this.frame.getNextLifelineMessage((Lifeline)selectedNode, null);
        } else if (selectedNode instanceof BasicExecutionOccurrence) {
            node = this.frame.getFirstExecution(((BasicExecutionOccurrence)selectedNode).getLifeline());
        } else if (this.frame.lifeLinesCount() > 0) {
            Lifeline lifeline = this.frame.getLifeline(0);
            node = this.frame.getNextLifelineMessage(lifeline, null);
        }
        if (node != null) {
            this.setFocus(node);
            this.redraw();
        }
    }

    public void traverseEnd() {
        GraphNode node;
        GraphNode selectedNode = this.getFocusNode();
        if (selectedNode == null) {
            this.traverseLeft();
        }
        if (selectedNode instanceof BaseMessage) {
            node = this.frame.getPrevLifelineMessage(((BaseMessage)selectedNode).getStartLifeline(), null);
        } else if (selectedNode instanceof Lifeline) {
            node = this.frame.getPrevLifelineMessage((Lifeline)selectedNode, null);
        } else if (selectedNode instanceof BasicExecutionOccurrence) {
            node = this.frame.getLastExecOccurrence(((BasicExecutionOccurrence)selectedNode).getLifeline());
        } else if (this.frame.lifeLinesCount() > 0) {
            Lifeline lifeline = this.frame.getLifeline(0);
            node = this.frame.getPrevLifelineMessage(lifeline, null);
        } else {
            return;
        }
        if (node != null) {
            this.setFocus(node);
            this.redraw();
        }
    }

    public void printUI(SDPrintDialogUI sdPrinter) {
        PrinterData data = sdPrinter.getPrinterData();
        if (data == null || this.frame == null) {
            return;
        }
        this.printer = new Printer(data);
        String jobName = MessageFormat.format(SDMessages._116, String.valueOf(this.site.getContentDescription()), String.valueOf(this.frame.getName()));
        this.printer.startJob(jobName);
        GC gc = new GC((Drawable)this.printer);
        Frame.setUserPref(SDViewPref.getInstance());
        float lastZoom = this.zoomValue;
        Rectangle area = this.getClientArea();
        GC gcim = null;
        gcim = gc;
        NGC context = new NGC(this, gcim);
        Metrics.setLifelineFontHeight(context.getFontHeight(SDViewPref.getInstance().getFont("PREF_LIFELINE")));
        Metrics.setLifelineFontWidth(context.getFontWidth(SDViewPref.getInstance().getFont("PREF_LIFELINE")));
        Metrics.setLifelineWidth(SDViewPref.getInstance().getLifelineWidth());
        Metrics.setFrameFontHeight(context.getFontHeight(Frame.getUserPref().getFont("PREF_FRAME_NAME")));
        Metrics.setLifelineHeaderFontHeight(context.getFontHeight(Frame.getUserPref().getFont("PREF_LIFELINE_HEADER")));
        int syncMessFontH = context.getFontHeight(SDViewPref.getInstance().getFont("PREF_SYNC_MESS"));
        int syncMessRetFontH = context.getFontHeight(SDViewPref.getInstance().getFont("PREF_SYNC_MESS_RET"));
        int asyncMessFontH = context.getFontHeight(SDViewPref.getInstance().getFont("PREF_ASYNC_MESS"));
        int asyncMessRetFontH = context.getFontHeight(SDViewPref.getInstance().getFont("PREF_ASYNC_MESS_RET"));
        int messageFontHeight = 0;
        messageFontHeight = syncMessFontH > syncMessRetFontH ? syncMessFontH : syncMessRetFontH;
        if (messageFontHeight < asyncMessFontH) {
            messageFontHeight = asyncMessFontH;
        }
        if (messageFontHeight < asyncMessRetFontH) {
            messageFontHeight = asyncMessRetFontH;
        }
        Metrics.setMessageFontHeight(messageFontHeight);
        context.setFont(SDViewPref.getInstance().getFont("PREF_LIFELINE"));
        int width = Math.round((float)(this.frame.getWidth() + 20) * this.zoomValue);
        int height = Math.round((float)(this.frame.getHeight() + 20) * this.zoomValue);
        if (width < area.width) {
            width = area.width;
        }
        if (height < area.height) {
            height = area.height;
        }
        this.resizeContents(width, height);
        context.setBackground(Frame.getUserPref().getBackGroundColor("PREF_FRAME"));
        context.fillRectangle(0, 0, this.getContentsWidth(), 10);
        context.fillRectangle(0, 0, this.frame.getX(), this.getContentsHeight());
        context.fillRectangle(this.frame.getX() + this.frame.getWidth() + 1, 0, this.getContentsWidth() - (this.frame.getX() + this.frame.getWidth() + 1), this.getContentsHeight());
        context.fillRectangle(0, this.frame.getY() + this.frame.getHeight() + 1, this.getContentsWidth(), this.getContentsHeight() - (this.frame.getY() + this.frame.getHeight() + 1));
        gcim.setLineWidth(1);
        this.printer.startPage();
        this.zoomValue = lastZoom;
        int restoreX = this.getContentsX();
        int restoreY = this.getContentsY();
        float zh = this.getContentsHeight();
        float zw = this.getContentsWidth();
        zh = sdPrinter.getStepY() * sdPrinter.getZoomFactor();
        zw = sdPrinter.getStepX() * sdPrinter.getZoomFactor();
        float zoomValueH = (float)this.printer.getClientArea().height / zh;
        float zoomValueW = (float)this.printer.getClientArea().width / zw;
        this.printerZoom = zoomValueH > zoomValueW ? zoomValueH : zoomValueW;
        if (sdPrinter.printSelection()) {
            int[] pagesList = sdPrinter.getPageList();
            int pageIndex = 0;
            while (pageIndex < pagesList.length) {
                this.printPage(pagesList[pageIndex], sdPrinter, context);
                ++pageIndex;
            }
        } else if (sdPrinter.printAll()) {
            int pageIndex = 1;
            while (pageIndex <= sdPrinter.maxNumOfPages()) {
                this.printPage(pageIndex, sdPrinter, context);
                ++pageIndex;
            }
        } else if (sdPrinter.printCurrent()) {
            this.printPage(this.getContentsX(), this.getContentsY(), sdPrinter, context, 1);
        } else if (sdPrinter.printRange()) {
            int pageIndex = sdPrinter.getFrom();
            while (pageIndex <= sdPrinter.maxNumOfPages() && pageIndex <= sdPrinter.getTo()) {
                this.printPage(pageIndex, sdPrinter, context);
                ++pageIndex;
            }
        }
        this.printer.endJob();
        this.printing = false;
        gc.dispose();
        context.dispose();
        this.zoomValue = lastZoom;
        this.printer.dispose();
        this.setContentsPos(restoreX, restoreY);
    }

    public void print() {
        SDPrintDialog sdPrinter = new SDPrintDialog(this.getShell(), this);
        try {
            if (sdPrinter.open() != 0) {
                return;
            }
        }
        catch (Exception exception) {}
        this.printUI(sdPrinter.getDialogUI());
    }

    public void printPage(int pageNum, SDPrintDialogUI pd, NGC context) {
        int j = pageNum / pd.getNbRow();
        int i = pageNum % pd.getNbRow();
        if (i != 0) {
            ++j;
        } else {
            i = pd.getNbRow();
        }
        --i;
        --j;
        i = (int)((float)i * pd.getStepX());
        j = (int)((float)j * pd.getStepY());
        this.printPage(i, j, pd, context, pageNum);
        this.printer.endPage();
    }

    public void printPage(int i, int j, SDPrintDialogUI pd, NGC context, int pageNum) {
        this.printing = false;
        int pageNumFontZoom = this.printer.getClientArea().height / this.getVisibleHeight();
        this.printerX = i;
        this.printerY = j;
        this.setContentsPos(i, j);
        this.update();
        this.printing = true;
        float lastZoom = this.zoomValue;
        this.zoomValue = this.printerZoom * lastZoom;
        this.frame.draw(context);
        this.zoomValue = pageNumFontZoom;
        context.setFont(SDViewPref.getInstance().getFont("PREF_LIFELINE"));
        String currentPageNum = String.valueOf(pageNum);
        int ii = context.textExtent(currentPageNum);
        int jj = context.getCurrentFontHeight();
        this.zoomValue = this.printerZoom * lastZoom;
        context.drawText(currentPageNum, Math.round((float)this.printerX + (float)this.getVisibleWidth() / this.printerZoom - (float)ii / this.printerZoom), Math.round((float)this.printerY + (float)this.getVisibleHeight() / this.printerZoom - (float)jj / this.printerZoom), false);
        this.printing = false;
        this.zoomValue = lastZoom;
    }

    @Override
    public int getVisibleWidth() {
        if (this.printing) {
            return this.printer.getClientArea().width;
        }
        return super.getVisibleWidth();
    }

    @Override
    public int getVisibleHeight() {
        if (this.printing) {
            return this.printer.getClientArea().height;
        }
        return super.getVisibleHeight();
    }

    @Override
    public int contentsToViewX(int _x) {
        if (this.printing) {
            int v = Math.round((float)this.printerX * this.printerZoom);
            return _x - v;
        }
        return _x - this.getContentsX();
    }

    @Override
    public int contentsToViewY(int _y) {
        if (this.printing) {
            int v = Math.round((float)this.printerY * this.printerZoom);
            return _y - v;
        }
        return _y - this.getContentsY();
    }

    @Override
    public int getContentsX() {
        if (this.printing) {
            return Math.round((float)this.printerX * this.printerZoom);
        }
        return super.getContentsX();
    }

    @Override
    public int getContentsY() {
        if (this.printing) {
            return Math.round((float)this.printerY * this.printerZoom);
        }
        return super.getContentsY();
    }

    public Printer getPrinter() {
        return this.printer;
    }

    public boolean isPrinting() {
        return this.printing;
    }

    protected static class AutoScroll
    extends TimerTask {
        public int dx_;
        public int dy_;
        public SDWidget sv_;

        public AutoScroll(SDWidget _sv, int _dx, int _dy) {
            this.sv_ = _sv;
            this.dx_ = _dx;
            this.dy_ = _dy;
        }

        @Override
        public void run() {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (AutoScroll.this.sv_.isDisposed()) {
                        return;
                    }
                    AutoScroll.this.sv_.dragX += AutoScroll.this.dx_;
                    AutoScroll.this.sv_.dragY += AutoScroll.this.dy_;
                    AutoScroll.this.sv_.scrollBy(AutoScroll.this.dx_, AutoScroll.this.dy_);
                }
            });
        }
    }
}

