/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.uml2sd.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.linuxtools.tmf.core.event.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.event.TmfTimestamp;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.AsyncMessage;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.Frame;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.GraphNode;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.ITimeRange;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.Lifeline;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.Metrics;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.SDTimeEvent;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.drawings.IGC;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.drawings.ISDPreferences;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.preferences.SDViewPref;

public class BasicFrame
extends GraphNode {
    protected ITmfTimestamp maxTime = new TmfTimestamp(0L);
    protected ITmfTimestamp minTime = new TmfTimestamp(0L);
    protected boolean computeMinMax = true;
    protected boolean lastExternalTimePref = SDViewPref.getInstance().excludeExternalTime();
    protected int verticalIndex = 0;
    protected int horizontalIndex = 0;
    protected boolean timeInfo = false;
    protected int visibleAreaX;
    protected int visibleAreaY;
    protected int visibleAreaWidth;
    protected int visibleAreaHeight;
    static ISDPreferences userPref = null;
    protected int forceEventOccurrenceSpacing = -1;
    protected boolean customMinMax = false;
    protected ITmfTimestamp minSDTime = new TmfTimestamp();
    protected ITmfTimestamp maxSDTime = new TmfTimestamp();
    protected boolean initSDMin = true;

    public BasicFrame() {
        Metrics.setForcedEventSpacing(this.forceEventOccurrenceSpacing);
    }

    protected int getMaxEventOccurrence() {
        return this.verticalIndex;
    }

    protected void setMaxEventOccurrence(int eventOccurrence) {
        this.verticalIndex = eventOccurrence;
    }

    protected int getNewHorizontalIndex() {
        return ++this.horizontalIndex;
    }

    protected int getHorizontalIndex() {
        return this.horizontalIndex;
    }

    @Override
    public void addNode(GraphNode nodeToAdd) {
        this.computeMinMax = true;
        super.addNode(nodeToAdd);
    }

    @Override
    public int getX() {
        return 10;
    }

    @Override
    public int getY() {
        return 10;
    }

    @Override
    public int getWidth() {
        if (this.horizontalIndex == 0) {
            return 3 * Metrics.swimmingLaneWidth() + 46 - 10 - 22;
        }
        return this.horizontalIndex * Metrics.swimmingLaneWidth() + 46 + 1 - 45;
    }

    @Override
    public int getHeight() {
        if (this.verticalIndex == 0) {
            return 5 * (Metrics.getMessagesSpacing() + Metrics.getMessageFontHeigth()) + 14 + 4 + Metrics.getFrameFontHeigth() + 30 + 20 + 14 + 4 + Metrics.getLifelineFontHeigth() * 2;
        }
        if (this.forceEventOccurrenceSpacing >= 0) {
            Metrics.setForcedEventSpacing(this.forceEventOccurrenceSpacing);
        }
        return this.verticalIndex * (Metrics.getMessagesSpacing() + Metrics.getMessageFontHeigth()) + 14 + 4 + Metrics.getFrameFontHeigth() + 30 + 20 + 14 + 4 + Metrics.getLifelineFontHeigth() * 2;
    }

    @Override
    protected GraphNode getNodeFromListAt(int x, int y, List<GraphNode> list, int fromIndex) {
        if (list == null) {
            return null;
        }
        int i = fromIndex;
        while (i < list.size()) {
            GraphNode node = list.get(i);
            if (node instanceof Lifeline && node.getX() > this.visibleAreaX + this.visibleAreaWidth || (node.getHeight() >= 0 ? node.getY() > this.visibleAreaY + this.visibleAreaHeight : node.getY() + node.getHeight() > this.visibleAreaY + this.visibleAreaHeight)) break;
            if (node.contains(x, y)) {
                return node;
            }
            ++i;
        }
        return null;
    }

    protected void drawFrame(IGC context) {
        context.setBackground(Frame.getUserPref().getBackGroundColor("PREF_FRAME"));
        context.setForeground(Frame.getUserPref().getForeGroundColor("PREF_FRAME"));
        int x = this.getX();
        int y = this.getY();
        int w = this.getWidth();
        int h = this.getHeight();
        context.fillRectangle(x, y, w, h);
        context.drawRectangle(x, y, w, h);
        context.setBackground(Frame.getUserPref().getBackGroundColor("PREF_FRAME_NAME"));
        context.setForeground(Frame.getUserPref().getForeGroundColor("PREF_FRAME_NAME"));
        context.setFont(Frame.getUserPref().getFont("PREF_FRAME_NAME"));
        int nameWidth = context.textExtent(this.getName()) + 16;
        int nameHeight = Metrics.getFrameFontHeigth() + 8;
        if (nameWidth > w) {
            nameWidth = w;
        }
        int[] points = new int[]{x, y, x + nameWidth, y, x + nameWidth, y - 11 + nameHeight, x - 11 + nameWidth, y + nameHeight, x, y + nameHeight, x, y + nameHeight};
        context.fillPolygon(points);
        context.drawPolygon(points);
        context.drawLine(x, y, x, y + nameHeight);
        context.setForeground(Frame.getUserPref().getFontColor("PREF_FRAME_NAME"));
        context.drawTextTruncatedCentred(this.getName(), x, y, nameWidth - 11, nameHeight, false);
        context.setBackground(Frame.getUserPref().getBackGroundColor("PREF_FRAME"));
        context.setForeground(Frame.getUserPref().getForeGroundColor("PREF_FRAME"));
    }

    @Override
    public void draw(IGC context) {
        this.draw(context, true);
    }

    protected void draw(IGC context, boolean drawFrame) {
        this.visibleAreaHeight = context.getVisibleHeight();
        this.visibleAreaWidth = context.getVisibleWidth();
        this.visibleAreaX = context.getContentsX();
        this.visibleAreaY = context.getContentsY();
        if (this.forceEventOccurrenceSpacing >= 0) {
            Metrics.setForcedEventSpacing(this.forceEventOccurrenceSpacing);
        } else {
            Metrics.setForcedEventSpacing(-1);
        }
        if (userPref == null) {
            return;
        }
        super.drawChildenNodes(context);
    }

    public static void setUserPref(ISDPreferences pref) {
        userPref = pref;
    }

    public static ISDPreferences getUserPref() {
        return userPref;
    }

    public void forceEventOccurrenceSpacing(int space) {
        this.forceEventOccurrenceSpacing = space;
    }

    public int getVisibleAreaX() {
        return this.visibleAreaX;
    }

    public int getVisibleAreaWidth() {
        return this.visibleAreaWidth;
    }

    public int getVisibleAreaHeight() {
        return this.visibleAreaHeight;
    }

    public int getVisibleAreaY() {
        return this.visibleAreaY;
    }

    public ITmfTimestamp getMinTime() {
        if (this.lastExternalTimePref != SDViewPref.getInstance().excludeExternalTime()) {
            this.lastExternalTimePref = SDViewPref.getInstance().excludeExternalTime();
            this.computeMinMax = true;
        }
        if (this.computeMinMax && !this.customMinMax) {
            this.computeMinMax();
            this.computeMinMax = false;
        }
        return this.minTime;
    }

    public void setMin(ITmfTimestamp min) {
        this.minTime = min;
        this.customMinMax = true;
    }

    public void setMax(ITmfTimestamp max) {
        this.maxTime = max;
        this.customMinMax = true;
    }

    public void resetCustomMinMax() {
        this.customMinMax = false;
        this.computeMinMax = true;
    }

    public ITmfTimestamp getMaxTime() {
        if (this.lastExternalTimePref != SDViewPref.getInstance().excludeExternalTime()) {
            this.lastExternalTimePref = SDViewPref.getInstance().excludeExternalTime();
            this.computeMinMax = true;
        }
        if (this.computeMinMax) {
            this.computeMinMax();
            this.computeMinMax = false;
        }
        return this.maxTime;
    }

    protected void computeMaxMinTime() {
        if (!this.initSDMin) {
            return;
        }
        List<SDTimeEvent> timeArray = this.buildTimeArray();
        if (timeArray == null) {
            return;
        }
        int i = 0;
        while (i < timeArray.size()) {
            SDTimeEvent m = timeArray.get(i);
            if (m.getTime().compareTo(this.maxSDTime, true) > 0) {
                this.maxSDTime = m.getTime();
            }
            if (m.getTime().compareTo(this.minSDTime, true) < 0 || this.initSDMin) {
                this.minSDTime = m.getTime();
                this.initSDMin = false;
            }
            ++i;
        }
    }

    public ITmfTimestamp getSDMinTime() {
        this.computeMaxMinTime();
        return this.minSDTime;
    }

    public ITmfTimestamp getSDMaxTime() {
        this.computeMaxMinTime();
        return this.maxSDTime;
    }

    protected void computeMinMax() {
        List<SDTimeEvent> timeArray = this.buildTimeArray();
        if (timeArray == null) {
            return;
        }
        int i = 0;
        while (i < timeArray.size() - 1) {
            SDTimeEvent m1 = timeArray.get(i);
            SDTimeEvent m2 = timeArray.get(i + 1);
            this.updateMinMax(m1, m2);
            ++i;
        }
    }

    protected void updateMinMax(SDTimeEvent m1, SDTimeEvent m2) {
        ITmfTimestamp delta = m2.getTime().getDelta(m1.getTime());
        if (this.computeMinMax) {
            this.minTime = delta.clone();
            if (this.minTime.compareTo(TmfTimestamp.ZERO, false) < 0) {
                this.minTime = new TmfTimestamp(0L, m1.getTime().getScale(), m1.getTime().getPrecision());
            }
            this.maxTime = this.minTime.clone();
            this.computeMinMax = false;
        }
        if (delta.compareTo(this.minTime, true) < 0 && delta.compareTo(TmfTimestamp.ZERO, false) > 0) {
            this.minTime = delta.clone();
        }
        if (delta.compareTo(this.maxTime, true) > 0 && delta.compareTo(TmfTimestamp.ZERO, false) > 0) {
            this.maxTime = delta.clone();
        }
    }

    protected List<SDTimeEvent> buildTimeArray() {
        if (!this.hasChilden) {
            return null;
        }
        Iterator it = this.fSort.keySet().iterator();
        ArrayList<SDTimeEvent> timeArray = new ArrayList<SDTimeEvent>();
        while (it.hasNext()) {
            String nodeType = (String)it.next();
            List list = (List)this.nodes.get(nodeType);
            int i = 0;
            while (i < list.size()) {
                Object timedNode = list.get(i);
                if (timedNode instanceof ITimeRange && ((ITimeRange)timedNode).hasTimeInfo()) {
                    int event = ((GraphNode)list.get(i)).getStartOccurrence();
                    ITmfTimestamp time = ((ITimeRange)list.get(i)).getStartTime();
                    SDTimeEvent f = new SDTimeEvent(time, event, (ITimeRange)list.get(i));
                    timeArray.add(f);
                    if (event != ((GraphNode)list.get(i)).getEndOccurrence()) {
                        event = ((AsyncMessage)list.get(i)).getEndOccurrence();
                        time = ((ITimeRange)list.get(i)).getEndTime();
                        f = new SDTimeEvent(time, event, (ITimeRange)list.get(i));
                        timeArray.add(f);
                    }
                }
                ++i;
            }
        }
        return timeArray;
    }

    @Override
    public String getArrayId() {
        return null;
    }

    @Override
    public boolean contains(int x, int y) {
        return false;
    }
}

