/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.dataviewers.charts.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.linuxtools.dataviewers.abstractviewers.AbstractSTViewer;
import org.eclipse.linuxtools.dataviewers.charts.Activator;
import org.eclipse.linuxtools.dataviewers.charts.dialogs.ChartDialog;
import org.eclipse.linuxtools.dataviewers.charts.view.ChartView;
import org.eclipse.swt.widgets.Shell;
import org.swtchart.Chart;

public class ChartAction
extends Action {
    private ChartDialog dialog;

    public ChartAction(Shell shell, AbstractSTViewer viewer) {
        super("Create chart...", Activator.getImageDescriptor("icons/chart_icon.png"));
        this.dialog = this.createDialog(shell, viewer);
        this.setEnabled(!viewer.getViewer().getSelection().isEmpty());
        viewer.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ChartAction.this.setEnabled(!event.getSelection().isEmpty());
            }
        });
    }

    public void run() {
        this.dialog.open();
        Chart chart = this.dialog.getValue();
        if (chart != null) {
            ChartView.createChartView(chart);
        }
    }

    protected ChartDialog createDialog(Shell shell, AbstractSTViewer viewer) {
        return new ChartDialog(shell, viewer);
    }
}

