/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng.jni.common;

import org.eclipse.linuxtools.internal.lttng.jni.common.Jni_C_Constant;

public class JniTime
extends Jni_C_Constant
implements Comparable<JniTime> {
    private long time = 0L;

    public JniTime() {
        this.time = 0L;
    }

    public JniTime(JniTime oldTime) {
        this.time = oldTime.getTime();
    }

    public JniTime(long newSec, long newNanoSec) {
        this.time = newSec * 1000000000L + newNanoSec;
    }

    public JniTime(long newNanoSecTime) {
        this.time = newNanoSecTime;
    }

    public long getSeconds() {
        return this.time / 1000000000L;
    }

    public long getNanoSeconds() {
        return this.time % 1000000000L;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long newTime) {
        this.time = newTime;
    }

    private void setTimeFromC(long newTime) {
        this.time = newTime;
    }

    public boolean isSmallerOrEqual(JniTime comparedTime) {
        return this.getTime() <= comparedTime.getTime();
    }

    @Override
    public int compareTo(JniTime right) {
        long rightTime;
        long leftTime = this.getTime();
        if (leftTime < (rightTime = right.getTime())) {
            return -1;
        }
        if (leftTime > rightTime) {
            return 1;
        }
        return 0;
    }

    public boolean equals(JniTime other) {
        return other != null && this.time == other.time;
    }

    public boolean equals(Object obj) {
        if (obj instanceof JniTime) {
            return ((JniTime)obj).time == this.time;
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        String returnData = "";
        returnData = String.valueOf(returnData) + "seconds     : " + this.getSeconds() + "\n";
        returnData = String.valueOf(returnData) + "nanoSeconds : " + this.getNanoSeconds() + "\n";
        return returnData;
    }
}

