/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.ui.views.control.handlers;

import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.ControlView;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.handlers.CommandParameter;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.messages.Messages;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public abstract class BaseControlViewHandler
extends AbstractHandler {
    protected final ReentrantLock fLock = new ReentrantLock();

    protected IWorkbenchPage getWorkbenchPage() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        IWorkbenchPart part = page.getActivePart();
        if (!(part instanceof ControlView)) {
            return null;
        }
        return page;
    }

    protected void refresh(final CommandParameter param) {
        Job job = new Job(Messages.TraceControl_RetrieveNodeConfigurationJob){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    param.getSession().getConfigurationFromNode(monitor);
                }
                catch (ExecutionException e) {
                    return new Status(4, "org.eclipse.linuxtools.lttng2.ui", Messages.TraceControl_ListSessionFailure, (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }
}

