/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.ctfadaptor;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.linuxtools.ctf.core.event.EventDeclaration;
import org.eclipse.linuxtools.ctf.core.event.EventDefinition;
import org.eclipse.linuxtools.ctf.core.trace.CTFReaderException;
import org.eclipse.linuxtools.ctf.core.trace.CTFTrace;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfIterator;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfLocation;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfTmfContent;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfTmfEvent;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfTmfEventType;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfTmfTimestamp;
import org.eclipse.linuxtools.tmf.core.event.ITmfEventField;
import org.eclipse.linuxtools.tmf.core.event.TmfTimestamp;
import org.eclipse.linuxtools.tmf.core.exceptions.TmfTraceException;
import org.eclipse.linuxtools.tmf.core.statesystem.IStateSystemQuerier;
import org.eclipse.linuxtools.tmf.core.trace.ITmfContext;
import org.eclipse.linuxtools.tmf.core.trace.ITmfEventParser;
import org.eclipse.linuxtools.tmf.core.trace.ITmfLocation;
import org.eclipse.linuxtools.tmf.core.trace.TmfTrace;

public class CtfTmfTrace
extends TmfTrace<CtfTmfEvent>
implements ITmfEventParser<CtfTmfEvent> {
    protected static final int DEFAULT_CACHE_SIZE = 50000;
    protected IStateSystemQuerier ss = null;
    private CTFTrace fTrace;

    @Override
    public void initTrace(IResource resource, String path, Class<CtfTmfEvent> eventType) throws TmfTraceException {
        this.setCacheSize();
        super.initTrace(resource, path, eventType);
        try {
            this.fTrace = new CTFTrace(path);
            int i = 0;
            while (i < this.fTrace.getNbEventTypes()) {
                EventDeclaration ed = this.fTrace.getEventType((long)i);
                ITmfEventField eventField = CtfTmfTrace.parseDeclaration(ed);
                new CtfTmfEventType(ed.getName(), eventField);
                ++i;
            }
            CtfIterator iterator = new CtfIterator(this, 0L, 0L);
            if (iterator.getLocation().equals(CtfIterator.NULL_LOCATION)) {
                this.setStartTime(TmfTimestamp.BIG_BANG);
            } else {
                this.setStartTime(iterator.getCurrentEvent().getTimestamp());
                this.setEndTime(iterator.getCurrentEvent().getTimestamp());
            }
        }
        catch (CTFReaderException e) {
            throw new TmfTraceException(e.getMessage(), e);
        }
        this.buildStateSystem();
        if (resource != null) {
            try {
                resource.getProject().refreshLocal(2, null);
            }
            catch (CoreException e) {
                throw new TmfTraceException(e.getMessage(), e);
            }
        }
    }

    @Override
    public boolean validate(IProject project, String path) {
        try {
            CTFTrace temp = new CTFTrace(path);
            return temp.majortIsSet();
        }
        catch (CTFReaderException cTFReaderException) {
            return false;
        }
    }

    @Override
    public ITmfLocation<?> getCurrentLocation() {
        return null;
    }

    @Override
    public double getLocationRatio(ITmfLocation<?> location) {
        CtfLocation curLocation = (CtfLocation)location;
        CtfIterator iterator = new CtfIterator(this);
        iterator.seek(curLocation.getLocation());
        return ((double)iterator.getCurrentEvent().getTimestampValue() - (double)iterator.getStartTime()) / (double)(iterator.getEndTime() - iterator.getStartTime());
    }

    @Override
    public ITmfContext seekEvent(ITmfLocation<?> location) {
        CtfLocation currentLocation = (CtfLocation)location;
        CtfIterator context = new CtfIterator(this);
        if (currentLocation == null) {
            currentLocation = new CtfLocation(0L);
            context.setRank(0L);
        }
        if (currentLocation.getLocation() == CtfLocation.INVALID_LOCATION) {
            ((CtfTmfTimestamp)this.getEndTime()).setType(CtfTmfTimestamp.TimestampType.NANOS);
            currentLocation.setLocation(this.getEndTime().getValue() + 1L);
        }
        context.setLocation((ITmfLocation<?>)currentLocation);
        if (context.getRank() != 0L) {
            context.setRank(-1L);
        }
        return context;
    }

    @Override
    public ITmfContext seekEvent(double ratio) {
        CtfIterator context = new CtfIterator(this);
        context.seek((long)((double)this.getNbEvents() * ratio));
        context.setRank(-1L);
        return context;
    }

    @Override
    public synchronized CtfTmfEvent getNext(ITmfContext context) {
        CtfIterator ctfIterator;
        CtfTmfEvent event = null;
        if (context instanceof CtfIterator && (event = (ctfIterator = (CtfIterator)context).getCurrentEvent()) != null) {
            this.updateAttributes(context, event.getTimestamp());
            ctfIterator.advance();
            ctfIterator.increaseRank();
        }
        return event;
    }

    protected void buildStateSystem() throws TmfTraceException {
    }

    public IStateSystemQuerier getStateSystem() {
        return this.ss;
    }

    private static ITmfEventField parseDeclaration(EventDeclaration ed) {
        EventDefinition eventDef = ed.createDefinition(null);
        return new CtfTmfContent(":root:", CtfTmfEvent.parseFields(eventDef));
    }

    public CTFTrace getCTFTrace() {
        return this.fTrace;
    }

    public int getNbEnvVars() {
        return this.fTrace.getEnvironment().size();
    }

    public String[] getEnvNames() {
        String[] s = new String[this.getNbEnvVars()];
        return this.fTrace.getEnvironment().keySet().toArray(s);
    }

    public String getEnvValue(String key) {
        return (String)this.fTrace.getEnvironment().get(key);
    }

    public long getOffset() {
        if (this.fTrace != null) {
            return this.fTrace.getOffset();
        }
        return 0L;
    }

    @Override
    public CtfTmfEvent parseEvent(ITmfContext context) {
        CtfTmfEvent event = null;
        if (context instanceof CtfIterator) {
            CtfIterator itt = (CtfIterator)context.clone();
            event = itt.getCurrentEvent();
        }
        return event;
    }

    protected void setCacheSize() {
        this.setCacheSize(50000);
    }
}

