"use strict";
(self["webpackChunkcdt_cloud_blueprint_app"] = self["webpackChunkcdt_cloud_blueprint_app"] || []).push([["vendors-node_modules_theia_remote_lib_electron-browser_port-forwarding_port-forwarding-servic-81d8fc"],{

/***/ "../../node_modules/@theia/remote/lib/electron-browser/port-forwarding/port-forwarding-service.js":
/*!********************************************************************************************************!*\
  !*** ../../node_modules/@theia/remote/lib/electron-browser/port-forwarding/port-forwarding-service.js ***!
  \********************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2024 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PortForwardingService = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const remote_port_forwarding_provider_1 = __webpack_require__(/*! ../../electron-common/remote-port-forwarding-provider */ "../../node_modules/@theia/remote/lib/electron-common/remote-port-forwarding-provider.js");
const electron_local_ws_connection_source_1 = __webpack_require__(/*! @theia/core/lib/electron-browser/messaging/electron-local-ws-connection-source */ "../../node_modules/@theia/core/lib/electron-browser/messaging/electron-local-ws-connection-source.js");
let PortForwardingService = class PortForwardingService {
    constructor() {
        this.onDidChangePortsEmitter = new core_1.Emitter();
        this.onDidChangePorts = this.onDidChangePortsEmitter.event;
        this.forwardedPorts = [];
    }
    init() {
        this.provider.getForwardedPorts().then(ports => {
            this.forwardedPorts = ports.map(p => ({ address: p.address, localPort: p.port, editing: false }));
            this.onDidChangePortsEmitter.fire();
        });
    }
    forwardNewPort(origin) {
        const index = this.forwardedPorts.push({ editing: true, origin });
        return this.forwardedPorts[index - 1];
    }
    updatePort(port, newAdress) {
        const connectionPort = (0, electron_local_ws_connection_source_1.getCurrentPort)();
        if (!connectionPort) {
            // if there is no open remote connection we can't forward a port
            return;
        }
        const parts = newAdress.split(':');
        if (parts.length === 2) {
            port.address = parts[0];
            port.localPort = parseInt(parts[1]);
        }
        else {
            port.localPort = parseInt(parts[0]);
        }
        port.editing = false;
        this.provider.forwardPort(parseInt(connectionPort), { port: port.localPort, address: port.address });
        this.onDidChangePortsEmitter.fire();
    }
    removePort(port) {
        const index = this.forwardedPorts.indexOf(port);
        if (index !== -1) {
            this.forwardedPorts.splice(index, 1);
            this.provider.portRemoved({ port: port.localPort });
            this.onDidChangePortsEmitter.fire();
        }
    }
    isValidAddress(address) {
        const match = address.match(/^(.*:)?\d+$/);
        if (!match) {
            return false;
        }
        const port = parseInt(address.includes(':') ? address.split(':')[1] : address);
        return !this.forwardedPorts.some(p => p.localPort === port);
    }
};
exports.PortForwardingService = PortForwardingService;
tslib_1.__decorate([
    (0, inversify_1.inject)(remote_port_forwarding_provider_1.RemotePortForwardingProvider),
    tslib_1.__metadata("design:type", Object)
], PortForwardingService.prototype, "provider", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], PortForwardingService.prototype, "init", null);
exports.PortForwardingService = PortForwardingService = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], PortForwardingService);


/***/ }),

/***/ "../../node_modules/@theia/remote/lib/electron-browser/remote-preferences.js":
/*!***********************************************************************************!*\
  !*** ../../node_modules/@theia/remote/lib/electron-browser/remote-preferences.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2023 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.bindRemotePreferences = exports.RemotePreferences = exports.RemotePreferenceContribution = exports.RemotePreferenceSchema = void 0;
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const preferences_1 = __webpack_require__(/*! @theia/core/lib/browser/preferences */ "../../node_modules/@theia/core/lib/browser/preferences/index.js");
const nls_1 = __webpack_require__(/*! @theia/core/lib/common/nls */ "../../node_modules/@theia/core/lib/common/nls.js");
const injectable_preference_proxy_1 = __webpack_require__(/*! @theia/core/lib/browser/preferences/injectable-preference-proxy */ "../../node_modules/@theia/core/lib/browser/preferences/injectable-preference-proxy.js");
const nodeDownloadTemplateParts = [
    nls_1.nls.localize('theia/remote/nodeDownloadTemplateVersion', '`{version}` for the used node version'),
    nls_1.nls.localize('theia/remote/nodeDownloadTemplateOS', '`{os}` for the remote operating system. Either `win`, `linux` or `darwin`.'),
    nls_1.nls.localize('theia/remote/nodeDownloadTemplateArch', '`{arch}` for the remote system architecture.'),
    nls_1.nls.localize('theia/remote/nodeDownloadTemplateExt', '`{ext}` for the file extension. Either `zip`, `tar.xz` or `tar.xz`, depending on the operating system.')
];
exports.RemotePreferenceSchema = {
    'type': 'object',
    properties: {
        'remote.nodeDownloadTemplate': {
            type: 'string',
            default: '',
            markdownDescription: nls_1.nls.localize('theia/remote/nodeDownloadTemplate', 'Controls the template used to download the node.js binaries for the remote backend. Points to the official node.js website by default. Uses multiple placeholders:') + '\n- ' + nodeDownloadTemplateParts.join('\n- ')
        },
        'remote.ssh.configFile': {
            type: 'string',
            default: core_1.OS.backend.isWindows ? '${env:USERPROFILE}\\.ssh\\config' : '${env:HOME}/.ssh/config',
            markdownDescription: nls_1.nls.localize('theia/remote/ssh/configFile', 'Remote SSH Config file')
        },
    }
};
exports.RemotePreferenceContribution = Symbol('RemotePreferenceContribution');
exports.RemotePreferences = Symbol('GettingStartedPreferences');
function bindRemotePreferences(bind) {
    bind(exports.RemotePreferences).toDynamicValue(ctx => {
        const factory = ctx.container.get(injectable_preference_proxy_1.PreferenceProxyFactory);
        return factory(exports.RemotePreferenceSchema);
    }).inSingletonScope();
    bind(exports.RemotePreferenceContribution).toConstantValue({ schema: exports.RemotePreferenceSchema });
    bind(preferences_1.PreferenceContribution).toService(exports.RemotePreferenceContribution);
}
exports.bindRemotePreferences = bindRemotePreferences;


/***/ }),

/***/ "../../node_modules/@theia/remote/lib/electron-browser/remote-registry-contribution.js":
/*!*********************************************************************************************!*\
  !*** ../../node_modules/@theia/remote/lib/electron-browser/remote-registry-contribution.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2023 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.RemoteRegistry = exports.AbstractRemoteRegistryContribution = exports.RemoteRegistryContribution = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const window_service_1 = __webpack_require__(/*! @theia/core/lib/browser/window/window-service */ "../../node_modules/@theia/core/lib/browser/window/window-service.js");
exports.RemoteRegistryContribution = Symbol('RemoteRegistryContribution');
let AbstractRemoteRegistryContribution = class AbstractRemoteRegistryContribution {
    openRemote(port, newWindow, workspace) {
        const searchParams = new URLSearchParams(location.search);
        const localPort = searchParams.get('localPort') || searchParams.get('port');
        const options = {
            search: { port }
        };
        if (localPort) {
            options.search.localPort = localPort;
        }
        if (workspace) {
            options.hash = workspace;
        }
        if (newWindow) {
            this.windowService.openNewDefaultWindow(options);
        }
        else {
            this.windowService.reload(options);
        }
    }
};
exports.AbstractRemoteRegistryContribution = AbstractRemoteRegistryContribution;
tslib_1.__decorate([
    (0, inversify_1.inject)(window_service_1.WindowService),
    tslib_1.__metadata("design:type", Object)
], AbstractRemoteRegistryContribution.prototype, "windowService", void 0);
exports.AbstractRemoteRegistryContribution = AbstractRemoteRegistryContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], AbstractRemoteRegistryContribution);
class RemoteRegistry {
    constructor() {
        this._commands = [];
        this.onDidRegisterCommandEmitter = new core_1.Emitter();
    }
    get commands() {
        return this._commands;
    }
    get onDidRegisterCommand() {
        return this.onDidRegisterCommandEmitter.event;
    }
    registerCommand(command, handler) {
        this.onDidRegisterCommandEmitter.fire([command, handler]);
        this._commands.push(command);
    }
}
exports.RemoteRegistry = RemoteRegistry;


/***/ }),

/***/ "../../node_modules/@theia/remote/lib/electron-common/remote-port-forwarding-provider.js":
/*!***********************************************************************************************!*\
  !*** ../../node_modules/@theia/remote/lib/electron-common/remote-port-forwarding-provider.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


// *****************************************************************************
// Copyright (C) 2024 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.RemotePortForwardingProvider = exports.RemoteRemotePortForwardingProviderPath = void 0;
exports.RemoteRemotePortForwardingProviderPath = '/remote/port-forwarding';
exports.RemotePortForwardingProvider = Symbol('RemoteSSHConnectionProvider');


/***/ }),

/***/ "../../node_modules/@theia/remote/lib/electron-common/remote-status-service.js":
/*!*************************************************************************************!*\
  !*** ../../node_modules/@theia/remote/lib/electron-common/remote-status-service.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


// *****************************************************************************
// Copyright (C) 2023 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.RemoteStatusService = exports.RemoteStatusServicePath = void 0;
exports.RemoteStatusServicePath = '/remote/status';
exports.RemoteStatusService = Symbol('RemoteStatusService');


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_theia_remote_lib_electron-browser_port-forwarding_port-forwarding-servic-81d8fc.js.map