"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GDBDebugSession = void 0;
/*********************************************************************
 * Copyright (c) 2018 QNX Software Systems and others
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *********************************************************************/
const fs = require("fs");
const debugadapter_1 = require("@vscode/debugadapter");
const GDBDebugSessionBase_1 = require("../gdb/GDBDebugSessionBase");
const GDBBackendFactory_1 = require("./factories/GDBBackendFactory");
class GDBDebugSession extends GDBDebugSessionBase_1.GDBDebugSessionBase {
    constructor(backendFactory) {
        super(backendFactory || new GDBBackendFactory_1.GDBBackendFactory());
        this.logger = debugadapter_1.logger;
    }
    /**
     * Main entry point
     */
    static run(debugSession) {
        GDBDebugSession.processArgv(process.argv.slice(2));
        debugadapter_1.DebugSession.run(debugSession);
    }
    /**
     * Parse an optional config file which is a JSON string of launch/attach request arguments.
     * The config can be a response file by starting with an @.
     */
    static processArgv(args) {
        args.forEach(function (val, _index, _array) {
            const configMatch = /^--config(-frozen)?=(.*)$/.exec(val);
            if (configMatch) {
                let configJson;
                const configStr = configMatch[2];
                if (configStr.startsWith('@')) {
                    const configFile = configStr.slice(1);
                    configJson = JSON.parse(fs.readFileSync(configFile).toString('utf8'));
                }
                else {
                    configJson = JSON.parse(configStr);
                }
                if (configMatch[1]) {
                    GDBDebugSession.frozenRequestArguments = configJson;
                }
                else {
                    GDBDebugSession.defaultRequestArguments = configJson;
                }
            }
        });
    }
    /**
     * Apply the initial and frozen launch/attach request arguments.
     * @param request the default request type to return if request type is not frozen
     * @param args the arguments from the user to apply initial and frozen arguments to.
     * @returns resolved request type and the resolved arguments
     */
    applyRequestArguments(request, args) {
        var _a;
        const frozenRequest = (_a = GDBDebugSession.frozenRequestArguments) === null || _a === void 0 ? void 0 : _a.request;
        if (frozenRequest === 'launch' || frozenRequest === 'attach') {
            request = frozenRequest;
        }
        return [
            request,
            Object.assign(Object.assign(Object.assign({}, GDBDebugSession.defaultRequestArguments), args), GDBDebugSession.frozenRequestArguments),
        ];
    }
}
exports.GDBDebugSession = GDBDebugSession;
//# sourceMappingURL=GDBDebugSession.js.map