"use strict";
(self["webpackChunkcdt_cloud_blueprint_app"] = self["webpackChunkcdt_cloud_blueprint_app"] || []).push([["vendors-node_modules_theia_core_lib_electron-browser_menu_electron-menu-module_js"],{

/***/ "../../node_modules/@theia/core/lib/browser/menu/browser-context-menu-renderer.js":
/*!****************************************************************************************!*\
  !*** ../../node_modules/@theia/core/lib/browser/menu/browser-context-menu-renderer.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2017 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BrowserContextMenuRenderer = exports.BrowserContextMenuAccess = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! inversify */ "../../node_modules/inversify/lib/cjs/index.js");
const context_menu_renderer_1 = __webpack_require__(/*! ../context-menu-renderer */ "../../node_modules/@theia/core/lib/browser/context-menu-renderer.js");
const browser_menu_plugin_1 = __webpack_require__(/*! ./browser-menu-plugin */ "../../node_modules/@theia/core/lib/browser/menu/browser-menu-plugin.js");
class BrowserContextMenuAccess extends context_menu_renderer_1.ContextMenuAccess {
    constructor(menu) {
        super(menu);
        this.menu = menu;
    }
}
exports.BrowserContextMenuAccess = BrowserContextMenuAccess;
let BrowserContextMenuRenderer = class BrowserContextMenuRenderer extends context_menu_renderer_1.ContextMenuRenderer {
    constructor(menuFactory) {
        super();
        this.menuFactory = menuFactory;
    }
    doRender({ menuPath, anchor, args, onHide, context, contextKeyService, skipSingleRootNode }) {
        const contextMenu = this.menuFactory.createContextMenu(menuPath, args, context, contextKeyService, skipSingleRootNode);
        const { x, y } = (0, context_menu_renderer_1.coordinateFromAnchor)(anchor);
        if (onHide) {
            contextMenu.aboutToClose.connect(() => onHide());
        }
        contextMenu.open(x, y, { host: context === null || context === void 0 ? void 0 : context.ownerDocument.body });
        return new BrowserContextMenuAccess(contextMenu);
    }
};
exports.BrowserContextMenuRenderer = BrowserContextMenuRenderer;
exports.BrowserContextMenuRenderer = BrowserContextMenuRenderer = tslib_1.__decorate([
    (0, inversify_1.injectable)(),
    tslib_1.__param(0, (0, inversify_1.inject)(browser_menu_plugin_1.BrowserMainMenuFactory)),
    tslib_1.__metadata("design:paramtypes", [browser_menu_plugin_1.BrowserMainMenuFactory])
], BrowserContextMenuRenderer);


/***/ }),

/***/ "../../node_modules/@theia/core/lib/electron-browser/menu/electron-context-menu-renderer.js":
/*!**************************************************************************************************!*\
  !*** ../../node_modules/@theia/core/lib/electron-browser/menu/electron-context-menu-renderer.js ***!
  \**************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2017 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ElectronContextMenuRenderer = exports.ElectronTextInputContextMenuContribution = exports.ElectronTextInputContextMenu = exports.ElectronContextMenuAccess = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
/* eslint-disable @typescript-eslint/no-explicit-any */
const inversify_1 = __webpack_require__(/*! inversify */ "../../node_modules/inversify/lib/cjs/index.js");
const browser_1 = __webpack_require__(/*! ../../browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const electron_main_menu_factory_1 = __webpack_require__(/*! ./electron-main-menu-factory */ "../../node_modules/@theia/core/lib/electron-browser/menu/electron-main-menu-factory.js");
const context_menu_context_1 = __webpack_require__(/*! ../../browser/menu/context-menu-context */ "../../node_modules/@theia/core/lib/browser/menu/context-menu-context.js");
const browser_context_menu_renderer_1 = __webpack_require__(/*! ../../browser/menu/browser-context-menu-renderer */ "../../node_modules/@theia/core/lib/browser/menu/browser-context-menu-renderer.js");
class ElectronContextMenuAccess extends browser_1.ContextMenuAccess {
    constructor(menuHandle) {
        super({
            dispose: () => menuHandle.then(handle => window.electronTheiaCore.closePopup(handle))
        });
        this.menuHandle = menuHandle;
    }
}
exports.ElectronContextMenuAccess = ElectronContextMenuAccess;
var ElectronTextInputContextMenu;
(function (ElectronTextInputContextMenu) {
    ElectronTextInputContextMenu.MENU_PATH = ['electron_text_input'];
    ElectronTextInputContextMenu.UNDO_REDO_EDIT_GROUP = [...ElectronTextInputContextMenu.MENU_PATH, '0_undo_redo_group'];
    ElectronTextInputContextMenu.EDIT_GROUP = [...ElectronTextInputContextMenu.MENU_PATH, '1_edit_group'];
    ElectronTextInputContextMenu.SELECT_GROUP = [...ElectronTextInputContextMenu.MENU_PATH, '2_select_group'];
})(ElectronTextInputContextMenu || (exports.ElectronTextInputContextMenu = ElectronTextInputContextMenu = {}));
let ElectronTextInputContextMenuContribution = class ElectronTextInputContextMenuContribution {
    onStart() {
        window.document.addEventListener('contextmenu', event => {
            if (event.target instanceof HTMLElement) {
                const target = event.target;
                if (target.nodeName && (target.nodeName.toLowerCase() === 'input' || target.nodeName.toLowerCase() === 'textarea')) {
                    event.preventDefault();
                    event.stopPropagation();
                    this.contextMenuRenderer.render({
                        anchor: event,
                        menuPath: ElectronTextInputContextMenu.MENU_PATH,
                        context: event.target,
                        onHide: () => target.focus()
                    });
                }
            }
        });
    }
    registerMenus(registry) {
        registry.registerMenuAction(ElectronTextInputContextMenu.UNDO_REDO_EDIT_GROUP, { commandId: browser_1.CommonCommands.UNDO.id });
        registry.registerMenuAction(ElectronTextInputContextMenu.UNDO_REDO_EDIT_GROUP, { commandId: browser_1.CommonCommands.REDO.id });
        registry.registerMenuAction(ElectronTextInputContextMenu.EDIT_GROUP, { commandId: browser_1.CommonCommands.CUT.id });
        registry.registerMenuAction(ElectronTextInputContextMenu.EDIT_GROUP, { commandId: browser_1.CommonCommands.COPY.id });
        registry.registerMenuAction(ElectronTextInputContextMenu.EDIT_GROUP, { commandId: browser_1.CommonCommands.PASTE.id });
        registry.registerMenuAction(ElectronTextInputContextMenu.SELECT_GROUP, { commandId: browser_1.CommonCommands.SELECT_ALL.id });
    }
};
exports.ElectronTextInputContextMenuContribution = ElectronTextInputContextMenuContribution;
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.ContextMenuRenderer),
    tslib_1.__metadata("design:type", browser_1.ContextMenuRenderer)
], ElectronTextInputContextMenuContribution.prototype, "contextMenuRenderer", void 0);
exports.ElectronTextInputContextMenuContribution = ElectronTextInputContextMenuContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], ElectronTextInputContextMenuContribution);
let ElectronContextMenuRenderer = class ElectronContextMenuRenderer extends browser_context_menu_renderer_1.BrowserContextMenuRenderer {
    constructor(electronMenuFactory) {
        super(electronMenuFactory);
        this.electronMenuFactory = electronMenuFactory;
        this.useNativeStyle = true;
    }
    init() {
        this.doInit();
    }
    async doInit() {
        this.useNativeStyle = await window.electronTheiaCore.getTitleBarStyleAtStartup() === 'native';
    }
    doRender(options) {
        var _a, _b, _c, _d;
        if (this.useNativeStyle) {
            const { menuPath, anchor, args, onHide, context, contextKeyService, skipSingleRootNode } = options;
            const menu = this.electronMenuFactory.createElectronContextMenu(menuPath, args, context, contextKeyService, skipSingleRootNode);
            const { x, y } = (0, browser_1.coordinateFromAnchor)(anchor);
            const windowName = (_b = (_a = options.context) === null || _a === void 0 ? void 0 : _a.ownerDocument.defaultView) === null || _b === void 0 ? void 0 : _b.Window.name;
            const menuHandle = window.electronTheiaCore.popup(menu, x, y, () => {
                if (onHide) {
                    onHide();
                }
            }, windowName);
            // native context menu stops the event loop, so there is no keyboard events
            this.context.resetAltPressed();
            return new ElectronContextMenuAccess(menuHandle);
        }
        else {
            const menuAccess = super.doRender(options);
            const node = menuAccess.menu.node;
            const topPanelHeight = (_d = (_c = document.getElementById('theia-top-panel')) === null || _c === void 0 ? void 0 : _c.clientHeight) !== null && _d !== void 0 ? _d : 0;
            // ensure the context menu is not displayed outside of the main area
            const menuRect = node.getBoundingClientRect();
            if (menuRect.top < topPanelHeight) {
                node.style.top = `${topPanelHeight}px`;
                node.style.maxHeight = `calc(${node.style.maxHeight} - ${topPanelHeight}px)`;
            }
            return menuAccess;
        }
    }
};
exports.ElectronContextMenuRenderer = ElectronContextMenuRenderer;
tslib_1.__decorate([
    (0, inversify_1.inject)(context_menu_context_1.ContextMenuContext),
    tslib_1.__metadata("design:type", context_menu_context_1.ContextMenuContext)
], ElectronContextMenuRenderer.prototype, "context", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.PreferenceService),
    tslib_1.__metadata("design:type", Object)
], ElectronContextMenuRenderer.prototype, "preferenceService", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], ElectronContextMenuRenderer.prototype, "init", null);
exports.ElectronContextMenuRenderer = ElectronContextMenuRenderer = tslib_1.__decorate([
    (0, inversify_1.injectable)(),
    tslib_1.__param(0, (0, inversify_1.inject)(electron_main_menu_factory_1.ElectronMainMenuFactory)),
    tslib_1.__metadata("design:paramtypes", [electron_main_menu_factory_1.ElectronMainMenuFactory])
], ElectronContextMenuRenderer);


/***/ }),

/***/ "../../node_modules/@theia/core/lib/electron-browser/menu/electron-menu-contribution.js":
/*!**********************************************************************************************!*\
  !*** ../../node_modules/@theia/core/lib/electron-browser/menu/electron-menu-contribution.js ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2017 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CustomTitleWidget = exports.ElectronMenuContribution = exports.CustomTitleWidgetFactory = exports.ElectronMenus = exports.ElectronCommands = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! inversify */ "../../node_modules/inversify/lib/cjs/index.js");
const common_1 = __webpack_require__(/*! ../../common */ "../../node_modules/@theia/core/lib/common/index.js");
const browser_1 = __webpack_require__(/*! ../../browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const electron_main_menu_factory_1 = __webpack_require__(/*! ./electron-main-menu-factory */ "../../node_modules/@theia/core/lib/electron-browser/menu/electron-main-menu-factory.js");
const frontend_application_state_1 = __webpack_require__(/*! ../../browser/frontend-application-state */ "../../node_modules/@theia/core/lib/browser/frontend-application-state.js");
const frontend_application_config_provider_1 = __webpack_require__(/*! ../../browser/frontend-application-config-provider */ "../../node_modules/@theia/core/lib/browser/frontend-application-config-provider.js");
const electron_window_preferences_1 = __webpack_require__(/*! ../window/electron-window-preferences */ "../../node_modules/@theia/core/lib/electron-browser/window/electron-window-preferences.js");
const browser_menu_plugin_1 = __webpack_require__(/*! ../../browser/menu/browser-menu-plugin */ "../../node_modules/@theia/core/lib/browser/menu/browser-menu-plugin.js");
const window_service_1 = __webpack_require__(/*! ../../browser/window/window-service */ "../../node_modules/@theia/core/lib/browser/window/window-service.js");
const window_title_service_1 = __webpack_require__(/*! ../../browser/window/window-title-service */ "../../node_modules/@theia/core/lib/browser/window/window-title-service.js");
__webpack_require__(/*! ../../../src/electron-browser/menu/electron-menu-style.css */ "../../node_modules/@theia/core/src/electron-browser/menu/electron-menu-style.css");
const theming_1 = __webpack_require__(/*! ../../browser/theming */ "../../node_modules/@theia/core/lib/browser/theming.js");
const theme_1 = __webpack_require__(/*! ../../common/theme */ "../../node_modules/@theia/core/lib/common/theme.js");
var ElectronCommands;
(function (ElectronCommands) {
    ElectronCommands.TOGGLE_DEVELOPER_TOOLS = common_1.Command.toDefaultLocalizedCommand({
        id: 'theia.toggleDevTools',
        label: 'Toggle Developer Tools'
    });
    ElectronCommands.RELOAD = common_1.Command.toDefaultLocalizedCommand({
        id: 'view.reload',
        label: 'Reload Window'
    });
    ElectronCommands.ZOOM_IN = common_1.Command.toDefaultLocalizedCommand({
        id: 'view.zoomIn',
        label: 'Zoom In'
    });
    ElectronCommands.ZOOM_OUT = common_1.Command.toDefaultLocalizedCommand({
        id: 'view.zoomOut',
        label: 'Zoom Out'
    });
    ElectronCommands.RESET_ZOOM = common_1.Command.toDefaultLocalizedCommand({
        id: 'view.resetZoom',
        label: 'Reset Zoom'
    });
    ElectronCommands.CLOSE_WINDOW = common_1.Command.toDefaultLocalizedCommand({
        id: 'close.window',
        label: 'Close Window'
    });
    ElectronCommands.TOGGLE_FULL_SCREEN = common_1.Command.toDefaultLocalizedCommand({
        id: 'workbench.action.toggleFullScreen',
        category: browser_1.CommonCommands.VIEW_CATEGORY,
        label: 'Toggle Full Screen'
    });
})(ElectronCommands || (exports.ElectronCommands = ElectronCommands = {}));
var ElectronMenus;
(function (ElectronMenus) {
    ElectronMenus.VIEW_WINDOW = [...browser_1.CommonMenus.VIEW, 'window'];
    ElectronMenus.VIEW_ZOOM = [...browser_1.CommonMenus.VIEW_APPEARANCE_SUBMENU, '4_appearance_submenu_zoom'];
})(ElectronMenus || (exports.ElectronMenus = ElectronMenus = {}));
(function (ElectronMenus) {
    ElectronMenus.HELP_TOGGLE = [...browser_1.CommonMenus.HELP, 'z_toggle'];
})(ElectronMenus || (exports.ElectronMenus = ElectronMenus = {}));
(function (ElectronMenus) {
    ElectronMenus.FILE_CLOSE = [...browser_1.CommonMenus.FILE_CLOSE, 'window-close'];
})(ElectronMenus || (exports.ElectronMenus = ElectronMenus = {}));
exports.CustomTitleWidgetFactory = Symbol('CustomTitleWidgetFactory');
let ElectronMenuContribution = class ElectronMenuContribution extends browser_menu_plugin_1.BrowserMenuBarContribution {
    constructor(factory) {
        super(factory);
        this.factory = factory;
        this.titleBarStyleChangeFlag = false;
    }
    onStart(app) {
        this.handleTitleBarStyling(app);
        if (common_1.isOSX) {
            this.attachWindowFocusListener(app);
        }
        // Make sure the application menu is complete, once the frontend application is ready.
        // https://github.com/theia-ide/theia/issues/5100
        let onStateChange = undefined;
        const stateServiceListener = (state) => {
            if (state === 'closing_window') {
                if (!!onStateChange) {
                    onStateChange.dispose();
                }
            }
        };
        onStateChange = this.stateService.onStateChanged(stateServiceListener);
        this.shell.onDidToggleMaximized(() => {
            this.handleToggleMaximized();
        });
        this.attachMenuBarVisibilityListener();
        this.themeService.onDidColorThemeChange(e => {
            this.handleThemeChange(e);
        });
    }
    attachWindowFocusListener(app) {
        // OSX: Recreate the menus when changing windows.
        // OSX only has one menu bar for all windows, so we need to swap
        // between them as the user switches windows.
        const disposeHandler = window.electronTheiaCore.onWindowEvent('focus', () => {
            this.setMenu(app);
        });
        window.addEventListener('unload', () => disposeHandler.dispose());
    }
    attachMenuBarVisibilityListener() {
        this.preferenceService.onPreferenceChanged(e => {
            if (e.preferenceName === 'window.menuBarVisibility') {
                this.handleFullScreen(e.newValue);
            }
        });
    }
    handleTitleBarStyling(app) {
        this.hideTopPanel(app);
        window.electronTheiaCore.getTitleBarStyleAtStartup().then(style => {
            this.titleBarStyle = style;
            this.setMenu(app);
            this.preferenceService.ready.then(() => {
                this.preferenceService.set('window.titleBarStyle', this.titleBarStyle, browser_1.PreferenceScope.User);
            });
        });
        this.preferenceService.ready.then(() => {
            window.electronTheiaCore.setMenuBarVisible(['classic', 'visible'].includes(this.preferenceService.get('window.menuBarVisibility', 'classic')));
        });
        this.preferenceService.onPreferenceChanged(change => {
            if (change.preferenceName === 'window.titleBarStyle') {
                if (this.titleBarStyleChangeFlag && this.titleBarStyle !== change.newValue) {
                    window.electronTheiaCore.setTitleBarStyle(change.newValue);
                    this.handleRequiredRestart();
                }
                this.titleBarStyleChangeFlag = true;
            }
        });
    }
    handleToggleMaximized() {
        const preference = this.preferenceService.get('window.menuBarVisibility');
        if (preference === 'classic') {
            this.factory.setMenuBar();
        }
    }
    /**
     * Hides the `theia-top-panel` depending on the selected `titleBarStyle`.
     * The `theia-top-panel` is used as the container of the main, application menu-bar for the
     * browser. Native Electron has its own.
     * By default, this method is called on application `onStart`.
     */
    hideTopPanel(app) {
        const itr = app.shell.children();
        let child = itr.next();
        while (!child.done) {
            // Top panel for the menu contribution is not required for native Electron title bar.
            if (child.value.id === 'theia-top-panel') {
                child.value.setHidden(this.titleBarStyle !== 'custom');
                break;
            }
            else {
                child = itr.next();
            }
        }
    }
    setMenu(app) {
        if (!common_1.isOSX) {
            this.hideTopPanel(app);
            if (this.titleBarStyle === 'custom' && !this.menuBar) {
                this.createCustomTitleBar(app);
                return;
            }
        }
        this.factory.setMenuBar();
    }
    createCustomTitleBar(app) {
        const dragPanel = new browser_1.Widget();
        dragPanel.id = 'theia-drag-panel';
        app.shell.addWidget(dragPanel, { area: 'top' });
        this.appendMenu(app.shell);
        this.createCustomTitleWidget(app);
        const controls = document.createElement('div');
        controls.id = 'window-controls';
        controls.append(this.createControlButton('minimize', () => window.electronTheiaCore.minimize()), this.createControlButton('maximize', () => window.electronTheiaCore.maximize()), this.createControlButton('restore', () => window.electronTheiaCore.unMaximize()), this.createControlButton('close', () => window.electronTheiaCore.close()));
        app.shell.topPanel.node.append(controls);
        this.handleWindowControls();
    }
    createCustomTitleWidget(app) {
        const titleWidget = this.customTitleWidgetFactory();
        if (titleWidget) {
            app.shell.addWidget(titleWidget, { area: 'top' });
        }
    }
    handleWindowControls() {
        toggleControlButtons();
        window.electronTheiaCore.onWindowEvent('maximize', toggleControlButtons);
        window.electronTheiaCore.onWindowEvent('unmaximize', toggleControlButtons);
        function toggleControlButtons() {
            if (window.electronTheiaCore.isMaximized()) {
                document.body.classList.add('maximized');
            }
            else {
                document.body.classList.remove('maximized');
            }
        }
    }
    createControlButton(id, handler) {
        const button = document.createElement('div');
        button.id = `${id}-button`;
        button.className = `control-button ${(0, browser_1.codicon)(`chrome-${id}`)}`;
        button.addEventListener('click', handler);
        return button;
    }
    async handleRequiredRestart() {
        const msgNode = document.createElement('div');
        const message = document.createElement('p');
        message.textContent = common_1.nls.localizeByDefault('A setting has changed that requires a restart to take effect.');
        const detail = document.createElement('p');
        detail.textContent = common_1.nls.localizeByDefault('Press the restart button to restart {0} and enable the setting.', frontend_application_config_provider_1.FrontendApplicationConfigProvider.get().applicationName);
        msgNode.append(message, detail);
        const restart = common_1.nls.localizeByDefault('Restart');
        const dialog = new browser_1.ConfirmDialog({
            title: restart,
            msg: msgNode,
            ok: restart,
            cancel: browser_1.Dialog.CANCEL
        });
        if (await dialog.open()) {
            this.windowService.setSafeToShutDown();
            window.electronTheiaCore.restart();
        }
    }
    registerCommands(registry) {
        registry.registerCommand(ElectronCommands.TOGGLE_DEVELOPER_TOOLS, {
            execute: () => {
                window.electronTheiaCore.toggleDevTools();
            }
        });
        registry.registerCommand(ElectronCommands.RELOAD, {
            execute: () => this.windowService.reload()
        });
        registry.registerCommand(ElectronCommands.CLOSE_WINDOW, {
            execute: () => window.electronTheiaCore.close()
        });
        registry.registerCommand(ElectronCommands.ZOOM_IN, {
            execute: async () => {
                const currentLevel = await window.electronTheiaCore.getZoomLevel();
                // When starting at a level that is not a multiple of 0.5, increment by at most 0.5 to reach the next highest multiple of 0.5.
                let zoomLevel = (Math.floor(currentLevel / electron_window_preferences_1.ZoomLevel.VARIATION) * electron_window_preferences_1.ZoomLevel.VARIATION) + electron_window_preferences_1.ZoomLevel.VARIATION;
                if (zoomLevel > electron_window_preferences_1.ZoomLevel.MAX) {
                    zoomLevel = electron_window_preferences_1.ZoomLevel.MAX;
                    return;
                }
                ;
                this.preferenceService.set('window.zoomLevel', zoomLevel, browser_1.PreferenceScope.User);
            }
        });
        registry.registerCommand(ElectronCommands.ZOOM_OUT, {
            execute: async () => {
                const currentLevel = await window.electronTheiaCore.getZoomLevel();
                // When starting at a level that is not a multiple of 0.5, decrement by at most 0.5 to reach the next lowest multiple of 0.5.
                let zoomLevel = (Math.ceil(currentLevel / electron_window_preferences_1.ZoomLevel.VARIATION) * electron_window_preferences_1.ZoomLevel.VARIATION) - electron_window_preferences_1.ZoomLevel.VARIATION;
                if (zoomLevel < electron_window_preferences_1.ZoomLevel.MIN) {
                    zoomLevel = electron_window_preferences_1.ZoomLevel.MIN;
                    return;
                }
                ;
                this.preferenceService.set('window.zoomLevel', zoomLevel, browser_1.PreferenceScope.User);
            }
        });
        registry.registerCommand(ElectronCommands.RESET_ZOOM, {
            execute: () => this.preferenceService.set('window.zoomLevel', electron_window_preferences_1.ZoomLevel.DEFAULT, browser_1.PreferenceScope.User)
        });
        registry.registerCommand(ElectronCommands.TOGGLE_FULL_SCREEN, {
            isEnabled: () => window.electronTheiaCore.isFullScreenable(),
            isVisible: () => window.electronTheiaCore.isFullScreenable(),
            execute: () => this.toggleFullScreen()
        });
    }
    registerKeybindings(registry) {
        registry.registerKeybindings({
            command: ElectronCommands.TOGGLE_DEVELOPER_TOOLS.id,
            keybinding: 'ctrlcmd+alt+i'
        }, {
            command: ElectronCommands.RELOAD.id,
            keybinding: 'ctrlcmd+r'
        }, {
            command: ElectronCommands.ZOOM_IN.id,
            keybinding: 'ctrlcmd+='
        }, {
            command: ElectronCommands.ZOOM_IN.id,
            keybinding: 'ctrlcmd+add'
        }, {
            command: ElectronCommands.ZOOM_OUT.id,
            keybinding: 'ctrlcmd+subtract'
        }, {
            command: ElectronCommands.ZOOM_OUT.id,
            keybinding: 'ctrlcmd+-'
        }, {
            command: ElectronCommands.RESET_ZOOM.id,
            keybinding: 'ctrlcmd+0'
        }, {
            command: ElectronCommands.CLOSE_WINDOW.id,
            keybinding: (common_1.isOSX ? 'cmd+shift+w' : (common_1.isWindows ? 'ctrl+w' : /* Linux */ 'ctrl+q'))
        }, {
            command: ElectronCommands.TOGGLE_FULL_SCREEN.id,
            keybinding: common_1.isOSX ? 'ctrl+ctrlcmd+f' : 'f11'
        });
    }
    registerMenus(registry) {
        registry.registerMenuAction(ElectronMenus.HELP_TOGGLE, {
            commandId: ElectronCommands.TOGGLE_DEVELOPER_TOOLS.id
        });
        registry.registerMenuAction(ElectronMenus.VIEW_WINDOW, {
            commandId: ElectronCommands.RELOAD.id,
            order: 'z0'
        });
        registry.registerMenuAction(ElectronMenus.VIEW_ZOOM, {
            commandId: ElectronCommands.ZOOM_IN.id,
            order: 'z1'
        });
        registry.registerMenuAction(ElectronMenus.VIEW_ZOOM, {
            commandId: ElectronCommands.ZOOM_OUT.id,
            order: 'z2'
        });
        registry.registerMenuAction(ElectronMenus.VIEW_ZOOM, {
            commandId: ElectronCommands.RESET_ZOOM.id,
            order: 'z3'
        });
        registry.registerMenuAction(ElectronMenus.FILE_CLOSE, {
            commandId: ElectronCommands.CLOSE_WINDOW.id,
        });
        registry.registerMenuAction(browser_1.CommonMenus.VIEW_APPEARANCE_SUBMENU_SCREEN, {
            commandId: ElectronCommands.TOGGLE_FULL_SCREEN.id,
            label: common_1.nls.localizeByDefault('Full Screen'),
            order: '0'
        });
    }
    toggleFullScreen() {
        window.electronTheiaCore.toggleFullScreen();
        const menuBarVisibility = this.preferenceService.get('window.menuBarVisibility', 'classic');
        this.handleFullScreen(menuBarVisibility);
    }
    handleFullScreen(menuBarVisibility) {
        const shouldShowTop = !window.electronTheiaCore.isFullScreen() || menuBarVisibility === 'visible';
        if (this.titleBarStyle === 'native') {
            window.electronTheiaCore.setMenuBarVisible(shouldShowTop);
        }
        else if (shouldShowTop) {
            this.shell.topPanel.show();
        }
        else {
            this.shell.topPanel.hide();
        }
    }
    handleThemeChange(e) {
        const backgroundColor = window.getComputedStyle(document.body).backgroundColor;
        window.electronTheiaCore.setBackgroundColor(backgroundColor);
        window.electronTheiaCore.setTheme((0, theme_1.getThemeMode)(e.newTheme.type));
    }
};
exports.ElectronMenuContribution = ElectronMenuContribution;
tslib_1.__decorate([
    (0, inversify_1.inject)(frontend_application_state_1.FrontendApplicationStateService),
    tslib_1.__metadata("design:type", frontend_application_state_1.FrontendApplicationStateService)
], ElectronMenuContribution.prototype, "stateService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(window_service_1.WindowService),
    tslib_1.__metadata("design:type", Object)
], ElectronMenuContribution.prototype, "windowService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(theming_1.ThemeService),
    tslib_1.__metadata("design:type", theming_1.ThemeService)
], ElectronMenuContribution.prototype, "themeService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(exports.CustomTitleWidgetFactory),
    tslib_1.__metadata("design:type", Function)
], ElectronMenuContribution.prototype, "customTitleWidgetFactory", void 0);
exports.ElectronMenuContribution = ElectronMenuContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)(),
    tslib_1.__param(0, (0, inversify_1.inject)(electron_main_menu_factory_1.ElectronMainMenuFactory)),
    tslib_1.__metadata("design:paramtypes", [electron_main_menu_factory_1.ElectronMainMenuFactory])
], ElectronMenuContribution);
let CustomTitleWidget = class CustomTitleWidget extends browser_1.Widget {
    constructor() {
        super();
        this.id = 'theia-custom-title';
    }
    init() {
        this.updateTitle(this.windowTitleService.title);
        this.windowTitleService.onDidChangeTitle(title => {
            this.updateTitle(title);
        });
        this.preferenceService.onPreferenceChanged(e => {
            if (e.preferenceName === 'window.menuBarVisibility') {
                (0, browser_1.animationFrame)().then(() => this.adjustTitleToCenter());
            }
        });
    }
    onResize(msg) {
        this.adjustTitleToCenter();
        super.onResize(msg);
    }
    onAfterShow(msg) {
        this.adjustTitleToCenter();
        super.onAfterShow(msg);
    }
    updateTitle(title) {
        this.node.textContent = title;
        this.adjustTitleToCenter();
    }
    adjustTitleToCenter() {
        const menubar = this.electronMenuContribution.menuBar;
        if (menubar) {
            const titleWidth = this.node.clientWidth;
            const margin = 16;
            const leftMarker = menubar.node.offsetLeft + menubar.node.clientWidth + margin;
            const panelWidth = this.applicationShell.topPanel.node.clientWidth;
            const controlsWidth = 48 * 3; // Each window button has a width of 48px
            const rightMarker = panelWidth - controlsWidth - margin;
            let hidden = false;
            let relative = false;
            this.node.style.left = '50%';
            // The title has not enough space between the menu and the window controls
            // So we simply hide it
            if (rightMarker - leftMarker < titleWidth) {
                hidden = true;
            }
            else if ((panelWidth - titleWidth) / 2 < leftMarker || (panelWidth + titleWidth) / 2 > rightMarker) {
                // This indicates that the title has either hit the left (menu) or right (window controls) marker
                relative = true;
                this.node.style.left = `${leftMarker + (rightMarker - leftMarker - titleWidth) / 2}px`;
            }
            this.node.classList.toggle('hidden', hidden);
            this.node.classList.toggle('relative', relative);
        }
    }
};
exports.CustomTitleWidget = CustomTitleWidget;
tslib_1.__decorate([
    (0, inversify_1.inject)(ElectronMenuContribution),
    tslib_1.__metadata("design:type", ElectronMenuContribution)
], CustomTitleWidget.prototype, "electronMenuContribution", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(window_title_service_1.WindowTitleService),
    tslib_1.__metadata("design:type", window_title_service_1.WindowTitleService)
], CustomTitleWidget.prototype, "windowTitleService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.ApplicationShell),
    tslib_1.__metadata("design:type", browser_1.ApplicationShell)
], CustomTitleWidget.prototype, "applicationShell", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.PreferenceService),
    tslib_1.__metadata("design:type", Object)
], CustomTitleWidget.prototype, "preferenceService", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], CustomTitleWidget.prototype, "init", null);
exports.CustomTitleWidget = CustomTitleWidget = tslib_1.__decorate([
    (0, inversify_1.injectable)(),
    tslib_1.__metadata("design:paramtypes", [])
], CustomTitleWidget);


/***/ }),

/***/ "../../node_modules/@theia/core/lib/electron-browser/menu/electron-menu-module.js":
/*!****************************************************************************************!*\
  !*** ../../node_modules/@theia/core/lib/electron-browser/menu/electron-menu-module.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2017 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
const inversify_1 = __webpack_require__(/*! inversify */ "../../node_modules/inversify/lib/cjs/index.js");
const common_1 = __webpack_require__(/*! ../../common */ "../../node_modules/@theia/core/lib/common/index.js");
const browser_1 = __webpack_require__(/*! ../../browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const electron_main_menu_factory_1 = __webpack_require__(/*! ./electron-main-menu-factory */ "../../node_modules/@theia/core/lib/electron-browser/menu/electron-main-menu-factory.js");
const electron_context_menu_renderer_1 = __webpack_require__(/*! ./electron-context-menu-renderer */ "../../node_modules/@theia/core/lib/electron-browser/menu/electron-context-menu-renderer.js");
const electron_menu_contribution_1 = __webpack_require__(/*! ./electron-menu-contribution */ "../../node_modules/@theia/core/lib/electron-browser/menu/electron-menu-contribution.js");
exports["default"] = new inversify_1.ContainerModule(bind => {
    bind(electron_main_menu_factory_1.ElectronMainMenuFactory).toSelf().inSingletonScope();
    bind(browser_1.ContextMenuRenderer).to(electron_context_menu_renderer_1.ElectronContextMenuRenderer).inSingletonScope();
    bind(browser_1.KeybindingContext).toConstantValue({
        id: 'theia.context',
        isEnabled: true
    });
    bind(electron_menu_contribution_1.ElectronMenuContribution).toSelf().inSingletonScope();
    for (const serviceIdentifier of [browser_1.FrontendApplicationContribution, browser_1.KeybindingContribution, common_1.CommandContribution, common_1.MenuContribution]) {
        bind(serviceIdentifier).toService(electron_menu_contribution_1.ElectronMenuContribution);
    }
    bind(electron_menu_contribution_1.CustomTitleWidget).toSelf().inSingletonScope();
    bind(electron_menu_contribution_1.CustomTitleWidgetFactory).toFactory(context => () => context.container.get(electron_menu_contribution_1.CustomTitleWidget));
    bind(browser_1.FrontendApplicationContribution).to(electron_context_menu_renderer_1.ElectronTextInputContextMenuContribution).inSingletonScope();
    bind(common_1.MenuContribution).to(electron_context_menu_renderer_1.ElectronTextInputContextMenuContribution).inSingletonScope();
});


/***/ }),

/***/ "../../node_modules/@theia/core/lib/electron-browser/window/electron-window-preferences.js":
/*!*************************************************************************************************!*\
  !*** ../../node_modules/@theia/core/lib/electron-browser/window/electron-window-preferences.js ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2021 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.bindWindowPreferences = exports.createElectronWindowPreferences = exports.ElectronWindowPreferences = exports.ElectronWindowPreferenceContribution = exports.ElectronWindowConfiguration = exports.electronWindowPreferencesSchema = exports.ZoomLevel = void 0;
const nls_1 = __webpack_require__(/*! ../../common/nls */ "../../node_modules/@theia/core/lib/common/nls.js");
const preferences_1 = __webpack_require__(/*! ../../browser/preferences */ "../../node_modules/@theia/core/lib/browser/preferences/index.js");
const common_1 = __webpack_require__(/*! ../../common */ "../../node_modules/@theia/core/lib/common/index.js");
var ZoomLevel;
(function (ZoomLevel) {
    ZoomLevel.DEFAULT = 0;
    // copied from https://github.com/microsoft/vscode/blob/dda96b69bfc63f309e60cfc5f98cb863c46b32ac/src/vs/workbench/electron-sandbox/actions/windowActions.ts#L47-L48
    ZoomLevel.MIN = -8;
    ZoomLevel.MAX = 9;
    // amount to increment or decrement the window zoom level.
    ZoomLevel.VARIATION = 0.5;
})(ZoomLevel || (exports.ZoomLevel = ZoomLevel = {}));
exports.electronWindowPreferencesSchema = {
    type: 'object',
    properties: {
        'window.zoomLevel': {
            'type': 'number',
            'default': ZoomLevel.DEFAULT,
            'minimum': ZoomLevel.MIN,
            'maximum': ZoomLevel.MAX,
            'scope': 'application',
            // eslint-disable-next-line max-len
            'description': nls_1.nls.localizeByDefault("Adjust the default zoom level for all windows. Each increment above `0` (e.g. `1`) or below (e.g. `-1`) represents zooming `20%` larger or smaller. You can also enter decimals to adjust the zoom level with a finer granularity. See {0} for configuring if the 'Zoom In' and 'Zoom Out' commands apply the zoom level to all windows or only the active window.")
        },
        'window.titleBarStyle': {
            type: 'string',
            enum: ['native', 'custom'],
            default: common_1.isWindows ? 'custom' : 'native',
            scope: 'application',
            // eslint-disable-next-line max-len
            description: nls_1.nls.localizeByDefault('Adjust the appearance of the window title bar to be native by the OS or custom. On Linux and Windows, this setting also affects the application and context menu appearances. Changes require a full restart to apply.'),
            included: !common_1.isOSX
        },
    }
};
class ElectronWindowConfiguration {
}
exports.ElectronWindowConfiguration = ElectronWindowConfiguration;
exports.ElectronWindowPreferenceContribution = Symbol('ElectronWindowPreferenceContribution');
exports.ElectronWindowPreferences = Symbol('ElectronWindowPreferences');
function createElectronWindowPreferences(preferences, schema = exports.electronWindowPreferencesSchema) {
    return (0, preferences_1.createPreferenceProxy)(preferences, schema);
}
exports.createElectronWindowPreferences = createElectronWindowPreferences;
function bindWindowPreferences(bind) {
    bind(exports.ElectronWindowPreferences).toDynamicValue(ctx => {
        const preferences = ctx.container.get(preferences_1.PreferenceService);
        const contribution = ctx.container.get(exports.ElectronWindowPreferenceContribution);
        return createElectronWindowPreferences(preferences, contribution.schema);
    }).inSingletonScope();
    bind(exports.ElectronWindowPreferenceContribution).toConstantValue({ schema: exports.electronWindowPreferencesSchema });
    bind(preferences_1.PreferenceContribution).toService(exports.ElectronWindowPreferenceContribution);
}
exports.bindWindowPreferences = bindWindowPreferences;


/***/ }),

/***/ "../../node_modules/@theia/core/src/electron-browser/menu/electron-menu-style.css":
/*!****************************************************************************************!*\
  !*** ../../node_modules/@theia/core/src/electron-browser/menu/electron-menu-style.css ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../../../style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _css_loader_dist_cjs_js_electron_menu_style_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !!../../../../../css-loader/dist/cjs.js!./electron-menu-style.css */ "../../node_modules/css-loader/dist/cjs.js!../../node_modules/@theia/core/src/electron-browser/menu/electron-menu-style.css");

            

var options = {};

options.insert = "head";
options.singleton = false;

var update = _style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_css_loader_dist_cjs_js_electron_menu_style_css__WEBPACK_IMPORTED_MODULE_1__["default"], options);



/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_css_loader_dist_cjs_js_electron_menu_style_css__WEBPACK_IMPORTED_MODULE_1__["default"].locals || {});

/***/ }),

/***/ "../../node_modules/css-loader/dist/cjs.js!../../node_modules/@theia/core/src/electron-browser/menu/electron-menu-style.css":
/*!**********************************************************************************************************************************!*\
  !*** ../../node_modules/css-loader/dist/cjs.js!../../node_modules/@theia/core/src/electron-browser/menu/electron-menu-style.css ***!
  \**********************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../css-loader/dist/runtime/sourceMaps.js */ "../../node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../../css-loader/dist/runtime/api.js */ "../../node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/********************************************************************************
 * Copyright (C) 2021 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
 ********************************************************************************/

#theia-drag-panel {
  position: absolute;
  display: block;
  top: 0;
  left: 0;
  width: 100%;
  height: calc(100% - 4px);
  margin: 4px;
  -webkit-app-region: drag !important;
}

#theia-top-panel > * {
  -webkit-app-region: no-drag;
}

#theia-custom-title {
  position: absolute;
  left: 50%;
  transform: translate(-50%, 0px);
  line-height: 30px;
  flex: 0 1 auto;
  font-size: 12px;
  overflow: hidden;
  white-space: nowrap;
  text-overflow: ellipsis;
  margin-top: 2px;
  margin-left: auto;
  margin-right: auto;
  zoom: 1;
  -webkit-app-region: drag !important;
}

#theia-custom-title.relative {
  transform: none;
}

#theia-custom-title.hidden {
  visibility: hidden;
}

#window-controls {
  display: grid;
  grid-template-columns: repeat(3, 48px);
  position: absolute;
  top: 0;
  right: 0;
  height: 100%;
}

#window-controls .control-button {
  display: flex;
  line-height: 30px;
  justify-content: center;
  align-items: center;
  width: 100%;
  height: 100%;
}

#minimize-button {
  grid-column: 1;
}

#maximize-button,
#restore-button {
  grid-column: 2;
}

#close-button {
  grid-column: 3;
}

#window-controls .control-button {
  user-select: none;
}

#window-controls .control-button:hover {
  background: rgba(50%, 50%, 50%, 0.2);
}

#window-controls #close-button:hover {
  background: #e81123;
}

#window-controls #close-button:hover:before {
  color: white;
}

body:not(.maximized) #restore-button {
  display: none;
}

body.maximized #maximize-button {
  display: none;
}
`, "",{"version":3,"sources":["webpack://./../../node_modules/@theia/core/src/electron-browser/menu/electron-menu-style.css"],"names":[],"mappings":"AAAA;;;;;;;;;;;;;;iFAciF;;AAEjF;EACE,kBAAkB;EAClB,cAAc;EACd,MAAM;EACN,OAAO;EACP,WAAW;EACX,wBAAwB;EACxB,WAAW;EACX,mCAAmC;AACrC;;AAEA;EACE,2BAA2B;AAC7B;;AAEA;EACE,kBAAkB;EAClB,SAAS;EACT,+BAA+B;EAC/B,iBAAiB;EACjB,cAAc;EACd,eAAe;EACf,gBAAgB;EAChB,mBAAmB;EACnB,uBAAuB;EACvB,eAAe;EACf,iBAAiB;EACjB,kBAAkB;EAClB,OAAO;EACP,mCAAmC;AACrC;;AAEA;EACE,eAAe;AACjB;;AAEA;EACE,kBAAkB;AACpB;;AAEA;EACE,aAAa;EACb,sCAAsC;EACtC,kBAAkB;EAClB,MAAM;EACN,QAAQ;EACR,YAAY;AACd;;AAEA;EACE,aAAa;EACb,iBAAiB;EACjB,uBAAuB;EACvB,mBAAmB;EACnB,WAAW;EACX,YAAY;AACd;;AAEA;EACE,cAAc;AAChB;;AAEA;;EAEE,cAAc;AAChB;;AAEA;EACE,cAAc;AAChB;;AAEA;EACE,iBAAiB;AACnB;;AAEA;EACE,oCAAoC;AACtC;;AAEA;EACE,mBAAmB;AACrB;;AAEA;EACE,YAAY;AACd;;AAEA;EACE,aAAa;AACf;;AAEA;EACE,aAAa;AACf","sourcesContent":["/********************************************************************************\n * Copyright (C) 2021 TypeFox and others.\n *\n * This program and the accompanying materials are made available under the\n * terms of the Eclipse Public License v. 2.0 which is available at\n * http://www.eclipse.org/legal/epl-2.0.\n *\n * This Source Code may also be made available under the following Secondary\n * Licenses when the conditions for such availability set forth in the Eclipse\n * Public License v. 2.0 are satisfied: GNU General Public License, version 2\n * with the GNU Classpath Exception which is available at\n * https://www.gnu.org/software/classpath/license.html.\n *\n * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0\n ********************************************************************************/\n\n#theia-drag-panel {\n  position: absolute;\n  display: block;\n  top: 0;\n  left: 0;\n  width: 100%;\n  height: calc(100% - 4px);\n  margin: 4px;\n  -webkit-app-region: drag !important;\n}\n\n#theia-top-panel > * {\n  -webkit-app-region: no-drag;\n}\n\n#theia-custom-title {\n  position: absolute;\n  left: 50%;\n  transform: translate(-50%, 0px);\n  line-height: 30px;\n  flex: 0 1 auto;\n  font-size: 12px;\n  overflow: hidden;\n  white-space: nowrap;\n  text-overflow: ellipsis;\n  margin-top: 2px;\n  margin-left: auto;\n  margin-right: auto;\n  zoom: 1;\n  -webkit-app-region: drag !important;\n}\n\n#theia-custom-title.relative {\n  transform: none;\n}\n\n#theia-custom-title.hidden {\n  visibility: hidden;\n}\n\n#window-controls {\n  display: grid;\n  grid-template-columns: repeat(3, 48px);\n  position: absolute;\n  top: 0;\n  right: 0;\n  height: 100%;\n}\n\n#window-controls .control-button {\n  display: flex;\n  line-height: 30px;\n  justify-content: center;\n  align-items: center;\n  width: 100%;\n  height: 100%;\n}\n\n#minimize-button {\n  grid-column: 1;\n}\n\n#maximize-button,\n#restore-button {\n  grid-column: 2;\n}\n\n#close-button {\n  grid-column: 3;\n}\n\n#window-controls .control-button {\n  user-select: none;\n}\n\n#window-controls .control-button:hover {\n  background: rgba(50%, 50%, 50%, 0.2);\n}\n\n#window-controls #close-button:hover {\n  background: #e81123;\n}\n\n#window-controls #close-button:hover:before {\n  color: white;\n}\n\nbody:not(.maximized) #restore-button {\n  display: none;\n}\n\nbody.maximized #maximize-button {\n  display: none;\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_theia_core_lib_electron-browser_menu_electron-menu-module_js.js.map