/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.files.ui.widgets;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.rse.subsystems.files.core.subsystems.RemoteFileEmpty;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.internal.ide.dialogs.ResourceTreeAndListGroup;

public class SystemFileTreeAndListGroup
extends ResourceTreeAndListGroup {
    private Object rootObject = null;
    private Object lastSelectedElement = null;
    private static final RemoteFileEmpty EMPTYROOT = new RemoteFileEmpty();

    public SystemFileTreeAndListGroup(Composite parent, Object rootObject, ITreeContentProvider treeContentProvider, ILabelProvider treeLabelProvider, IStructuredContentProvider listContentProvider, ILabelProvider listLabelProvider, int style, int width, int height) {
        super(parent, rootObject, treeContentProvider, treeLabelProvider, listContentProvider, listLabelProvider, style, true);
        this.rootObject = rootObject;
    }

    public SystemFileTreeAndListGroup(Composite parent, ITreeContentProvider treeContentProvider, ILabelProvider treeLabelProvider, IStructuredContentProvider listContentProvider, ILabelProvider listLabelProvider, int style, int width, int height) {
        this(parent, EMPTYROOT, treeContentProvider, treeLabelProvider, listContentProvider, listLabelProvider, style, width, height);
    }

    public void refresh() {
        if (!(this.rootObject instanceof RemoteFileEmpty)) {
            Object oldRoot = this.rootObject;
            this.setRoot(EMPTYROOT);
            this.setRoot(oldRoot);
        }
    }

    public void refreshFiles() {
        if (this.lastSelectedElement != null) {
            this.populateListViewer(this.lastSelectedElement);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        this.lastSelectedElement = selection.getFirstElement();
        super.selectionChanged(event);
    }

    public void setRoot(Object newRoot) {
        this.lastSelectedElement = null;
        this.rootObject = newRoot;
        super.setRoot(newRoot);
    }

    public void clearAll() {
        this.setRoot(EMPTYROOT);
    }
}

