/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.text;

import java.lang.reflect.Field;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.tm4e.core.TMException;
import org.eclipse.tm4e.core.grammar.IGrammar;
import org.eclipse.tm4e.core.internal.utils.NullSafetyHelper;
import org.eclipse.tm4e.core.model.ModelTokensChangedEvent;
import org.eclipse.tm4e.registry.TMEclipseRegistryPlugin;
import org.eclipse.tm4e.ui.TMUIPlugin;
import org.eclipse.tm4e.ui.internal.model.TMDocumentModel;
import org.eclipse.tm4e.ui.internal.model.TMModelManager;
import org.eclipse.tm4e.ui.internal.text.TMPresentationReconcilerTestGenerator;
import org.eclipse.tm4e.ui.internal.themes.ThemeManager;
import org.eclipse.tm4e.ui.internal.utils.ContentTypeHelper;
import org.eclipse.tm4e.ui.internal.utils.ContentTypeInfo;
import org.eclipse.tm4e.ui.internal.utils.MarkerUtils;
import org.eclipse.tm4e.ui.internal.utils.PreferenceUtils;
import org.eclipse.tm4e.ui.text.Colorizer;
import org.eclipse.tm4e.ui.text.ITMPresentationReconcilerListener;
import org.eclipse.tm4e.ui.themes.ITheme;
import org.eclipse.tm4e.ui.themes.IThemeManager;
import org.eclipse.tm4e.ui.themes.ITokenProvider;
import org.eclipse.ui.IEditorPart;

public class TMPresentationReconciler
implements IPresentationReconciler {
    private final ModelTokensChangedEvent.Listener modelsTokensChangedListener = new ModelTokensChangedEvent.Listener(){

        public void onModelTokensChanged(ModelTokensChangedEvent event) {
            StyledText control;
            Colorizer colorizer = TMPresentationReconciler.this.colorizer;
            if (colorizer != null && (control = colorizer.getTextViewer().getTextWidget()) != null) {
                control.getDisplay().asyncExec(() -> colorizer.colorize(event));
            }
            MarkerUtils.updateTextMarkers(event);
        }
    };
    private final IEclipsePreferences.IPreferenceChangeListener themeChangeListener = new IEclipsePreferences.IPreferenceChangeListener(){

        public void preferenceChange(// Could not load outer class - annotation placement on inner may be incorrect
         @Nullable IEclipsePreferences.PreferenceChangeEvent event) {
            if (event == null) {
                return;
            }
            switch (event.getKey()) {
                case "themeid": {
                    this.preferenceThemeChange((String)event.getNewValue(), TMUIPlugin.getThemeManager());
                    break;
                }
                case "org.eclipse.tm4e.ui.themeAssociations": {
                    this.preferenceThemeChange(PreferenceUtils.getE4PreferenceCSSThemeId(), TMUIPlugin.getThemeManager());
                }
            }
        }

        void preferenceThemeChange(@Nullable String eclipseThemeId, IThemeManager themeManager) {
            IDocument doc = TMPresentationReconciler.this.getViewerDocument();
            if (doc == null) {
                return;
            }
            IGrammar grammar = TMPresentationReconciler.this.grammar;
            if (grammar == null) {
                return;
            }
            boolean dark = themeManager.isDarkEclipseTheme(eclipseThemeId);
            ITheme newTheme = themeManager.getThemeForScope(grammar.getScopeName(), dark);
            TMPresentationReconciler.this.setTheme(newTheme);
        }
    };
    private @Nullable ITextViewer viewer;
    private final TextViewerListener viewerListener = new TextViewerListener();
    private volatile @Nullable Colorizer colorizer;
    private @Nullable IGrammar grammar;
    private boolean isForcedGrammar;
    private @Nullable ITokenProvider theme;
    private final Set<ITMPresentationReconcilerListener> listeners = new CopyOnWriteArraySet<ITMPresentationReconcilerListener>();

    /*
     * WARNING - void declaration
     */
    public static @Nullable TMPresentationReconciler getTMPresentationReconciler(@Nullable IEditorPart editorPart) {
        TMPresentationReconciler tMPresentationReconciler;
        if (editorPart == null) {
            return null;
        }
        @Nullable ITextOperationTarget target = (ITextOperationTarget)editorPart.getAdapter(ITextOperationTarget.class);
        ITextOperationTarget iTextOperationTarget = target;
        if (iTextOperationTarget instanceof ITextViewer) {
            void textViewer;
            ITextViewer iTextViewer = (ITextViewer)iTextOperationTarget;
            ITextViewer cfr_ignored_0 = (ITextViewer)iTextOperationTarget;
            tMPresentationReconciler = TMPresentationReconciler.getTMPresentationReconciler((ITextViewer)textViewer);
        } else {
            tMPresentationReconciler = null;
        }
        return tMPresentationReconciler;
    }

    /*
     * WARNING - void declaration
     */
    public static @Nullable TMPresentationReconciler getTMPresentationReconciler(ITextViewer textViewer) {
        try {
            Field presentationReconcilerField = SourceViewer.class.getDeclaredField("fPresentationReconciler");
            if (presentationReconcilerField != null) {
                TMPresentationReconciler tMPresentationReconciler;
                presentationReconcilerField.trySetAccessible();
                Object object = presentationReconcilerField.get(textViewer);
                if (object instanceof TMPresentationReconciler) {
                    void tmPresentationReconciler;
                    TMPresentationReconciler tMPresentationReconciler2 = (TMPresentationReconciler)object;
                    TMPresentationReconciler cfr_ignored_0 = (TMPresentationReconciler)object;
                    tMPresentationReconciler = tmPresentationReconciler;
                } else {
                    tMPresentationReconciler = null;
                }
                return tMPresentationReconciler;
            }
        }
        catch (NoSuchFieldException | SecurityException ex) {
            TMUIPlugin.logError(ex);
        }
        catch (ExceptionInInitializerError | IllegalAccessException | IllegalArgumentException | NullPointerException throwable) {
            // empty catch block
        }
        return null;
    }

    public TMPresentationReconciler() {
        if (PreferenceUtils.isDebugGenerateTest()) {
            this.addListener(new TMPresentationReconcilerTestGenerator());
        }
    }

    private @Nullable IGrammar findGrammar(IDocument doc) {
        String fileExtension;
        String fileName;
        IGrammar currentGrammar;
        IGrammar iGrammar = currentGrammar = this.isForcedGrammar ? this.grammar : null;
        if (currentGrammar != null) {
            return currentGrammar;
        }
        ContentTypeInfo info = ContentTypeHelper.findContentTypes(doc);
        if (info == null) {
            return null;
        }
        IContentType[] contentTypes = info.getContentTypes();
        IGrammar grammar = TMEclipseRegistryPlugin.getGrammarRegistryManager().getGrammarFor(contentTypes);
        if (grammar == null && (fileName = info.getFileName()).indexOf(46) > -1 && (fileExtension = new Path(fileName).getFileExtension()) != null) {
            grammar = TMEclipseRegistryPlugin.getGrammarRegistryManager().getGrammarForFileExtension(fileExtension);
        }
        return grammar;
    }

    public @Nullable IGrammar getGrammar() {
        return this.grammar;
    }

    public void setGrammar(@Nullable IGrammar newGrammar) {
        if (newGrammar == null && this.grammar == null) {
            return;
        }
        boolean bl = this.isForcedGrammar = newGrammar != null;
        if (Objects.equals(newGrammar, this.grammar)) {
            return;
        }
        if (newGrammar == null) {
            this.colorizer = null;
        }
        this.grammar = newGrammar;
        IDocument doc = this.getViewerDocument();
        if (doc == null) {
            return;
        }
        this.viewerListener.inputDocumentAboutToBeChanged(doc, null);
        this.viewerListener.inputDocumentChanged(null, doc);
    }

    public @Nullable ITokenProvider getTokenProvider() {
        return this.theme;
    }

    public void setTheme(ITokenProvider newTheme) {
        if (!Objects.equals(this.theme, newTheme)) {
            this.theme = newTheme;
            ITextViewer viewer = this.viewer;
            if (this.grammar == null || viewer == null) {
                return;
            }
            Colorizer colorizer = this.colorizer = new Colorizer(viewer, newTheme, this.listeners);
            IDocument doc = this.getViewerDocument();
            if (doc == null) {
                return;
            }
            TMDocumentModel docModel = TMModelManager.INSTANCE.connect(doc);
            try {
                colorizer.colorize((IRegion)new Region(0, doc.getLength()), docModel);
            }
            catch (BadLocationException ex) {
                TMUIPlugin.logError((Exception)((Object)ex));
            }
        }
    }

    public void install(@NonNullByDefault(value={}) ITextViewer viewer) {
        this.viewer = viewer;
        viewer.addTextInputListener((ITextInputListener)this.viewerListener);
        IDocument doc = viewer.getDocument();
        if (doc != null) {
            this.viewerListener.inputDocumentChanged(null, doc);
        }
        ThemeManager.getInstance().addPreferenceChangeListener(this.themeChangeListener);
    }

    public void uninstall() {
        ITextViewer viewer = (ITextViewer)NullSafetyHelper.castNonNull((Object)this.viewer);
        viewer.removeTextInputListener((ITextInputListener)this.viewerListener);
        this.viewerListener.inputDocumentAboutToBeChanged(viewer.getDocument(), null);
        ThemeManager.getInstance().removePreferenceChangeListener(this.themeChangeListener);
        this.viewer = null;
    }

    public @Nullable IPresentationDamager getDamager(@Nullable String contentType) {
        return null;
    }

    public @Nullable IPresentationRepairer getRepairer(@Nullable String contentType) {
        return null;
    }

    private @Nullable IDocument getViewerDocument() {
        ITextViewer viewer = this.viewer;
        if (viewer == null) {
            return null;
        }
        return viewer.getDocument();
    }

    public boolean addListener(ITMPresentationReconcilerListener listener) {
        return this.listeners.add(listener);
    }

    public boolean removeListener(ITMPresentationReconcilerListener listener) {
        return this.listeners.remove(listener);
    }

    public boolean isEnabled() {
        return this.colorizer != null;
    }

    private final class TextViewerListener
    implements ITextInputListener,
    ITextListener {
        private TextViewerListener() {
        }

        public void inputDocumentAboutToBeChanged(@Nullable IDocument oldDoc, @Nullable IDocument newDoc) {
            if (oldDoc == null) {
                return;
            }
            ITextViewer viewer = TMPresentationReconciler.this.viewer;
            if (viewer != null) {
                viewer.removeTextListener((ITextListener)TMPresentationReconciler.this.viewerListener);
            }
            TMModelManager.INSTANCE.disconnect(oldDoc);
            TMPresentationReconciler.this.listeners.forEach(l -> l.onUninstalled());
        }

        public void inputDocumentChanged(@Nullable IDocument oldDoc, @Nullable IDocument newDoc) {
            IGrammar newDocGrammar;
            if (newDoc == null) {
                return;
            }
            ITextViewer viewer = TMPresentationReconciler.this.viewer;
            if (viewer == null) {
                return;
            }
            TMPresentationReconciler.this.listeners.forEach(l -> l.onInstalled(viewer, newDoc));
            viewer.addTextListener((ITextListener)TMPresentationReconciler.this.viewerListener);
            if (TMPresentationReconciler.this.isForcedGrammar) {
                newDocGrammar = TMPresentationReconciler.this.grammar;
            } else {
                newDocGrammar = TMPresentationReconciler.this.findGrammar(newDoc);
                if (newDocGrammar == null) {
                    newDocGrammar = TMPresentationReconciler.this.grammar;
                } else {
                    TMPresentationReconciler.this.grammar = newDocGrammar;
                }
            }
            if (newDocGrammar == null) {
                TMPresentationReconciler.this.colorizer = null;
                TMPresentationReconciler.this.grammar = null;
                if (PreferenceUtils.isDebugThrowError()) {
                    throw new TMException("Cannot find TextMate grammar for the given document!");
                }
                return;
            }
            String scopeName = newDocGrammar.getScopeName();
            ITokenProvider theme = TMPresentationReconciler.this.theme;
            if (theme == null) {
                theme = TMPresentationReconciler.this.theme = TMUIPlugin.getThemeManager().getThemeForScope(scopeName, viewer.getTextWidget().getBackground().getRGB());
            }
            TMPresentationReconciler.this.colorizer = new Colorizer(viewer, theme, TMPresentationReconciler.this.listeners);
            TMDocumentModel docModel = TMModelManager.INSTANCE.connect(newDoc);
            docModel.setGrammar(newDocGrammar);
            docModel.addModelTokensChangedListener(TMPresentationReconciler.this.modelsTokensChangedListener);
        }

        public void textChanged(@Nullable TextEvent event) {
            if (event == null || !event.getViewerRedrawState()) {
                return;
            }
            ITextViewer viewer = TMPresentationReconciler.this.viewer;
            if (viewer == null) {
                return;
            }
            if (event.getDocumentEvent() != null) {
                int diff = event.getText().length() - event.getLength();
                if (diff == 0 || event.getOffset() <= 0) {
                    return;
                }
                StyleRange range = viewer.getTextWidget().getStyleRangeAtOffset(event.getOffset() - 1);
                if (range == null) {
                    return;
                }
                range.length = Math.max(0, range.length + diff);
                viewer.getTextWidget().setStyleRange(range);
                return;
            }
            IDocument doc = viewer.getDocument();
            if (doc == null) {
                return;
            }
            IRegion region = this.computeRegionToRedraw(event, doc);
            Colorizer colorizer = TMPresentationReconciler.this.colorizer;
            if (colorizer != null) {
                TMDocumentModel docModel = TMModelManager.INSTANCE.connect(doc);
                docModel.setGrammar((IGrammar)NullSafetyHelper.castNonNull((Object)TMPresentationReconciler.this.grammar));
                docModel.addModelTokensChangedListener(TMPresentationReconciler.this.modelsTokensChangedListener);
                try {
                    colorizer.colorize(region, docModel);
                }
                catch (BadLocationException ex) {
                    TMUIPlugin.logError((Exception)((Object)ex));
                }
            } else {
                TextPresentation presentation = new TextPresentation(region, 100);
                presentation.setDefaultStyleRange(new StyleRange(region.getOffset(), region.getLength(), null, null));
                viewer.changeTextPresentation(presentation, false);
            }
        }

        IRegion computeRegionToRedraw(TextEvent event, IDocument doc) {
            IRegion region = event.getOffset() == 0 && event.getLength() == 0 && event.getText() == null ? new Region(0, doc.getLength()) : this.getRegionOfTextEvent(event);
            return region == null || region.getLength() == 0 ? new Region(0, 0) : region;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable IRegion getRegionOfTextEvent(TextEvent event) {
            Region region;
            String text = event.getText();
            int length = text == null ? 0 : text.length();
            ITextViewer viewer = (ITextViewer)NullSafetyHelper.castNonNull((Object)TMPresentationReconciler.this.viewer);
            ITextViewer iTextViewer = viewer;
            if (iTextViewer instanceof ITextViewerExtension5) {
                void viewerExt5;
                ITextViewerExtension5 iTextViewerExtension5 = (ITextViewerExtension5)iTextViewer;
                ITextViewerExtension5 cfr_ignored_0 = (ITextViewerExtension5)iTextViewer;
                region = viewerExt5.widgetRange2ModelRange((IRegion)new Region(event.getOffset(), length));
            } else {
                region = new Region(event.getOffset() + viewer.getVisibleRegion().getOffset(), length);
            }
            return region;
        }
    }
}

