/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.variables.details;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.internal.ui.views.variables.details.DetailMessages;
import org.eclipse.debug.internal.ui.views.variables.details.DetailPaneManager;
import org.eclipse.debug.internal.ui.views.variables.details.IDetailPaneContainer;
import org.eclipse.debug.internal.ui.views.variables.details.IDetailPaneContainer2;
import org.eclipse.debug.ui.IDetailPane;
import org.eclipse.debug.ui.IDetailPane2;
import org.eclipse.debug.ui.IDetailPane3;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IWorkbenchPartSite;

public class DetailPaneProxy
implements ISaveablePart {
    private IDetailPane fCurrentPane;
    private Control fCurrentControl;
    private final IDetailPaneContainer fParentContainer;
    private final ListenerList<IPropertyListener> fListeners = new ListenerList();

    public DetailPaneProxy(IDetailPaneContainer parent) {
        this.fParentContainer = parent;
    }

    public void display(IStructuredSelection selection) {
        IDetailPane3 saveable = this.getSaveable();
        boolean clean = false;
        if (saveable != null && saveable.isDirty() && saveable.isSaveOnCloseNeeded()) {
            saveable.doSave(null);
        }
        if ((selection == null || selection.isEmpty()) && this.fCurrentPane != null) {
            this.fCurrentPane.display(selection);
            if (clean) {
                this.fireDirty();
            }
            return;
        }
        String preferredPaneID = DetailPaneManager.getDefault().getPreferredPaneFromSelection(selection);
        if (preferredPaneID == null) {
            preferredPaneID = "org.eclipse.debug.ui.detailpanes.message";
            selection = new StructuredSelection((Object)DetailMessages.DetailPaneProxy_1);
        }
        if (this.fCurrentPane != null && preferredPaneID.equals(this.fCurrentPane.getID())) {
            this.fCurrentPane.display(selection);
            if (clean) {
                this.fireDirty();
            }
            return;
        }
        this.setupPane(preferredPaneID, selection);
        this.fParentContainer.paneChanged(preferredPaneID);
        if (clean) {
            this.fireDirty();
        }
    }

    private void fireDirty() {
        for (IPropertyListener iPropertyListener : this.fListeners) {
            iPropertyListener.propertyChanged((Object)this, 257);
        }
    }

    public boolean setFocus() {
        if (this.fCurrentPane != null) {
            return this.fCurrentPane.setFocus();
        }
        return false;
    }

    public void dispose() {
        if (this.fCurrentPane != null) {
            this.fCurrentPane.dispose();
            this.fCurrentPane = null;
        }
        if (this.fCurrentControl != null && !this.fCurrentControl.isDisposed()) {
            this.fCurrentControl.dispose();
            this.fCurrentControl = null;
        }
    }

    public Object getAdapter(Class<?> required) {
        if (this.fCurrentPane != null && this.fCurrentPane instanceof IAdaptable) {
            return ((IAdaptable)this.fCurrentPane).getAdapter(required);
        }
        return null;
    }

    public Control getCurrentControl() {
        return this.fCurrentControl;
    }

    public String getCurrentPaneID() {
        if (this.fCurrentPane != null) {
            return this.fCurrentPane.getID();
        }
        return null;
    }

    private void setupPane(String paneID, IStructuredSelection selection) {
        try {
            this.fParentContainer.getParentComposite().setRedraw(false);
            if (this.fCurrentPane != null) {
                this.fCurrentPane.dispose();
            }
            if (this.fCurrentControl != null && !this.fCurrentControl.isDisposed()) {
                this.fCurrentControl.dispose();
            }
            this.fCurrentPane = null;
            this.fCurrentPane = DetailPaneManager.getDefault().getDetailPaneFromID(paneID);
            if (this.fCurrentPane != null) {
                IWorkbenchPartSite workbenchPartSite = this.fParentContainer.getWorkbenchPartSite();
                this.fCurrentPane.init(workbenchPartSite);
                IDetailPane3 saveable = this.getSaveable();
                if (saveable != null) {
                    for (IPropertyListener iPropertyListener : this.fListeners) {
                        saveable.addPropertyListener(iPropertyListener);
                    }
                }
                this.fCurrentControl = this.fCurrentPane.createControl(this.fParentContainer.getParentComposite());
                if (this.fCurrentControl != null) {
                    this.fParentContainer.getParentComposite().layout(true);
                    this.fCurrentPane.display(selection);
                    if (this.fParentContainer instanceof IDetailPaneContainer2) {
                        this.fCurrentControl.addFocusListener((FocusListener)new FocusAdapter(){

                            public void focusGained(FocusEvent e) {
                                DetailPaneProxy.this.updateSelectionProvider(true);
                            }

                            public void focusLost(FocusEvent e) {
                                DetailPaneProxy.this.updateSelectionProvider(false);
                            }
                        });
                    }
                } else {
                    this.createErrorLabel(DetailMessages.DetailPaneProxy_0);
                    DebugUIPlugin.log(new CoreException((IStatus)new Status(4, DebugUIPlugin.getUniqueIdentifier(), MessageFormat.format(DetailMessages.DetailPaneProxy_2, this.fCurrentPane.getID()))));
                }
            } else {
                this.createErrorLabel(DetailMessages.DetailPaneProxy_0);
                DebugUIPlugin.log(new CoreException((IStatus)new Status(4, DebugUIPlugin.getUniqueIdentifier(), MessageFormat.format(DetailMessages.DetailPaneProxy_3, paneID))));
            }
        }
        finally {
            this.fParentContainer.getParentComposite().setRedraw(true);
        }
    }

    protected void updateSelectionProvider(boolean hasFocus) {
        if (this.fParentContainer instanceof IDetailPaneContainer2) {
            IDetailPaneContainer2 container2 = (IDetailPaneContainer2)this.fParentContainer;
            if (this.fCurrentPane instanceof IDetailPane2) {
                ISelectionProvider provider = hasFocus ? ((IDetailPane2)this.fCurrentPane).getSelectionProvider() : null;
                container2.setSelectionProvider(provider);
            } else {
                IWorkbenchPartSite site = container2.getWorkbenchPartSite();
                if (site != null) {
                    container2.setSelectionProvider(site.getSelectionProvider());
                }
            }
        }
    }

    private void createErrorLabel(String message) {
        if (this.fCurrentPane != null) {
            this.fCurrentPane.dispose();
        }
        if (this.fCurrentControl != null && !this.fCurrentControl.isDisposed()) {
            this.fCurrentControl.dispose();
        }
        this.fCurrentControl = SWTFactory.createComposite(this.fParentContainer.getParentComposite(), 1, 1, 768);
        SWTFactory.createLabel((Composite)this.fCurrentControl, message, 1);
        this.fParentContainer.getParentComposite().layout();
    }

    public void doSave(IProgressMonitor monitor) {
        IDetailPane3 saveable = this.getSaveable();
        if (saveable != null) {
            saveable.doSave(monitor);
        }
    }

    public void doSaveAs() {
        IDetailPane3 saveable = this.getSaveable();
        if (saveable != null) {
            saveable.doSaveAs();
        }
    }

    public boolean isDirty() {
        IDetailPane3 saveable = this.getSaveable();
        if (saveable != null) {
            return saveable.isDirty();
        }
        return false;
    }

    public boolean isSaveAsAllowed() {
        IDetailPane3 saveable = this.getSaveable();
        if (saveable != null) {
            return saveable.isSaveAsAllowed();
        }
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        IDetailPane3 saveable = this.getSaveable();
        if (saveable != null) {
            return saveable.isSaveOnCloseNeeded();
        }
        return false;
    }

    IDetailPane3 getSaveable() {
        if (this.fCurrentPane instanceof IDetailPane3) {
            return (IDetailPane3)this.fCurrentPane;
        }
        return null;
    }

    public void addProperyListener(IPropertyListener listener) {
        this.fListeners.add((Object)listener);
        IDetailPane3 saveable = this.getSaveable();
        if (saveable != null) {
            saveable.addPropertyListener(listener);
        }
    }

    public void removePropertyListener(IPropertyListener listener) {
        this.fListeners.remove((Object)listener);
        IDetailPane3 saveable = this.getSaveable();
        if (saveable != null) {
            saveable.removePropertyListener(listener);
        }
    }
}

