/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.properties.tabbed.view;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabbedPropertyList;

public class TabbedPropertyViewer
extends StructuredViewer {
    protected TabbedPropertyList list;
    protected List elements;
    protected IWorkbenchPart part;

    public TabbedPropertyViewer(TabbedPropertyList list) {
        this.list = list;
        this.hookControl((Control)list);
        this.elements = new ArrayList();
    }

    public Object getElementAt(int index) {
        if (index >= 0 && index < this.elements.size()) {
            return this.elements.get(index);
        }
        return null;
    }

    public int getSelectionIndex() {
        return this.list.getSelectionIndex();
    }

    protected Widget doFindInputItem(Object element) {
        return null;
    }

    protected Widget doFindItem(Object element) {
        return null;
    }

    protected void doUpdateItem(Widget item, Object element, boolean fullMap) {
    }

    protected List getSelectionFromWidget() {
        int index = this.list.getSelectionIndex();
        if (index == -1) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> result = new ArrayList<Object>(1);
        result.add(this.getElementAt(index));
        return result;
    }

    protected void internalRefresh(Object element) {
    }

    public void reveal(Object element) {
    }

    protected void setSelectionToWidget(List l, boolean reveal) {
        if (l == null || l.isEmpty()) {
            this.list.deselectAll();
        } else {
            Object object = l.get(0);
            int index = -1;
            int i = 0;
            while (i < this.elements.size()) {
                if (this.elements.get(i) == object) {
                    index = i;
                }
                ++i;
            }
            Assert.isTrue((index != -1 ? 1 : 0) != 0, (String)"Could not set the selected tab in the tabbed property viewer");
            this.list.select(index);
        }
    }

    public Control getControl() {
        return this.list;
    }

    protected void inputChanged(Object input, Object oldInput) {
        this.elements.clear();
        Object[] children = this.getSortedChildren(this.getRoot());
        this.list.removeAll();
        Object[] objectArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            this.elements.add(child);
            this.mapElement(child, (Widget)this.list);
            ++n2;
        }
        this.list.setElements(children);
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        this.part = part;
        this.setInput(selection);
    }

    public IWorkbenchPart getWorkbenchPart() {
        return this.part;
    }

    public List getElements() {
        return this.elements;
    }
}

